/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private static final String LABEL = AuthoringUIResources.renameAction_text;
    private IStructuredSelection selection;
    private IWorkbenchPart activePart;

    public RenameAction(String string) {
        super(null, string);
    }

    public RenameAction() {
        this(LABEL);
    }

    private boolean canRename(IStructuredSelection iStructuredSelection) {
        if (!(this.domain instanceof AdapterFactoryEditingDomain) || iStructuredSelection.size() > 1) {
            return false;
        }
        Object object = TngUtil.unwrap((Object)iStructuredSelection.getFirstElement());
        return object instanceof NamedElement && !TngUtil.isPredefined((MethodElement)((MethodElement)object));
    }

    public boolean updateSelection(IStructuredSelection iStructuredSelection) {
        boolean bl = false;
        if (this.canRename(iStructuredSelection)) {
            this.selection = iStructuredSelection;
            bl = super.updateSelection(iStructuredSelection);
        }
        this.setEnabled(bl);
        return bl;
    }

    public Command createCommand(Collection<?> collection) {
        if (collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        Object object = TngUtil.unwrap(collection.iterator().next());
        if (object instanceof NamedElement) {
            return new RenameCommand((NamedElement)object, null);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public void setActiveWorkbenchPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)iWorkbenchPart).getEditingDomain();
        }
        this.activePart = iWorkbenchPart;
    }

    private void superRun() {
        IValidator iValidator;
        NamedElement namedElement = (NamedElement)TngUtil.unwrap((Object)this.selection.getFirstElement());
        Shell shell = this.activePart.getSite().getShell();
        if (namedElement.eContainer() != null && namedElement.eContainer().eResource() != namedElement.eResource() && !(iValidator = UserInteractionHelper.checkModify((EObject)namedElement.eContainer(), (Shell)shell)).isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, (IStatus)iValidator);
            return;
        }
        iValidator = IValidatorFactory.INSTANCE.createNameValidator(namedElement, ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory());
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (iValidator != null) {
                    return UserInteractionHelper.getSimpleErrorMessage((String)iValidator.isValid(string));
                }
                return null;
            }
        };
        boolean bl = true;
        InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, namedElement.getName(), iInputValidator);
        while (bl) {
            Object object;
            bl = false;
            if (inputDialog.open() != 0) continue;
            String string = inputDialog.getValue().trim();
            if (namedElement instanceof ContentElement) {
                string = StrUtil.makeValidFileName((String)string);
            }
            if (string.equals(namedElement.getName())) continue;
            if (namedElement instanceof MethodConfiguration) {
                object = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
                int n = 0;
                while (n < ((String[])object).length) {
                    if (string.equals(object[n])) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.duplicateElementNameError_msg, (Object)string));
                        bl = true;
                        break;
                    }
                    ++n;
                }
            }
            if (bl) {
                inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), AuthoringUIResources.rename_text, AuthoringUIResources.newname_text, namedElement.getName(), iInputValidator);
                continue;
            }
            if (namedElement instanceof MethodPlugin) {
                String string2 = AuthoringUIResources.methodPluginDescriptionPage_confirmRename_title;
                object = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_confirmRename, (Object[])new Object[]{namedElement.getName(), string});
                if (!MessageDialog.openConfirm((Shell)shell, (String)string2, (String)object)) {
                    return;
                }
                EditorChooser.getInstance().closeMethodEditorsForPluginElements((MethodPlugin)namedElement);
            }
            object = (RenameCommand)this.command;
            ((RenameCommand)((Object)object)).setNewName(string);
            ((RenameCommand)((Object)object)).setShell(shell);
            super.run();
        }
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.activePart.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
                libraryLockingOperationRunner.run(new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        RenameAction.this.superRun();
                    }
                });
            }
        });
    }

    public static void doRename(NamedElement namedElement, String string) {
        new RenameCommand(namedElement, string).execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameCommand
    extends AbstractCommand {
        private NamedElement e;
        private String newName;
        private String oldName;
        private Shell shell;
        Collection<Resource> renamedResources;

        public RenameCommand(NamedElement namedElement, String string) {
            this.e = namedElement;
            this.newName = string;
        }

        public void setNewName(String string) {
            this.newName = string;
        }

        public void setShell(Shell shell) {
            this.shell = shell;
        }

        private void rollback() {
            this.setName(this.oldName);
            if (!this.renamedResources.isEmpty()) {
                this.adjustLocation(this.renamedResources, new ArrayList<Resource>());
            }
        }

        private void handlePersistenceException(Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            String string = exception.getMessage() != null ? MessageFormat.format(": {0}", exception.getMessage()) : "";
            String string2 = MessageFormat.format(AuthoringUIResources.ElementsView_err_saving, this.e.eResource().getURI().toFileString(), string);
            throw new MessageException(string2);
        }

        private ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
            return LibraryServiceUtil.getPersisterFor((Resource)this.e.eResource()).getFailSafePersister();
        }

        private IStatus adjustLocation(Collection<Resource> collection) {
            ArrayList<Resource> arrayList = new ArrayList<Resource>();
            if (this.e instanceof ContentElement && ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)this.e))) {
                arrayList.add(((ContentElement)this.e).getPresentation().eResource());
            }
            arrayList.add(this.e.eResource());
            return this.adjustLocation(arrayList, collection);
        }

        private IStatus adjustLocation(Collection<Resource> collection, Collection<Resource> collection2) {
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = this.getPersister();
            try {
                for (Resource resource : collection) {
                    URI uRI = resource.getURI();
                    failSafeMethodLibraryPersister.adjustLocation(resource);
                    if (resource.getURI().equals((Object)uRI)) continue;
                    collection2.add(resource);
                }
                return Status.OK_STATUS;
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                try {
                    failSafeMethodLibraryPersister.rollback();
                }
                catch (Exception exception2) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                return new Status(4, AuthoringUIPlugin.getDefault().getId(), exception.getMessage(), (Throwable)exception);
            }
        }

        private void setName(String string) {
            this.e.setName(string);
            if (this.e instanceof ProcessComponent) {
                Process process = ((ProcessComponent)this.e).getProcess();
                process.setName(string);
            }
        }

        public void execute() {
            this.oldName = this.e.getName();
            this.setName(this.newName);
            this.renamedResources = new ArrayList<Resource>();
            Runnable runnable = new Runnable(){

                public void run() {
                    IStatus iStatus = RenameCommand.this.adjustLocation(RenameCommand.this.renamedResources);
                    if (!iStatus.isOK()) {
                        RenameCommand.this.rollback();
                        Exception exception = (Exception)iStatus.getException();
                        throw exception instanceof RuntimeException ? (RuntimeException)exception : new WrappedException(exception);
                    }
                }
            };
            boolean bl = UserInteractionHelper.runWithProgress((Runnable)runnable, (String)AuthoringUIResources.ElementsView_renaming_text);
            if (!bl) {
                return;
            }
            IStatus iStatus = UserInteractionHelper.checkModify((EObject)this.e, (Shell)(this.shell == null ? MsgBox.getDefaultShell() : this.shell));
            if (!iStatus.isOK()) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, AuthoringUIResources.renameDialog_renameError, iStatus);
                UserInteractionHelper.runWithProgress((Runnable)new Runnable(){

                    public void run() {
                        RenameCommand.this.rollback();
                    }
                }, (String)"");
                return;
            }
            runnable = new Runnable(){

                public void run() {
                    Process process;
                    DiagramManager diagramManager;
                    ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = RenameCommand.this.getPersister();
                    try {
                        try {
                            failSafeMethodLibraryPersister.save(RenameCommand.this.e.eResource());
                            failSafeMethodLibraryPersister.commit();
                        }
                        catch (Exception exception) {
                            try {
                                failSafeMethodLibraryPersister.rollback();
                            }
                            catch (Exception exception2) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception2);
                            }
                            RenameCommand.this.handlePersistenceException(exception);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        RenameCommand.this.rollback();
                        throw runtimeException;
                    }
                    if (RenameCommand.this.e instanceof ProcessComponent && (diagramManager = DiagramManager.getInstance((Process)(process = ((ProcessComponent)RenameCommand.this.e).getProcess()), (Object)this)) != null) {
                        try {
                            try {
                                diagramManager.updateResourceURI();
                            }
                            catch (Exception exception) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                                try {
                                    diagramManager.removeConsumer((Object)this);
                                }
                                catch (Exception exception3) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception3);
                                }
                            }
                        }
                        finally {
                            try {
                                diagramManager.removeConsumer((Object)this);
                            }
                            catch (Exception exception) {
                                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                            }
                        }
                    }
                }
            };
            UserInteractionHelper.runWithProgress((Runnable)runnable, (String)AuthoringUIResources.ElementsView_renaming_text);
        }

        public void redo() {
            this.execute();
        }

        protected boolean prepare() {
            return true;
        }

        public void dispose() {
            this.e = null;
            super.dispose();
        }
    }
}

