/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.common.serviceability.ErrorDialogNoReason;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.MethodElementCreateChildCommand;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.dialogs.UncancelableListSelectionDialog;
import org.eclipse.epf.library.ui.dialogs.UserInputsDialog;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class UserInteractionHandler
implements IUserInteractionHandler {
    private Shell shell;
    private IUserInteractionHandler.IMessenger messenger = new IUserInteractionHandler.IMessenger(){

        public void showWarning(final String string, final String string2) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2);
            }
        }

        public void showError(final String string, final String string2, final IStatus iStatus) {
            if (iStatus == null) {
                this.showError(string, string2);
            } else if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, iStatus);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, iStatus);
            }
        }

        public void showError(final String string, final String string2, final String string3, final Exception exception) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, string3, (Throwable)exception);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, string3, (Throwable)exception);
            }
        }

        public void showWarning(final String string, final String string2, final String string3) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2, string3);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2, string3);
            }
        }

        public void showError(final String string, final String string2) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2);
            }
        }

        public void showInfo(final String string, final String string2) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayInfo(string, string2);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayInfo(string, string2);
            }
        }

        public void showError(final String string, final String string2, final String string3, final String string4, final Exception exception) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, string3, string4, (Throwable)exception);
                    }
                });
            } else {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(string, string2, string3, string4, (Throwable)exception);
            }
        }
    };

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public Object getUIContext() {
        if (this.shell == null) {
            return MsgBox.getDefaultShell();
        }
        return this.shell;
    }

    public List select(List list, ILabelProvider iLabelProvider, boolean bl, List list2, String string, String string2) {
        if (bl) {
            ArrayContentProvider arrayContentProvider = new ArrayContentProvider();
            UncancelableListSelectionDialog uncancelableListSelectionDialog = new UncancelableListSelectionDialog(this.shell, (Object)list, (IStructuredContentProvider)arrayContentProvider, iLabelProvider, string2);
            uncancelableListSelectionDialog.setTitle(string);
            uncancelableListSelectionDialog.setBlockOnOpen(true);
            uncancelableListSelectionDialog.open();
            Object[] objectArray = uncancelableListSelectionDialog.getResult();
            if (objectArray == null) {
                return null;
            }
            if (objectArray.length == 0) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.asList(objectArray);
        }
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.shell, iLabelProvider);
        elementListSelectionDialog.setBlockOnOpen(true);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setMultipleSelection(false);
        elementListSelectionDialog.setMessage(string2);
        elementListSelectionDialog.setTitle(string);
        elementListSelectionDialog.setFilter(null);
        if (elementListSelectionDialog.open() == 1) {
            return null;
        }
        Object object = elementListSelectionDialog.getFirstResult();
        return Collections.singletonList(object);
    }

    public int selectOne(int[] nArray, String string, String string2, IStatus iStatus) {
        final String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = UserInteractionHandler.getActionText(nArray[n]);
            ++n;
        }
        Image image = null;
        try {
            this.shell = LibraryUIPlugin.getDefault().getWorkbench().getDisplay().getActiveShell();
            image = this.shell.getImage();
        }
        catch (Exception exception) {}
        if (iStatus == null) {
            MessageDialog messageDialog = new MessageDialog(this.shell, string, image, string2, 3, stringArray, 0);
            int n2 = messageDialog.open();
            return nArray[n2];
        }
        ErrorDialogNoReason errorDialogNoReason = new ErrorDialogNoReason(this.shell, string, string2, iStatus, 7){

            protected void createButtonsForButtonBar(Composite composite) {
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    this.createButton(composite, n, string, n == 0);
                    ++n;
                }
                if (this.shouldShowDetailsButton()) {
                    this.detailsButton = this.createButton(composite, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
                }
            }

            protected void buttonPressed(int n) {
                if (n == 13) {
                    super.buttonPressed(n);
                } else {
                    this.setReturnCode(n);
                    this.close();
                }
            }
        };
        int n3 = errorDialogNoReason.open();
        return nArray[n3];
    }

    public static String getActionText(int n) {
        switch (n) {
            case 3: {
                return IDialogConstants.ABORT_LABEL;
            }
            case 1: {
                return IDialogConstants.CANCEL_LABEL;
            }
            case 0: {
                return IDialogConstants.OK_LABEL;
            }
            case 2: {
                return IDialogConstants.RETRY_LABEL;
            }
            case 4: {
                return IDialogConstants.YES_LABEL;
            }
            case 5: {
                return IDialogConstants.NO_LABEL;
            }
        }
        return null;
    }

    public IUserInteractionHandler.IMessenger getMessenger() {
        return this.messenger;
    }

    public boolean requestInput(final String string, final String string2, final List list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (Display.getCurrent() == null) {
            final boolean[] blArray = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    blArray[0] = UserInteractionHandler.this.doRequestInput(string, string2, list);
                }
            });
            return blArray[0];
        }
        return this.doRequestInput(string, string2, list);
    }

    private boolean doRequestInput(String string, String string2, List list) {
        Object object;
        final UserInput userInput = (UserInput)list.get(0);
        if (userInput.getContext() instanceof MethodElementCreateChildCommand && (object = (MethodElementCreateChildCommand)userInput.getContext()).getFeature() == UmaPackage.eINSTANCE.getMethodLibrary_PredefinedConfigurations()) {
            NewConfigurationWizard newConfigurationWizard = new NewConfigurationWizard();
            newConfigurationWizard.init(PlatformUI.getWorkbench(), null);
            newConfigurationWizard.setMethodConfiguration((MethodConfiguration)object.getChild());
            WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newConfigurationWizard);
            wizardDialog.create();
            if (wizardDialog.open() == 0) {
                userInput.setInput((Object)newConfigurationWizard.getMethodConfiguration().getName());
                return true;
            }
            return false;
        }
        if (list.size() == 1 && userInput.getType() == 0 && userInput.getLabel() == null) {
            object = userInput.getValidator() != null ? new IInputValidator(){

                public String isValid(String string) {
                    return userInput.getValidator().isValid(string);
                }
            } : null;
            InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), string, string2, (String)userInput.getInput(), (IInputValidator)object);
            if (inputDialog.open() == 0) {
                userInput.setInput((Object)inputDialog.getValue());
                return true;
            }
            return false;
        }
        object = new UserInputsDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), list, string, string2);
        object.setBlockOnOpen(true);
        object.open();
        return object.getResult();
    }

    public IRunnableContext getRunnableContext() {
        Object object = this.getUIContext();
        Shell shell = object instanceof Shell ? (Shell)object : MsgBox.getDefaultShell();
        return new ProgressMonitorDialog(shell);
    }
}

