/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.io.File;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AttachmentDialog
extends Dialog {
    protected Button okButton;
    protected Button cancelButton;
    private Text attachment;

    public AttachmentDialog(Shell shell) {
        super(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 2;
        GridData gridData = (GridData)composite2.getLayoutData();
        gridData.verticalIndent = 10;
        gridLayout.numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.AttachmentDialogFileURL_text);
        this.attachment = new Text(composite2, 2048);
        gridData.widthHint = 300;
        this.attachment.setLayoutData((Object)gridData);
        this.attachment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (AttachmentDialog.this.okButton != null) {
                    AttachmentDialog.this.okButton.setEnabled(AttachmentDialog.this.attachment.getText().trim().length() > 0);
                }
            }
        });
        Button button = new Button(composite2, 0);
        button.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                String string = fileDialog.open();
                if (string != null && string.length() > 0) {
                    File file = new File(string);
                    try {
                        String string2 = file.toURL().toExternalForm();
                        AttachmentDialog.this.attachment.setText(string2);
                    }
                    catch (Exception exception) {}
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        super.getShell().setText(AuthoringUIResources.AttachmentDialogattachFile_text);
        return composite2;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = super.getButton(0);
        this.cancelButton = super.getButton(1);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public String getAttachmentPath() {
        return this.attachment.getText();
    }
}

