/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ConfigurationAddViewsDialog;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.ContentCategoriesGroupItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.PlatformUI;

public class ContributionSelection {
    private HashSet filterElementList = new HashSet();

    public boolean checkProcessPkg(Object object) {
        List list = new ArrayList();
        if (object instanceof ProcessPackage) {
            if (this.filterElementList.contains(object)) {
                return true;
            }
            if (object instanceof ProcessComponent) {
                if (this.filterElementList.contains(((ProcessComponent)object).getProcess())) {
                    return true;
                }
                list = ((ProcessComponent)object).getProcess().getBreakdownElements();
            } else {
                list = ((ProcessPackage)object).getChildPackages();
            }
        }
        for (Object e : list) {
            if (e instanceof ProcessComponent && this.checkProcessPkg(e)) {
                return true;
            }
            if (!(e instanceof BreakdownElement) || !this.filterElementList.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean checkProcessElements(Object object) {
        List list = ((Process)object).getBreakdownElements();
        for (Object e : list) {
            if (!(e instanceof BreakdownElement) || !this.filterElementList.contains((BreakdownElement)e)) continue;
            return true;
        }
        return false;
    }

    public boolean anyCategorizedElementAccepted(CustomCategory customCategory, HashSet hashSet) {
        if (hashSet.contains(customCategory)) {
            return true;
        }
        List list = customCategory.getCategorizedElements();
        for (Object e : list) {
            if (!(e instanceof CustomCategory)) continue;
            if (hashSet.contains(e)) {
                return true;
            }
            this.anyCategorizedElementAccepted((CustomCategory)e, hashSet);
        }
        return false;
    }

    public Object getSelectedContributor(VariabilityElement variabilityElement) {
        this.filterElementList = new HashSet();
        MethodConfiguration methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration();
        List list = ConfigurationHelper.getContributors((VariabilityElement)variabilityElement, (MethodConfiguration)methodConfiguration);
        if (list != null && !list.isEmpty()) {
            Object object;
            ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
            arrayList.add(variabilityElement);
            arrayList.addAll(list);
            this.filterElementList.addAll(arrayList);
            for (Object object22 : arrayList) {
                object = null;
                if (object22 instanceof Discipline) {
                    object = AssociationHelper.getDisciplineGroups((Discipline)((Discipline)object22));
                }
                if (object22 instanceof RoleSet) {
                    object = AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)object22));
                }
                if (object == null || object.isEmpty()) continue;
                this.filterElementList.addAll(object);
            }
            ContributionFilter contributionFilter = new ContributionFilter();
            String[] stringArray = new String[]{FilterConstants.CONFIG_CONTENT_ELEMENT};
            object = new ConfigurationAddViewsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            ((ItemsFilterDialog)((Object)object)).setFilter((IFilter)contributionFilter);
            ((ItemsFilterDialog)((Object)object)).setTitle(FilterConstants.CONFIG_CONTENT_ELEMENT);
            ((ItemsFilterDialog)((Object)object)).setViewerSelectionSingle(true);
            ((ItemsFilterDialog)((Object)object)).setTypes(stringArray);
            ((ItemsFilterDialog)((Object)object)).setInput(UmaUtil.getMethodLibrary((EObject)variabilityElement));
            ((ItemsFilterDialog)((Object)object)).setContentProvider((IStructuredContentProvider)new AdapterFactoryContentProvider(TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory((IFilter)contributionFilter)), TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory());
            object.setBlockOnOpen(true);
            String string = MessageFormat.format(AuthoringUIResources.ContributionSelection_filterdialog_title, variabilityElement.getName());
            ((ItemsFilterDialog)((Object)object)).setTitle(string);
            object.setBlockOnOpen(true);
            object.open();
            ArrayList arrayList2 = ((ItemsFilterDialog)((Object)object)).getSelectedItems();
            if (arrayList2 == null || arrayList2.isEmpty()) {
                return null;
            }
            return arrayList2.get(0);
        }
        return variabilityElement;
    }

    private class ContributionFilter
    extends AllFilter {
        private ContributionFilter() {
        }

        public boolean accept(Object object) {
            Object object2 = this.helper.getContentElement();
            if (object2 != null && object.equals(this.helper.getContentElement())) {
                return false;
            }
            if (this.helper.getAlreadySelectedList() != null && (object instanceof ProcessComponent ? this.helper.getAlreadySelectedList().contains(((ProcessComponent)object).getProcess()) : this.helper.getAlreadySelectedList().contains(object))) {
                return false;
            }
            if (object instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)object)) && ((CustomCategory)object).getCategorizedElements().isEmpty()) {
                return false;
            }
            if (!this.helper.matchPattern(object)) {
                return false;
            }
            if (object instanceof MethodPlugin && object instanceof MethodPlugin) {
                if (object2 != null) {
                    return MethodElementUtil.getAllModels((Object)object2).contains(object);
                }
                return true;
            }
            if (object instanceof ContentPackage) {
                return true;
            }
            if (object instanceof ContentCategoriesGroupItemProvider) {
                Collection collection = ((ContentCategoriesGroupItemProvider)object).getChildren(object);
                return !collection.isEmpty();
            }
            if (object instanceof ProcessesItemProvider) {
                Collection collection = ((ProcessesItemProvider)object).getChildren(object);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!((CategorizedProcessesItemProvider)e).getChildren(e).isEmpty()) continue;
                    iterator.remove();
                }
                return !collection.isEmpty();
            }
            return this.childAccept(object);
        }

        public boolean childAccept(Object object) {
            if (object instanceof CustomCategory) {
                return ContributionSelection.this.anyCategorizedElementAccepted((CustomCategory)object, ContributionSelection.this.filterElementList);
            }
            if (object instanceof ContentElement && ContributionSelection.this.filterElementList.contains(object)) {
                return true;
            }
            if (object instanceof Process && ContributionSelection.this.filterElementList.contains(object)) {
                return true;
            }
            if (object instanceof ProcessPackage) {
                return ContributionSelection.this.checkProcessPkg(object);
            }
            if (object instanceof Process) {
                return ContributionSelection.this.checkProcessElements(object);
            }
            return false;
        }
    }
}

