/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SwitchConfigDialog {
    private Shell shell;
    private IEditorPart part;

    public SwitchConfigDialog(Shell shell, IEditorPart iEditorPart) {
        this.shell = shell;
        this.part = iEditorPart;
    }

    public void execute() {
        Display display;
        Display display2 = display = this.shell != null ? this.shell.getDisplay() : null;
        if (display == null) {
            display = MsgBox.getDisplay();
        }
        if (display == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                BreakdownElementEditorInput breakdownElementEditorInput;
                Object object = null;
                if (SwitchConfigDialog.this.part instanceof AbstractDiagramEditor) {
                    if (((AbstractDiagramEditor)SwitchConfigDialog.this.part).isDisposed()) {
                        return;
                    }
                    breakdownElementEditorInput = (BreakdownElementEditorInput)SwitchConfigDialog.this.part.getEditorInput();
                    if (breakdownElementEditorInput.getSuppression().getProcess() != null) {
                        object = breakdownElementEditorInput.getSuppression().getProcess().eContainer();
                    }
                } else if (SwitchConfigDialog.this.part instanceof ProcessEditor) {
                    if (((ProcessEditor)SwitchConfigDialog.this.part).isDisposed()) {
                        return;
                    }
                    object = EditorChooser.getInstance().getMethodEditorInput(SwitchConfigDialog.this.part);
                }
                if (object != null && object instanceof ProcessComponent) {
                    breakdownElementEditorInput = ((ProcessComponent)object).getProcess().getDefaultContext();
                    String string = LibraryUIPreferences.getSwitchConfig();
                    if ("never".equals(string)) {
                        LibraryService.getInstance().setCurrentMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
                        return;
                    }
                    if (LibraryService.getInstance().getCurrentMethodConfiguration() != breakdownElementEditorInput) {
                        String string2 = breakdownElementEditorInput.getName();
                        if ("prompt".equals(string)) {
                            MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)SwitchConfigDialog.this.shell, (String)LibraryUIResources.switchConfigDialog_title, (String)LibraryUIResources.bind((String)LibraryUIResources.switchConfigDialog_text, (Object)string2), null, (boolean)false, (IPreferenceStore)LibraryUIPlugin.getDefault().getPreferenceStore(), (String)LibraryUIPreferences.getSwitchConfigPreferenceKey());
                            if (messageDialogWithToggle.getReturnCode() == 2) {
                                MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string2);
                                LibraryService.getInstance().setCurrentMethodConfiguration(methodConfiguration);
                            } else {
                                LibraryService.getInstance().setCurrentMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
                            }
                        } else if ("always".equals(string)) {
                            MethodConfiguration methodConfiguration = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (String)string2);
                            LibraryService.getInstance().setCurrentMethodConfiguration(methodConfiguration);
                        }
                    }
                }
            }
        });
    }

    public static void run(Shell shell, IEditorPart iEditorPart) {
        SwitchConfigDialog switchConfigDialog = new SwitchConfigDialog(Display.getCurrent().getActiveShell(), iEditorPart);
        switchConfigDialog.execute();
    }
}

