/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.providers.CategoryContentProvider;
import org.eclipse.epf.authoring.ui.providers.CategoryLabelProvider;
import org.eclipse.epf.authoring.ui.providers.CategoryTreeFilter;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.authoring.ui.util.ConfigurationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.CategoryTreeViewerWrapper;
import org.eclipse.epf.authoring.ui.views.ConfigurationViewer;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.closure.ClosureListener;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.configuration.closure.ElementDependencyError;
import org.eclipse.epf.library.configuration.closure.IConfigurationError;
import org.eclipse.epf.library.edit.IPluginUIPackageContextChangedListener;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.PluginUIPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ConfigurationUtil;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfigurationPage
extends FormPage
implements ISelectionProvider {
    MethodConfiguration config = null;
    ConfigurationClosure closure = null;
    ConfigurationViewer treeViewer;
    ConfigPackageContentProvider contProvider;
    ISelectionChangedListener selectionChangedListener = null;
    protected CategoryTreeViewerWrapper addCategoryViewer;
    protected CategoryTreeViewerWrapper subCategoryViewer;
    protected CategoryTreeFilter addCategoryTreeFilter;
    protected CategoryTreeFilter subCategoryTreeFilter;
    ScrolledForm form = null;
    boolean isDirty = false;
    private boolean needUpdate = false;
    private String formPrefix = AuthoringUIResources.ConfigurationPage_FormPrefix;
    private ArrayList expandedElements = new ArrayList();
    private List modifiedElements = new ArrayList();
    private Button closureButton;
    private Button fixWarningButton;
    private Button refreshButton;
    private Button hideButton;
    private Text elemDespContentText;
    protected Collection selectionChangedListeners = new ArrayList();
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    private static final ConfigurationMarkerHelper markerHelper = ConfigurationMarkerHelper.INSTANCE;
    ISelectionChangedListener msgViewListener = null;
    private ConfigTreeFilter configFilter;
    private IActionManager actionMgr;
    private ILibraryChangeListener libListener = null;
    protected Adapter configurationChangedListener = null;
    private static final ClosureListener closureListener = new ClosureListener(){

        public void errorAdded(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
            markerHelper.createMarker(methodConfiguration, iConfigurationError);
        }

        public void errorRemoved(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
            markerHelper.deleteMarker(methodConfiguration, iConfigurationError);
        }

        public void errorUpdated(MethodConfiguration methodConfiguration, IConfigurationError iConfigurationError) {
            markerHelper.adjustMarker(null, methodConfiguration, iConfigurationError);
        }
    };
    private IPluginUIPackageContextChangedListener layoutListener = new IPluginUIPackageContextChangedListener(){

        public void layoutChanged(boolean bl) {
            ConfigurationPage.this.refreshViewers();
        }
    };

    public ConfigurationPage(FormEditor formEditor) {
        super(formEditor, AuthoringUIResources.ConfigurationPage_Description1, AuthoringUIResources.ConfigurationPage_Description2);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        ConfigurationEditorInput configurationEditorInput = (ConfigurationEditorInput)iEditorInput;
        this.config = configurationEditorInput.getConfiguration();
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.configurationChangedListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                int n = notification.getEventType();
                if (n == 3 || n == 5 || n == 4 || n == 6) {
                    ConfigurationPage.this.needUpdate = true;
                }
            }
        };
        this.config.eAdapters().add((Object)this.configurationChangedListener);
    }

    private void reInitializeConfigFactory() {
        this.createConfigurationClosure();
        ConfigTreeFilter configTreeFilter = this.configFilter;
        this.configFilter = new ConfigTreeFilter(this.closure);
        if (this.treeViewer != null && configTreeFilter != null) {
            this.treeViewer.removeFilter(configTreeFilter);
        }
        this.treeViewer.addFilter(this.configFilter);
    }

    public void setInput(Object object) {
        this.treeViewer.setInput(object);
        this.addCategoryViewer.setRoot(object);
        this.subCategoryViewer.setRoot(object);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        this.addCategoryViewer.expandAll();
        this.addCategoryViewer.collapseAll();
        this.subCategoryViewer.expandAll();
        this.subCategoryViewer.collapseAll();
        this.updateCheckStates();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.form = iManagedForm.getForm();
        this.form.setText(String.valueOf(this.formPrefix) + this.config.getName());
        FormToolkit formToolkit = iManagedForm.getToolkit();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)tableWrapLayout);
        Section section = formToolkit.createSection(this.form.getBody(), 450);
        this.createTreeContent(formToolkit, section);
        this.addListeners();
        this.setInput(LibraryService.getInstance().getCurrentMethodLibrary());
        this.initializeCategoriesViewers();
    }

    public void createTreeContent(FormToolkit formToolkit, Section section) {
        section.setText(AuthoringUIResources.ConfigurationPage_ConfigContent);
        section.setDescription(AuthoringUIResources.ConfigurationPage_ConfigContentDescription);
        section.setLayoutData((Object)new TableWrapData(256));
        Composite composite = formToolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 6;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        Composite composite2 = formToolkit.createComposite(composite);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 6;
        composite2.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 3;
        composite2.setLayoutData((Object)gridData);
        this.hideButton = formToolkit.createButton(composite2, "", 136);
        this.hideButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("hideUncheckedElem.gif"));
        this.hideButton.setToolTipText(AuthoringUIResources.ConfigurationPage_hideToolTip);
        this.hideButton.setLayoutData((Object)new GridData(3));
        this.hideButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_hideToolTip));
        this.fixWarningButton = formToolkit.createButton(composite2, "", 8);
        this.fixWarningButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("addref_co.gif"));
        this.fixWarningButton.setToolTipText(AuthoringUIResources.ConfigurationPage_AddMissingToolTip);
        this.fixWarningButton.setLayoutData((Object)new GridData(3));
        this.fixWarningButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_AddMissingToolTip));
        this.closureButton = formToolkit.createButton(composite2, "", 8);
        this.closureButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("closure_co.gif"));
        this.closureButton.setToolTipText(AuthoringUIResources.ConfigurationPage_MakeClosureToolTip);
        this.closureButton.setLayoutData((Object)new GridData(3));
        this.closureButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.ConfigurationPage_MakeClosureToolTip));
        this.refreshButton = formToolkit.createButton(composite2, "", 8);
        this.refreshButton.setImage(AuthoringUIImages.IMG_REFRESH);
        this.refreshButton.setToolTipText(AuthoringUIResources.refreshButton_text);
        gridLayout2 = new GridData(131);
        gridLayout2.horizontalAlignment = 3;
        gridLayout2.horizontalSpan = 1;
        this.refreshButton.setLayoutData((Object)gridLayout2);
        this.refreshButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.refreshButton_text));
        this.createViewers(formToolkit, composite);
        gridLayout2 = formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationPage_Description);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridLayout2.setLayoutData((Object)gridData);
        this.elemDespContentText = formToolkit.createText(composite, "", 74);
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 6;
        gridData2.heightHint = 50;
        formToolkit.paintBordersFor(composite);
        formToolkit.paintBordersFor(composite2);
        this.elemDespContentText.setLayoutData((Object)gridData2);
        this.addCategoryViewer.setTextWidget(this.elemDespContentText);
        this.subCategoryViewer.setTextWidget(this.elemDespContentText);
        this.hideButton.setEnabled(true);
        this.hideButton.setVisible(true);
        this.refreshButton.setEnabled(true);
        this.refreshButton.setVisible(true);
        this.fixWarningButton.setEnabled(true);
        this.fixWarningButton.setVisible(true);
        this.closureButton.setEnabled(true);
        this.closureButton.setVisible(true);
    }

    private void createConfigurationClosure() {
        IEditorInput iEditorInput;
        FormEditor formEditor = this.getEditor();
        if (formEditor != null && (iEditorInput = formEditor.getEditorInput()) instanceof ConfigurationEditorInput) {
            this.config = ((ConfigurationEditorInput)iEditorInput).getConfiguration();
        }
        this.closure = new ConfigurationClosure(this.actionMgr, this.config);
        this.closure.addListener(closureListener);
    }

    public void initializeConfigFactory() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                ConfigurationPage.this.createConfigurationClosure();
            }
        };
        UserInteractionHelper.runWithProgress((IRunnableWithProgress)iRunnableWithProgress, (String)AuthoringUIResources.ConfigurationPage_LoadingMessage);
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory();
        this.contProvider = new ConfigPackageContentProvider((AdapterFactory)composedAdapterFactory);
        this.treeViewer.setContentProvider((IContentProvider)this.contProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigPackageLabelProvider(this.contProvider));
        this.configFilter = new ConfigTreeFilter(this.closure);
        this.treeViewer.addFilter(this.configFilter);
        this.addCategoryTreeFilter = new CategoryTreeFilter(this.addCategoryViewer);
        this.addCategoryViewer.addTreeFilter(this.addCategoryTreeFilter);
        this.subCategoryTreeFilter = new CategoryTreeFilter(this.subCategoryViewer);
        this.subCategoryViewer.addTreeFilter(this.subCategoryTreeFilter);
    }

    private void initializeCategoriesViewers() {
        ArrayList arrayList = new ArrayList(this.config.getAddedCategory());
        this.initializeCCViewer(this.addCategoryViewer, arrayList);
        ArrayList arrayList2 = new ArrayList(this.config.getSubtractedCategory());
        this.initializeCCViewer(this.subCategoryViewer, arrayList2);
        this.addCategoryViewer.aboutToOpen();
        this.subCategoryViewer.aboutToOpen();
    }

    private void initializeCCViewer(CategoryTreeViewerWrapper categoryTreeViewerWrapper, List list) {
        if (!list.isEmpty()) {
            categoryTreeViewerWrapper.updateSelections(list);
        }
    }

    private void createViewers(FormToolkit formToolkit, Composite composite) {
        Label label = formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationPage_TreeTitleLabel);
        GridData gridData = new GridData(9);
        label.setLayoutData((Object)gridData);
        gridData.horizontalSpan = 1;
        gridData = formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationPage_AddCategoriesTitleLabel);
        GridData gridData2 = new GridData(9);
        gridData.setLayoutData((Object)gridData2);
        gridData2.horizontalSpan = 1;
        composite.setLayoutData((Object)new GridData(1808));
        gridData2 = new GridLayout(2, true);
        composite.setLayout((Layout)gridData2);
        this.treeViewer = new ConfigurationViewer(composite);
        GridData gridData3 = new GridData(1808);
        gridData3.heightHint = 200;
        gridData3.verticalSpan = 3;
        this.treeViewer.getTree().setLayoutData((Object)gridData3);
        this.addCategoryViewer = new CategoryTreeViewerWrapper(composite, 200, LibraryService.getInstance().getCurrentMethodLibrary(), new CategoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), this.config), new CategoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()), this.config);
        gridData3 = formToolkit.createLabel(composite, AuthoringUIResources.ConfigurationPage_SubCategoriesTitleLabel);
        GridData gridData4 = new GridData(9);
        gridData3.setLayoutData((Object)gridData4);
        gridData4.horizontalSpan = 1;
        this.subCategoryViewer = new CategoryTreeViewerWrapper(composite, 200, LibraryService.getInstance().getCurrentMethodLibrary(), new CategoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), this.config), new CategoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()), this.config);
        this.addCategoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.subCategoryViewer.getTree().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (checkStateChangedEvent.getChecked()) {
                            (this).ConfigurationPage.this.subCategoryViewer.selectTreeCheck(checkStateChangedEvent.getElement(), false);
                        }
                    }
                });
            }
        });
        this.subCategoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
                BusyIndicator.showWhile((Display)ConfigurationPage.this.addCategoryViewer.getTree().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        if (checkStateChangedEvent.getChecked()) {
                            (this).ConfigurationPage.this.addCategoryViewer.selectTreeCheck(checkStateChangedEvent.getElement(), false);
                        }
                    }
                });
            }
        });
        this.initializeConfigFactory();
    }

    private void addListeners() {
        this.addEditorSetFocusLiseners();
        this.closureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationPage.this.makeClosure();
            }
        });
        this.fixWarningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationPage.this.fixWarning();
            }
        });
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationPage.this.showErrors();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.hideButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurationPage.this.showHideElements();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                ConfigurationPage.this.expandedElements.remove(object);
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                Object object = treeExpansionEvent.getElement();
                ConfigurationPage.this.expandedElements.add(object);
            }
        });
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    ConfigurationPage.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
            this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ConfigurationPage.this.modifiedElements = new ArrayList();
                boolean bl = checkStateChangedEvent.getChecked();
                ConfigurationPage.this.updateCheckStates(checkStateChangedEvent.getElement(), bl);
                boolean bl2 = ConfigurationPage.this.saveConfiguration();
                ConfigurationPage.this.refreshCategoryViewers();
                ConfigurationPage.this.showErrors();
                if (!(bl2 &= ConfigurationPage.this.saveContentCategorySelectionsToConfiguration())) {
                    ConfigurationPage.this.updateCheckStates(checkStateChangedEvent.getElement(), false);
                    int n = 0;
                    while (n < ConfigurationPage.this.modifiedElements.size()) {
                        ConfigurationPage.this.treeViewer.setChecked(ConfigurationPage.this.modifiedElements.get(n), false);
                        ++n;
                    }
                }
            }
        });
        ICheckStateListener iCheckStateListener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                ConfigurationPage.this.saveContentCategorySelectionsToConfiguration();
                ConfigurationPage.this.showErrors();
            }
        };
        this.addCategoryViewer.addCheckStateListener(iCheckStateListener);
        this.subCategoryViewer.addCheckStateListener(iCheckStateListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int n, Collection collection) {
                Object object;
                if ((n == 16 || n == 32 || n == 32) && collection != null && collection.size() > 0 && ((object = collection.toArray()[0]) instanceof MethodPlugin || object instanceof ProcessComponent || object instanceof MethodPackage || object instanceof CustomCategory)) {
                    ConfigurationPage.this.reInitializeConfigFactory();
                    ConfigurationPage.this.refreshViewers();
                    ConfigurationPage.this.updateCheckStates();
                    ConfigurationPage.this.showErrors();
                }
            }
        };
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener(this.libListener);
        }
        PluginUIPackageContext.INSTANCE.addListener(this.layoutListener);
    }

    protected void showHideElements() {
        this.configFilter.setHide();
        this.addCategoryTreeFilter.toggleHideUnchecked();
        this.subCategoryTreeFilter.toggleHideUnchecked();
        this.refreshViewers();
        this.updateCheckStates();
    }

    protected Object[] getConvertedSelections() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.treeViewer.getCheckedElements();
        ConfigPackageContentProvider configPackageContentProvider = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
        int n = 0;
        while (n < objectArray.length) {
            Object object = configPackageContentProvider.getUITargetElement(objectArray[n]);
            if (object != null && !arrayList.contains(object)) {
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    protected void showErrors() {
        List list = this.closure.getInvalidElements();
        this.closure.checkError();
        if (this.configFilter.isHiding()) {
            this.treeViewer.refresh();
        } else {
            list.addAll(this.closure.getInvalidElements());
            ConfigPackageContentProvider configPackageContentProvider = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
            list.addAll(configPackageContentProvider.getUIElements());
            this.treeViewer.update(list.toArray(), null);
        }
        this.needUpdate = false;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection iSelection) {
        Object object2;
        this.currentSelection = iSelection;
        for (Object object2 : this.selectionChangedListeners) {
            object2.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        object2 = iStructuredSelection.getFirstElement();
        if (object2 instanceof MethodElement) {
            String string = ((MethodElement)object2).getBriefDescription();
            this.elemDespContentText.setText(string != null ? string : "");
        }
    }

    protected void makeClosure() {
        this.closure.fixErrors();
        this.refreshViewers();
        this.updateCheckStates();
        this.saveConfiguration();
    }

    protected void fixWarning() {
        this.closure.fixProblems();
        this.refreshViewers();
        this.updateCheckStates();
        this.saveConfiguration();
    }

    private void updateCheckStates(Object object, boolean bl) {
        if (bl) {
            ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            this.checkParent(iTreeContentProvider, object);
        } else {
            this.treeViewer.setChecked(object, false);
        }
        this.selectionChildren(object, bl);
    }

    public void selectionChildren(Object object, boolean bl) {
        ITreeContentProvider iTreeContentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = iTreeContentProvider.getChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.treeViewer.setChecked(objectArray[n], bl);
            this.selectionChildren(objectArray[n], bl);
            ++n;
        }
    }

    private void updateCheckStates() {
        this.treeViewer.getTree().setVisible(false);
        try {
            Object object = this.treeViewer.getInput();
            if (object instanceof MethodLibrary) {
                Object[] objectArray = this.closure.getSelection();
                ConfigPackageContentProvider configPackageContentProvider = (ConfigPackageContentProvider)this.treeViewer.getContentProvider();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    this.checkParent((ITreeContentProvider)configPackageContentProvider, object2);
                    this.treeViewer.setChecked(object2, true);
                    ++n;
                }
                for (Object object2 : new ArrayList(configPackageContentProvider.getUIElements())) {
                    Object object3 = configPackageContentProvider.getUITargetElement(object2);
                    if (object3 == null || !this.closure.isSelected(object3)) continue;
                    this.checkParent((ITreeContentProvider)configPackageContentProvider, object2);
                    this.treeViewer.setChecked(object2, true);
                }
            }
        }
        finally {
            this.treeViewer.getTree().setVisible(true);
        }
    }

    private void checkParent(ITreeContentProvider iTreeContentProvider, Object object) {
        if (object == null || object instanceof MethodLibrary) {
            return;
        }
        this.modifiedElements.add(object);
        Object object2 = LibraryUtil.unwrap((Object)iTreeContentProvider.getParent(object));
        if (object2 != null) {
            this.treeViewer.setChecked(object2, true);
            this.checkParent(iTreeContentProvider, object2);
        }
    }

    public void getAllParents(List list, MethodPackage methodPackage) {
        MethodPackage methodPackage2 = methodPackage.getParentPackage();
        if (methodPackage2 != null) {
            list.add(methodPackage2);
            this.getAllParents(list, methodPackage2);
        }
    }

    public boolean setParentsChecked(Object object) {
        Widget widget = this.treeViewer.testFindItem(object);
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            treeItem = treeItem.getParentItem();
            while (treeItem != null) {
                treeItem.setChecked(true);
                treeItem = treeItem.getParentItem();
            }
            return true;
        }
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean saveConfiguration() {
        ConfigurationData configurationData = LibraryService.getInstance().getConfigurationManager(this.config).getConfigurationData();
        configurationData.setEnableUpdate(false);
        boolean bl = this.saveConfiguration_();
        configurationData.setEnableUpdate(true);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveConfiguration_() {
        boolean bl = this.config.eDeliver();
        try {
            ArrayList<Object> arrayList = this.config.getMethodPackageSelection();
            ArrayList<Object> arrayList2 = this.config.getMethodPluginSelection();
            if (!ConfigurationUtil.removeCollFromMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, (Collection)arrayList2)) {
                return false;
            }
            if (!ConfigurationUtil.removeCollFromMethodPackageList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, (Collection)arrayList)) {
                return false;
            }
            arrayList = new ArrayList<Object>();
            arrayList2 = new ArrayList<Object>();
            Object[] objectArray = this.treeViewer.getCheckedElements();
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof MethodPlugin && !arrayList2.contains(objectArray[n])) {
                    arrayList2.add(objectArray[n]);
                } else if (objectArray[n] instanceof MethodPackage && !arrayList.contains(objectArray[n])) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            if (!ConfigurationUtil.addCollToMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, arrayList2)) {
                return false;
            }
            if (!ConfigurationUtil.addCollToMethodPackageList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, arrayList)) {
                return false;
            }
            TngUtil.validateMethodConfiguration((IActionManager)this.actionMgr, (MethodConfiguration)this.config);
            return true;
        }
        finally {
            this.config.eSetDeliver(bl);
        }
    }

    public boolean saveContentCategorySelectionsToConfiguration() {
        ArrayList arrayList = new ArrayList(this.config.getAddedCategory());
        ArrayList arrayList2 = new ArrayList(this.config.getSubtractedCategory());
        Set<ContentCategory> set = this.addCategoryViewer.getCheckedContentCategories();
        Set<ContentCategory> set2 = this.subCategoryViewer.getCheckedContentCategories();
        arrayList.removeAll(set);
        arrayList2.removeAll(set2);
        set.removeAll(this.config.getAddedCategory());
        set2.removeAll(this.config.getSubtractedCategory());
        if (!ConfigurationUtil.removeCollFromAddedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, arrayList)) {
            return false;
        }
        if (!set.isEmpty()) {
            if (!ConfigurationUtil.addCollToAddedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, set)) {
                return false;
            }
            Map map = MethodElementUtil.buildMap((Collection)this.config.getMethodPluginSelection());
            HashSet<MethodPlugin> hashSet = new HashSet<MethodPlugin>();
            for (ContentCategory contentCategory : set) {
                MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)contentCategory);
                if (map.containsKey(methodPlugin.getGuid()) || hashSet.contains(methodPlugin)) continue;
                hashSet.add(methodPlugin);
            }
            if (!hashSet.isEmpty()) {
                if (!ConfigurationUtil.addCollToMethodPluginList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, hashSet)) {
                    return false;
                }
                LibraryUtil.validateMethodConfiguration((IActionManager)this.actionMgr, (MethodConfiguration)this.config);
            }
        }
        if (!ConfigurationUtil.removeCollFromSubtractedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, arrayList2)) {
            return false;
        }
        return ConfigurationUtil.addCollToSubtractedCategoryList((IActionManager)this.actionMgr, (MethodConfiguration)this.config, set2);
    }

    public void dispose() {
        ILibraryManager iLibraryManager;
        super.dispose();
        if (this.libListener != null && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            iLibraryManager.removeListener(this.libListener);
        }
        if (this.layoutListener != null) {
            PluginUIPackageContext.INSTANCE.removeListener(this.layoutListener);
        }
        if (this.configFilter != null) {
            this.configFilter.dispose();
        }
        if (this.closure != null) {
            this.closure.dispose();
            this.closure = null;
        }
        this.config.eAdapters().remove((Object)this.configurationChangedListener);
    }

    public ConfigurationClosure getClosure() {
        return this.closure;
    }

    private void addEditorSetFocusLiseners() {
        if (this.getEditor() instanceof ConfigurationEditor) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.data == ConfigurationPage.this && ConfigurationPage.this.needUpdate && ConfigurationPage.this.treeViewer != null) {
                        ConfigurationPage.this.reInitializeConfigFactory();
                        ConfigurationPage.this.refreshViewers();
                        ConfigurationPage.this.updateCheckStates();
                        ConfigurationPage.this.showErrors();
                        ConfigurationPage.this.needUpdate = false;
                    }
                }
            };
            ((ConfigurationEditor)this.getEditor()).addToSetFocusLiseners(listener);
        }
    }

    private void refreshViewers() {
        this.treeViewer.refresh();
        this.refreshCategoryViewers();
    }

    private void refreshCategoryViewers() {
        this.addCategoryViewer.refresh();
        this.subCategoryViewer.refresh();
        this.addCategoryViewer.aboutToOpen();
        this.subCategoryViewer.aboutToOpen();
    }

    public void doQuickFix(IMarker iMarker) {
        if (iMarker == null) {
            return;
        }
        MethodElement methodElement = markerHelper.getCauseMethodElement(iMarker);
        if (methodElement == null) {
            return;
        }
        if (this.closure.getConfigurationManager().getConfigurationData().isElementInSubtractedCategory(methodElement)) {
            String string = AuthoringUIResources.bind((String)AuthoringUIResources.configurationPage_QuickfixError_reason1, (Object[])new String[]{LibraryUtil.getTypeName((MethodElement)methodElement)});
            AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.configurationPage_quickfixError_title, string);
            return;
        }
        EObject eObject = LibraryUtil.getSelectable((EObject)methodElement);
        this.treeViewer.setChecked(eObject, true);
        this.updateCheckStates(eObject, true);
        this.saveConfiguration();
        this.showErrors();
        this.updateCheckStates();
    }

    public void gotoMarker(IMarker iMarker) {
        MethodElement methodElement = ConfigurationMarkerHelper.INSTANCE.getErrorMethodElement(iMarker);
        if (methodElement != null && this.treeViewer != null) {
            this.treeViewer.setSelection(LibraryUtil.getSelectable((EObject)methodElement));
        }
    }

    public class ConfigPackageContentProvider
    extends AdapterFactoryContentProvider {
        Map childUIParentMap;
        List uiFolders;

        public List getUIElements() {
            return this.uiFolders;
        }

        public ConfigPackageContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.childUIParentMap = new HashMap();
            this.uiFolders = new ArrayList();
        }

        public Object[] getChildren(Object object) {
            Object[] objectArray = this.getValidItems(object, super.getChildren(object));
            return objectArray;
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = this.getValidItems(object, super.getElements(object));
            return objectArray;
        }

        private boolean isUIFolder(Object object) {
            return object instanceof ContentItemProvider || object instanceof ProcessesItemProvider || object instanceof MethodPackagesItemProvider || object instanceof PluginUIPackagesItemProvider;
        }

        public Object getUITargetElement(Object object) {
            Notifier notifier;
            if (object instanceof CustomCategory) {
                return ((CustomCategory)object).eContainer();
            }
            if (object instanceof MethodElement) {
                return object;
            }
            if (object instanceof ContentItemProvider) {
                return ((ContentItemProvider)object).getParent(null);
            }
            if (object instanceof ProcessesItemProvider) {
                return ((ProcessesItemProvider)object).getParent(null);
            }
            if (object instanceof ItemProviderAdapter && (notifier = ((ItemProviderAdapter)object).getTarget()) != null && notifier instanceof MethodElement) {
                return notifier;
            }
            return null;
        }

        private Object[] getValidItems(Object object, Object[] objectArray) {
            if (objectArray == null || objectArray.length == 0) {
                return objectArray;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = LibraryUtil.unwrap((Object)objectArray[n]);
                boolean bl = this.isUIFolder(object2);
                if (bl || object2 instanceof MethodPackage || object2 instanceof MethodPlugin) {
                    arrayList.add(object2);
                    if (bl) {
                        this.uiFolders.add(object2);
                    }
                    this.childUIParentMap.put(object2, object);
                }
                ++n;
            }
            return arrayList.toArray();
        }

        public Object getParent(Object object) {
            if (this.childUIParentMap.containsKey(object)) {
                return this.childUIParentMap.get(object);
            }
            return super.getParent(object);
        }

        public boolean hasChildren(Object object) {
            Object[] objectArray = this.getChildren(object);
            return objectArray != null && objectArray.length > 0;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            super.inputChanged(viewer, object, object2);
            this.childUIParentMap.clear();
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification instanceof IViewerNotification) {
                IViewerNotification iViewerNotification = (IViewerNotification)notification;
                final Object object = iViewerNotification.getElement();
                final ConfigurationViewer configurationViewer = (ConfigurationViewer)this.viewer;
                if (object != null && iViewerNotification.getEventType() == 3) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            configurationViewer.setChecked(object, true);
                        }
                    });
                }
            }
        }

        public void dispose() {
            super.dispose();
            this.uiFolders.clear();
            this.childUIParentMap.clear();
        }
    }

    public class ConfigPackageLabelProvider
    extends LabelProvider {
        ConfigPackageContentProvider contentProvider;
        AdapterFactoryLabelProvider afProvider;

        public ConfigPackageLabelProvider(ConfigPackageContentProvider configPackageContentProvider) {
            this.contentProvider = configPackageContentProvider;
            this.afProvider = new AdapterFactoryLabelProvider(configPackageContentProvider.getAdapterFactory());
        }

        private ElementDependencyError getFirstChildError(Object object) {
            ElementDependencyError elementDependencyError = null;
            Object[] objectArray = this.contentProvider.getChildren(object);
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            int n = 0;
            while (n < objectArray.length) {
                Object object2 = objectArray[n];
                if (object2 instanceof ItemProviderAdapter) {
                    return this.getFirstChildError(object2);
                }
                elementDependencyError = ConfigurationPage.this.closure.getError(object2);
                if (elementDependencyError != null) {
                    return elementDependencyError;
                }
                ++n;
            }
            return elementDependencyError;
        }

        public Image getImage(Object object) {
            ConfigurationClosure configurationClosure = ConfigurationPage.this.closure;
            if (configurationClosure != null) {
                ElementDependencyError elementDependencyError = null;
                elementDependencyError = object instanceof ItemProviderAdapter ? this.getFirstChildError(object) : ConfigurationPage.this.closure.getError(object);
                if (elementDependencyError != null) {
                    if (elementDependencyError.isError() || elementDependencyError.isChildError()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                    if (elementDependencyError.isWarning() || elementDependencyError.isChildWarning()) {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                }
            }
            return this.afProvider.getImage(object);
        }

        protected Image getImageFromObject(Object object) {
            return ExtendedImageRegistry.getInstance().getImage(object);
        }

        public String getText(Object object) {
            if (object instanceof ProcessComponent) {
                Process process = ((ProcessComponent)object).getProcess();
                if (process != null) {
                    return process.getPresentationName();
                }
                return ((ProcessComponent)object).getName();
            }
            return this.afProvider.getText(object);
        }

        public void dispose() {
            super.dispose();
            this.contentProvider = null;
            this.afProvider = null;
        }
    }

    public class ConfigTreeFilter
    extends ViewerFilter {
        boolean hideUncheckedNodes = false;
        CheckboxTreeViewer checkTree = null;
        ConfigurationClosure closure = null;
        ConfigPackageContentProvider cp = null;

        public ConfigTreeFilter(ConfigurationClosure configurationClosure) {
            this.closure = configurationClosure;
        }

        public void setHide() {
            boolean bl = this.hideUncheckedNodes = !this.hideUncheckedNodes;
            if (this.checkTree != null) {
                this.checkTree.refresh();
            }
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (this.checkTree == null) {
                this.checkTree = (CheckboxTreeViewer)viewer;
                this.cp = (ConfigPackageContentProvider)this.checkTree.getContentProvider();
            }
            if (this.hideUncheckedNodes) {
                Object object3 = this.cp.getUITargetElement(object2);
                return this.closure.isSelected(object3);
            }
            return true;
        }

        public boolean isHiding() {
            return this.hideUncheckedNodes;
        }

        public void dispose() {
            this.checkTree = null;
            this.cp = null;
            this.closure = null;
        }
    }
}

