/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.actions.MethodElementDeleteAction;
import org.eclipse.epf.library.util.ConvertGuidanceType;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class DescriptionFormPage
extends BaseFormPage
implements IRefreshable {
    public static final int BUTTON_WIDTH = 150;
    protected static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    protected static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String LOCAL_CONTRIBUTES_TEXT = AuthoringUIResources.localContributes_text;
    protected static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    protected static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    protected static final String LOCAL_REPLACES_TEXT = AuthoringUIResources.localReplaces_text;
    protected static final String EXTENDS_REPLACES_TEXT = AuthoringUIResources.extendsReplaces_text;
    protected static final ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngUtil.umaItemProviderAdapterFactory);
    protected Section formSection;
    protected Composite sectionComposite;
    protected Composite expandedComposite;
    protected Section generalSection;
    protected Section variabilitySection;
    protected Composite generalComposite;
    protected Composite variabilityComposite;
    protected Section versionSection;
    protected Composite versionComposite;
    protected Section iconSection;
    protected Composite iconComposite;
    private Canvas pane1;
    private Canvas pane3;
    protected Section detailSection;
    protected Composite detailComposite;
    protected Section notationSection;
    protected Composite notationComposite;
    protected Section tailoringSection;
    protected Composite tailoringComposite;
    protected Text ctrl_name;
    protected Text ctrl_presentation_name;
    protected Label ctrl_type_label;
    protected Button ctrl_type_button;
    protected Text ctrl_brief_desc;
    protected IMethodRichText ctrl_full_desc;
    protected IMethodRichText ctrl_key;
    protected IMethodRichTextEditor ctrl_expanded;
    protected ComboViewer viewer_variability;
    protected Combo ctrl_variability;
    protected Label label_base;
    protected TableViewer base_viewer;
    protected Table ctrl_base;
    protected Button ctrl_base_button;
    private IMethodRichText activeControl;
    private Text ctrl_authors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    protected Label label_copyright;
    protected TableViewer copyright_viewer;
    protected Table ctrl_copyright;
    private Button copyright_button;
    private Button copyright_button_deselect;
    protected ImageHyperlink expandDetailLink;
    protected Label expandDetailLabel;
    protected ImageHyperlink expandNotationLink;
    protected Label expandNotationLabel;
    protected ImageHyperlink expandTailoringLink;
    protected Label expandTailoringLabel;
    protected IMethodRichText ctrl_purpose;
    protected Text ctrl_external_id;
    private Image shapeImage;
    private Image nodeImage;
    protected Button ctrl_select_shapeIcon_button;
    protected Button ctrl_clear_shapeIcon_button;
    protected Button ctrl_select_nodeIcon_button;
    protected Button ctrl_clear_nodeIcon_button;
    protected Button ctrl_publish_categories_button;
    protected ImageHyperlink expandVersionLink;
    protected Label expandVersionLabel;
    protected ImageHyperlink expandLink;
    protected Label expandLabel;
    protected IStructuredContentProvider contentProviderVariability;
    protected IStructuredContentProvider contentProviderBase;
    protected ILabelProvider labelProviderVariability = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType variabilityType = (VariabilityType)object;
            if (variabilityType == VariabilityType.NA_LITERAL) {
                return NOT_APPLICABLE_TEXT;
            }
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                return CONTRIBUTES_TEXT;
            }
            if (variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                return LOCAL_CONTRIBUTES_TEXT;
            }
            if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                return EXTENDS_TEXT;
            }
            if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                return REPLACES_TEXT;
            }
            if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                return LOCAL_REPLACES_TEXT;
            }
            if (variabilityType == VariabilityType.EXTENDS_REPLACES_LITERAL) {
                return EXTENDS_REPLACES_TEXT;
            }
            return null;
        }
    };
    protected ILabelProvider labelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int n) {
            return TngUtil.getLabelWithPath((Object)object);
        }
    };
    protected IActionManager actionMgr;
    protected IStructuredContentProvider copyrightContentProvider;
    private ILabelProvider copyrightLabelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    protected ModifyListener modelModifyListener;
    protected ModifyListener contentModifyListener;
    protected boolean descExpandFlag = false;
    protected boolean generalSectionExpandFlag = false;
    protected boolean detailSectionExpandFlag = false;
    protected boolean notationSectionExpandFlag = false;
    protected boolean tailoringSectionExpandFlag = false;
    protected boolean versionSectionExpandFlag = false;
    protected boolean elementSectionExpandFlag = false;
    protected boolean iconSectionExpandFlag = false;
    protected boolean fullDescOn = true;
    protected boolean keyConsiderationOn = true;
    protected boolean briefDescOn = true;
    protected boolean elementTypeOn = false;
    protected boolean contentFieldOn = false;
    protected boolean versionSectionOn = true;
    protected boolean anyAttributeModified = false;
    protected boolean generalSectionOn = true;
    protected boolean notationSectionOn = false;
    protected boolean detailSectionOn = true;
    protected boolean tailoringSectionOn = false;
    protected boolean variabilitySectionOn = true;
    protected boolean purposeOn = false;
    protected boolean externalIdOn = false;
    protected boolean iconSectionOn = false;
    protected boolean publishCategoryOn = false;
    protected static final int GENERAL_SECTION_ID = 1;
    protected static final int DETAIL_SECTION_ID = 2;
    protected static final int VERSION_SECTION_ID = 3;
    protected static final int NOTATION_SECTION_ID = 4;
    protected static final int TAILORING_SECTION_ID = 5;
    private int warningCount = 1;
    private int SECTIONS = 0;
    private static int SHAPEICON_WIDTH_MAX = 32;
    private static int SHAPEICON_HEIGHT_MAX = 32;
    private static int NODEICON_WIDTH_MAX = 16;
    private static int NODEICON_HEIGHT_MAX = 16;
    protected IFilter filter;
    private boolean disposed;
    public String generalSectionDescription;
    public String detailSectionDescription;
    public String tailoringSectionDescription;
    public String notationSectionDescription;
    public String variabilitySectionDescription;
    public String iconSectionDescription;
    public String versionSectionDescription;
    private Label nodeIconPath;
    private Label shapeIconPath;
    private String[] imageTypes = new String[]{"*.gif;*.jpg;*.png;*.ico;*.bmp"};
    private String[] imageNames = new String[]{"Image (gif, jpeg, png, ico, bmp)"};

    protected IFilter getFilter() {
        return this.filter;
    }

    protected Object getContentElement() {
        return null;
    }

    protected void initContentProviderBase() {
        this.contentProviderBase = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
                if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null) {
                    arrayList.add(DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement());
                }
                return arrayList.toArray();
            }

            public void notifyChanged(Notification notification) {
                switch (notification.getFeatureID(VariabilityElement.class)) {
                    case 8: {
                        super.notifyChanged(notification);
                    }
                }
            }
        };
        this.base_viewer.setContentProvider((IContentProvider)this.contentProviderBase);
    }

    public DescriptionFormPage(FormEditor formEditor, String string, String string2) {
        super(formEditor, string, string2);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.contentProviderVariability = this.contentElement instanceof ContentCategory ? new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityType> arrayList = new ArrayList<VariabilityType>();
                arrayList.add(VariabilityType.NA_LITERAL);
                arrayList.add(VariabilityType.CONTRIBUTES_LITERAL);
                arrayList.add(VariabilityType.REPLACES_LITERAL);
                arrayList.add(VariabilityType.EXTENDS_REPLACES_LITERAL);
                return arrayList.toArray();
            }
        } : new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<VariabilityType> arrayList = new ArrayList<VariabilityType>();
                arrayList.add(VariabilityType.NA_LITERAL);
                arrayList.add(VariabilityType.CONTRIBUTES_LITERAL);
                arrayList.add(VariabilityType.EXTENDS_LITERAL);
                arrayList.add(VariabilityType.REPLACES_LITERAL);
                arrayList.add(VariabilityType.EXTENDS_REPLACES_LITERAL);
                return arrayList.toArray();
            }
        };
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        this.createEditorContent(this.toolkit);
        this.setContextHelp();
        this.setFormTextWithVariableInfo();
        this.loadData();
        this.addListeners();
    }

    private void setFormTextWithVariableInfo() {
        UIHelper.setFormText(this.form, (MethodElement)this.contentElement);
    }

    public String getLabel(VariabilityElement variabilityElement, String string, boolean bl) {
        String string2 = TngUtil.getLabel((Object)variabilityElement, (String)string);
        if (bl && variabilityElement.getVariabilityBasedOnElement() != null) {
            VariabilityType variabilityType = variabilityElement.getVariabilityType();
            String string3 = null;
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                string3 = AuthoringUIResources.contributes_to_text;
            } else if (variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                string3 = AuthoringUIResources.localContributes_text;
            } else if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                string3 = AuthoringUIResources.extends_text;
            } else if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                string3 = AuthoringUIResources.replaces_text;
            } else if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                string3 = AuthoringUIResources.localReplaces_text;
            } else if (variabilityType == VariabilityType.EXTENDS_REPLACES_LITERAL) {
                string3 = AuthoringUIResources.extendsReplaces_text;
            }
            if (string3 != null) {
                StringBuffer stringBuffer = new StringBuffer(string2).append(" (").append(string3).append(" '").append(TngUtil.getLabel((Object)variabilityElement.getVariabilityBasedOnElement(), (String)string)).append("'");
                MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)variabilityElement.getVariabilityBasedOnElement());
                if (methodPlugin != null) {
                    stringBuffer.append(" in '").append(methodPlugin.getName()).append("')");
                }
                string2 = stringBuffer.toString();
            }
        }
        return string2;
    }

    protected void createEditorContent(FormToolkit formToolkit) {
        this.createFormComposites(formToolkit);
        this.loadSectionDescription();
        if (this.generalSectionOn) {
            this.createGeneralSection(formToolkit);
            ++this.SECTIONS;
        }
        if (this.detailSectionOn) {
            this.createDetailSection(formToolkit);
            ++this.SECTIONS;
        }
        if (this.notationSectionOn) {
            this.createNotationSection(formToolkit);
            ++this.SECTIONS;
        }
        if (this.tailoringSectionOn) {
            this.createTailoringSection(formToolkit);
            ++this.SECTIONS;
        }
        if (this.versionSectionOn) {
            this.createVersionSection(formToolkit);
            this.createVersionSectionContent();
            ++this.SECTIONS;
        }
        if (this.variabilitySectionOn) {
            this.createVariabilitySection(formToolkit);
            ++this.SECTIONS;
        }
        if (this.iconSectionOn) {
            this.createIconSection(formToolkit);
            this.createIconSectionContent();
            ++this.SECTIONS;
        }
        formToolkit.paintBordersFor(this.variabilityComposite);
        formToolkit.paintBordersFor(this.expandedComposite);
        formToolkit.paintBordersFor(this.generalComposite);
        formToolkit.paintBordersFor(this.versionComposite);
    }

    private void createFormComposites(FormToolkit formToolkit) {
        this.formSection = formToolkit.createSection(this.form.getBody(), 4096);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.formSection.setLayoutData((Object)tableWrapData);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = formToolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData(256));
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.expandedComposite = formToolkit.createComposite((Composite)this.formSection, 0);
        tableWrapData = new TableWrapData(256);
        this.expandedComposite.setLayoutData((Object)tableWrapData);
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = formToolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                DescriptionFormPage.this.toggle(hyperlinkEvent);
            }
        });
        this.expandLabel = DescriptionFormPage.createDecoratedLabel(formToolkit, this.expandedComposite, "");
    }

    protected void createGeneralSection(FormToolkit formToolkit) {
        this.generalSection = this.createSection(formToolkit, this.sectionComposite, AuthoringUIText.GENERAL_INFO_SECTION_NAME, this.getGeneralSectionDescription());
        this.generalComposite = this.createComposite(formToolkit, this.generalSection);
        ((GridLayout)this.generalComposite.getLayout()).numColumns = 4;
        this.createGeneralSectionContent();
    }

    private void createGeneralSectionContent() {
        GridData gridData;
        this.ctrl_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT, -1, 4);
        this.ctrl_presentation_name = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT, -1, 4);
        if (this.elementTypeOn) {
            DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.TYPE_TEXT, 2);
            this.ctrl_type_label = DescriptionFormPage.createLabel(this.toolkit, this.generalComposite, "");
            gridData = new GridData(1);
            gridData.horizontalSpan = 1;
            this.ctrl_type_label.setBackground(Display.getCurrent().getSystemColor(19));
            this.ctrl_type_label.setLayoutData((Object)gridData);
            if (this.contentElement instanceof Guidance) {
                this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
                gridData = new GridData(1);
                gridData.horizontalSpan = 1;
                this.ctrl_type_button.setLayoutData((Object)gridData);
                if (ConvertGuidanceType.getValidNewGuidanceTypes((Guidance)((Guidance)this.contentElement)) == null) {
                    this.ctrl_type_button.setVisible(false);
                }
            }
        }
        if (this.externalIdOn) {
            this.ctrl_external_id = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.UNIQUE_ID_TEXT, -1, 4);
        }
        if (this.briefDescOn) {
            this.ctrl_brief_desc = DescriptionFormPage.createTextEditWithLabel3(this.toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT, 40, 18);
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.PUBLISH_CATEGORIES_TEXT, 32);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            this.ctrl_publish_categories_button.setLayoutData((Object)gridData);
        }
    }

    protected void createVariabilitySection(FormToolkit formToolkit) {
        this.variabilitySection = this.createSection(formToolkit, this.sectionComposite, AuthoringUIText.VARIABILITY_SECTION_NAME, this.getVariabilitySectionDescription());
        this.variabilityComposite = formToolkit.createComposite((Composite)this.variabilitySection);
        GridData gridData = new GridData(769);
        gridData.horizontalSpan = 1;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.variabilityComposite.setLayoutData((Object)gridData);
        this.variabilityComposite.setLayout((Layout)new GridLayout(5, false));
        this.variabilitySection.setClient((Control)this.variabilityComposite);
        this.ctrl_variability = this.createComboWithLabel3(formToolkit, this.variabilityComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.viewer_variability.getCombo().setLayoutData((Object)gridData);
        this.viewer_variability.setContentProvider((IContentProvider)this.contentProviderVariability);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.labelProviderVariability);
        this.viewer_variability.setInput((Object)this.contentElement);
        formToolkit.createLabel(this.variabilityComposite, "", 0);
        this.label_base = DescriptionFormPage.createLabel(formToolkit, this.variabilityComposite, AuthoringUIText.BASE_ELEMENT_TEXT, 2);
        this.ctrl_base = DescriptionFormPage.createTable(formToolkit, this.variabilityComposite, 12, 769, 5, 300, 1, 2);
        gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 24;
        gridData.widthHint = 300;
        this.ctrl_base.setLayoutData((Object)gridData);
        this.base_viewer = new TableViewer(this.ctrl_base);
        this.initContentProviderBase();
        this.base_viewer.setLabelProvider((IBaseLabelProvider)this.labelProviderBase);
        this.base_viewer.setInput((Object)this.contentElement);
        gridData = DescriptionFormPage.createComposite(formToolkit, this.variabilityComposite, 258, 1, 1, 1);
        GridData gridData2 = new GridData(256);
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_base_button = formToolkit.createButton((Composite)gridData, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        gridData2 = new GridData(768);
        gridData2.widthHint = 150;
        this.ctrl_base_button.setLayoutData((Object)gridData2);
        gridData2 = this.form.getBody().getDisplay();
        if (gridData2 != null && !gridData2.isDisposed()) {
            gridData2.asyncExec(new Runnable(){

                public void run() {
                    if (DescriptionFormPage.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    DescriptionFormPage.this.ctrl_name.setFocus();
                    ContentDescription contentDescription = DescriptionFormPage.this.contentElement.getPresentation();
                    if (contentDescription.getChangeDate() == null) {
                        DescriptionFormPage.this.ctrl_name.setSelection(0, DescriptionFormPage.this.ctrl_name.getText().length());
                    }
                }
            });
        }
    }

    protected void refresh(boolean bl) {
        this.ctrl_name.setEditable(bl);
        this.ctrl_presentation_name.setEditable(bl);
        if (this.briefDescOn) {
            this.ctrl_brief_desc.setEditable(bl);
        }
        if (this.purposeOn) {
            this.ctrl_purpose.setEditable(bl);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc.setEditable(bl);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setEditable(bl);
        }
        if (this.externalIdOn) {
            this.ctrl_external_id.setEditable(bl);
        }
        if (this.elementTypeOn) {
            this.ctrl_type_button.setEnabled(bl);
        }
        if (this.variabilitySectionOn) {
            this.ctrl_variability.setEnabled(bl);
            this.ctrl_base_button.setEnabled(bl);
            if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA_LITERAL) {
                this.ctrl_base_button.setEnabled(false);
            }
        }
        if (this.versionSectionOn) {
            this.ctrl_change_date.setEditable(false);
            this.ctrl_change_desc.setEditable(bl);
            this.ctrl_authors.setEditable(bl);
            this.ctrl_version.setEditable(bl);
            this.copyright_button.setEnabled(bl);
            this.setCopyrightButtonDeselect();
        }
        if (this.iconSectionOn) {
            this.ctrl_select_shapeIcon_button.setEnabled(bl);
            this.ctrl_clear_shapeIcon_button.setEnabled(bl && this.contentElement.getShapeicon() != null);
            this.ctrl_select_nodeIcon_button.setEnabled(bl);
            this.ctrl_clear_nodeIcon_button.setEnabled(bl && this.contentElement.getNodeicon() != null);
        }
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(bl);
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button.setEnabled(bl);
        }
    }

    protected void createDetailSection(FormToolkit formToolkit) {
        this.detailSection = this.createSection(formToolkit, this.sectionComposite, AuthoringUIText.DETAIL_SECTION_NAME, this.getDetailSectionDescription());
        this.detailComposite = this.createComposite(formToolkit, this.detailSection);
        this.createDetailSectionContent();
        formToolkit.paintBordersFor(this.detailComposite);
    }

    private void createDetailSectionContent() {
        if (this.purposeOn) {
            this.ctrl_purpose = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.PURPOSE_TEXT, 40, 400, 2);
        }
        if (this.fullDescOn) {
            this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.KEY_CONSIDERATIONS_TEXT, 40, 400, 2);
        }
    }

    protected void createNotationSection(FormToolkit formToolkit) {
        this.notationSection = this.createSection(formToolkit, this.sectionComposite, AuthoringUIText.NOTATION_SECTION_NAME, this.getNotationSectionDescription());
        this.notationComposite = this.createComposite(formToolkit, this.notationSection);
        this.createNotationSectionContent();
        formToolkit.paintBordersFor(this.notationComposite);
    }

    protected void createNotationSectionContent() {
    }

    protected void createTailoringSection(FormToolkit formToolkit) {
        this.tailoringSection = this.createSection(formToolkit, this.sectionComposite, AuthoringUIText.TAILORING_SECTION_NAME, this.getTailoringSectionDescription());
        this.tailoringComposite = this.createComposite(formToolkit, this.tailoringSection);
        this.createTailoringSectionContent();
        formToolkit.paintBordersFor(this.tailoringComposite);
    }

    protected void createTailoringSectionContent() {
    }

    protected void addListeners() {
        final MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = methodElementEditor.createModifyListener((EObject)this.contentElement);
        this.contentModifyListener = methodElementEditor.createModifyListener((EObject)this.contentElement.getPresentation());
        this.actionMgr = methodElementEditor.getActionManager();
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                if (DescriptionFormPage.this.ctrl_expanded != null) {
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).heightHint = DescriptionFormPage.this.getRichTextEditorHeight();
                    ((GridData)DescriptionFormPage.this.ctrl_expanded.getLayoutData()).widthHint = DescriptionFormPage.this.getRichTextEditorWidth();
                }
                DescriptionFormPage.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (DescriptionFormPage.this.disposed) {
                    return;
                }
                DescriptionFormPage.this.refresh(!TngUtil.isLocked((EObject)DescriptionFormPage.this.contentElement));
                DescriptionFormPage.this.setFormTextWithVariableInfo();
                if (DescriptionFormPage.this.variabilitySectionOn) {
                    DescriptionFormPage.this.base_viewer.refresh();
                }
                if (DescriptionFormPage.this.versionSectionOn) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                }
            }
        });
        if (this.generalSectionOn) {
            this.addGeneralSectionListeners();
        }
        if (this.detailSectionOn) {
            this.addDetailSectionListeners();
        }
        if (this.versionSectionOn) {
            this.addVersionSectionListeners();
        }
        if (this.iconSectionOn) {
            this.addIconSectionListeners();
        }
        this.viewer_variability.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                boolean bl;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection();
                if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null && !(bl = methodElementEditor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)iStructuredSelection.getFirstElement()), -1))) {
                    return;
                }
                if (iStructuredSelection.getFirstElement() == VariabilityType.NA_LITERAL) {
                    if (DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement() != null && !(bl = methodElementEditor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                        return;
                    }
                    DescriptionFormPage.this.ctrl_base_button.setEnabled(false);
                    DescriptionFormPage.this.base_viewer.refresh();
                } else {
                    ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
                    VariabilityElement variabilityElement = DescriptionFormPage.this.contentElement.getVariabilityBasedOnElement();
                    arrayList.add(variabilityElement);
                    DescriptionFormPage.this.ctrl_base_button.setEnabled(true);
                    DescriptionFormPage.this.base_viewer.refresh();
                }
                DescriptionFormPage.this.setFormTextWithVariableInfo();
            }
        });
        this.ctrl_base_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DescriptionFormPage.this.filter = DescriptionFormPage.this.getFilter();
                if (DescriptionFormPage.this.filter != null) {
                    ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DescriptionFormPage.this.filter, DescriptionFormPage.this.getContentElement(), LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.contentElement, (boolean)true));
                    itemsFilterDialog.setViewerSelectionSingle(true);
                    itemsFilterDialog.setBlockOnOpen(true);
                    itemsFilterDialog.setTitle(LibraryUIText.getUIText((MethodElement)DescriptionFormPage.this.contentElement, (boolean)true));
                    itemsFilterDialog.open();
                    itemsFilterDialog.getSelectedItems();
                    if (itemsFilterDialog.getSelectedItems().size() > 0) {
                        IStatus iStatus = DependencyChecker.checkCircularDependencyAfterFilterSelection((VariabilityElement)DescriptionFormPage.this.contentElement, (VariabilityElement)((VariabilityElement)itemsFilterDialog.getSelectedItems().get(0)));
                        if (!iStatus.isOK()) {
                            String string = AuthoringUIResources.variability_error_title;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, iStatus.getMessage());
                            return;
                        }
                        boolean bl = methodElementEditor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), (Object)((VariabilityElement)itemsFilterDialog.getSelectedItems().get(0)), -1);
                        if (!bl) {
                            return;
                        }
                        bl = methodElementEditor.getActionManager().doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)((VariabilityType)((IStructuredSelection)DescriptionFormPage.this.viewer_variability.getSelection()).getFirstElement()), -1);
                    }
                }
                DescriptionFormPage.this.setFormTextWithVariableInfo();
                if (DescriptionFormPage.this.ctrl_base != null && !DescriptionFormPage.this.ctrl_base.isDisposed()) {
                    DescriptionFormPage.this.ctrl_base.redraw();
                }
                if (DescriptionFormPage.this.base_viewer != null && !DescriptionFormPage.this.base_viewer.getControl().isDisposed()) {
                    DescriptionFormPage.this.base_viewer.refresh();
                }
            }
        });
    }

    private void addGeneralSectionListeners() {
        this.ctrl_name.addModifyListener(this.modelModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = DescriptionFormPage.this.contentElement.getName();
                String string2 = DescriptionFormPage.this.ctrl_name.getText().trim();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, DescriptionFormPage.this.contentElement.getName())) {
                    return;
                }
                if (string2.equals(DescriptionFormPage.this.contentElement.getName())) {
                    return;
                }
                String string3 = null;
                if (string.indexOf("&") < 0 && string2.indexOf("&") > -1) {
                    string3 = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string2);
                } else {
                    IValidator iValidator = DescriptionFormPage.this.getNameValidator();
                    if (iValidator == null) {
                        iValidator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)DescriptionFormPage.this.contentElement, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                    }
                    string3 = iValidator.isValid(string2);
                }
                if (string3 == null && !string2.equals(DescriptionFormPage.this.contentElement.getName()) && string2.indexOf("&") > -1) {
                    string3 = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string2);
                }
                if (string3 == null) {
                    string2 = StrUtil.makeValidFileName((String)DescriptionFormPage.this.ctrl_name.getText());
                    DescriptionFormPage.this.ctrl_name.setText(string2);
                    if (!string2.equals(DescriptionFormPage.this.contentElement.getName())) {
                        Resource resource;
                        boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string2, -1);
                        if (!bl) {
                            return;
                        }
                        if (ContentDescriptionFactory.hasPresentation((MethodElement)DescriptionFormPage.this.contentElement) && (resource = DescriptionFormPage.this.contentElement.getPresentation().eResource()) != null) {
                            ((MethodElementEditor)DescriptionFormPage.this.getEditor()).addResourceToAdjustLocation(resource);
                        }
                        DescriptionFormPage.this.setFormTextWithVariableInfo();
                        DescriptionFormPage.this.ctrl_name.setText(string2);
                    }
                } else {
                    if (string3.indexOf("&") >= 0) {
                        string3 = string3.replace("&", "&&");
                    }
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameError_title, string3);
                    DescriptionFormPage.this.ctrl_name.setText(DescriptionFormPage.this.contentElement.getName());
                    DescriptionFormPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).DescriptionFormPage.this.ctrl_name.setFocus();
                            (this).DescriptionFormPage.this.ctrl_name.selectAll();
                        }
                    });
                }
            }
        });
        this.ctrl_presentation_name.addModifyListener(this.modelModifyListener);
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = DescriptionFormPage.this.contentElement.getPresentationName();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_presentation_name.getText());
                if (!string2.equals(string) && (bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), (Object)string2, -1))) {
                    DescriptionFormPage.this.ctrl_presentation_name.setText(string2);
                }
            }

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
            }
        });
        if (this.briefDescOn) {
            this.ctrl_brief_desc.addModifyListener(this.modelModifyListener);
            this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
                }

                public void focusLost(FocusEvent focusEvent) {
                    boolean bl;
                    String string = DescriptionFormPage.this.contentElement.getBriefDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                        return;
                    }
                    String string2 = DescriptionFormPage.this.ctrl_brief_desc.getText();
                    if (!string2.equals(string) && (bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)string2, -1))) {
                        DescriptionFormPage.this.ctrl_brief_desc.setText(string2);
                    }
                }
            });
        }
        if (this.elementTypeOn && this.contentElement instanceof Guidance) {
            this.ctrl_type_button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    MethodElementEditor methodElementEditor = (MethodElementEditor)DescriptionFormPage.this.getEditor();
                    if (methodElementEditor.isDirty()) {
                        String string = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String string2 = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2);
                    } else if (DescriptionFormPage.this.contentElement instanceof Guidance) {
                        MethodElementDeleteAction methodElementDeleteAction = new MethodElementDeleteAction();
                        methodElementDeleteAction.setEditingDomain(LibraryView.getView().getEditingDomain());
                        methodElementDeleteAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)DescriptionFormPage.this.contentElement));
                        Command command = methodElementDeleteAction.createCommand((Collection)Collections.singleton(DescriptionFormPage.this.contentElement));
                        if (command instanceof DeleteMethodElementCommand) {
                            Guidance guidance;
                            try {
                                guidance = ConvertGuidanceType.convertGuidance((Guidance)((Guidance)DescriptionFormPage.this.contentElement), null, (DeleteMethodElementCommand)((DeleteMethodElementCommand)command));
                            }
                            catch (Throwable throwable) {
                                try {
                                    command.dispose();
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            try {
                                command.dispose();
                            }
                            catch (Exception exception) {}
                            if (guidance != null) {
                                EditorChooser.getInstance().closeEditor(DescriptionFormPage.this.contentElement);
                                EditorChooser.getInstance().openEditor(guidance);
                            }
                        }
                    } else if (methodElementEditor.isDirty()) {
                        String string = AuthoringUIResources.descriptionTabGuidanceWarningDialog_title;
                        String string3 = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message2;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(string, string3);
                    }
                }
            });
        }
        if (this.publishCategoryOn) {
            this.ctrl_publish_categories_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = new Boolean(DescriptionFormPage.this.ctrl_publish_categories_button.getSelection()).toString();
                    MethodElementProperty methodElementProperty = TngUtil.getPublishCategoryProperty((MethodElement)DescriptionFormPage.this.contentElement);
                    if (methodElementProperty == null) {
                        methodElementProperty = UmaFactory.eINSTANCE.createMethodElementProperty();
                        methodElementProperty.setName("PUBLISH_CATEGORY");
                        methodElementProperty.setValue(string);
                        DescriptionFormPage.this.actionMgr.doAction(3, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_MethodElementProperty(), (Object)methodElementProperty, -1);
                    } else {
                        DescriptionFormPage.this.actionMgr.doAction(1, (EObject)methodElementProperty, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElementProperty_Value(), (Object)string, -1);
                    }
                }
            });
        }
    }

    protected IValidator getNameValidator() {
        return null;
    }

    private void addDetailSectionListeners() {
        if (this.fullDescOn) {
            this.ctrl_full_desc.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
            this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
            this.ctrl_full_desc.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_full_desc;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: control=" + iMethodRichText);
                    }
                    if (!iMethodRichText.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String string = DescriptionFormPage.this.contentElement.getPresentation().getMainDescription();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String string2 = iMethodRichText.getText();
                    if (!string2.equals(string)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saving modified content");
                        }
                        boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)string2, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: saved status=" + bl);
                        }
                        if (bl && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_full_desc.deactivateListener: exit");
                    }
                }
            });
        }
        if (this.keyConsiderationOn) {
            this.ctrl_key.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_key.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
            this.ctrl_key.addModifyListener(this.contentModifyListener);
            this.ctrl_key.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    IMethodRichText iMethodRichText;
                    IMethodRichText iMethodRichText2 = iMethodRichText = DescriptionFormPage.this.descExpandFlag ? DescriptionFormPage.this.ctrl_expanded : DescriptionFormPage.this.ctrl_key;
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: control=" + iMethodRichText);
                    }
                    if (!iMethodRichText.getModified()) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: content not modified, exit");
                        }
                        return;
                    }
                    String string = DescriptionFormPage.this.contentElement.getPresentation().getKeyConsiderations();
                    if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: restored old content, exit");
                        }
                        return;
                    }
                    String string2 = iMethodRichText.getText();
                    if (!string2.equals(string)) {
                        boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)string2, -1);
                        if (DescriptionFormPage.this.debug) {
                            System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: saved status=" + bl);
                        }
                        if (bl && DescriptionFormPage.this.isVersionSectionOn()) {
                            DescriptionFormPage.this.updateChangeDate();
                        }
                    }
                    if (DescriptionFormPage.this.debug) {
                        System.out.println("DescriptionFormPage.ctrl_key.deactivateListener: exit");
                    }
                }
            });
        }
    }

    protected void loadData() {
        if (this.generalSectionOn) {
            this.loadGeneralSectionData();
        }
        if (this.detailSectionOn) {
            this.loadDetailSectionData();
        }
        if (this.notationSectionOn) {
            this.loadNotationSectionData();
        }
        if (this.tailoringSectionOn) {
            this.loadTailoringSectionData();
        }
        if (this.versionSectionOn) {
            this.loadVersionSectionData();
        }
        if (this.iconSectionOn) {
            this.loadIconSectionData();
        }
        if (this.variabilitySectionOn) {
            this.variabilitySectionData();
        }
        this.form.getBody().layout(true, true);
    }

    private void loadGeneralSectionData() {
        String string;
        String string2 = this.contentElement.getName();
        String string3 = this.contentElement.getPresentationName();
        this.ctrl_name.setText(string2 == null ? "" : string2);
        this.ctrl_presentation_name.setText(string3 == null ? "" : string3);
        if (this.elementTypeOn) {
            string = LibraryUIText.getUIText((MethodElement)this.contentElement);
            this.ctrl_type_label.setText(string == null ? "" : string);
        }
        if (this.briefDescOn) {
            string = this.contentElement.getBriefDescription();
            this.ctrl_brief_desc.setText(string == null ? "" : string);
        }
        if (this.publishCategoryOn && (string = TngUtil.getPublishCategoryProperty((MethodElement)this.contentElement)) != null) {
            String string4 = string.getValue();
            this.ctrl_publish_categories_button.setSelection(new Boolean(string4).booleanValue());
        }
    }

    private void loadDetailSectionData() {
        String string;
        if (this.fullDescOn) {
            string = this.contentElement.getPresentation().getMainDescription();
            this.ctrl_full_desc.setText(string == null ? "" : string);
        }
        if (this.keyConsiderationOn) {
            string = this.contentElement.getPresentation().getKeyConsiderations();
            this.ctrl_key.setText(string == null ? "" : string);
        }
    }

    private void loadTailoringSectionData() {
    }

    private void loadNotationSectionData() {
    }

    private void variabilitySectionData() {
        VariabilityType variabilityType = this.contentElement.getVariabilityType();
        ArrayList<VariabilityType> arrayList = new ArrayList<VariabilityType>();
        arrayList.add(variabilityType);
        StructuredSelection structuredSelection = new StructuredSelection(arrayList);
        this.viewer_variability.setSelection((ISelection)structuredSelection, true);
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandLabel);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.expandedComposite.setVisible(false);
            this.sectionComposite.setVisible(true);
            this.formSection.setClient((Control)this.sectionComposite);
            this.enableSections(true);
            IMethodRichText iMethodRichText = this.getActiveRichTextControl();
            iMethodRichText.setText(this.ctrl_expanded.getText());
            iMethodRichText.setFindReplaceAction(this.ctrl_expanded.getFindReplaceAction());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.removeListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            iMethodRichText.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.enableSections(false);
            this.expandLabel.setText((String)((ImageHyperlink)hyperlinkEvent.getSource()).getData("Title"));
            IMethodRichText iMethodRichText = (IMethodRichText)hyperlinkEvent.getHref();
            this.ctrl_expanded.setInitialText(iMethodRichText.getText());
            this.ctrl_expanded.setModalObject(iMethodRichText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(iMethodRichText.getModalObjectFeature());
            this.ctrl_expanded.setFindReplaceAction(iMethodRichText.getFindReplaceAction());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.addListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            boolean bl = !TngUtil.isLocked((EObject)this.contentElement);
            this.ctrl_expanded.setEditable(bl);
            if (bl) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(iMethodRichText);
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText iMethodRichText) {
        this.activeControl = iMethodRichText;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public void setBriefDescOn(boolean bl) {
        this.briefDescOn = bl;
    }

    public void setFullDescOn(boolean bl) {
        this.fullDescOn = bl;
    }

    public void setKeyConsiderationOn(boolean bl) {
        this.keyConsiderationOn = bl;
    }

    public void setElementTypeOn(boolean bl) {
        this.elementTypeOn = bl;
    }

    public boolean isAnyAttributeModified() {
        return this.anyAttributeModified;
    }

    public void setAnyAttributeModified(boolean bl) {
        this.anyAttributeModified = bl;
    }

    public boolean isVersionSectionOn() {
        return this.versionSectionOn;
    }

    public void setVersionSectionOn(boolean bl) {
        this.versionSectionOn = bl;
    }

    private void createVersionSection(FormToolkit formToolkit) {
        this.versionSection = formToolkit.createSection(this.sectionComposite, 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.versionSection.setLayoutData((Object)tableWrapData);
        this.versionSection.setText(AuthoringUIText.VERSION_INFO_SECTION_NAME);
        this.versionSection.setDescription(this.getVersionSectionDescription());
        this.versionSection.setLayout((Layout)new GridLayout());
        this.versionComposite = formToolkit.createComposite((Composite)this.versionSection);
        this.versionComposite.setLayoutData((Object)new GridData(768));
        this.versionComposite.setLayout((Layout)new GridLayout(5, false));
        this.versionSection.setClient((Control)this.versionComposite);
    }

    private void createVersionSectionContent() {
        ContentDescription contentDescription = this.contentElement.getPresentation();
        String string = contentDescription.getVersion() == null ? "" : contentDescription.getVersion();
        this.ctrl_version = DescriptionFormPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.VERSION_TEXT, -1, 4, string);
        string = contentDescription.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(contentDescription.getChangeDate());
        this.ctrl_change_date = DescriptionFormPage.createTextEditWithLabel4(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DATE_TEXT, -1, 4, string);
        this.ctrl_change_date.setEditable(false);
        this.ctrl_change_desc = DescriptionFormPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT, 40, 2);
        this.ctrl_authors = DescriptionFormPage.createTextEditWithLabel5(this.toolkit, this.versionComposite, AuthoringUIText.AUTHORS_TEXT, 40, 2);
        this.label_copyright = DescriptionFormPage.createLabel(this.toolkit, this.versionComposite, AuthoringUIText.COPYRIGHT_TEXT, 2);
        this.ctrl_copyright = DescriptionFormPage.createTable(this.toolkit, this.versionComposite, 12, 1809, 5, 400, 1, 2);
        this.copyright_viewer = new TableViewer(this.ctrl_copyright);
        this.initContentProviderCopyright();
        this.copyright_viewer.setLabelProvider((IBaseLabelProvider)this.copyrightLabelProviderBase);
        this.copyright_viewer.setInput((Object)this.contentElement);
        Composite composite = DescriptionFormPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 1);
        GridData gridData = new GridData(128);
        composite.setLayoutData((Object)gridData);
        this.copyright_button = this.toolkit.createButton(composite, AuthoringUIText.SELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button.setLayoutData((Object)gridData);
        this.copyright_button_deselect = this.toolkit.createButton(composite, AuthoringUIText.DESELECT_BUTTON_TEXT, 64);
        gridData = new GridData(128);
        gridData.widthHint = 150;
        this.copyright_button_deselect.setLayoutData((Object)gridData);
        this.setCopyrightButtonDeselect();
        this.toolkit.paintBordersFor(this.versionComposite);
    }

    private void initContentProviderCopyright() {
        this.copyrightContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<SupportingMaterial> arrayList = new ArrayList<SupportingMaterial>();
                if (DescriptionFormPage.this.contentElement.getPresentation().getCopyrightStatement() != null) {
                    arrayList.add(DescriptionFormPage.this.contentElement.getPresentation().getCopyrightStatement());
                }
                return arrayList.toArray();
            }

            public void notifyChanged(Notification notification) {
            }
        };
        this.copyright_viewer.setContentProvider((IContentProvider)this.copyrightContentProvider);
    }

    protected void addVersionSectionListeners() {
        this.ctrl_version.addModifyListener(this.contentModifyListener);
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = DescriptionFormPage.this.contentElement.getPresentation().getVersion();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_version.getText());
                if (!string2.equals(string) && (bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version(), (Object)string2, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_authors.addModifyListener(this.contentModifyListener);
        this.ctrl_authors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = DescriptionFormPage.this.contentElement.getPresentation().getAuthors();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = StrUtil.getPlainText((String)DescriptionFormPage.this.ctrl_authors.getText());
                if (!string2.equals(string) && (bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors(), (Object)string2, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl;
                Object object;
                ContentFilter contentFilter = new ContentFilter(){

                    protected boolean childAccept(Object object) {
                        if (object instanceof Guidance) {
                            return object instanceof SupportingMaterial;
                        }
                        return false;
                    }
                };
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (DescriptionFormPage.this.ctrl_copyright.getItemCount() > 0 && (object = DescriptionFormPage.this.ctrl_copyright.getItems()[0]).getData() != null) {
                    arrayList.add(object.getData());
                }
                object = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)contentFilter, DescriptionFormPage.this.contentElement, FilterConstants.SUPPORTING_MATERIALS, arrayList);
                ((ItemsFilterDialog)((Object)object)).setViewerSelectionSingle(true);
                object.setBlockOnOpen(true);
                ((ItemsFilterDialog)((Object)object)).setTitle(FilterConstants.SUPPORTING_MATERIALS);
                object.open();
                ((ItemsFilterDialog)((Object)object)).getSelectedItems();
                if (((ItemsFilterDialog)((Object)object)).getSelectedItems().size() > 0 && !(bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), (Object)((SupportingMaterial)((ItemsFilterDialog)((Object)object)).getSelectedItems().get(0)), -1))) {
                    return;
                }
                DescriptionFormPage.this.copyright_viewer.refresh();
                DescriptionFormPage.this.setCopyrightButtonDeselect();
            }
        });
        this.ctrl_change_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)DescriptionFormPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = DescriptionFormPage.this.contentElement.getPresentation().getChangeDescription();
                if (((MethodElementEditor)DescriptionFormPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = DescriptionFormPage.this.ctrl_change_desc.getText();
                if (!(string2 = string2.replace(StrUtil.LINE_FEED, AuthoringUIResources.ChangeHistoryDialog_delimiter)).equals(string) && (bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription(), (Object)string2, -1))) {
                    DescriptionFormPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button_deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), null, -1);
                if (bl) {
                    DescriptionFormPage.this.copyright_viewer.refresh();
                    DescriptionFormPage.this.setCopyrightButtonDeselect();
                }
            }
        });
    }

    protected void updateChangeDate() {
        Date date;
        String string;
        Date date2 = this.contentElement.getPresentation().getChangeDate();
        DateFormat dateFormat = DateFormat.getDateInstance((int)0);
        String string2 = "";
        if (date2 != null) {
            string2 = dateFormat.format(date2);
        }
        if (!(string = dateFormat.format(date = new Date())).equals(string2)) {
            boolean bl = this.actionMgr.doAction(1, (EObject)this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDate(), (Object)date, -1);
            if (!bl) {
                return;
            }
            this.ctrl_change_date.setText(string);
        }
    }

    protected void loadVersionSectionData() {
        ContentDescription contentDescription = this.contentElement.getPresentation();
        this.ctrl_version.setText(contentDescription.getVersion() == null ? "" : contentDescription.getVersion());
        this.ctrl_authors.setText(contentDescription.getAuthors() == null ? "" : contentDescription.getAuthors());
        String string = contentDescription.getChangeDescription() == null ? "" : contentDescription.getChangeDescription();
        string = string.replace(AuthoringUIResources.ChangeHistoryDialog_delimiter, StrUtil.LINE_FEED);
        this.ctrl_change_desc.setText(string);
        this.ctrl_change_date.setText(contentDescription.getChangeDate() == null ? "" : DateFormat.getDateInstance((int)0).format(contentDescription.getChangeDate()));
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent, int n) {
        this.toggle(hyperlinkEvent);
    }

    public boolean isIconSectionOn() {
        return this.iconSectionOn;
    }

    public void setIconSectionOn(boolean bl) {
        this.iconSectionOn = bl;
    }

    protected void createIconSection(FormToolkit formToolkit) {
        this.iconSection = formToolkit.createSection(this.sectionComposite, 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.iconSection.setLayoutData((Object)tableWrapData);
        this.iconSection.setText(AuthoringUIText.ICON_SECTION_NAME);
        this.iconSection.setDescription(this.getIconSectionDescription());
        this.iconSection.setLayout((Layout)new GridLayout());
        this.iconComposite = formToolkit.createComposite((Composite)this.iconSection);
        this.iconComposite.setLayoutData((Object)new GridData(768));
        this.iconComposite.setLayout((Layout)new GridLayout(3, true));
        this.iconSection.setClient((Control)this.iconComposite);
    }

    private void createIconSectionContent() {
        Composite composite = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        composite.setLayoutData((Object)new GridData());
        composite.setLayout((Layout)new GridLayout(2, true));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, composite, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_Label, 1, 2);
        this.pane1 = new Canvas(composite, 2048);
        GridData gridData = new GridData(1);
        gridData.heightHint = 60;
        gridData.widthHint = 60;
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 1;
        this.pane1.setLayoutData((Object)gridData);
        this.pane1.setBackground(ColorConstants.lightGray);
        gridData = DescriptionFormPage.createCompositeForButtons(this.toolkit, composite);
        this.ctrl_select_shapeIcon_button = this.toolkit.createButton((Composite)gridData, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_shapeIcon_button = this.toolkit.createButton((Composite)gridData, AuthoringUIResources.DescriptionFormPage_ShapeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getShapeicon() == null) {
            this.ctrl_clear_shapeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_shapeIcon_button.setEnabled(true);
        }
        Composite composite2 = DescriptionFormPage.createComposite(this.toolkit, this.iconComposite, 1);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(2, false));
        DescriptionFormPage.createLabelWithNoWrap(this.toolkit, composite2, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_Label, 1, 2);
        this.pane3 = new Canvas(composite2, 2048);
        GridData gridData2 = new GridData(1);
        gridData2.heightHint = 40;
        gridData2.widthHint = 40;
        gridData2.verticalSpan = 1;
        gridData2.horizontalSpan = 1;
        this.pane3.setLayoutData((Object)gridData2);
        this.pane3.setBackground(ColorConstants.lightGray);
        gridData2 = DescriptionFormPage.createCompositeForButtons(this.toolkit, composite2);
        this.ctrl_select_nodeIcon_button = this.toolkit.createButton((Composite)gridData2, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_SelectButtonLabel, 0);
        this.ctrl_clear_nodeIcon_button = this.toolkit.createButton((Composite)gridData2, AuthoringUIResources.DescriptionFormPage_NodeIconPreview_ClearButtonLabel, 0);
        if (this.contentElement.getNodeicon() == null) {
            this.ctrl_clear_nodeIcon_button.setEnabled(false);
        } else {
            this.ctrl_clear_nodeIcon_button.setEnabled(true);
        }
        new Label(this.iconComposite, 0);
        this.shapeIconPath = DescriptionFormPage.createLabelWithNoWrap(this.toolkit, this.iconComposite, "", 1, 1);
        this.nodeIconPath = DescriptionFormPage.createLabelWithNoWrap(this.toolkit, this.iconComposite, "", 1, 2);
        this.toolkit.paintBordersFor((Composite)this.pane1);
        this.toolkit.paintBordersFor((Composite)gridData);
        this.toolkit.paintBordersFor((Composite)this.pane3);
        this.toolkit.paintBordersFor((Composite)gridData2);
    }

    protected void addIconSectionListeners() {
        this.ctrl_select_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string;
                String string2;
                FileDialog fileDialog;
                URI uRI;
                block10: {
                    uRI = null;
                    fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileDialog.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileDialog.setFilterExtensions(DescriptionFormPage.this.imageTypes);
                    fileDialog.setFilterNames(DescriptionFormPage.this.imageNames);
                    string2 = null;
                    string = null;
                    while (true) {
                        string2 = fileDialog.open();
                        string = fileDialog.getFileName();
                        if (string2 == null) break;
                        if (!new File(string2).exists()) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, string2));
                            continue;
                        }
                        break block10;
                        break;
                    }
                    return;
                }
                if (string2 != null && string2.length() > 0) {
                    try {
                        String string3 = DescriptionFormPage.this.copyResourceToLib(DescriptionFormPage.this.ctrl_select_shapeIcon_button.getShell(), string, fileDialog.getFilterPath(), (MethodElement)DescriptionFormPage.this.contentElement);
                        if (string3 != null) {
                            boolean bl;
                            File file = new File(string3);
                            uRI = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)new File(DescriptionFormPage.this.getPluginPath((MethodElement)DescriptionFormPage.this.contentElement)))));
                            if (uRI != null && !(bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), (Object)uRI, -1))) {
                                return;
                            }
                            DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                            DescriptionFormPage.this.shapeIconPath.setText(uRI.getPath());
                        }
                    }
                    catch (Exception exception) {
                        uRI = null;
                        DescriptionFormPage.this.shapeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        if (exception instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, exception.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)exception);
                    }
                }
                if (DescriptionFormPage.this.shapeImage != null) {
                    DescriptionFormPage.this.pane1.redraw();
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_shapeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Shapeicon(), null, -1);
                if (!bl) {
                    return;
                }
                DescriptionFormPage.this.pane1.redraw();
                DescriptionFormPage.this.ctrl_clear_shapeIcon_button.setEnabled(false);
                DescriptionFormPage.this.shapeIconPath.setText("");
            }
        });
        this.ctrl_select_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object;
                String string;
                String string2;
                FileDialog fileDialog;
                URI uRI;
                block11: {
                    uRI = null;
                    fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileDialog.setText(AuthoringUIResources.DescriptionFormPage_IconFileChooserDialog_title);
                    fileDialog.setFilterExtensions(DescriptionFormPage.this.imageTypes);
                    fileDialog.setFilterNames(DescriptionFormPage.this.imageNames);
                    string2 = null;
                    string = null;
                    while (true) {
                        string2 = fileDialog.open();
                        string = fileDialog.getFileName();
                        if (string2 == null) break;
                        if (new File(string2).exists()) {
                            object = new ImageData(string2);
                            if (object.width > NODEICON_WIDTH_MAX || object.height > NODEICON_HEIGHT_MAX) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageTooBigDialog_template, string2, new Integer(NODEICON_WIDTH_MAX), new Integer(NODEICON_HEIGHT_MAX)));
                                continue;
                            }
                            break block11;
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_title, MessageFormat.format(AuthoringUIResources.forms_DescriptionFormPage_imageNotFoundDialog_template, string2));
                    }
                    return;
                }
                if (string2 != null && string2.length() > 0) {
                    try {
                        object = DescriptionFormPage.this.copyResourceToLib(DescriptionFormPage.this.ctrl_select_nodeIcon_button.getShell(), string, fileDialog.getFilterPath(), (MethodElement)DescriptionFormPage.this.contentElement);
                        if (object != null) {
                            boolean bl;
                            File file = new File((String)object);
                            uRI = new URI(NetUtil.encodeFileURL((String)FileUtil.getRelativePath((File)file, (File)new File(DescriptionFormPage.this.getPluginPath((MethodElement)DescriptionFormPage.this.contentElement)))));
                            if (uRI != null && !(bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), (Object)uRI, -1))) {
                                return;
                            }
                            DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), file.getAbsolutePath());
                            DescriptionFormPage.this.nodeIconPath.setText(uRI.getPath());
                        }
                    }
                    catch (Exception exception) {
                        uRI = null;
                        DescriptionFormPage.this.nodeImage = null;
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                        if (exception instanceof IOException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_copying_file_title, AuthoringUIResources.err_copying_file_error, AuthoringUIResources.err_copying_file_reason, exception.getMessage());
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.err_processing_file_title, AuthoringUIResources.err_processing_file_description, (Throwable)exception);
                    }
                }
                if (DescriptionFormPage.this.nodeImage != null) {
                    DescriptionFormPage.this.pane3.redraw();
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(true);
                } else {
                    DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
                }
            }
        });
        this.ctrl_clear_nodeIcon_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = DescriptionFormPage.this.actionMgr.doAction(1, (EObject)DescriptionFormPage.this.contentElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_Nodeicon(), null, -1);
                if (!bl) {
                    return;
                }
                DescriptionFormPage.this.pane3.redraw();
                DescriptionFormPage.this.ctrl_clear_nodeIcon_button.setEnabled(false);
                DescriptionFormPage.this.nodeIconPath.setText("");
            }
        });
    }

    protected String copyResourceToLib(Shell shell, String string, String string2, MethodElement methodElement) throws IOException {
        File file = ResourceHelper.copyResourceToLib((Shell)shell, (File)new File(string2, string), (MethodElement)methodElement);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    protected void loadIconSectionData() {
        this.pane1.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                String string;
                Rectangle rectangle = DescriptionFormPage.this.pane1.getClientArea();
                paintEvent.gc.setClipping(rectangle);
                paintEvent.gc.setBackground(Display.getCurrent().getSystemColor(15));
                paintEvent.gc.fillRectangle(rectangle);
                URI uRI = DescriptionFormPage.this.contentElement.getShapeicon();
                if (uRI != null && (string = DescriptionFormPage.this.contentElement.getShapeicon().getPath()) != null) {
                    try {
                        Object object;
                        File file = new File(string);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                object = UmaUtil.getMethodPlugin((EObject)DescriptionFormPage.this.contentElement);
                                string = string.indexOf(object.getName()) > -1 ? String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryLocation()) + File.separator + string : String.valueOf(DescriptionFormPage.this.getPluginPath((MethodElement)DescriptionFormPage.this.contentElement)) + File.separator + string;
                            }
                            file = new File(string);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.shapeImage == null) {
                                DescriptionFormPage.this.shapeImage = new Image((Device)Display.getCurrent(), string);
                            }
                            if (DescriptionFormPage.this.contentElement.getShapeicon() != null) {
                                DescriptionFormPage.this.shapeIconPath.setText(DescriptionFormPage.this.contentElement.getShapeicon().getPath());
                            }
                            rectangle = DescriptionFormPage.this.pane1.getClientArea();
                            paintEvent.gc.setClipping(rectangle);
                            paintEvent.gc.setBackground(Display.getCurrent().getSystemColor(15));
                            paintEvent.gc.fillRectangle(rectangle);
                            paintEvent.gc.drawImage(DescriptionFormPage.this.shapeImage, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).shapeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane1.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                            object = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.contentElement.getName(), string});
                            MsgBox.showWarning((String)object);
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadShapeIconError, (Object[])new Object[]{exception.getMessage()}));
                    }
                }
            }
        });
        this.pane1.redraw();
        if (this.contentElement.getShapeicon() != null) {
            this.shapeIconPath.setText(this.contentElement.getShapeicon().getPath());
        }
        this.pane3.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                String string;
                Rectangle rectangle = DescriptionFormPage.this.pane3.getClientArea();
                paintEvent.gc.setClipping(rectangle);
                paintEvent.gc.setBackground(Display.getCurrent().getSystemColor(15));
                paintEvent.gc.fillRectangle(rectangle);
                URI uRI = DescriptionFormPage.this.contentElement.getNodeicon();
                if (uRI != null && (string = DescriptionFormPage.this.contentElement.getNodeicon().getPath()) != null) {
                    try {
                        Object object;
                        File file = new File(string);
                        if (!file.exists()) {
                            if (!file.isAbsolute()) {
                                object = UmaUtil.getMethodPlugin((EObject)DescriptionFormPage.this.contentElement);
                                string = string.indexOf(object.getName()) > -1 ? String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryLocation()) + File.separator + string : String.valueOf(DescriptionFormPage.this.getPluginPath((MethodElement)DescriptionFormPage.this.contentElement)) + File.separator + string;
                            }
                            file = new File(string);
                        }
                        if (file.exists()) {
                            if (DescriptionFormPage.this.nodeImage == null) {
                                DescriptionFormPage.this.nodeImage = new Image((Device)Display.getCurrent(), string);
                            }
                            if (DescriptionFormPage.this.contentElement.getNodeicon() != null) {
                                DescriptionFormPage.this.nodeIconPath.setText(DescriptionFormPage.this.contentElement.getNodeicon().getPath());
                            }
                            rectangle = DescriptionFormPage.this.pane3.getClientArea();
                            paintEvent.gc.setClipping(rectangle);
                            paintEvent.gc.setBackground(Display.getCurrent().getSystemColor(15));
                            paintEvent.gc.fillRectangle(rectangle);
                            paintEvent.gc.drawImage(DescriptionFormPage.this.nodeImage, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().x, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().y, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().width, ((DescriptionFormPage)DescriptionFormPage.this).nodeImage.getBounds().height, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().x, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().y, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().width, ((DescriptionFormPage)DescriptionFormPage.this).pane3.getClientArea().height);
                        } else if (DescriptionFormPage.this.warningCount == 1) {
                            DescriptionFormPage descriptionFormPage = DescriptionFormPage.this;
                            descriptionFormPage.warningCount = descriptionFormPage.warningCount + 1;
                            object = AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconWarning, (Object[])new Object[]{DescriptionFormPage.this.contentElement.getName(), string});
                            MsgBox.showWarning((String)object);
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getLogger().logError(AuthoringUIResources.bind((String)AuthoringUIResources.DescriptionFormPage_LoadNodeIconError, (Object[])new Object[]{exception.getMessage()}));
                    }
                }
            }
        });
        this.pane3.redraw();
        if (this.contentElement.getNodeicon() != null) {
            this.nodeIconPath.setText(this.contentElement.getNodeicon().getPath());
        }
    }

    protected void enableSections(boolean bl) {
        if (this.generalSectionOn) {
            this.generalSection.setVisible(bl);
            if (bl) {
                this.generalSection.setExpanded(this.generalSectionExpandFlag);
            } else {
                this.generalSectionExpandFlag = this.generalSection.isExpanded();
                this.generalSection.setExpanded(bl);
            }
        }
        if (this.detailSectionOn) {
            this.detailSection.setVisible(bl);
            if (bl) {
                this.detailSection.setExpanded(this.detailSectionExpandFlag);
            } else {
                this.detailSectionExpandFlag = this.detailSection.isExpanded();
                this.detailSection.setExpanded(bl);
            }
        }
        if (this.notationSectionOn) {
            this.notationSection.setVisible(bl);
            if (bl) {
                this.notationSection.setExpanded(this.notationSectionExpandFlag);
            } else {
                this.notationSectionExpandFlag = this.notationSection.isExpanded();
                this.notationSection.setExpanded(bl);
            }
        }
        if (this.tailoringSectionOn) {
            this.tailoringSection.setVisible(bl);
            if (bl) {
                this.tailoringSection.setExpanded(this.tailoringSectionExpandFlag);
            } else {
                this.tailoringSectionExpandFlag = this.tailoringSection.isExpanded();
                this.tailoringSection.setExpanded(bl);
            }
        }
        if (this.versionSectionOn) {
            this.versionSection.setVisible(bl);
            if (bl) {
                this.versionSection.setExpanded(this.versionSectionExpandFlag);
            } else {
                this.versionSectionExpandFlag = this.versionSection.isExpanded();
                this.versionSection.setExpanded(bl);
            }
        }
        if (this.iconSectionOn) {
            this.iconSection.setVisible(bl);
            if (bl) {
                this.iconSection.setExpanded(this.iconSectionExpandFlag);
            } else {
                this.iconSectionExpandFlag = this.iconSection.isExpanded();
                this.iconSection.setExpanded(bl);
            }
        }
        if (this.variabilitySectionOn) {
            this.variabilitySection.setVisible(bl);
            if (bl) {
                this.variabilitySection.setExpanded(this.elementSectionExpandFlag);
            } else {
                this.elementSectionExpandFlag = this.variabilitySection.isExpanded();
                this.variabilitySection.setExpanded(bl);
            }
        }
    }

    public void dispose() {
        if (this.shapeImage != null) {
            this.shapeImage.dispose();
        }
        if (this.nodeImage != null) {
            this.nodeImage.dispose();
        }
        if (this.labelProviderVariability != null) {
            this.labelProviderVariability.dispose();
        }
        if (this.contentProviderVariability != null) {
            this.contentProviderVariability.dispose();
        }
        if (this.labelProviderBase != null) {
            this.labelProviderBase.dispose();
        }
        if (this.copyrightLabelProviderBase != null) {
            this.copyrightLabelProviderBase.dispose();
        }
        super.dispose();
        this.disposed = true;
    }

    private void setCopyrightButtonDeselect() {
        if (this.contentElement.getPresentation().getCopyrightStatement() != null) {
            this.copyright_button_deselect.setEnabled(this.contentElement.getPresentation().getCopyrightStatement().getName() != null);
        } else {
            this.copyright_button_deselect.setEnabled(false);
        }
        if (TngUtil.isLocked((EObject)this.contentElement)) {
            this.copyright_button_deselect.setEnabled(false);
        }
    }

    private void setContextHelp() {
        if (this.sectionComposite != null) {
            EditorsContextHelper.setHelp((Control)this.sectionComposite.getParent(), this.getContentElement());
        }
        if (this.expandedComposite != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.expandedComposite, AuthoringUIHelpContexts.RICH_TEXT_EDITOR_CONTEXT_ID);
        }
    }

    public void refreshName(String string) {
        if (string != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener(this.modelModifyListener);
            this.ctrl_name.setText(string);
            this.ctrl_name.addModifyListener(this.modelModifyListener);
            this.setFormTextWithVariableInfo();
        }
    }

    public void loadSectionDescription() {
    }

    protected String getDetailSectionDescription() {
        if (this.detailSectionDescription != null) {
            return this.detailSectionDescription;
        }
        return AuthoringUIText.DETAIL_SECTION_DESC;
    }

    protected String getGeneralSectionDescription() {
        if (this.generalSectionDescription != null) {
            return this.generalSectionDescription;
        }
        return AuthoringUIText.GENERAL_INFO_SECTION_DESC;
    }

    protected String getTailoringSectionDescription() {
        if (this.tailoringSectionDescription != null) {
            return this.tailoringSectionDescription;
        }
        return AuthoringUIText.TAILORING_SECTION_DESC;
    }

    protected String getNotationSectionDescription() {
        if (this.notationSectionDescription != null) {
            return this.notationSectionDescription;
        }
        return AuthoringUIText.NOTATION_SECTION_DESC;
    }

    protected String getVariabilitySectionDescription() {
        if (this.variabilitySectionDescription != null) {
            return this.variabilitySectionDescription;
        }
        return AuthoringUIText.VARIABILITY_SECTION_DESC;
    }

    private String getIconSectionDescription() {
        if (this.iconSectionDescription != null) {
            return this.iconSectionDescription;
        }
        return AuthoringUIText.ICON_SECTION_DESC;
    }

    private String getVersionSectionDescription() {
        if (this.versionSectionDescription != null) {
            return this.versionSectionDescription;
        }
        return AuthoringUIText.VERSION_INFO_SECTION_DESC;
    }

    public Text getCtrl_brief_desc() {
        return this.ctrl_brief_desc;
    }

    public void setCtrl_brief_desc(Text text) {
        this.ctrl_brief_desc = text;
    }

    public IMethodRichText getCtrl_full_desc() {
        return this.ctrl_full_desc;
    }

    public void setCtrl_full_desc(IMethodRichText iMethodRichText) {
        this.ctrl_full_desc = iMethodRichText;
    }

    public Text getCtrl_presentation_name() {
        return this.ctrl_presentation_name;
    }

    public void setCtrl_presentation_name(Text text) {
        this.ctrl_presentation_name = text;
    }

    public IMethodRichTextEditor getCtrl_expanded() {
        return this.ctrl_expanded;
    }

    public void setCtrl_expanded(IMethodRichTextEditor iMethodRichTextEditor) {
        this.ctrl_expanded = iMethodRichTextEditor;
    }

    public IMethodRichText getCtrl_key() {
        return this.ctrl_key;
    }

    public void setCtrl_key(IMethodRichText iMethodRichText) {
        this.ctrl_key = iMethodRichText;
    }

    public String getPluginPath(MethodElement methodElement) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin != null) {
            return ResourceHelper.getFolderAbsolutePath((MethodElement)methodPlugin);
        }
        return null;
    }
}

