/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.SectionsOrderDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.AddToSectionListCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInSectionListCommand;
import org.eclipse.epf.library.edit.command.RemoveFromSectionList;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TaskStepsPage
extends BaseFormPage {
    private static final String FORM_PAGE_ID = "taskStepsPage";
    private Text ctrl_name;
    private Button ctrl_add;
    private Button ctrl_delete;
    private Button ctrl_up;
    private Button ctrl_down;
    private Button ctrl_ordering;
    private Table ctrl_steps;
    private TableViewer stepsTableViewer;
    private SectionList allSteps;
    protected IMethodRichText activeControl;
    protected boolean descExpandFlag = false;
    protected IMethodRichTextEditor ctrl_expanded;
    protected ImageHyperlink expandLink;
    protected Label expandLabel;
    protected org.eclipse.ui.forms.widgets.Section formSection;
    protected org.eclipse.ui.forms.widgets.Section generalSection;
    protected Composite sectionComposite;
    protected Composite generalComposite;
    protected Composite expandedComposite;
    protected IMethodRichText ctrl_maindesc;
    private IStructuredContentProvider stepsViewerContentProvider;
    private ILabelProvider stepsViewerLabelProvider;
    private Task task;
    private Section currentStep;
    private MethodElementEditor.ModifyListener contentModifyListener;
    private IActionManager actionMgr;

    public TaskStepsPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.STEPS_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        this.task = (Task)methodElementEditorInput.getMethodElement();
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        this.form.setText(String.valueOf(LibraryUIText.getUIText((MethodElement)this.task)) + ": " + this.task.getName());
        this.formSection = this.toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.formSection.setLayoutData((Object)tableWrapData);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData(256));
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.generalSection = this.toolkit.createSection(this.sectionComposite, 450);
        this.generalSection.setLayoutData((Object)new TableWrapData(256));
        this.generalSection.setText(AuthoringUIText.STEPS_SECTION_NAME);
        this.generalSection.setDescription(AuthoringUIText.STEPS_SECTION_DESC);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(4, false));
        this.generalSection.setClient((Control)this.generalComposite);
        EditorsContextHelper.setHelp((Control)this.generalComposite.getParent(), this.task);
        tableWrapData = this.toolkit.createComposite(this.generalComposite);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        tableWrapData.setLayoutData((Object)gridData);
        tableWrapData.setLayout((Layout)new GridLayout());
        gridData = this.toolkit.createLabel((Composite)tableWrapData, AuthoringUIText.STEPS_TEXT);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 3;
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_steps = this.toolkit.createTable((Composite)tableWrapData, 2);
        gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 3;
        gridData2.heightHint = 150;
        this.ctrl_steps.setLayoutData((Object)gridData2);
        this.initProviders();
        this.stepsTableViewer = new TableViewer(this.ctrl_steps);
        this.stepsTableViewer.setContentProvider((IContentProvider)this.stepsViewerContentProvider);
        this.stepsTableViewer.setLabelProvider((IBaseLabelProvider)this.stepsViewerLabelProvider);
        gridData2 = this.toolkit.createComposite(this.generalComposite);
        gridData2.setLayoutData((Object)new GridData(68));
        gridData2.setLayout((Layout)new GridLayout());
        this.ctrl_add = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.ADD_BUTTON_TEXT, 0);
        this.ctrl_add.setLayoutData((Object)new GridData(768));
        this.ctrl_delete = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.DELETE_BUTTON_TEXT, 0);
        this.ctrl_delete.setLayoutData((Object)new GridData(768));
        this.ctrl_delete.setEnabled(false);
        this.ctrl_up = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.UP_BUTTON_TEXT, 0);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_down.setEnabled(false);
        this.ctrl_ordering = this.toolkit.createButton((Composite)gridData2, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
        this.ctrl_ordering.setLayoutData((Object)new GridData(768));
        Label label = this.toolkit.createLabel(this.generalComposite, AuthoringUIText.STEP_NAME_TEXT);
        GridData gridData3 = new GridData(1);
        gridData3.horizontalSpan = 4;
        label.setLayoutData((Object)gridData3);
        this.ctrl_name = this.toolkit.createText(this.generalComposite, "", 4);
        gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        this.ctrl_name.setLayoutData((Object)gridData3);
        TaskStepsPage.createBlankLabel(this.toolkit, this.generalComposite, 4);
        this.ctrl_maindesc = this.createRichTextEditWithLink(this.toolkit, this.generalComposite, AuthoringUIText.DESCRIPTION_TEXT, 250, 300, 4);
        this.createRichTextEditorSection();
        this.toolkit.paintBordersFor((Composite)tableWrapData);
        this.toolkit.paintBordersFor((Composite)gridData2);
        this.toolkit.paintBordersFor(this.generalComposite);
        this.toolkit.paintBordersFor(this.expandedComposite);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.addListeners();
        this.loadData();
        this.enableControls();
    }

    public void addListeners() {
        MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.contentModifyListener = methodElementEditor.createModifyListener((EObject)this.currentStep);
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.contentModifyListener.setDisable(true);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (TaskStepsPage.this.form != null && !TaskStepsPage.this.form.isDisposed()) {
                    UIHelper.setFormText(TaskStepsPage.this.form, (MethodElement)TaskStepsPage.this.contentElement);
                }
                TaskStepsPage.this.loadData();
                if (TngUtil.isLocked((EObject)TaskStepsPage.this.contentElement)) {
                    TaskStepsPage.this.enableControls(false);
                } else {
                    TaskStepsPage.this.ctrl_add.setEnabled(true);
                    TaskStepsPage.this.checkSelection();
                }
            }
        });
        this.form.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                TaskStepsPage.this.deactivate();
            }
        });
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                if (TaskStepsPage.this.ctrl_expanded != null) {
                    ((GridData)TaskStepsPage.this.ctrl_expanded.getLayoutData()).heightHint = TaskStepsPage.this.getRichTextEditorHeight();
                    ((GridData)TaskStepsPage.this.ctrl_expanded.getLayoutData()).widthHint = TaskStepsPage.this.getRichTextEditorWidth();
                }
                TaskStepsPage.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (TaskStepsPage.this.currentStep != null) {
                    String string = TaskStepsPage.this.currentStep.getName();
                    String string2 = TaskStepsPage.this.ctrl_name.getText();
                    if (TaskStepsPage.this.ctrl_name.getText() == null || TaskStepsPage.this.ctrl_name.getText().length() == 0) {
                        String string3 = AuthoringUIResources.bind((String)AuthoringUIResources.renameDialog_title, (Object)LibraryUIText.TEXT_STEP);
                        String string4 = AuthoringUIResources.bind((String)AuthoringUIResources.emptyElementNameError_msg, (Object)StrUtil.toLower((String)LibraryUIText.TEXT_STEP));
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string3, string4);
                        TaskStepsPage.this.ctrl_name.setSelection(0, string.length());
                    } else if (!string2.equals(string)) {
                        TaskStepsPage.this.actionMgr.doAction(1, (EObject)TaskStepsPage.this.currentStep, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string2, -1);
                    }
                }
            }
        });
        this.ctrl_maindesc.addModifyListener(this.contentModifyListener);
        this.ctrl_maindesc.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                TaskStepsPage.this.saveMainDescription();
            }
        });
        this.stepsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                TaskStepsPage.this.checkSelection();
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Section section = UmaFactory.eINSTANCE.createSection();
                String string = MessageFormat.format(AuthoringUIText.NEW_ELEMENT_TEXT, LibraryUIText.TEXT_STEP);
                section.setName(string);
                AddToSectionListCommand addToSectionListCommand = new AddToSectionListCommand((ContentElement)TaskStepsPage.this.task, section, TaskStepsPage.this.allSteps);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)addToSectionListCommand);
                TaskStepsPage.this.stepsTableViewer.refresh();
                TaskStepsPage.this.stepsTableViewer.setSelection((ISelection)new StructuredSelection((Object)section));
                TaskStepsPage.this.ctrl_name.setFocus();
                TaskStepsPage.this.ctrl_name.setSelection(0, string.length());
            }
        });
        this.ctrl_delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                for (Object e : iStructuredSelection.toList()) {
                    if (!(e instanceof Section)) continue;
                    RemoveFromSectionList removeFromSectionList = new RemoveFromSectionList((ContentElement)TaskStepsPage.this.task, (Section)e, TaskStepsPage.this.allSteps);
                    TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)removeFromSectionList);
                }
                TaskStepsPage.this.stepsTableViewer.refresh();
                TaskStepsPage.this.editStep(null);
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(iStructuredSelection.toList());
                MoveInSectionListCommand moveInSectionListCommand = new MoveInSectionListCommand((ContentElement)TaskStepsPage.this.task, arrayList, TaskStepsPage.this.allSteps, 1);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)moveInSectionListCommand);
                TaskStepsPage.this.stepsTableViewer.refresh();
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_up.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_up.setEnabled(false);
                }
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() < TaskStepsPage.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_down.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskStepsPage.this.stepsTableViewer.getSelection();
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(iStructuredSelection.toList());
                MoveInSectionListCommand moveInSectionListCommand = new MoveInSectionListCommand((ContentElement)TaskStepsPage.this.task, arrayList, TaskStepsPage.this.allSteps, 0);
                TaskStepsPage.this.getActionManager().execute((IResourceAwareCommand)moveInSectionListCommand);
                TaskStepsPage.this.stepsTableViewer.refresh();
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_up.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_up.setEnabled(false);
                }
                if (TaskStepsPage.this.stepsTableViewer.getTable().getSelectionIndex() < TaskStepsPage.this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)TaskStepsPage.this.task)) {
                    TaskStepsPage.this.ctrl_down.setEnabled(true);
                } else {
                    TaskStepsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_ordering.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SectionsOrderDialog sectionsOrderDialog = new SectionsOrderDialog(Display.getCurrent().getActiveShell(), (ContentElement)TaskStepsPage.this.task, TaskStepsPage.this.getActionManager(), AuthoringUIResources.StepsOrderDialog_title, AuthoringUIResources.StepsOrderDialog_description, AuthoringUIResources.steps_text);
                sectionsOrderDialog.open();
            }
        });
    }

    protected void enableControls(boolean bl) {
        this.ctrl_name.setEditable(bl);
        this.ctrl_maindesc.setEditable(bl);
        this.ctrl_add.setEnabled(bl);
        this.ctrl_delete.setEnabled(bl);
        this.ctrl_up.setEnabled(bl);
        this.ctrl_down.setEnabled(bl);
        this.ctrl_ordering.setEnabled(true);
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(bl);
        }
    }

    protected void deactivate() {
        if (this.allSteps != null) {
            this.allSteps.apply();
        }
    }

    private void loadData() {
        this.allSteps = null;
        this.stepsTableViewer.setInput((Object)this.task);
        this.stepsTableViewer.refresh();
        this.editStep(this.currentStep);
    }

    private void editStep(Section section) {
        this.contentModifyListener.setDisable(true);
        if (this.ctrl_maindesc.getModified()) {
            this.saveMainDescription();
        }
        this.currentStep = section;
        String string = "";
        String string2 = "";
        if (this.currentStep != null) {
            string = this.currentStep.getName();
            string2 = this.currentStep.getSectionDescription();
            this.ctrl_name.setFocus();
        }
        this.ctrl_name.setText(string == null ? "" : string);
        this.ctrl_maindesc.setText(string2 == null ? "" : string2);
        this.ctrl_maindesc.setModalObject((EObject)this.currentStep);
        this.ctrl_maindesc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription());
        if (section == null) {
            this.ctrl_maindesc.getFindReplaceAction().dispose();
        }
        this.contentModifyListener.setElement((EObject)this.currentStep);
        this.contentModifyListener.setDisable(this.currentStep == null);
        this.enableControls();
    }

    private void enableControls() {
        if (this.task.getPresentation().getSections().contains(this.currentStep)) {
            if (!TngUtil.isLocked((EObject)this.contentElement)) {
                this.ctrl_name.setEditable(true);
                this.ctrl_maindesc.setEditable(true);
            }
        } else {
            this.ctrl_name.setEditable(false);
            this.ctrl_maindesc.setEditable(false);
        }
    }

    public void dispose() {
    }

    private void createRichTextEditorSection() {
        this.expandedComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.expandedComposite.setLayoutData((Object)new TableWrapData(256));
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                TaskStepsPage.this.toggle(hyperlinkEvent);
            }
        });
        this.expandLabel = TaskStepsPage.createDecoratedLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent) {
        if (this.currentStep == null) {
            return;
        }
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandLabel);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.sectionComposite.setVisible(true);
            this.expandedComposite.setVisible(false);
            this.formSection.setClient((Control)this.sectionComposite);
            IMethodRichText iMethodRichText = this.activeControl;
            iMethodRichText.setText(this.ctrl_expanded.getText());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.removeListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            iMethodRichText.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.expandLabel.setText(String.valueOf(this.currentStep.getName()) + " - " + (String)((ImageHyperlink)hyperlinkEvent.getSource()).getData("Title"));
            IMethodRichText iMethodRichText = (IMethodRichText)hyperlinkEvent.getHref();
            this.ctrl_expanded.setInitialText(iMethodRichText.getText());
            this.ctrl_expanded.setModalObject(iMethodRichText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(iMethodRichText.getModalObjectFeature());
            this.ctrl_expanded.setFindReplaceAction(iMethodRichText.getFindReplaceAction());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.addListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            boolean bl = !TngUtil.isLocked((EObject)this.contentElement);
            this.ctrl_expanded.setEditable(bl);
            if (bl) {
                this.ctrl_expanded.setFocus();
            }
            this.activeControl = iMethodRichText;
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void initProviders() {
        this.stepsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (TaskStepsPage.this.allSteps == null) {
                    TaskStepsPage.this.allSteps = new SectionList((ContentElement)TaskStepsPage.this.task, 1);
                }
                return TaskStepsPage.this.allSteps.toArray();
            }
        };
        this.stepsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object object) {
                return !TaskStepsPage.this.task.getPresentation().getSections().contains(object);
            }
        };
    }

    private void saveMainDescription() {
        if (this.currentStep != null) {
            IMethodRichText iMethodRichText;
            IMethodRichText iMethodRichText2 = iMethodRichText = this.descExpandFlag ? this.ctrl_expanded : this.ctrl_maindesc;
            if (!iMethodRichText.getModified()) {
                return;
            }
            String string = this.currentStep.getSectionDescription();
            if (((MethodElementEditor)this.getEditor()).mustRestoreValue(iMethodRichText, string)) {
                return;
            }
            String string2 = iMethodRichText.getText();
            if (!string2.equals(string)) {
                this.actionMgr.doAction(1, (EObject)this.currentStep, (EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription(), (Object)string2, -1);
            }
        }
    }

    protected IActionManager getActionManager() {
        FormEditor formEditor = this.getEditor();
        if (formEditor instanceof MethodElementEditor) {
            return ((MethodElementEditor)formEditor).getActionManager();
        }
        return null;
    }

    private void checkSelection() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.stepsTableViewer.getSelection();
        if (iStructuredSelection.size() > 0 && !TngUtil.isLocked((EObject)this.task)) {
            this.ctrl_delete.setEnabled(true);
            if (this.stepsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)this.task) && iStructuredSelection.size() == 1) {
                this.ctrl_up.setEnabled(true);
            } else {
                this.ctrl_up.setEnabled(false);
            }
            if (this.stepsTableViewer.getTable().getSelectionIndex() < this.stepsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)this.task) && iStructuredSelection.size() == 1) {
                this.ctrl_down.setEnabled(true);
            } else {
                this.ctrl_down.setEnabled(false);
            }
        }
        if (iStructuredSelection.size() == 1) {
            this.editStep((Section)iStructuredSelection.getFirstElement());
        }
    }
}

