/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.internal.IProblemChangedListener;
import org.eclipse.epf.authoring.ui.providers.MethodElementUILabelProvider;
import org.eclipse.epf.authoring.ui.providers.ProblemsLabelDecorator;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class MethodElementEditorErrorTickUpdater
implements IProblemChangedListener {
    private MethodElementEditor fMethodElementEditor;
    private MethodElementUILabelProvider fLabelProvider;

    public MethodElementEditorErrorTickUpdater(MethodElementEditor methodElementEditor) {
        Assert.isNotNull((Object)((Object)methodElementEditor));
        this.fMethodElementEditor = methodElementEditor;
        this.fLabelProvider = new MethodElementUILabelProvider();
        this.fLabelProvider.addLabelDecorator(new ProblemsLabelDecorator(null));
        AuthoringUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    public void problemsChanged(IResource[] iResourceArray, boolean bl) {
        if (!bl) {
            return;
        }
        IEditorInput iEditorInput = this.fMethodElementEditor.getEditorInput();
        if (iEditorInput instanceof MethodElementEditorInput) {
            MethodElement methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement();
            if (methodElement instanceof ProcessComponent) {
                methodElement = ((ProcessComponent)methodElement).getProcess();
            }
            if (methodElement != null) {
                IResource iResource = PersistenceUtil.getWorkspaceResource((Object)methodElement);
                int n = 0;
                while (n < iResourceArray.length) {
                    if (iResourceArray[n].equals((Object)iResource)) {
                        this.updateEditorImage(methodElement);
                    }
                    ++n;
                }
            }
        }
    }

    public void updateEditorImage(MethodElement methodElement) {
        Image image = this.fMethodElementEditor.getTitleImage();
        if (image == null) {
            return;
        }
        Image image2 = this.fLabelProvider.getImage(methodElement);
        if (image != image2) {
            this.postImageChange(image2);
        }
    }

    private void postImageChange(final Image image) {
        Shell shell = this.fMethodElementEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MethodElementEditorErrorTickUpdater.this.fMethodElementEditor.updatedTitleImage(image);
                }
            });
        }
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        AuthoringUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

