/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TaskDescriptorStepSection
extends AbstractSection {
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private TaskDescriptor element;
    private IActionManager actionMgr;
    private FormToolkit toolkit;
    private Button ctrl_add;
    private Button ctrl_remove;
    private Button ctrl_up;
    private Button ctrl_down;
    private Table ctrl_selected;
    private TableViewer viewer;
    private Image titleImage;

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
        this.init();
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createStepSection(composite);
        this.addListeners();
    }

    private void init() {
        this.element = (TaskDescriptor)this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = EPFPropertySheetPage.getActionManager();
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof TaskDescriptor) {
                this.element = (TaskDescriptor)this.getElement();
                this.viewer.refresh();
                this.updateControls();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing TaskDescriptor step section" + this.element, (Throwable)exception);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
    }

    public void updateControls() {
        List list;
        this.ctrl_add.setEnabled(this.editable);
        if (this.element.getTask() == null) {
            this.ctrl_add.setEnabled(false);
        } else {
            list = this.getSteps();
            if (list != null && list.size() > 0) {
                this.ctrl_add.setEnabled(true);
            } else {
                this.ctrl_add.setEnabled(false);
            }
        }
        list = (IStructuredSelection)this.viewer.getSelection();
        if (list.size() > 0 && this.editable) {
            this.ctrl_remove.setEnabled(this.editable);
            this.ctrl_up.setEnabled(this.editable);
            this.ctrl_down.setEnabled(this.editable);
        } else {
            this.ctrl_remove.setEnabled(false);
            this.ctrl_up.setEnabled(false);
            this.ctrl_down.setEnabled(false);
        }
    }

    private void createStepSection(Composite composite) {
        List list;
        org.eclipse.ui.forms.widgets.Section section = FormUI.createSection(this.toolkit, composite, PropertiesResources.TaskDescriptor_stepInformationTitle, PropertiesResources.TaskDescriptor_stepInformationDescription);
        Composite composite2 = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite composite3 = FormUI.createComposite(this.toolkit, composite2, 1808);
        FormUI.createLabel(this.toolkit, composite3, PropertiesResources.TaskDescriptor_Selected_Steps);
        this.ctrl_selected = FormUI.createTable(this.toolkit, composite3);
        this.viewer = new TableViewer(this.ctrl_selected);
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return TaskDescriptorStepSection.this.element.getSelectedSteps().toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.element);
        Composite composite4 = FormUI.createComposite(this.toolkit, composite2, 68);
        this.ctrl_add = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Add);
        this.ctrl_add.setEnabled(false);
        this.ctrl_remove = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Remove);
        this.ctrl_remove.setEnabled(false);
        this.ctrl_up = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Up);
        this.ctrl_down = FormUI.createButton(this.toolkit, composite4, PropertiesResources.Process_Down);
        if (this.element.getTask() != null && (list = this.getSteps()) != null && list.size() > 0) {
            this.ctrl_add.setEnabled(true);
        }
        this.toolkit.paintBordersFor(composite2);
        this.toolkit.paintBordersFor(composite3);
    }

    private void addListeners() {
        this.ctrl_selected.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_remove.setEnabled(TaskDescriptorStepSection.this.editable);
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(TaskDescriptorStepSection.this.editable);
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(TaskDescriptorStepSection.this.editable);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_remove.setEnabled(true);
                    if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && iStructuredSelection.size() == 1) {
                        TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                    } else {
                        TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                    }
                    if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && iStructuredSelection.size() == 1) {
                        TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                    } else {
                        TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                    }
                }
                if (iStructuredSelection.size() == 1) {
                    String string = ((MethodElement)iStructuredSelection.getFirstElement()).getBriefDescription();
                    if (string == null) {
                        string = "";
                    }
                } else {
                    iStructuredSelection.size();
                }
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                    public Object[] getElements(Object object) {
                        return TaskDescriptorStepSection.this.getSteps().toArray();
                    }
                };
                VariabilityElementLabelProvider variabilityElementLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

                    public boolean isExternal(Object object) {
                        boolean bl = !TaskDescriptorStepSection.this.element.getTask().getPresentation().getSections().contains(object);
                        return bl;
                    }
                };
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)TaskDescriptorStepSection.this.element.getTask(), (IStructuredContentProvider)adapterFactoryContentProvider, (ILabelProvider)variabilityElementLabelProvider, PropertiesResources.TaskDescriptor_StepDialogMessage);
                TaskDescriptorStepSection.this.titleImage = Display.getCurrent().getActiveShell().getImage();
                ListSelectionDialog.setDefaultImage((Image)TaskDescriptorStepSection.this.titleImage);
                listSelectionDialog.setTitle(PropertiesResources.TaskDescriptor_StepDialogTitle);
                listSelectionDialog.setBlockOnOpen(true);
                listSelectionDialog.open();
                TaskDescriptorStepSection.this.addSteps(listSelectionDialog.getResult());
                List list = TaskDescriptorStepSection.this.getSteps();
                if (list != null && list.size() > 0) {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(false);
                }
                TaskDescriptorStepSection.this.viewer.refresh();
            }
        });
        this.ctrl_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                List list;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    list = new ArrayList();
                    ((ArrayList)list).addAll(iStructuredSelection.toList());
                    TaskDescriptorStepSection.this.removeSteps(list);
                    TaskDescriptorStepSection.this.viewer.refresh();
                    TaskDescriptorStepSection.this.viewer.setSelection(null, true);
                }
                if ((list = TaskDescriptorStepSection.this.getSteps()) != null && list.size() > 0) {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_add.setEnabled(false);
                }
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ArrayList arrayList = new ArrayList();
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.addAll(iStructuredSelection.toList());
                    BasicEList basicEList = (BasicEList)TaskDescriptorStepSection.this.element.getSelectedSteps();
                    for (Object e : arrayList2) {
                        int n = basicEList.indexOf(e);
                        if (n <= 0) continue;
                        basicEList.move(n - 1, e);
                    }
                    arrayList.addAll(basicEList);
                    TaskDescriptorStepSection.this.actionMgr.doAction(6, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)basicEList, -1);
                    TaskDescriptorStepSection.this.actionMgr.doAction(5, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), arrayList, -1);
                    TaskDescriptorStepSection.this.viewer.refresh();
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ArrayList arrayList = new ArrayList();
                IStructuredSelection iStructuredSelection = (IStructuredSelection)TaskDescriptorStepSection.this.viewer.getSelection();
                if (iStructuredSelection.size() > 0) {
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.addAll(iStructuredSelection.toList());
                    BasicEList basicEList = (BasicEList)TaskDescriptorStepSection.this.element.getSelectedSteps();
                    for (Object e : arrayList2) {
                        int n = basicEList.indexOf(e);
                        if (n >= basicEList.size() - 1) continue;
                        basicEList.move(n + arrayList2.size(), e);
                    }
                    arrayList.addAll(basicEList);
                    TaskDescriptorStepSection.this.actionMgr.doAction(6, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)basicEList, -1);
                    TaskDescriptorStepSection.this.actionMgr.doAction(5, (EObject)TaskDescriptorStepSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), arrayList, -1);
                    TaskDescriptorStepSection.this.viewer.refresh();
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() > 0 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_up.setEnabled(false);
                }
                if (TaskDescriptorStepSection.this.viewer.getTable().getSelectionIndex() < TaskDescriptorStepSection.this.viewer.getTable().getItemCount() - 1 && TaskDescriptorStepSection.this.editable) {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(true);
                } else {
                    TaskDescriptorStepSection.this.ctrl_down.setEnabled(false);
                }
            }
        });
    }

    private void addSteps(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Section section = (Section)objectArray[n];
                this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)section, -1);
                ++n;
            }
        }
    }

    private void removeSteps(List list) {
        if (!list.isEmpty()) {
            for (Section section : list) {
                this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps(), (Object)section, -1);
            }
        }
    }

    private List getSteps() {
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration methodConfiguration = TngUtil.getOwningProcess((BreakdownElement)this.element).getDefaultContext();
        List list = (List)iConfigurationApplicator.getReference((VariabilityElement)this.element.getTask(), UmaPackage.eINSTANCE.getTask_Steps(), methodConfiguration);
        list.removeAll(this.element.getSelectedSteps());
        return list;
    }
}

