/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.element.TransientContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryValidationMarkerHelper
extends ValidateAction.EclipseResourcesUtil {
    public static final LibraryValidationMarkerHelper INSTANCE = new LibraryValidationMarkerHelper();
    public static final String GUID = "guid";
    private static ErrorCalculator errorCalculator = new ErrorCalculator();

    protected IFile getFile(URI uRI) {
        if (uRI.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uRI.toFileString());
        }
        return super.getFile(uRI);
    }

    protected boolean adjustMarker(IMarker iMarker, Diagnostic diagnostic) throws CoreException {
        Object e;
        boolean bl = super.adjustMarker(iMarker, diagnostic);
        if (!diagnostic.getData().isEmpty() && (e = diagnostic.getData().get(0)) instanceof MethodElement) {
            iMarker.setAttribute(GUID, (Object)((MethodElement)e).getGuid());
            iMarker.setAttribute("location", (Object)TngUtil.getLabelWithPath(e));
            iMarker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
            errorCalculator.addError((MethodElement)e);
        }
        return bl;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ProcessesItemProvider) {
            ProcessesItemProvider processesItemProvider = (ProcessesItemProvider)object;
            ProcessPackage processPackage = processesItemProvider.getCapabilityPatternPackage();
            return processPackage != null && errorCalculator.hasErrors((MethodElement)processPackage) || (processPackage = processesItemProvider.getDeliveryProcessPackage()) != null && errorCalculator.hasErrors((MethodElement)processPackage);
        }
        if (object instanceof MethodPackagesItemProvider) {
            object = ((ItemProviderAdapter)object).getTarget();
        } else if (object instanceof ContentItemProvider) {
            ContentPackage contentPackage = ((ContentItemProvider)object).getCoreContentPackage();
            if (contentPackage != null) {
                object = contentPackage.eContainer();
            }
        } else {
            if (object instanceof TransientContentPackageItemProvider) {
                Collection collection = ((TransientContentPackageItemProvider)object).getChildren(object);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Object object2 = TngUtil.unwrap(iterator.next());
                    if (!(object2 instanceof MethodElement) || !errorCalculator.hasErrors((MethodElement)object2)) continue;
                    return true;
                }
                return false;
            }
            if (object instanceof TransientGroupItemProvider) {
                object = ((TransientGroupItemProvider)object).getTarget();
            }
        }
        object = TngUtil.unwrap((Object)object);
        return object instanceof MethodElement && errorCalculator.hasErrors((MethodElement)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMarkers(Object object) {
        if (!(object instanceof MethodElement)) return super.hasMarkers(object);
        IFile iFile = this.getFile(object);
        if (iFile == null) return false;
        if (!iFile.exists()) return false;
        try {
            String string = ((MethodElement)object).getGuid();
            IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
            int n = 0;
            while (true) {
                if (n >= iMarkerArray.length) {
                    return false;
                }
                IMarker iMarker = iMarkerArray[n];
                if (string.equals(iMarker.getAttribute(GUID))) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected IFile getFile(Object object) {
        try {
            return super.getFile(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deleteMarkers(Object object) {
        if (object instanceof MethodElement) {
            IFile iFile = this.getFile(object);
            if (iFile != null && iFile.exists()) {
                try {
                    MethodElement methodElement = (MethodElement)object;
                    String string = methodElement.getGuid();
                    IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        if (string.equals(iMarker.getAttribute(GUID))) {
                            iMarker.delete();
                            errorCalculator.removeError(methodElement);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
            return;
        }
        super.deleteMarkers(object);
    }

    protected void deleteMarkers(IResource iResource, boolean bl, int n) {
        if (iResource != null && iResource.exists()) {
            try {
                IMarker[] iMarkerArray = iResource.findMarkers(this.getMarkerID(), false, 0);
                int n2 = 0;
                while (n2 < iMarkerArray.length) {
                    IMarker iMarker = iMarkerArray[n2];
                    String string = (String)iMarker.getAttribute(GUID);
                    MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                    if (methodElement != null) {
                        errorCalculator.removeError(methodElement);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        super.deleteMarkers(iResource, bl, n);
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic diagnostic2) {
        int n = diagnostic.getMessage().indexOf(LibraryEditResources.duplicateElementNameError_msg2);
        if (n > 0) {
            return diagnostic.getMessage().substring(0, n);
        }
        return super.composeMessage(diagnostic, diagnostic2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorCalculator
    extends HashMap<MethodPlugin, Set<MethodElement>> {
        private static final long serialVersionUID = 1L;

        public ErrorCalculator() {
            this.initialize();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary methodLibrary) {
                    ErrorCalculator.this.initialize();
                }

                public void libraryClosed(MethodLibrary methodLibrary) {
                    ErrorCalculator.this.clear();
                }

                public void libraryReopened(MethodLibrary methodLibrary) {
                    ErrorCalculator.this.initialize();
                }
            });
        }

        private void initialize() {
            this.clear();
            MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
            if (methodLibrary != null) {
                IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                try {
                    IMarker[] iMarkerArray = iWorkspaceRoot.findMarkers(INSTANCE.getMarkerID(), false, 2);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        String string = (String)iMarker.getAttribute(LibraryValidationMarkerHelper.GUID);
                        MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                        if (methodElement != null) {
                            if (methodElement.eIsProxy()) {
                                methodElement = (MethodElement)PersistenceUtil.resolve((EObject)methodElement, (ResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet());
                            }
                            this.addError(methodElement);
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
        }

        public void addError(MethodElement methodElement) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            if (methodPlugin != null) {
                HashSet<MethodElement> hashSet = (HashSet<MethodElement>)this.get(methodPlugin);
                if (hashSet == null) {
                    hashSet = new HashSet<MethodElement>();
                    this.put(methodPlugin, hashSet);
                }
                hashSet.add(methodElement);
            }
        }

        public void removeError(MethodElement methodElement) {
            Set set;
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            if (methodPlugin != null && (set = (Set)this.get(methodPlugin)) != null) {
                set.remove(methodElement);
                if (set.isEmpty()) {
                    this.remove(methodPlugin);
                }
            }
        }

        public boolean hasErrors(MethodElement methodElement) {
            Set set;
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            if (methodPlugin != null && (set = (Set)this.get(methodPlugin)) != null) {
                if (set.contains(methodElement)) {
                    return true;
                }
                HashSet<Object> hashSet = null;
                for (MethodElement methodElement2 : set) {
                    if (UmaUtil.isContainedBy((EObject)methodElement2, (Object)methodElement)) {
                        return true;
                    }
                    if (methodElement2 instanceof CustomCategory) {
                        if (hashSet == null) {
                            hashSet = new HashSet<Object>();
                        } else {
                            hashSet.clear();
                        }
                        if (!ErrorCalculator.isParentOf(methodElement2, methodElement, IParentProvider.parentCustomCategoryProvider, hashSet)) continue;
                        return true;
                    }
                    if (!(methodElement2 instanceof ContentCategory)) continue;
                    if (methodElement instanceof ContentPackage && methodElement == UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.standardCategoryPath)) {
                        return true;
                    }
                    if (hashSet == null) {
                        hashSet = new HashSet();
                    } else {
                        hashSet.clear();
                    }
                    if (!ErrorCalculator.isParentOf(methodElement2, methodElement, IParentProvider.parentStandardCategoryProvider, hashSet)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isParentOf(Object object, Object object2, IParentProvider iParentProvider, Set<Object> set) {
            set.add(object);
            for (Object obj : iParentProvider.getParents(object)) {
                if (obj == object2) {
                    return true;
                }
                if (set.contains(obj) || !ErrorCalculator.isParentOf(obj, object2, iParentProvider, set)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IParentProvider {
        public static final IParentProvider containerProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof EObject) {
                    return Collections.singleton(((EObject)object).eContainer());
                }
                return Collections.emptyList();
            }
        };
        public static final IParentProvider parentCustomCategoryProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof CustomCategory) {
                    return AssociationHelper.getCustomCategories((DescribableElement)((CustomCategory)object));
                }
                return Collections.emptyList();
            }
        };
        public static final IParentProvider parentStandardCategoryProvider = new IParentProvider(){

            @Override
            public Collection<?> getParents(Object object) {
                if (object instanceof Discipline) {
                    Discipline discipline = (Discipline)object;
                    List list = AssociationHelper.getDiscipline((Discipline)discipline);
                    List list2 = AssociationHelper.getDisciplineGroups((Discipline)discipline);
                    if (!list.isEmpty() && !list2.isEmpty()) {
                        ArrayList arrayList = new ArrayList(list2);
                        arrayList.addAll(list);
                        return arrayList;
                    }
                    return list.isEmpty() ? list2 : list;
                }
                if (object instanceof RoleSet) {
                    return AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)object));
                }
                return Collections.emptyList();
            }
        };

        public Collection<?> getParents(Object var1);
    }
}

