/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.wizards.DirectoryValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathSelectionDialog
extends Dialog {
    protected Text ctrl_path;
    protected Button ctrl_browse_button;
    protected String title;
    protected String message;
    protected String value;

    public PathSelectionDialog(Shell shell, String string, String string2, String string3) {
        super(shell);
        this.title = string;
        this.message = string2;
        this.value = string3;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.value = this.ctrl_path.getText();
            String string = LibraryUIResources.pathSelectionError_msg;
            if (!DirectoryValidator.checkAndCreateDir(this.value, this.title, string)) {
                return;
            }
        } else {
            this.value = null;
        }
        super.buttonPressed(n);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.ctrl_path.setFocus();
        if (this.value != null) {
            this.ctrl_path.setText(this.value);
            this.ctrl_path.selectAll();
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        if (this.message != null) {
            Label label = new Label(composite2, 64);
            label.setText(this.message);
            GridData gridData = new GridData(1796);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            label.setFont(composite.getFont());
        }
        this.ctrl_path = new Text(composite2, 2052);
        this.ctrl_path.setLayoutData((Object)new GridData(768));
        this.ctrl_browse_button = new Button(composite2, 0);
        this.ctrl_browse_button.setLayoutData((Object)new GridData(128));
        this.ctrl_browse_button.setText(LibraryUIResources.browseButton_text);
        this.ctrl_browse_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PathSelectionDialog.this.openDirectoryDialog();
            }
        });
        PathSelectionDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0);
            directoryDialog.setFilterPath(this.ctrl_path.getText());
            String string = directoryDialog.open();
            if (string != null) {
                this.ctrl_path.setText(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getPath() {
        return this.value;
    }
}

