/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.internal.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryWizardPageFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.preferences.RecentlyOpenedLibrary;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OpenLibraryMainPage2
extends BaseWizardPage {
    public static final String PAGE_NAME = OpenLibraryMainPage2.class.getName();
    protected static final String TYPE_ID = "typeId";
    protected Combo nameCombo;
    protected Text uriText;
    protected Button openUnlistedLibraryCheckbox;
    protected boolean openUnlistedLibrary = false;
    protected Button[] radioButtons;
    protected Map<String, RecentlyOpenedLibrary> recentlyOpenedLibraries = new HashMap<String, RecentlyOpenedLibrary>();

    public OpenLibraryMainPage2() {
        super(PAGE_NAME);
        this.setTitle(LibraryUIResources.openLibraryWizard_title);
        this.setDescription(LibraryUIResources.openLibraryMainWizardPage_title_2);
        this.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
    }

    public void createControl(Composite composite) {
        RecentlyOpenedLibrary recentlyOpenedLibrary2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(LibraryUIResources.nameLabel_text);
        this.nameCombo = new Combo(composite2, 2056);
        this.nameCombo.setLayoutData((Object)new GridData(768));
        List list = OpenLibraryMainPage2.getRecentlyOpenedLibraries();
        for (RecentlyOpenedLibrary recentlyOpenedLibrary2 : list) {
            this.recentlyOpenedLibraries.put(recentlyOpenedLibrary2.getName(), recentlyOpenedLibrary2);
        }
        String[] stringArray = new String[this.recentlyOpenedLibraries.size()];
        this.recentlyOpenedLibraries.keySet().toArray(stringArray);
        this.nameCombo.setItems(stringArray);
        recentlyOpenedLibrary2 = new Label(composite2, 0);
        recentlyOpenedLibrary2.setText(LibraryUIResources.uriLabel_text);
        this.uriText = new Text(composite2, 2048);
        this.uriText.setLayoutData((Object)new GridData(768));
        this.uriText.setEditable(false);
        this.openUnlistedLibraryCheckbox = new Button(composite2, 32);
        this.openUnlistedLibraryCheckbox.setText(LibraryUIResources.openUnlistedLibraryCheckbox_text);
        this.openUnlistedLibraryCheckbox.setLayoutData((Object)new GridData(768));
        ((GridData)this.openUnlistedLibraryCheckbox.getLayoutData()).horizontalSpan = 2;
        Label label2 = new Label(composite2, 0);
        label2.setText(LibraryUIResources.libraryTypeLabel_text);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayout((Layout)new GridLayout(2, false));
        composite3.setLayoutData((Object)new GridData(768));
        Map map = LibraryManagerFactory.getInstance().getLibraryTypes();
        this.radioButtons = new Button[map.size()];
        int n = 0;
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            Button button = new Button(composite3, 16);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OpenLibraryMainPage2.this.setPageComplete(OpenLibraryMainPage2.this.isPageComplete());
                    OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
                }
            });
            button.setText(string2);
            button.setData(TYPE_ID, (Object)string);
            this.radioButtons[n++] = button;
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
        }
        this.addListeners();
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)composite2);
    }

    public IWizardPage getNextPage() {
        OpenLibraryWizardPage openLibraryWizardPage = OpenLibraryWizardPageFactory.getInstance().getWizardPage(this.getLibraryType());
        if (openLibraryWizardPage != null) {
            openLibraryWizardPage.onEnterPage(this.getLibraryName());
        }
        if (!this.openUnlistedLibrary) {
            return null;
        }
        return openLibraryWizardPage;
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0 || this.openUnlistedLibrary;
    }

    private void addListeners() {
        this.nameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.openUnlistedLibraryCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OpenLibraryMainPage2.this.openUnlistedLibrary = OpenLibraryMainPage2.this.openUnlistedLibraryCheckbox.getSelection();
                OpenLibraryMainPage2.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getLibraryName() {
        return this.nameCombo.getText().trim();
    }

    public String getLibraryURI() {
        RecentlyOpenedLibrary recentlyOpenedLibrary = this.recentlyOpenedLibraries.get(this.getLibraryName());
        return recentlyOpenedLibrary.getURI().toString();
    }

    public String getLibraryPath() {
        RecentlyOpenedLibrary recentlyOpenedLibrary = this.recentlyOpenedLibraries.get(this.getLibraryName());
        return recentlyOpenedLibrary.getPath();
    }

    public boolean isOpenUnlistedLibrary() {
        return this.openUnlistedLibrary;
    }

    public String getLibraryType() {
        int n = 0;
        while (n < this.radioButtons.length) {
            Button button = this.radioButtons[n];
            if (button.getSelection()) {
                return (String)button.getData(TYPE_ID);
            }
            ++n;
        }
        return (String)this.radioButtons[0].getData(TYPE_ID);
    }

    protected static List getRecentlyOpenedLibraries() {
        List list = LibraryUIPreferences.getOpenLibraryURIsList();
        ArrayList<RecentlyOpenedLibrary> arrayList = new ArrayList<RecentlyOpenedLibrary>();
        if (list.size() > 0) {
            for (String string : list) {
                arrayList.add(new RecentlyOpenedLibrary(string));
            }
        }
        return arrayList;
    }
}

