/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.uma.MethodPlugin;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseExportService {
    protected static final String exportFile = "export.xmi";
    protected static final String libraryFile = "library.xmi";
    protected List selectedIds = new ArrayList();
    protected List selectedPluginNames = new ArrayList();

    protected boolean isIdSelected(String string) {
        for (String string2 : this.selectedIds) {
            if (string.indexOf(string2) < 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isSelectedPluginResource(String string) {
        for (String string2 : this.selectedPluginNames) {
            if (!string.startsWith(String.valueOf(string2) + "/")) continue;
            return true;
        }
        return false;
    }

    protected boolean isResourceSelected(String string) {
        if (this.isIdSelected(string)) {
            return true;
        }
        return this.isSelectedPluginResource(string);
    }

    protected LibraryDocument processLibraryFile(File file, File file2) {
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            LibraryDocument libraryDocument = new LibraryDocument(file);
            NodeList nodeList = libraryDocument.getPlugins();
            int n = 0;
            while (n < nodeList.getLength()) {
                object3 = (Element)nodeList.item(n);
                object2 = object3.getAttribute("href");
                if (!this.isIdSelected((String)object2)) {
                    libraryDocument.removePlugin((Element)object3);
                    continue;
                }
                ++n;
            }
            nodeList = libraryDocument.getConfigurations();
            n = 0;
            while (n < nodeList.getLength()) {
                object3 = (Element)nodeList.item(n);
                object2 = object3.getAttribute("href");
                if (!this.isIdSelected((String)object2)) {
                    libraryDocument.removeConfiguration((Element)object3);
                    continue;
                }
                ++n;
            }
            object3 = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
            object2 = MethodElementUtil.buildMap((Collection)object3);
            nodeList = libraryDocument.getResourceDescriptors();
            n = 0;
            while (n < nodeList.getLength()) {
                object = (Element)nodeList.item(n);
                string = object.getAttribute("id");
                String string2 = this.getPluginResMgrUri(string, (Element)object, (Map<String, MethodPlugin>)object2);
                if (!this.isIdSelected(string) && !this.isResourceSelected(URLDecoder.decode(string2, "UTF-8"))) {
                    libraryDocument.removeResourceDescriptor((Element)object);
                    continue;
                }
                ++n;
            }
            nodeList = libraryDocument.getResourceSubManagers();
            n = 0;
            while (n < nodeList.getLength()) {
                object = (Element)nodeList.item(n);
                string = object.getAttribute("href");
                if (!this.isResourceSelected(string)) {
                    libraryDocument.removeResourceDescriptor((Element)object);
                    continue;
                }
                ++n;
            }
            object = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
            libraryDocument.storeExtraInfo((List<MethodPlugin>)object);
            libraryDocument.saveAs(file2.getAbsolutePath());
            return libraryDocument;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String getPluginResMgrUri(String string, Element element, Map<String, MethodPlugin> map) {
        String string2;
        String string3 = element.getAttribute("uri");
        MethodPlugin methodPlugin = map.get(string);
        if (methodPlugin != null && !(string2 = String.valueOf(methodPlugin.getName()) + "/plugin.xmi").equals(string3)) {
            element.setAttribute("uri", string2);
            return string2;
        }
        return string3;
    }
}

