/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;

public class ConfigurationExportService {
    public static String excludes = ".copyarea.dat, **/.copyarea.dat, .copyarea.db, **/.copyarea.db";
    private ConfigurationExportData data;

    public ConfigurationExportService(ConfigurationExportData configurationExportData) {
        this.data = configurationExportData;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        try {
            if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
                return;
            }
            iProgressMonitor.setTaskName(ExportResources.ConfigurationExportService_MSG0);
            String string = this.data.llData.getParentFolder();
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            MethodConfiguration methodConfiguration = (MethodConfiguration)this.data.selectedConfigs.get(0);
            this.exportConfig(methodConfiguration.getName(), file.getAbsolutePath(), iProgressMonitor);
        }
        catch (Exception exception) {
            ExportPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    public void exportConfig(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        boolean bl = RefreshJob.getInstance().isEnabled();
        try {
            if (bl) {
                RefreshJob.getInstance().setEnabled(false);
            }
            this.doEexportConfig(string, string2, iProgressMonitor);
        }
        finally {
            if (bl) {
                RefreshJob.getInstance().setEnabled(true);
            }
        }
    }

    private void doEexportConfig(String string, String string2, IProgressMonitor iProgressMonitor) throws Exception {
        Object object;
        Object object2;
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        try {
            LibraryUtil.loadAll((MethodLibrary)methodLibrary);
        }
        catch (Throwable throwable) {
            ExportPlugin.getDefault().getLogger().logError("Error loading library", throwable);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG2;
            return;
        }
        MethodLibrary methodLibrary2 = null;
        try {
            methodLibrary2 = (MethodLibrary)EcoreUtil.copy((EObject)methodLibrary);
        }
        catch (Throwable throwable) {
            ExportPlugin.getDefault().getLogger().logError(throwable);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG4;
            return;
        }
        ConfigurationClosure configurationClosure = null;
        try {
            LibraryUtil.detachFromResource((MethodLibrary)methodLibrary2);
            object2 = new HashMap<String, String>();
            object2.put("library.path", string2);
            object2.put("libraryRegisterType", "ConfigExport");
            LibraryService.getInstance().registerMethodLibrary(methodLibrary2, "xmi", object2);
            object = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)methodLibrary2, (String)string);
            LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)object);
            configurationClosure = new ConfigurationClosure(null, object);
            configurationClosure.packageLibrary(this.data.removeBrokenReferences);
        }
        catch (Throwable throwable) {
            ExportPlugin.getDefault().getLogger().logError("Error making library configuration closure", throwable);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG1;
            if (configurationClosure != null) {
                configurationClosure.dispose();
            }
            LibraryService.getInstance().unRegisterMethodLibrary(methodLibrary2);
            return;
        }
        try {
            LibraryUtil.saveAll((MethodLibrary)methodLibrary2);
            LibraryUtil.saveAll((MethodLibrary)methodLibrary2);
        }
        catch (Throwable throwable) {
            ExportPlugin.getDefault().getLogger().logError("Error saving library", throwable);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG9;
            if (configurationClosure != null) {
                configurationClosure.dispose();
            }
            LibraryService.getInstance().unRegisterMethodLibrary(methodLibrary2);
            return;
        }
        object2 = "resources/**, **/resources/**, **/diagram.xmi";
        object = LibraryUtil.getLibraryRootPath((MethodLibrary)methodLibrary);
        File file = LibraryUtil.getLibraryRootPath((MethodLibrary)methodLibrary2);
        LayoutResources.copyDir((File)object, (File)file, (String)object2, (String)excludes);
        this.handleExtraResourceCopy(methodLibrary, methodLibrary2, (File)object, file, (String)object2);
        if (configurationClosure != null) {
            configurationClosure.dispose();
        }
        LibraryService.getInstance().unRegisterMethodLibrary(methodLibrary2);
    }

    private void handleExtraResourceCopy(MethodLibrary methodLibrary, MethodLibrary methodLibrary2, File file, File file2, String string) {
        ILibraryResourceManager iLibraryResourceManager = LibraryService.getInstance().getCurrentLibraryManager().getResourceManager();
        Map map = MethodElementUtil.buildMap((Collection)methodLibrary.getMethodPlugins());
        List list = methodLibrary.getMethodPlugins();
        int n = 0;
        while (n < list.size()) {
            MethodPlugin methodPlugin;
            MethodPlugin methodPlugin2 = (MethodPlugin)list.get(n);
            File file3 = new File(iLibraryResourceManager.getPhysicalPath((MethodElement)methodPlugin2));
            boolean bl = file.equals(file3.getParentFile());
            if (!bl && (methodPlugin = (MethodPlugin)map.get(methodPlugin2.getGuid())) != null) {
                File file4 = new File(file2, methodPlugin.getName());
                LayoutResources.copyDir((File)file3, (File)file4, (String)string, (String)excludes);
            }
            ++n;
        }
    }
}

