/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;

public class PluginExportService
extends BaseExportService {
    PluginExportData data;

    public PluginExportService(PluginExportData pluginExportData) {
        this.data = pluginExportData;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        Object object2;
        iProgressMonitor.setTaskName(ExportResources.PluginExportService_MSG0);
        List list = this.data.selectedPlugins;
        if (list == null || list.size() == 0) {
            return;
        }
        iProgressMonitor.setTaskName(ExportResources.PluginExportService_MSG1);
        String string = new File(this.data.llData.getParentFolder()).getAbsolutePath();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        iProgressMonitor.setTaskName(ExportResources.PluginExportService_MSG2);
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        String string2 = methodLibrary.eResource().getURI().toFileString();
        File file2 = new File(string2);
        for (Object object2 : list) {
            if (object2 == null) continue;
            URI uRI = object2.eResource().getURI();
            String string3 = uRI.toFileString();
            File file3 = new File(string3).getParentFile();
            String string4 = String.valueOf(object2.getName()) + File.separator;
            File file4 = new File(file, string4);
            PluginExportService.copyDir(file3, file4);
        }
        iProgressMonitor.setTaskName(ExportResources.PluginExportService_MSG3);
        this.getSelectedIds(this.data.selectedPlugins, this.data.associatedConfigMap);
        File file5 = new File(LibraryService.getInstance().getCurrentMethodLibraryLocation());
        object2 = this.processLibraryFile(file2, new File(file, "export.xmi"));
        if (object2 != null) {
            this.copyConfigurationFiles((LibraryDocument)object2, file5, file);
        }
        iProgressMonitor.setTaskName(ExportResources.PluginExportService_MSG4);
    }

    private void copyConfigurationFiles(LibraryDocument libraryDocument, File file, File file2) {
        for (List list : this.data.associatedConfigMap.values()) {
            if (list == null || list.size() == 0) continue;
            for (MethodConfiguration methodConfiguration : list) {
                Object object;
                String string = methodConfiguration.getGuid();
                String string2 = libraryDocument.getResourceUri(string);
                File file3 = null;
                if (string2 == null) {
                    object = methodConfiguration.eResource().getURI();
                    string2 = "configurations" + File.separator + object.lastSegment();
                    string2 = libraryDocument.decodeUri(string2);
                    file3 = new File(object.toFileString());
                }
                if (string2 == null) continue;
                if (file3 == null) {
                    file3 = new File(file, string2);
                }
                object = new File(file2, string2);
                FileUtil.copyFile((File)file3, (File)object);
            }
        }
    }

    public static void copyDir(File file, File file2) {
        Copy copy = new Copy();
        copy.setOverwrite(true);
        FileSet fileSet = new FileSet();
        fileSet.setExcludes(ConfigurationExportService.excludes);
        fileSet.setDir(file);
        copy.addFileset(fileSet);
        copy.setTodir(file2);
        copy.setProject(new Project());
        copy.setPreserveLastModified(true);
        copy.execute();
    }

    private void getSelectedIds(List list, Map map) {
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        MethodPlugin methodPlugin = null;
        Object object = list.iterator();
        while (object.hasNext()) {
            methodPlugin = (MethodPlugin)object.next();
            Object object2 = methodPlugin.getGuid();
            this.selectedPluginNames.add(methodPlugin.getName());
            if (this.selectedIds.contains(object2)) continue;
            this.selectedIds.add(object2);
        }
        if (methodPlugin != null && (object = (MethodLibrary)methodPlugin.eContainer()) != null) {
            this.selectedIds.add(object.getGuid());
        }
        for (Object object2 : map.values()) {
            if (object2 == null || object2.size() == 0) continue;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                MethodConfiguration methodConfiguration = (MethodConfiguration)iterator.next();
                String string = methodConfiguration.getGuid();
                if (this.selectedIds.contains(string)) continue;
                this.selectedIds.add(string);
                EList eList = methodConfiguration.eCrossReferences();
                for (Object e : eList) {
                    if (e instanceof MethodPlugin || e instanceof MethodPackage) {
                        string = ((MethodElement)e).getGuid();
                        if (this.selectedIds.contains(string)) continue;
                        this.selectedIds.add(string);
                        continue;
                    }
                    System.out.println("Unexpected element type '" + ((MethodElement)e).getType().getName() + "' in configuration '" + methodConfiguration.getName() + "'");
                }
            }
        }
    }
}

