/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.wizards.ExportPluginWizard;
import org.eclipse.epf.export.wizards.PluginInfoPage;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SelectPluginPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME = SelectPluginPage.class.getName();
    private Table table;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_author;
    private Text ctrl_version;
    private Text ctrl_briefDesc;
    private int checkedCount = 0;
    private List<Object> checkedPluginList = new ArrayList<Object>();
    private PluginExportData data;

    public SelectPluginPage(PluginExportData pluginExportData) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectPluginsPage_title);
        this.setDescription(ExportResources.selectPluginsPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_meth_plugin_wizban.gif"));
        this.data = pluginExportData;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        SelectPluginPage.createLabel((Composite)composite2, (String)ExportResources.selectPluginsPage_pluginsLabel_text);
        this.ctrl_chkboxTableViewer = SelectPluginPage.createCheckboxTableViewer((Composite)composite2, (int)1);
        this.table = this.ctrl_chkboxTableViewer.getTable();
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        List list = methodLibrary == null ? new ArrayList() : methodLibrary.getMethodPlugins();
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object object) {
                if (object instanceof MethodPlugin) {
                    return ((MethodPlugin)object).getName();
                }
                return object.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (list != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)list.toArray());
        }
        SelectPluginPage.createLabel((Composite)composite2, (String)AuthoringUIText.AUTHORS_TEXT);
        this.ctrl_author = SelectPluginPage.createMultiLineText((Composite)composite2, (String)"", (int)360, (int)40, (int)3);
        SelectPluginPage.createLabel((Composite)composite2, (String)AuthoringUIText.VERSION_TEXT);
        this.ctrl_version = SelectPluginPage.createText((Composite)composite2, (String)"", (int)360, (int)3);
        SelectPluginPage.createLabel((Composite)composite2, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = SelectPluginPage.createMultiLineText((Composite)composite2, (String)"", (int)360, (int)80, (int)3);
        if (list != null && !list.isEmpty()) {
            this.table.select(0);
            this.setDisplayAttributes((MethodPlugin)list.get(0));
        }
        this.addListeners();
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
        Object object = checkStateChangedEvent.getElement();
        if (checkStateChangedEvent.getChecked()) {
            ++this.checkedCount;
            this.checkedPluginList.add(object);
        } else {
            --this.checkedCount;
            this.checkedPluginList.remove(object);
        }
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (!structuredSelection.isEmpty()) {
            Object[] objectArray = structuredSelection.toArray();
            this.setDisplayAttributes((MethodPlugin)objectArray[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodPlugin methodPlugin) {
        this.ctrl_author.setText(methodPlugin.getAuthors());
        this.ctrl_version.setText(methodPlugin.getVersion());
        this.ctrl_briefDesc.setText(methodPlugin.getBriefDescription());
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    protected void saveDataToModel() {
        this.data.setSelectedPlugins(this.checkedPluginList);
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        PluginInfoPage pluginInfoPage = ((ExportPluginWizard)this.getWizard()).page2;
        pluginInfoPage.onEnterPage(null);
        return pluginInfoPage;
    }
}

