/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutExtension;
import org.eclipse.epf.library.layout.LayoutExtensionFactory;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;

public class ElementLayoutManager {
    private static final String PACKAGE_NAME = ElementLayoutManager.class.getPackage().getName();
    private static final String default_config_path = "noconfig";
    private boolean isPublishingMode = false;
    private String publish_dir = null;
    private MethodConfiguration config = null;
    private IActivityDiagramService diagramService = null;
    private LayoutAdapterFactory contentLayoutAdapterFactory = null;
    private LayoutAdapterFactory diagramLayoutAdapterFactory = null;
    private Map supressionMap = null;
    private IContentValidator validator = null;
    private ElementRealizer realizer = null;
    private Map<String, LayoutExtension> layoutExtensions = new HashMap<String, LayoutExtension>();
    private static final Pattern p_parameters = Pattern.compile("\\?proc=(.*?)&path=(.*)?", 34);

    public boolean isPublishingMode() {
        return this.isPublishingMode;
    }

    public ElementLayoutManager() {
        this(null, null, null, false);
    }

    public ElementLayoutManager(MethodConfiguration methodConfiguration) {
        this(methodConfiguration, null, null, false);
    }

    public ElementLayoutManager(MethodConfiguration methodConfiguration, String string, IContentValidator iContentValidator, boolean bl) {
        this.validator = iContentValidator;
        this.isPublishingMode = bl;
        if (methodConfiguration != null) {
            this.config = methodConfiguration;
        }
        if (string == null) {
            string = LayoutResources.getDefaultPublishDir();
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            if (this.config == null) {
                string = String.valueOf(string) + default_config_path;
            } else {
                String string2 = StrUtil.removeSpecialCharacters((String)this.config.getName());
                if (string2 == "") {
                    string2 = Integer.toHexString(this.config.toString().hashCode());
                }
                string = String.valueOf(string) + string2;
            }
        }
        this.setPublishDir(string);
        this.contentLayoutAdapterFactory = new LayoutAdapterFactory(this.config);
        this.diagramLayoutAdapterFactory = new LayoutAdapterFactory(this.config);
        this.loadLayoutExtensions();
    }

    private void loadLayoutExtensions() {
        if (this.config == null) {
            return;
        }
        List list = this.config.getMethodElementProperty();
        if (list != null && list.size() > 0) {
            for (MethodElementProperty methodElementProperty : list) {
                String string = methodElementProperty.getName();
                LayoutExtension layoutExtension = LayoutExtensionFactory.getInstance().createExtension(string);
                if (layoutExtension == null) continue;
                layoutExtension.init(this);
                this.layoutExtensions.put(string, layoutExtension);
            }
        }
    }

    public IContentValidator getValidator() {
        if (this.validator == null) {
            this.validator = new DefaultContentValidator(this.getPublishDir());
        }
        return this.validator;
    }

    public ElementRealizer getElementRealizer() {
        if (this.realizer == null) {
            this.realizer = new DefaultElementRealizer(this.config);
            this.realizer.setFilter(this.contentLayoutAdapterFactory.getFilter());
        }
        return this.realizer;
    }

    public void setElementRealizer(ElementRealizer elementRealizer) {
        this.realizer = elementRealizer;
    }

    public ConfigurableComposedAdapterFactory getWBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.wbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getTBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.tbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getWPBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.wpbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getCBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.cbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getDiagramAdapterFactory() {
        return this.diagramLayoutAdapterFactory.wbsAdapterFactory;
    }

    public void setActivityDiagramService(IActivityDiagramService iActivityDiagramService) {
        this.diagramService = iActivityDiagramService;
    }

    public IActivityDiagramService getActivityDiagramService() {
        return this.diagramService;
    }

    public Suppression getSuppression(Process process) {
        Suppression suppression = null;
        if (this.isPublishingMode) {
            String string;
            if (this.supressionMap == null) {
                this.supressionMap = new HashMap();
            }
            if ((suppression = (Suppression)this.supressionMap.get(string = process.getGuid())) == null) {
                suppression = this.createSuppression(process);
                this.supressionMap.put(string, suppression);
            }
        } else {
            suppression = this.createSuppression(process);
        }
        return suppression;
    }

    public void prepareAdaptorFactoriesForProcess(Process process) {
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getCBSAdapterFactory(), process);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getTBSAdapterFactory(), process);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getWBSAdapterFactory(), process);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getWPBSAdapterFactory(), process);
    }

    private void prepareAdapterfactoryFor(ComposedAdapterFactory composedAdapterFactory, Object object) {
        if (object == null || composedAdapterFactory == null) {
            return;
        }
        ITreeItemContentProvider iTreeItemContentProvider = null;
        iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)composedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            for (Object e : collection) {
                MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(e);
                if (!(methodElement instanceof Activity)) continue;
                this.prepareAdapterfactoryFor(composedAdapterFactory, e);
            }
        }
    }

    private IElementLayout createLayout(MethodElement methodElement) {
        String string = null;
        Process process = null;
        if (methodElement instanceof Activity) {
            Activity activity = (Activity)methodElement;
            string = AbstractProcessElementLayout.getPath((BreakdownElement)activity);
            process = TngUtil.getOwningProcess((BreakdownElement)activity);
        }
        return this.createLayout(methodElement, process, string);
    }

    public IElementLayout createLayout(MethodElement methodElement, Process process, String string) {
        Object object;
        String string2;
        AbstractElementLayout abstractElementLayout = null;
        if (ConfigurationHelper.isDescriptionElement(methodElement)) {
            string2 = "ContentDescription";
        } else if (methodElement instanceof Activity) {
            string2 = "Activity";
        } else if (methodElement instanceof WorkBreakdownElement && !(methodElement instanceof TaskDescriptor)) {
            string2 = "WorkBreakdownElement";
        } else {
            object = methodElement.getClass().getInterfaces();
            string2 = object != null && ((Class<?>[])object).length == 1 ? object[0].getName() : methodElement.getClass().getName();
            int n = string2.lastIndexOf(".");
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
        }
        string2 = String.valueOf(PACKAGE_NAME) + ".elements." + string2 + "Layout";
        try {
            object = Class.forName(string2);
            if (object != null) {
                abstractElementLayout = (AbstractElementLayout)((Class)object).newInstance();
            }
        }
        catch (Exception exception) {}
        if (abstractElementLayout == null) {
            abstractElementLayout = new GeneralLayout();
        }
        if (abstractElementLayout instanceof AbstractProcessElementLayout) {
            ((AbstractProcessElementLayout)abstractElementLayout).init(this, methodElement, process, string);
        } else {
            ((AbstractElementLayout)abstractElementLayout).init(this, methodElement);
        }
        return abstractElementLayout;
    }

    public IElementLayout getLayout(MethodElement methodElement, boolean bl) {
        IElementLayout iElementLayout = null;
        if (iElementLayout == null && bl) {
            iElementLayout = this.createLayout(methodElement);
        }
        return iElementLayout;
    }

    public IElementLayout getLayout(String string) {
        Object object;
        Process process = null;
        String string2 = null;
        Matcher matcher = p_parameters.matcher(string);
        if (matcher.find()) {
            object = matcher.group(1);
            string2 = matcher.group(2);
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                process = (Process)iLibraryManager.getMethodElement((String)object);
            }
        }
        if ((object = ResourceHelper.getElementFromFileName(string)) != null) {
            return this.createLayout((MethodElement)object, process, string2);
        }
        System.out.println("Can't find element for url '" + string + "'");
        return null;
    }

    public static String getQueryString(String string, String string2) {
        return "?proc=" + string + "&" + "path" + "=" + string2;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public void setPublishDir(String string) {
        this.publish_dir = string;
        if (!this.publish_dir.endsWith(File.separator)) {
            this.publish_dir = String.valueOf(this.publish_dir) + File.separator;
        }
        this.init_publishingSite();
    }

    public String getPublishDir() {
        return this.publish_dir;
    }

    private void init_publishingSite() {
        if (BrowsingLayoutSettings.INSTANCE.needUpdate(this.publish_dir)) {
            if (LibraryPlugin.getDefault().isDebugging()) {
                System.out.println("Begin initializing publishing site: " + this.publish_dir);
            }
            LayoutResources.copyLayoutFiles(this.publish_dir);
            if (LibraryPlugin.getDefault().isDebugging()) {
                System.out.println("End initializing publishing site: " + this.publish_dir);
            }
        }
    }

    public void clear() {
        this.diagramService = null;
        if (this.supressionMap != null) {
            this.supressionMap.clear();
        }
        this.layoutExtensions.clear();
        this.layoutExtensions = null;
        this.contentLayoutAdapterFactory.clear();
        this.diagramLayoutAdapterFactory.clear();
        if (this.validator != null) {
            this.validator.dispose();
            this.validator = null;
        }
        if (this.realizer != null) {
            this.realizer.dispose();
            this.realizer = null;
        }
        if (this.contentLayoutAdapterFactory != null) {
            this.contentLayoutAdapterFactory.clear();
            this.contentLayoutAdapterFactory = null;
        }
        if (this.diagramLayoutAdapterFactory != null) {
            this.diagramLayoutAdapterFactory.clear();
            this.diagramLayoutAdapterFactory = null;
        }
    }

    private Suppression createSuppression(Process process) {
        if (this.layoutExtensions != null && this.layoutExtensions.size() > 0) {
            for (LayoutExtension layoutExtension : this.layoutExtensions.values()) {
                Suppression suppression = layoutExtension.getSuppression(process);
                if (suppression == null) continue;
                return suppression;
            }
        }
        return new Suppression(process);
    }

    public class LayoutAdapterFactory {
        public ConfigurableComposedAdapterFactory wbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory tbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory wpbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory cbsAdapterFactory = null;
        ProcessAdapterFactoryFilter configurator = null;

        public LayoutAdapterFactory(MethodConfiguration methodConfiguration) {
            if (ElementLayoutManager.this.isPublishingMode()) {
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingWBSAdapterFactory();
                this.tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingTBSAdapterFactory();
                this.wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingWPBSAdapterFactory();
                this.cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingCBSAdapterFactory();
            } else {
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
                this.tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
                this.wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWPBSComposedAdapterFactory();
                this.cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createProcessComposedAdapterFactory();
            }
            this.configurator = new ProcessAdapterFactoryFilter(methodConfiguration, this);
            this.wbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.tbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.wpbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.cbsAdapterFactory.setFilter((IFilter)this.configurator);
        }

        public IFilter getFilter() {
            return this.configurator;
        }

        public void clear() {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.setFilter(null);
                this.wbsAdapterFactory.dispose();
                this.wbsAdapterFactory = null;
            }
            if (this.tbsAdapterFactory != null) {
                this.tbsAdapterFactory.setFilter(null);
                this.tbsAdapterFactory.dispose();
                this.tbsAdapterFactory = null;
            }
            if (this.wpbsAdapterFactory != null) {
                this.wpbsAdapterFactory.setFilter(null);
                this.wpbsAdapterFactory.dispose();
                this.wpbsAdapterFactory = null;
            }
            if (this.cbsAdapterFactory != null) {
                this.cbsAdapterFactory.setFilter(null);
                this.cbsAdapterFactory.dispose();
                this.cbsAdapterFactory = null;
            }
            if (this.configurator != null) {
                this.configurator.dispose();
                this.configurator = null;
            }
        }
    }
}

