/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.util.TypeConverter;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertGuidanceType {
    static IValidator validator;
    private static int[] compatibleGuidances;
    private static List compatibleGuidancesList;

    static {
        compatibleGuidances = new int[]{73, 76, 79};
        compatibleGuidancesList = new ArrayList();
        int n = 0;
        while (n < compatibleGuidances.length) {
            compatibleGuidancesList.add(new Integer(compatibleGuidances[n]));
            ++n;
        }
    }

    public static Guidance convertGuidance(Guidance guidance, Shell shell, DeleteMethodElementCommand deleteMethodElementCommand) {
        return ConvertGuidanceType.convertGuidance(guidance, shell, deleteMethodElementCommand, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Guidance convertGuidance(Guidance guidance, Shell shell, DeleteMethodElementCommand deleteMethodElementCommand, EClass eClass) {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        if (eClass == null) {
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            object = new ListDialog(shell);
            object.setHeightInChars(5);
            object.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            object.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object object) {
                    switch ((Integer)object) {
                        case 73: {
                            return LibraryResources.concept_text;
                        }
                        case 74: {
                            return LibraryResources.checklist_text;
                        }
                        case 75: {
                            return LibraryResources.example_text;
                        }
                        case 76: {
                            return LibraryResources.guideline_text;
                        }
                        case 84: {
                            return LibraryResources.estimationConsiderations_text;
                        }
                        case 77: {
                            return LibraryResources.report_text;
                        }
                        case 78: {
                            return LibraryResources.template_text;
                        }
                        case 79: {
                            return LibraryResources.supportingMaterial_text;
                        }
                        case 80: {
                            return LibraryResources.toolMentor_text;
                        }
                        case 81: {
                            return LibraryResources.whitepaper_text;
                        }
                        case 82: {
                            return LibraryResources.termDefinition_text;
                        }
                        case 83: {
                            return LibraryResources.practice_text;
                        }
                        case 85: {
                            return LibraryResources.reusableAsset_text;
                        }
                    }
                    return LibraryResources.unknownGuidance_text;
                }
            });
            List list = ConvertGuidanceType.getValidNewGuidanceTypes(guidance);
            if (list == null) {
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, LibraryResources.unsupportedGuidanceTypeError_msg, NLS.bind((String)LibraryResources.unsupportedGuidanceTypeError_reason, (Object)StrUtil.toLower((String)TngUtil.getTypeText((EObject)guidance))));
                return null;
            }
            object.setInput((Object)list);
            object.setTitle(LibraryResources.convertGuidanceDialog_title);
            object.setMessage(LibraryResources.convertGuidanceDialog_text);
            if (object.open() == 1) {
                return null;
            }
            objectArray2 = object.getResult();
            if (objectArray2 == null) {
                return null;
            }
            int n = (Integer)objectArray2[0];
            eClass = ConvertGuidanceType.getGuidanceType(n);
        }
        if (eClass == null) {
            return null;
        }
        object = TypeConverter.createTypeConversionCommand((EObject)guidance, eClass, null, null, true, true);
        try {
            Resource resource;
            Object object2;
            block28: {
                block27: {
                    IStatus iStatus;
                    block26: {
                        if (((TypeConverter.TypeConversionCommand)((Object)object)).getIllegalReferencers().isEmpty()) break block26;
                        MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                        for (MethodElement methodElement : ((TypeConverter.TypeConversionCommand)((Object)object)).getIllegalReferencers()) {
                            if (TngUtil.isPredefined((MethodElement)methodElement)) continue;
                            object2 = NLS.bind((String)LibraryEditResources.elementType_text, (Object)methodElement.eClass().getName(), (Object)TngUtil.getLabelWithPath((Object)methodElement));
                            resource = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, (String)object2, null);
                            multiStatus.add((IStatus)resource);
                        }
                        if (multiStatus.getChildren().length > 0 && LibraryPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryResources.convertGuidanceDialog_title, LibraryEditResources.confirm_remove_references_text, (IStatus)multiStatus) == 1) break block27;
                    }
                    if ((iStatus = UserInteractionHelper.checkModify(((TypeConverter.TypeConversionCommand)((Object)object)).getModifiedResources(), (Shell)shell)).isOK()) break block28;
                    LibraryPlugin.getDefault().getMsgDialog().display(LibraryResources.convertGuidanceDialog_title, iStatus);
                }
                if (object == null) return null;
                try {
                    ((TypeConverter.TypeConversionCommand)((Object)object)).dispose();
                    return null;
                }
                catch (Exception exception) {}
                return null;
            }
            ((TypeConverter.TypeConversionCommand)((Object)object)).execute();
            objectArray2 = (Object[])((TypeConverter.TypeConversionCommand)((Object)object)).getResult().iterator().next();
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                object2 = ((TypeConverter.TypeConversionCommand)((Object)object)).getModifiedResources().iterator();
                while (true) {
                    if (!object2.hasNext()) {
                        failSafeMethodLibraryPersister.commit();
                        if (ContentDescriptionFactory.hasPresentation((MethodElement)objectArray2)) {
                            failSafeMethodLibraryPersister.adjustLocation(objectArray2.getPresentation().eResource());
                        }
                        ((TypeConverter.TypeConversionCommand)((Object)object)).copyResources();
                        break;
                    }
                    resource = object2.next();
                    failSafeMethodLibraryPersister.save(resource);
                }
            }
            catch (Exception exception) {
                failSafeMethodLibraryPersister.rollback();
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertGuidanceError_title, NLS.bind((String)LibraryResources.saveConvertedGuidanceError_msg, (Object)objectArray2.getName()), LibraryResources.error_reason, (Throwable)exception);
            }
            objectArray = objectArray2;
            if (object == null) return objectArray;
        }
        catch (Throwable throwable) {
            if (object == null) throw throwable;
            try {
                ((TypeConverter.TypeConversionCommand)((Object)object)).dispose();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((TypeConverter.TypeConversionCommand)((Object)object)).dispose();
            return objectArray;
        }
        catch (Exception exception) {}
        return objectArray;
    }

    private static String checkName(Guidance guidance, Guidance guidance2) {
        validator = new ContentElementNameValidator(guidance.eContainer(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), (ContentElement)guidance2, (IFilter)new ValidatorFactory.TypeFilter((EObject)guidance2));
        String string = validator.isValid(guidance2.getName());
        if (string != null) {
            String string2 = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String string3 = LibraryEditResources.resolveNameConflictDialog_title;
            String string4 = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)string2), (Object)guidance2.getName());
            String string5 = (String)guidance2.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator iInputValidator = new IInputValidator(){

                public String isValid(String string) {
                    return validator.isValid(string);
                }
            };
            InputDialog inputDialog = new InputDialog(MsgBox.getDefaultShell(), string3, string4, string5, iInputValidator);
            if (inputDialog.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDialog.getValue();
        }
        return null;
    }

    private static EClass getGuidanceType(int n) {
        switch (n) {
            case 73: {
                return UmaPackage.Literals.CONCEPT;
            }
            case 74: {
                return UmaPackage.Literals.CHECKLIST;
            }
            case 75: {
                return UmaPackage.Literals.EXAMPLE;
            }
            case 76: {
                return UmaPackage.Literals.GUIDELINE;
            }
            case 84: {
                return UmaPackage.Literals.ESTIMATION_CONSIDERATIONS;
            }
            case 77: {
                return UmaPackage.Literals.REPORT;
            }
            case 78: {
                return UmaPackage.Literals.TEMPLATE;
            }
            case 79: {
                return UmaPackage.Literals.SUPPORTING_MATERIAL;
            }
            case 80: {
                return UmaPackage.Literals.TOOL_MENTOR;
            }
            case 81: {
                return UmaPackage.Literals.WHITEPAPER;
            }
            case 82: {
                return UmaPackage.Literals.TERM_DEFINITION;
            }
            case 83: {
                return UmaPackage.Literals.PRACTICE;
            }
            case 85: {
                return UmaPackage.Literals.REUSABLE_ASSET;
            }
        }
        return null;
    }

    private static Guidance createNewGuidance(int n) {
        switch (n) {
            case 73: {
                return UmaFactory.eINSTANCE.createConcept();
            }
            case 74: {
                return UmaFactory.eINSTANCE.createChecklist();
            }
            case 75: {
                return UmaFactory.eINSTANCE.createExample();
            }
            case 76: {
                return UmaFactory.eINSTANCE.createGuideline();
            }
            case 84: {
                return UmaFactory.eINSTANCE.createEstimationConsiderations();
            }
            case 77: {
                return UmaFactory.eINSTANCE.createReport();
            }
            case 78: {
                return UmaFactory.eINSTANCE.createTemplate();
            }
            case 79: {
                return UmaFactory.eINSTANCE.createSupportingMaterial();
            }
            case 80: {
                return UmaFactory.eINSTANCE.createToolMentor();
            }
            case 81: {
                return UmaFactory.eINSTANCE.createWhitepaper();
            }
            case 82: {
                return UmaFactory.eINSTANCE.createTermDefinition();
            }
            case 83: {
                return UmaFactory.eINSTANCE.createPractice();
            }
            case 85: {
                return UmaFactory.eINSTANCE.createReusableAsset();
            }
        }
        return null;
    }

    public static List getValidNewGuidanceTypes(Guidance guidance) {
        if (guidance == null) {
            return null;
        }
        Integer n = new Integer(guidance.eClass().getClassifierID());
        if (!compatibleGuidancesList.contains(n)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 0;
        while (n2 < compatibleGuidances.length) {
            Integer n3 = new Integer(compatibleGuidances[n2]);
            if (!n.equals(n3)) {
                arrayList.add(n3);
            }
            ++n2;
        }
        return arrayList;
    }
}

