/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.util.UmaUtil;

public final class ModelStorage {
    public static List getBaseModels() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary != null) {
            return new ArrayList(methodLibrary.getMethodPlugins());
        }
        return Collections.EMPTY_LIST;
    }

    public static Resource newLibrary(ILibraryResourceSet iLibraryResourceSet, String string, String string2, boolean bl) throws Exception {
        String string3 = null;
        string3 = bl ? "library.xmi" : string;
        iLibraryResourceSet.unload();
        Resource resource = iLibraryResourceSet.createResource(URI.createFileURI((String)(String.valueOf(string2) + File.separator + string3)));
        MethodLibrary methodLibrary = UmaFactory.eINSTANCE.createMethodLibrary();
        methodLibrary.setName(string);
        resource.getContents().add((Object)methodLibrary);
        iLibraryResourceSet.save(null);
        return resource;
    }

    public static MethodPlugin initialize(MethodPlugin methodPlugin) {
        methodPlugin.setUserChangeable(Boolean.TRUE);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT_DOMAIN_PATH);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.disciplineDefinitionPath);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.roleSetPath);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.coreContentPath);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.workProductTypePath);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.toolPath);
        ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.standardCategoryPath);
        ContentPackage contentPackage = ModelStorage.createContentPackages(methodPlugin, ModelStructure.DEFAULT.customCategoryPath);
        TngUtil.createRootCustomCategory((ContentPackage)contentPackage);
        ProcessPackage processPackage = UmaFactory.eINSTANCE.createProcessPackage();
        processPackage.setName(ModelStructure.DEFAULT.deliveryProcessPath[0]);
        methodPlugin.getMethodPackages().add(processPackage);
        ModelStructure.createProcessContributionPackage((MethodPlugin)methodPlugin);
        processPackage = UmaFactory.eINSTANCE.createProcessPackage();
        int n = ModelStructure.DEFAULT.capabilityPatternPath.length - 1;
        processPackage.setName(ModelStructure.DEFAULT.capabilityPatternPath[n]);
        String[] stringArray = new String[n];
        System.arraycopy(ModelStructure.DEFAULT.capabilityPatternPath, 0, stringArray, 0, n);
        ContentPackage contentPackage2 = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])stringArray);
        contentPackage2.getChildPackages().add(processPackage);
        return methodPlugin;
    }

    private static ContentPackage createContentPackages(MethodPlugin methodPlugin, String[] stringArray) {
        List list = methodPlugin.getMethodPackages();
        ContentPackage contentPackage = UmaUtil.findContentPackage((List)list, (String)stringArray[0]);
        if (contentPackage == null) {
            contentPackage = UmaFactory.eINSTANCE.createContentPackage();
            contentPackage.setName(stringArray[0]);
            list.add(contentPackage);
        }
        int n = 1;
        while (n < stringArray.length) {
            list = contentPackage.getChildPackages();
            if ((contentPackage = UmaUtil.findContentPackage((List)list, (String)stringArray[n])) == null) {
                contentPackage = UmaFactory.eINSTANCE.createContentPackage();
                contentPackage.setName(stringArray[n]);
                list.add(contentPackage);
            }
            ++n;
        }
        return contentPackage;
    }

    public static void loadContainmentProxies(EObject eObject) {
        EList eList = eObject.eContents();
        int n = 0;
        while (n < eList.size()) {
            InternalEObject internalEObject = (InternalEObject)eList.get(n);
            if (internalEObject.eProxyURI() != null) {
                System.out.println("proxy URI = " + internalEObject.eProxyURI());
                ResourceSet resourceSet = internalEObject.eResource().getResourceSet();
                Resource resource = resourceSet.getResource(internalEObject.eProxyURI(), true);
                InternalEObject internalEObject2 = null;
                try {
                    internalEObject2 = (InternalEObject)resource.getContents().get(0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.out.println("resolvedObj = " + internalEObject2);
                System.out.println("-----------------------------------");
                if (internalEObject2 != null) {
                    EcoreUtil.replace((EObject)internalEObject, (EObject)internalEObject2);
                    ((BasicEList)resource.getContents()).setData(1, new Object[]{internalEObject2});
                    internalEObject = internalEObject2;
                }
            }
            ModelStorage.loadContainmentProxies((EObject)internalEObject);
            ++n;
        }
    }

    public static void loadAllProxies(EObject eObject) {
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject2 = (EObject)treeIterator.next();
            Iterator iterator = eObject2.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    public static void loadCrossReferenceProxies(EObject eObject) {
        EList eList = eObject.eCrossReferences();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            EObject eObject2 = (EObject)eList.get(n2);
            ModelStorage.loadCrossReferenceProxies(eObject2);
            ++n2;
        }
    }

    public static MethodElement findMethodElement(List list, String string) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            MethodElement methodElement = (MethodElement)list.get(n2);
            if (string.equals(methodElement.getName())) {
                return methodElement;
            }
            ++n2;
        }
        return null;
    }

    public static int indexOf(List list, String string) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            MethodElement methodElement = (MethodElement)list.get(n2);
            if (string.equals(methodElement.getName())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }
}

