/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.layout.elements.ActivityLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.FileNameGenerator;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.ui.EPFUIResources;
import org.eclipse.epf.ui.dialogs.RenameFileConflictDialog;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.swt.widgets.Shell;

public class ResourceHelper {
    public static final String URL_BOOKMARK_INDICATOR = "#";
    public static final String URL_PARAMETER_INDICATOR = "?";
    public static final String URL_PARAMETER_PROCESS = "proc";
    public static final String URL_STR_JAVASCRIPT = "javascript:";
    public static final String URL_STR_MAILTO = "mailto:";
    public static final String URL_PARAMETER_PATH = "path";
    public static final String TAG_ATTR_NAME = "name";
    public static final String TAG_ATTR_KEY = "key";
    public static final String TAG_ATTR_TEXT = "text";
    public static final String TAG_ATTR_CLASS = "class";
    public static final String TAG_ATTR_GUID = "guid";
    public static final String TAG_ATTR_HREF = "href";
    public static final String TAG_ATTR_VALUE_INDEX = "index";
    public static final String FILE_EXT_HTML = ".html";
    public static final String FILE_EXT_HTM = ".htm";
    public static final String FILE_EXT_JPEG = ".jpeg";
    public static final String MISSING_PAGES_FOLDER = "pages_not_installed/";
    public static final String ELEMENT_LINK_CLASS_elementLink = "elementLink";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithType = "elementLinkWithType";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithUserText = "elementLinkWithUserText";
    public static final String RESOURCE_FOLDER = "resources";
    public static final Pattern p_html_file_name = Pattern.compile("(.*),(.*)\\.html");
    public static final Pattern p_link_ref = Pattern.compile("<a\\s+?(.*?)>(.*?)</a>", 34);
    public static final Pattern p_template_attachment_url = Pattern.compile("<a\\s+?href\\s*?=\\s*?\"(.*?)\"\\s*?>(.*?)</a>", 34);
    public static final Pattern p_area_ref = Pattern.compile("<area\\s+?(.*?)/?>", 34);
    public static final Pattern p_link_ref_gen = Pattern.compile("<(a|area)\\s+?([^>]*)>", 34);
    public static final Pattern p_link_type_picker = Pattern.compile(" class\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_guid_picker = Pattern.compile(" guid\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_href_picker = Pattern.compile(" href\\s*?=\\s*?\"(.*?)\"\\s+", 34);
    public static final Pattern p_tag_ref = Pattern.compile("<([^>!]*)(\\n|\\r)([^>]*)>", 34);
    public static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    public static final Pattern p_url_decoder = Pattern.compile("(<[^>]*?(src|href)\\s*=\\s*\")(.*?)(\"[^>]*?>)", 34);
    public static final Pattern p_tag_attributes = Pattern.compile("([\\S&&[^=]]+)\\s*=\\s*([\\S&&[^\"]]+|\"([\\S &&[^\"]]+)\")", 34);
    public static final Pattern p_css_ref = Pattern.compile(" url\\((.*?)\\)", 34);
    public static final String DIAGRAM_TYPE_WORKFLOW = "Activity";
    public static final String DIAGRAM_TYPE_ACTIVITY_DETAIL = "ActivityDetail";
    public static final String DIAGRAM_TYPE_WP_DEPENDENCY = "WPDependency";
    private static ILibraryResourceManager defaultResourceMgr;
    private static final String EXTERNAL_URL_START_WITH;
    public static final Pattern p_external_url_startWith;

    static {
        EXTERNAL_URL_START_WITH = LayoutResources.getString("externalUrl_startWith");
        p_external_url_startWith = Pattern.compile("(" + EXTERNAL_URL_START_WITH + ")", 34);
    }

    public static synchronized void setDefaultResourceMgr(ILibraryResourceManager iLibraryResourceManager) {
        defaultResourceMgr = iLibraryResourceManager;
    }

    public static synchronized ILibraryResourceManager getDefaultResourceMgr() {
        return defaultResourceMgr;
    }

    public static ILibraryResourceManager getResourceMgr(MethodElement methodElement) {
        MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)methodElement);
        if (methodLibrary != null) {
            ILibraryManager iLibraryManager = LibraryService.getInstance().getLibraryManager(methodLibrary);
            if (iLibraryManager == null) {
                methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
                iLibraryManager = LibraryService.getInstance().getLibraryManager(methodLibrary);
            }
            if (iLibraryManager == null) {
                return ResourceHelper.getDefaultResourceMgr();
            }
            return iLibraryManager.getResourceManager();
        }
        return null;
    }

    public static String getPluginResourcePath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            if (methodPlugin == null) {
                return iLibraryResourceManager.getLogicalResourcePath(methodElement);
            }
            return iLibraryResourceManager.getLogicalResourcePath((MethodElement)methodPlugin);
        }
        return null;
    }

    public static String getElementResourcePath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            return iLibraryResourceManager.getLogicalResourcePath(methodElement);
        }
        return null;
    }

    public static String getAbsoluteElementResourcePath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            return iLibraryResourceManager.getPhysicalResourcePath(methodElement);
        }
        return null;
    }

    public static String getElementPath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            return iLibraryResourceManager.getLogicalPath(methodElement);
        }
        return null;
    }

    public static String getFolderAbsolutePath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            return iLibraryResourceManager.getPhysicalPath(methodElement);
        }
        return null;
    }

    public static String getBackPath(MethodElement methodElement) {
        ILibraryResourceManager iLibraryResourceManager = ResourceHelper.getResourceMgr(methodElement);
        if (iLibraryResourceManager != null) {
            return iLibraryResourceManager.getBackPath(methodElement);
        }
        return "";
    }

    public static String getFileName(MethodElement methodElement, String string) {
        return ResourceHelper.getFileName(methodElement, null, null, string);
    }

    public static String getFileName(MethodElement methodElement, String string, String string2, String string3) {
        return FileNameGenerator.INSTANCE.getFileName(methodElement, string, string2, string3);
    }

    public static String getGuidFromFileName(String string) {
        return FileNameGenerator.INSTANCE.getGuidFromFileName(string);
    }

    public static MethodElement getElementFromFileName(String string) {
        ILibraryManager iLibraryManager;
        String string2 = ResourceHelper.getGuidFromFileName(string);
        if (string2 != null && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            return iLibraryManager.getMethodElement(string2);
        }
        return null;
    }

    public static String getUrl(MethodElement methodElement, MethodElement methodElement2, String string, String string2) {
        String string3 = ResourceHelper.getUrl(methodElement, methodElement2, string);
        if (string2 != null) {
            int n = string2.indexOf(URL_BOOKMARK_INDICATOR);
            if (n < 0) {
                n = string2.indexOf(URL_PARAMETER_INDICATOR);
            }
            if (n >= 0) {
                string3 = String.valueOf(string3) + string2.substring(n);
            }
        }
        return string3;
    }

    public static String getUrl(MethodElement methodElement, MethodElement methodElement2, String string) {
        if (methodElement == null) {
            return "";
        }
        if (methodElement2 == null) {
            return String.valueOf(ResourceHelper.getElementPath(methodElement).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(methodElement, string);
        }
        return String.valueOf((String.valueOf(ResourceHelper.getBackPath(methodElement2)) + ResourceHelper.getElementPath(methodElement)).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(methodElement, string);
    }

    public static String getLinkText(MethodElement methodElement, String string) {
        String string2 = null;
        if (string != null && !ELEMENT_LINK_CLASS_elementLinkWithUserText.equalsIgnoreCase(string)) {
            if (ELEMENT_LINK_CLASS_elementLinkWithType.equalsIgnoreCase(string)) {
                string2 = ResourceHelper.getElementLinkText(methodElement, true);
            } else if (ELEMENT_LINK_CLASS_elementLink.equalsIgnoreCase(string)) {
                string2 = ResourceHelper.getElementLinkText(methodElement, false);
            }
        }
        return string2;
    }

    public static String getElementLinkText(MethodElement methodElement, boolean bl) {
        String string = TngUtil.getPresentationName((Object)methodElement);
        if (bl) {
            return String.valueOf(ResourceHelper.getElementTypeText(methodElement)) + LibraryResources.colon_with_space + string;
        }
        return string;
    }

    public static String getElementTypeText(MethodElement methodElement) {
        if (methodElement == null) {
            return "";
        }
        return TngUtil.getTypeText((EObject)methodElement);
    }

    public static String getElementLink(MethodElement methodElement, boolean bl, String string) {
        String string2 = ResourceHelper.getElementLinkText(methodElement, bl);
        String string3 = ELEMENT_LINK_CLASS_elementLink;
        if (bl) {
            string3 = ELEMENT_LINK_CLASS_elementLinkWithType;
        }
        return ResourceHelper.getElementLink(methodElement, string2, string, string3);
    }

    public static String getElementLink(MethodElement methodElement, String string, String string2) {
        return ResourceHelper.getElementLink(methodElement, string, string2, ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String getElementLink(MethodElement methodElement, String string, String string2, String string3) {
        return "<a class=\"" + string3 + "\" " + ResourceHelper.getUrlText(string2) + " guid=\"" + methodElement.getGuid() + "\" >" + string + "</a>";
    }

    private static String getUrlText(String string) {
        if ((string = string == null ? "" : string.trim()).toLowerCase().startsWith(TAG_ATTR_HREF) || string.toLowerCase().indexOf(" href") > 0) {
            return string;
        }
        return "href=\"" + string + "\"";
    }

    public static String validateContent(MethodElement methodElement, String string) {
        return ResourceHelper.validateContent(methodElement, string, new DefaultContentValidator(), null);
    }

    public static boolean isElementLink(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLink) || string.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLinkWithType) || string.equalsIgnoreCase(ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String validateContent(MethodElement methodElement, String string, IContentValidator iContentValidator, MethodConfiguration methodConfiguration) {
        try {
            Object object;
            Object object2;
            String string2;
            String string3;
            string = ResourceHelper.validateTag(string);
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = p_link_ref.matcher(string);
            while (matcher.find()) {
                String string4;
                string3 = matcher.group();
                string2 = matcher.group(1);
                object = iContentValidator.validateLink(methodElement, string2, (String)(object2 = matcher.group(2)), methodConfiguration, "a");
                if (object != null) {
                    string3 = ((LinkInfo)object).getHtml(iContentValidator.showBrokenLinks()).toString();
                    string4 = ((LinkInfo)object).getLinkedElement();
                    if (string4 != null) {
                        iContentValidator.addReferencedElement(methodElement, (MethodElement)string4);
                    }
                }
                string4 = string3.replaceAll("file:///", "");
                string4 = string4.replaceAll("file://", "");
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string4));
            }
            matcher.appendTail(stringBuffer);
            if (methodElement == null) {
                return stringBuffer.toString();
            }
            string = stringBuffer.toString();
            matcher = p_area_ref.matcher(string);
            stringBuffer.setLength(0);
            while (matcher.find()) {
                string3 = matcher.group();
                string2 = matcher.group(1);
                object2 = iContentValidator.validateLink(methodElement, string2, "", methodConfiguration, "area");
                if (object2 != null) {
                    string3 = ((LinkInfo)object2).getHtml(false).toString();
                    object = ((LinkInfo)object2).getLinkedElement();
                    if (object != null) {
                        iContentValidator.addReferencedElement(methodElement, (MethodElement)object);
                    }
                }
                object = string3.replaceAll("file:///", "");
                object = ((String)object).replaceAll("file://", "");
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape((String)object));
            }
            matcher.appendTail(stringBuffer);
            return ResourceHelper.decodeUrlsInContent(stringBuffer.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String decodeUrlsInContent(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = p_url_decoder.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(3);
                string2 = URLDecoder.decode(string2, "UTF-8");
                String string3 = String.valueOf(matcher.group(1)) + string2 + matcher.group(4);
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string3));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return string;
        }
    }

    public static String regExpEscape(String string) {
        int n = string.indexOf(36);
        if (n < 0) {
            return string;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n > n2) {
            stringBuffer.append(string.substring(n2, n)).append("\\");
            n2 = n;
            n = string.indexOf(36, n2 + 1);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String fixElementUrl(MethodElement methodElement, String string, MethodConfiguration methodConfiguration) {
        Matcher matcher = p_link_href_picker.matcher(" " + string + " ");
        StringBuffer stringBuffer = new StringBuffer();
        if (matcher.find()) {
            String string2;
            String string3 = matcher.group(1);
            String string4 = null;
            if (methodElement != null && (string2 = ResourceHelper.getGuidFromUrl(string)) != null) {
                MethodElement methodElement2;
                ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                MethodElement methodElement3 = methodElement2 = iLibraryManager != null ? iLibraryManager.getMethodElement(string2) : null;
                if (methodElement2 != null) {
                    if (methodConfiguration != null) {
                        methodElement2 = ConfigurationHelper.getCalculatedElement(methodElement2, methodConfiguration);
                    }
                    string4 = ResourceHelper.getUrl(methodElement2, methodElement, FILE_EXT_HTML, string3);
                }
            }
            if (string4 != null && !string4.equals(string3)) {
                string2 = " href=\"" + string4 + "\" ";
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string2));
                matcher.appendTail(stringBuffer);
                return stringBuffer.toString();
            }
        }
        return string;
    }

    public static String getElementLinkType(String string) {
        Matcher matcher = p_link_type_picker.matcher(" " + string + " ");
        if (matcher.find()) {
            return matcher.group(1).trim().replaceAll("\"", "");
        }
        return null;
    }

    public static String getGuidFromUrl(String string) {
        Matcher matcher = p_link_guid_picker.matcher(" " + string + " ");
        if (matcher.find()) {
            return matcher.group(1).trim().replaceAll("\"", "");
        }
        matcher = p_link_href_picker.matcher(" " + string + " ");
        if (matcher.find()) {
            String string2 = matcher.group(1).trim().replaceAll("\"", "");
            return ResourceHelper.getGuidFromFileName(string2);
        }
        return null;
    }

    public static String validateTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = p_tag_ref.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            String string3 = ResourceHelper.fixTagAttribute(string2);
            matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String fixTagAttribute(String string) {
        return string.replaceAll("\\\r\\\n", " ").replaceAll("\\\r", " ").replaceAll("\\\n", " ");
    }

    public static URI getRelativeURI(URI uRI, URI uRI2) {
        URI uRI3 = uRI2.relativize(uRI);
        return uRI3;
    }

    public static String getURLForAttachment(Shell shell, File file, MethodElement methodElement, boolean bl) throws IOException {
        FileUtil.appendSeparator((String)new File(UmaUtil.getMethodPlugin((EObject)methodElement).eResource().getURI().toFileString()).getParent());
        File file2 = null;
        String string = ResourceHelper.getAbsoluteElementResourcePath(methodElement);
        file2 = new File(String.valueOf(string) + File.separator + file.getName());
        if (bl) {
            File file3 = ResourceHelper.copyResourceToLib(shell, file, methodElement);
            if (file3 == null) {
                return null;
            }
            file2 = new File(String.valueOf(string) + File.separator + file3.getName());
            IResource iResource = FileManager.getResourceForLocation((String)file2.getAbsolutePath());
            if (iResource != null) {
                try {
                    FileManager.refresh((IResource)iResource);
                }
                catch (Exception exception) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
        return ResourceHelper.getRelativePathToFileFromElement(methodElement, file2);
    }

    private static String getRelativePathToFileFromElement(MethodElement methodElement, File file) {
        String string = ResourceHelper.getFolderAbsolutePath(methodElement);
        return FileUtil.getRelativePath((File)file, (File)new File(string));
    }

    public static String getDiagramFilePathName(MethodElement methodElement, String string) {
        return String.valueOf(ResourceHelper.getElementResourcePath(methodElement)) + FileNameGenerator.INSTANCE.getFileName(methodElement, "", "_" + string, FILE_EXT_JPEG);
    }

    public static boolean isAbsolutepath(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("/") || string.startsWith(File.separator) || string.indexOf(":") > 0;
    }

    public static String getFilePathFromUrl(String string, String string2) {
        String string3 = string;
        if (ResourceHelper.isExternalLink(string3) || string3.startsWith(URL_STR_MAILTO) || string3.startsWith(URL_BOOKMARK_INDICATOR)) {
            return null;
        }
        int n = string3.indexOf("file:///");
        if (n == 0) {
            string3 = string3.substring("file:///".length());
        }
        if ((n = string3.indexOf("file://")) == 0) {
            string3 = string3.substring("file://".length());
        }
        if (ResourceHelper.isAbsolutepath(string3)) {
            return string;
        }
        File file = new File(string2);
        int n2 = 0;
        n = 0;
        while (file != null && (n = string3.indexOf("../", n2)) >= 0) {
            file = file.getParentFile();
            n2 = n + 3;
        }
        String string4 = "";
        if (file != null) {
            string4 = file.getPath();
        }
        if (string4.length() > 0 && !string4.endsWith(File.separator)) {
            string4 = String.valueOf(string4) + File.separator;
        }
        String string5 = String.valueOf(string4) + string3.substring(n2).replace('/', File.separatorChar);
        return XMLUtil.unescape((String)NetUtil.decodedFileUrl((String)string5));
    }

    public static String fixContentUrlPath(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            CharSequence charSequence;
            Matcher matcher = p_image_ref.matcher(string);
            while (matcher.find()) {
                charSequence = matcher.group(3);
                if ((charSequence = ResourceHelper.resolveUrl((String)charSequence, string2, string3)) == null) continue;
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(String.valueOf(matcher.group(1)) + (String)charSequence + matcher.group(4)));
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            matcher = p_link_ref_gen.matcher(string);
            while (matcher.find()) {
                Matcher matcher2;
                charSequence = new StringBuffer();
                String string4 = " " + matcher.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(string4) != null || !(matcher2 = p_link_href_picker.matcher(string4)).find()) continue;
                String string5 = matcher2.group(1).trim().replaceAll("\"", "");
                if ((string5 = ResourceHelper.resolveUrl(string5, string2, string3)) == null) continue;
                String string6 = String.valueOf(string4.substring(matcher2.start(), matcher2.start(1))) + string5 + string4.substring(matcher2.end(1), matcher2.end());
                matcher2.appendReplacement((StringBuffer)charSequence, ResourceHelper.regExpEscape(string6));
                matcher2.appendTail((StringBuffer)charSequence);
                string6 = String.valueOf(string.substring(matcher.start(), matcher.start(2))) + ((StringBuffer)charSequence).toString() + string.substring(matcher.end(2), matcher.end());
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string6));
            }
            matcher.appendTail(stringBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String resolveUrl(String string, String string2, String string3) {
        String string4 = ResourceHelper.getFilePathFromUrl(string, string2);
        if (string4 != null && !string4.equals(string)) {
            if (string3 != null) {
                string4 = String.valueOf(string3) + string4;
            }
            return string4.replace(File.separatorChar, '/');
        }
        return null;
    }

    public static boolean isExternalLink(String string) {
        if (string == null) {
            return false;
        }
        if ((string = string.toLowerCase()).startsWith("file://")) {
            return false;
        }
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://") || string.startsWith("www.")) {
            return true;
        }
        Matcher matcher = p_external_url_startWith.matcher(string);
        if (matcher.find()) {
            return matcher.start(1) == 0;
        }
        return false;
    }

    public static boolean isJavascriptUrl(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(URL_STR_MAILTO) || string.toLowerCase().startsWith(URL_STR_JAVASCRIPT);
    }

    public static String processResourceUrl(MethodElement methodElement, File file, String string, String string2, File file2, File file3, String string3, List list, IContentValidator iContentValidator) {
        String string4;
        Object object;
        String string5;
        if (string == null || ResourceHelper.isExternalLink(string) || ResourceHelper.isJavascriptUrl(string) || string.startsWith(URL_BOOKMARK_INDICATOR)) {
            return string;
        }
        String string6 = "";
        if (methodElement != null && (string.indexOf(string6 = methodElement.getGuid()) >= 0 || ResourceHelper.isActivityTabUrl(string))) {
            return string;
        }
        int n = string.indexOf(URL_BOOKMARK_INDICATOR);
        if (n < 0) {
            n = string.indexOf(URL_PARAMETER_INDICATOR);
        }
        String string7 = "";
        if (n > 0) {
            string7 = string.substring(n);
            string = string.substring(0, n);
        }
        if ((string5 = ResourceHelper.getFilePathFromUrl(string, string2)) == null) {
            if (iContentValidator != null) {
                iContentValidator.logMissingResource(methodElement, file, string);
            }
            return null;
        }
        if (string5.equalsIgnoreCase("index.htm") || string5.equalsIgnoreCase("index.html")) {
            return String.valueOf(string) + string7;
        }
        String string8 = string;
        File file4 = new File(string5);
        if (file4.exists()) {
            return String.valueOf(string) + string7;
        }
        boolean bl = true;
        String string9 = string5;
        if (string3 != null && string3.length() > 0 && string9.startsWith(string3)) {
            string9 = string9.substring(string3.length());
            bl = false;
        }
        if (!(file4 = new File(file2, string9)).exists() && (object = ResourceHelper.getResourceMgr(methodElement)) != null && (string4 = object.resolve(methodElement, string9)) != null) {
            file4 = new File(string4);
        }
        if (!file4.exists()) {
            file4 = new File(LibraryPlugin.getDefault().getLayoutPath(), string9);
        }
        if (bl && string3 != null && string3.length() > 0) {
            object = new File(string3);
            while (object != null) {
                object = ((File)object).getParentFile();
                file3 = file3.getParentFile();
            }
        }
        File file5 = new File(file3, string9);
        if (file4.exists()) {
            FileUtil.copyFile((File)file4, (File)file5);
            if (string5.endsWith(FILE_EXT_HTM) || string5.endsWith(FILE_EXT_HTML)) {
                object = new File(string5);
                try {
                    ResourceHelper.resolveResources(methodElement, (File)object, FileUtil.readFile((File)file4, (String)"UTF-8").toString(), ((File)object).getParent(), file2, file3, string3, list, iContentValidator);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else if (!file5.exists() && ResourceHelper.isValidFileUrl(string) && iContentValidator != null) {
            iContentValidator.logMissingResource(methodElement, file, string);
        }
        return String.valueOf(string8) + string7;
    }

    private static boolean isActivityTabUrl(String string) {
        return ActivityLayout.isActivityTabUrl(string);
    }

    private static boolean isValidFileUrl(String string) {
        return string != null && !string.equals("' + diagram_img + '");
    }

    public static void resolveResources(MethodElement methodElement, File file, String string, String string2, File file2, File file3, String string3, List list, IContentValidator iContentValidator) {
        try {
            String string4;
            Matcher matcher = p_image_ref.matcher(string);
            while (matcher.find()) {
                string4 = matcher.group(3);
                if (list.contains(string4)) continue;
                list.add(string4);
                ResourceHelper.processResourceUrl(methodElement, file, string4, string2, file2, file3, string3, list, iContentValidator);
            }
            matcher = p_css_ref.matcher(string);
            while (matcher.find()) {
                string4 = matcher.group(1);
                if (list.contains(string4)) continue;
                list.add(string4);
                ResourceHelper.processResourceUrl(methodElement, file, string4, string2, file2, file3, string3, list, null);
            }
            matcher = p_link_ref_gen.matcher(string);
            while (matcher.find()) {
                String string5;
                Matcher matcher2;
                string4 = matcher.group(2);
                if (ResourceHelper.getGuidFromUrl(string4) != null || !(matcher2 = p_link_href_picker.matcher(" " + string4 + " ")).find() || list.contains(string5 = matcher2.group(1).trim().replaceAll("\"", ""))) continue;
                list.add(string5);
                ResourceHelper.processResourceUrl(methodElement, file, string5, string2, file2, file3, string3, list, iContentValidator);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Map getTagAttributes(String string) {
        try {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(3);
            Matcher matcher = p_tag_attributes.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group(1).trim().toLowerCase();
                String string3 = "";
                if (matcher.group(3) != null) {
                    string3 = matcher.group(3).trim();
                } else if (matcher.group(2) != null) {
                    string3 = matcher.group(2).trim();
                }
                if (string2.equals(TAG_ATTR_HREF)) {
                    try {
                        string3 = URLDecoder.decode(string3, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                linkedHashMap.put(string2, string3);
            }
            return linkedHashMap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Map getAttributesFromLink(String string) {
        Matcher matcher = p_link_ref.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return ResourceHelper.getTagAttributes(string2);
        }
        return null;
    }

    public static Map getAttributesFromLink(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            return ResourceHelper.getTagAttributes(string2);
        }
        return null;
    }

    public static String getAttributesAsString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(String.valueOf(string) + "=\"" + string2 + "\"");
        }
        return stringBuffer.toString();
    }

    private static String getDiscardedElementURL(MethodElement methodElement, MethodElement methodElement2, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MISSING_PAGES_FOLDER).append("pages_not_installed").append(FILE_EXT_HTML);
        File file = new File(string2, stringBuffer.toString());
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        XmlElement xmlElement = new XmlElement("Element");
        xmlElement.setAttribute(TAG_ATTR_GUID, string).setAttribute("type", methodElement2.getType().getName()).setAttribute(TAG_ATTR_NAME, methodElement2.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)methodElement2).getName());
        String string3 = LayoutResources.getDefaultXslPath("page_not_installed", null);
        try {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(XmlHelper.XML_HEADER).append(xmlElement.toXml());
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            Properties properties = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)string3, (String)stringBuffer2.toString(), (Properties)properties, (Writer)outputStreamWriter);
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return String.valueOf(ResourceHelper.getBackPath(methodElement).replace(File.separatorChar, '/')) + stringBuffer.toString();
    }

    public static String validateRichTextContent(MethodElement methodElement, String string, IContentValidator iContentValidator) {
        try {
            Object object;
            Object object2;
            String string2;
            String string3;
            MethodConfiguration methodConfiguration = null;
            string = ResourceHelper.validateTag(string);
            StringBuffer stringBuffer = new StringBuffer();
            Matcher matcher = p_link_ref.matcher(string);
            while (matcher.find()) {
                String string4;
                string3 = matcher.group();
                string2 = matcher.group(1);
                object = iContentValidator.validateLink(methodElement, string2, (String)(object2 = matcher.group(2)), methodConfiguration, "a");
                if (object != null) {
                    string3 = ((LinkInfo)object).getHtml(iContentValidator.showBrokenLinks()).toString();
                    string4 = ((LinkInfo)object).getLinkedElement();
                    if (string4 != null) {
                        iContentValidator.addReferencedElement(methodElement, (MethodElement)string4);
                    }
                }
                string4 = string3.replaceAll("file:///", "");
                string4 = string4.replaceAll("file://", "");
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape(string4));
            }
            matcher.appendTail(stringBuffer);
            if (methodElement == null) {
                return stringBuffer.toString();
            }
            string = stringBuffer.toString();
            matcher = p_area_ref.matcher(string);
            stringBuffer.setLength(0);
            while (matcher.find()) {
                string3 = matcher.group();
                string2 = matcher.group(1);
                object2 = iContentValidator.validateLink(methodElement, string2, "", methodConfiguration, "area");
                if (object2 != null) {
                    string3 = ((LinkInfo)object2).getHtml(iContentValidator.showBrokenLinks()).toString();
                    object = ((LinkInfo)object2).getLinkedElement();
                    if (object != null) {
                        iContentValidator.addReferencedElement(methodElement, (MethodElement)object);
                    }
                }
                object = string3.replaceAll("file:///", "");
                object = ((String)object).replaceAll("file://", "");
                matcher.appendReplacement(stringBuffer, ResourceHelper.regExpEscape((String)object));
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            return string;
        }
    }

    public static String getPluginPath(MethodElement methodElement) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        return ResourceHelper.getFolderAbsolutePath((MethodElement)methodPlugin);
    }

    public static String getPluginPath(MethodPlugin methodPlugin) {
        return ResourceHelper.getFolderAbsolutePath((MethodElement)methodPlugin);
    }

    public static File copyResourceToLib(Shell shell, File file, MethodElement methodElement) {
        RenameFileConflictDialog renameFileConflictDialog;
        String string = ResourceHelper.getAbsoluteElementResourcePath(methodElement);
        File file2 = new File(string, file.getName());
        if (file.equals(file2)) {
            return file2;
        }
        if (file2.exists() && shell != null) {
            renameFileConflictDialog = new RenameFileConflictDialog(shell);
            renameFileConflictDialog.setMessageStr(MessageFormat.format(EPFUIResources.Dialog_fileNameConflict_msg, file.getName(), string));
            renameFileConflictDialog.setDestination(string);
            renameFileConflictDialog.setFilePath(file.getName());
            renameFileConflictDialog.open();
            if (renameFileConflictDialog.getReturnCode() == 1) {
                return null;
            }
            file2 = new File(string, renameFileConflictDialog.getFilePath());
        }
        FileUtil.copyFile((File)file, (File)file2);
        renameFileConflictDialog = FileManager.getResourceForLocation((String)file2.getAbsolutePath());
        if (renameFileConflictDialog != null) {
            try {
                FileManager.refresh((IResource)renameFileConflictDialog);
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        return file2;
    }
}

