/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class TypeConverter {
    private static final Comparator activityFeatureComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == UmaPackage.Literals.BREAKDOWN_ELEMENT__SUPER_ACTIVITIES) {
                return -1;
            }
            return 0;
        }
    };

    public static final EObject convert(EObject eObject, EClass eClass, Map map, Comparator comparator, Set set) {
        IStatus iStatus;
        TypeConversionCommand typeConversionCommand = TypeConverter.createTypeConversionCommand(eObject, eClass, map, comparator);
        Collection<Resource> collection = typeConversionCommand.getModifiedResources();
        if (!collection.isEmpty()) {
            Resource[] resourceArray = new Resource[collection.size()];
            collection.toArray(resourceArray);
            iStatus = Services.getAccessController().checkModify(resourceArray, ExtensionManager.getDefaultUserInteractionHandler().getUIContext());
            if (!iStatus.isOK()) {
                Messenger.INSTANCE.showError(LibraryResources.convertActivityError_title, null, iStatus);
                return null;
            }
        }
        try {
            typeConversionCommand.execute();
            set.addAll(typeConversionCommand.getModifiedResources());
            iStatus = (EObject)typeConversionCommand.getResult().iterator().next();
            return iStatus;
        }
        finally {
            typeConversionCommand.dispose();
        }
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject eObject, EClass eClass, Map map, Comparator comparator) {
        return TypeConverter.createTypeConversionCommand(eObject, eClass, map, comparator, false, false);
    }

    public static final TypeConversionCommand createTypeConversionCommand(EObject eObject, EClass eClass, Map map, Comparator comparator, boolean bl, boolean bl2) {
        TypeConversionCommand typeConversionCommand = new TypeConversionCommand(eObject);
        EObject eObject2 = TypeConverter.prepareConvert(eObject, eClass, map, comparator, bl, bl2, typeConversionCommand);
        EObject eObject3 = eObject.eContainer();
        if (eObject3 != null) {
            EReference eReference = eObject.eContainmentFeature();
            if (eReference.isMany()) {
                List list = (List)eObject3.eGet((EStructuralFeature)eReference);
                int n = list.indexOf(eObject);
                typeConversionCommand.commandList().add(0, new SetCommand(null, eObject3, (EStructuralFeature)eReference, (Object)eObject2, n));
            } else {
                typeConversionCommand.commandList().add(0, new SetCommand(null, eObject3, (EStructuralFeature)eReference, (Object)eObject2));
            }
        }
        typeConversionCommand.setResult(Collections.singletonList(eObject2));
        return typeConversionCommand;
    }

    private static ContentResourceScanner createScanner(EObject eObject) {
        if (eObject instanceof ContentDescription && !(eObject instanceof BreakdownElementDescription)) {
            File file = new File(ResourceHelper.getFolderAbsolutePath((MethodElement)eObject));
            String string = ResourceHelper.getElementPath((MethodElement)eObject);
            ContentResourceScanner contentResourceScanner = new ContentResourceScanner(file, null, string, null);
            return contentResourceScanner;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final EObject prepareConvert(EObject eObject, EClass eClass, Map map, Comparator comparator, boolean bl, boolean bl2, TypeConversionCommand typeConversionCommand) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        MethodElement methodElement;
        ArrayList arrayList;
        EObject eObject2 = UmaFactory.eINSTANCE.create(eClass);
        if (eObject instanceof MethodElement && !(arrayList = (methodElement = (MethodElement)eObject).getOppositeFeatures()).isEmpty()) {
            object5 = Collections.singletonList(eObject);
            for (Object object6 : ExtensionManager.getOppositeFeatureLoaders()) {
                object6.loadOppositeFeatures((Collection)object5);
            }
            Map map2 = AssociationHelper.getReferenceMap((MethodElement)methodElement);
            for (Map.Entry entry : map2.entrySet()) {
                object4 = (EObject)entry.getKey();
                object3 = ((Collection)entry.getValue()).iterator();
                while (object3.hasNext()) {
                    object2 = (EReference)object3.next();
                    if (!bl && object2.getEType().isInstance((Object)eObject2)) {
                        if (object2.isMany()) {
                            object = (List)object4.eGet((EStructuralFeature)object2);
                            int list2 = object.indexOf(eObject);
                            typeConversionCommand.append((Command)new SetCommand(null, object4, (EStructuralFeature)object2, (Object)eObject2, list2));
                            continue;
                        }
                        typeConversionCommand.append((Command)new SetCommand(null, object4, (EStructuralFeature)object2, (Object)eObject2));
                        continue;
                    }
                    if (object2.isMany()) {
                        typeConversionCommand.append((Command)new RemoveCommand(null, object4, (EStructuralFeature)object2, (Object)eObject));
                        continue;
                    }
                    typeConversionCommand.append((Command)new SetCommand(null, object4, (EStructuralFeature)object2, object2.getDefaultValue()));
                }
            }
        }
        methodElement = eClass.getEAllStructuralFeatures();
        arrayList = new ArrayList(eObject.eClass().getEAllStructuralFeatures());
        if (bl2) {
            arrayList.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT);
            arrayList.remove(UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE);
        }
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        object5 = TypeConverter.createScanner(eObject);
        for (Object object6 : arrayList) {
            void var13_18;
            if (!methodElement.contains(object6)) {
                Object v;
                object6 = map != null ? ((v = map.get(object6)) != null && methodElement.contains(v) ? (EStructuralFeature)v : null) : null;
            }
            if (object6 == null || !object6.isChangeable()) continue;
            boolean bl3 = false;
            if (object6 instanceof EReference) {
                List list;
                object4 = (EReference)object6;
                if (object4 == UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION) {
                    if (ContentDescriptionFactory.hasPresentation((MethodElement)((MethodElement)eObject))) {
                        object3 = (ContentDescription)eObject.eGet((EStructuralFeature)object4);
                        object2 = ContentDescriptionFactory.getContentDescriptionType((EClass)eClass);
                        if (object2 != null && object2 != object3.eClass()) {
                            object = TypeConverter.prepareConvert((EObject)object3, (EClass)object2, null, null, bl, bl2, typeConversionCommand);
                            EObject eObject3 = object3.eContainer();
                            if (eObject3 != null) {
                                typeConversionCommand.append((Command)new SetCommand(null, eObject, (EStructuralFeature)object4, null));
                                list = object3.eResource();
                                if (list != null) {
                                    typeConversionCommand.modifiedResources.add(object3.eResource());
                                }
                            }
                            object3 = (ContentDescription)object;
                        } else {
                            typeConversionCommand.resourceCopyTasks.add(new ResourceCopyTask(TypeConverter.createScanner((EObject)object3), (MethodElement)object3, null, ""));
                        }
                        typeConversionCommand.append((Command)new SetCommand(null, eObject2, (EStructuralFeature)object4, object3));
                    }
                    boolean bl4 = true;
                } else if (!object4.isContainment() && object4.getEOpposite() != null && (object3 = object4.getEOpposite()).isMany()) {
                    object2 = eObject.eGet((EStructuralFeature)object4);
                    if (object2 != null) {
                        if (object4.isMany()) {
                            for (EObject eObject4 : (Collection)object2) {
                                list = (List)eObject4.eGet((EStructuralFeature)object3);
                                int n = list.indexOf(eObject);
                                typeConversionCommand.append((Command)new SetCommand(null, eObject4, (EStructuralFeature)object3, (Object)eObject2, n));
                            }
                        } else {
                            object = (EObject)object2;
                            List list2 = (List)object.eGet((EStructuralFeature)object3);
                            int n = list2.indexOf(eObject);
                            typeConversionCommand.append((Command)new SetCommand(null, (EObject)object, (EStructuralFeature)object3, (Object)eObject2, n));
                        }
                    }
                    boolean bl5 = true;
                }
            }
            if (var13_18 != false) continue;
            object4 = eObject.eGet((EStructuralFeature)object6);
            if (object6 == UmaPackage.Literals.NAMED_ELEMENT__NAME && (object3 = TypeConverter.checkName(eObject, eClass)) != null) {
                object4 = object3;
            }
            if (object5 != null && object4 instanceof String && eObject instanceof MethodElement && !StrUtil.isBlank((String)(object3 = (String)object4))) {
                typeConversionCommand.resourceCopyTasks.add(new ResourceCopyTask((ContentResourceScanner)object5, (MethodElement)eObject, (String)object3, ""));
            }
            typeConversionCommand.append((Command)new SetCommand(null, eObject2, (EStructuralFeature)object6, object4));
        }
        return eObject2;
    }

    public static Activity convertActivity(Activity activity, EClass eClass) {
        if (eClass == activity.eClass()) {
            return null;
        }
        HashSet hashSet = new HashSet();
        Activity activity2 = (Activity)TypeConverter.convert((EObject)activity, eClass, null, activityFeatureComparator, hashSet);
        URI uRI = PersistenceUtil.getProxyURI((EObject)activity2);
        ((InternalEObject)activity).eSetProxyURI(uRI);
        if (!hashSet.isEmpty()) {
            ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            try {
                for (Resource resource : hashSet) {
                    failSafeMethodLibraryPersister.save(resource);
                }
                failSafeMethodLibraryPersister.commit();
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, NLS.bind((String)LibraryResources.saveConvertedActivityError_msg, (Object)activity2.getName()), LibraryResources.error_reason, (Throwable)exception);
                failSafeMethodLibraryPersister.rollback();
            }
        }
        return activity2;
    }

    public static EClass getActivityType(int n) {
        switch (n) {
            case 53: {
                return UmaPackage.Literals.ACTIVITY;
            }
            case 57: {
                return UmaPackage.Literals.ITERATION;
            }
            case 58: {
                return UmaPackage.Literals.PHASE;
            }
        }
        return null;
    }

    private static String checkName(EObject eObject, EClass eClass) {
        NamedElement namedElement;
        IValidator iValidator;
        String string;
        if (eObject instanceof NamedElement && (string = (iValidator = IValidatorFactory.INSTANCE.createNameValidator((Object)(namedElement = (NamedElement)eObject).eContainer(), namedElement, eClass)).isValid(namedElement.getName())) != null) {
            String string2 = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String string3 = LibraryEditResources.resolveNameConflictDialog_title;
            String string4 = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)string2), (Object)namedElement.getName());
            String string5 = (String)namedElement.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator iInputValidator = new IInputValidator(){

                public String isValid(String string) {
                    return iValidator.isValid(string);
                }
            };
            InputDialog inputDialog = new InputDialog(MsgBox.getDefaultShell(), string3, string4, string5, iInputValidator);
            if (inputDialog.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDialog.getValue();
        }
        return null;
    }

    private static class ResourceCopyTask {
        ContentResourceScanner scanner;
        MethodElement owner;
        String content;
        String contentPath;

        public ResourceCopyTask(ContentResourceScanner contentResourceScanner, MethodElement methodElement, String string, String string2) {
            this.scanner = contentResourceScanner;
            this.owner = methodElement;
            this.content = string;
            this.contentPath = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeConversionCommand
    extends CompoundCommand
    implements IResourceAwareCommand {
        private Collection<?> result;
        private EObject object;
        private HashSet<Resource> modifiedResources;
        private boolean gotModifiedResources;
        private List<ResourceCopyTask> resourceCopyTasks;
        private Resource resource;
        private Collection illegalReferencers;
        private NestedCommandExcecutor nestedCommandExcecutor;

        public TypeConversionCommand(EObject eObject) {
            this.object = eObject;
            this.modifiedResources = new HashSet();
            this.resource = eObject.eResource();
            if (this.resource != null) {
                this.modifiedResources.add(this.resource);
            }
            this.resourceCopyTasks = new ArrayList<ResourceCopyTask>();
            this.nestedCommandExcecutor = new NestedCommandExcecutor((Command)this);
        }

        public void dispose() {
            if (this.illegalReferencers != null) {
                this.illegalReferencers.clear();
            }
            if (this.modifiedResources != null) {
                this.modifiedResources.clear();
            }
            if (this.resourceCopyTasks != null) {
                this.resourceCopyTasks.clear();
            }
            if (this.nestedCommandExcecutor != null) {
                this.nestedCommandExcecutor.dispose();
            }
            super.dispose();
        }

        public Collection getIllegalReferencers() {
            if (this.illegalReferencers == null) {
                this.getModifiedResources();
            }
            return this.illegalReferencers;
        }

        public void copyResources() {
            if (!this.resourceCopyTasks.isEmpty()) {
                for (ResourceCopyTask resourceCopyTask : this.resourceCopyTasks) {
                    File file = new File(ResourceHelper.getAbsoluteElementResourcePath(resourceCopyTask.owner));
                    resourceCopyTask.scanner.setTargetRootPath(file);
                    if (resourceCopyTask.content != null) {
                        resourceCopyTask.scanner.resolveResources(resourceCopyTask.owner, resourceCopyTask.content, resourceCopyTask.contentPath);
                        continue;
                    }
                    for (EAttribute eAttribute : resourceCopyTask.owner.eClass().getEAllAttributes()) {
                        Object object = resourceCopyTask.owner.eGet((EStructuralFeature)eAttribute);
                        if (!(object instanceof String)) continue;
                        resourceCopyTask.scanner.resolveResources(resourceCopyTask.owner, (String)object, resourceCopyTask.contentPath);
                    }
                }
            }
        }

        public Collection<Resource> getModifiedResources() {
            if (!this.gotModifiedResources) {
                this.illegalReferencers = new HashSet();
                for (Command command : this.commandList) {
                    EObject eObject;
                    Resource resource;
                    EObject eObject2;
                    RemoveCommand removeCommand;
                    if (command instanceof RemoveCommand) {
                        removeCommand = (RemoveCommand)command;
                        eObject2 = removeCommand.getOwner();
                        resource = eObject2.eResource();
                        if (resource != null && resource != this.resource) {
                            this.modifiedResources.add(resource);
                        }
                        if (resource == null || eObject2 == this.object || UmaUtil.isContainedBy((EObject)eObject2, (Object)this.object)) continue;
                        this.illegalReferencers.add(eObject2);
                        continue;
                    }
                    if (!(command instanceof SetCommand)) continue;
                    removeCommand = (SetCommand)command;
                    eObject2 = removeCommand.getOwner();
                    resource = eObject2.eResource();
                    if (resource != null && resource != this.resource && removeCommand.getValue() instanceof EObject && ((eObject = (EObject)removeCommand.getValue()) != this.object || !UmaUtil.isContainedBy((EObject)eObject, (Object)this.object))) {
                        this.modifiedResources.add(resource);
                    }
                    if (resource == null || eObject2 == this.object || UmaUtil.isContainedBy((EObject)eObject2, (Object)this.object) || removeCommand.getValue() != removeCommand.getFeature().getDefaultValue()) continue;
                    this.illegalReferencers.add(eObject2);
                }
                this.gotModifiedResources = true;
            }
            this.modifiedResources.addAll(this.nestedCommandExcecutor.getModifiedResources());
            return this.modifiedResources;
        }

        private void setResult(Collection<?> collection) {
            this.result = collection;
        }

        public Collection<?> getResult() {
            return this.result;
        }

        public void execute() {
            super.execute();
            this.nestedCommandExcecutor.executeNestedCommands();
        }

        public void undo() {
            this.nestedCommandExcecutor.undoNestedCommands();
            super.undo();
        }

        private List<Command> commandList() {
            return this.commandList;
        }
    }
}

