/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import java.io.File;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class XMILibraryResourceManager
implements ILibraryResourceManager {
    public String getLogicalPath(MethodElement methodElement) {
        String string;
        block3: {
            try {
                string = MethodLibraryPersister.INSTANCE.getElementVirtualPath(methodElement);
                if (string != null && !string.equals("")) break block3;
                System.out.println("Warning! No Path for Element [" + methodElement.getType().getName() + ": " + methodElement.getName() + "]");
                return "";
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                return "";
            }
        }
        return this.fixPath(string);
    }

    public String getBackPath(MethodElement methodElement) {
        String string = "";
        String string2 = this.getLogicalPath(methodElement);
        if (string2 != null && string2.length() > 0) {
            string = string2.replace(File.separatorChar, '/').replaceAll(".*?/", "\\.\\./");
        }
        return "./" + string;
    }

    private String fixPath(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        if (!string.endsWith(File.separator)) {
            return String.valueOf(string) + File.separator;
        }
        return string;
    }

    public String getLogicalResourcePath(MethodElement methodElement) {
        String string = MethodLibraryPersister.INSTANCE.geResourceVirtualPath(methodElement);
        return this.fixPath(string);
    }

    public String getPhysicalPath(MethodElement methodElement) {
        if (methodElement == null) {
            return null;
        }
        IFileBasedLibraryPersister iFileBasedLibraryPersister = this.getFileBasedLibraryPersister(methodElement);
        return iFileBasedLibraryPersister != null ? this.fixPath(iFileBasedLibraryPersister.getFolderAbsolutePath(methodElement)) : null;
    }

    public String getPhysicalResourcePath(MethodElement methodElement) {
        IFileBasedLibraryPersister iFileBasedLibraryPersister = this.getFileBasedLibraryPersister(methodElement);
        return iFileBasedLibraryPersister != null ? this.fixPath(iFileBasedLibraryPersister.getResourceFolderPath(methodElement)) : null;
    }

    private IFileBasedLibraryPersister getFileBasedLibraryPersister(MethodElement methodElement) {
        ILibraryPersister iLibraryPersister;
        Resource resource = methodElement.eResource();
        if (resource != null && (iLibraryPersister = LibraryServiceUtil.getPersisterFor((Resource)resource)) instanceof IFileBasedLibraryPersister) {
            return (IFileBasedLibraryPersister)iLibraryPersister;
        }
        return null;
    }

    public String getLogicalPluginPath(MethodElement methodElement) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin != null) {
            return String.valueOf(methodPlugin.getName()) + File.separator;
        }
        return "";
    }

    public String getPhysicalPluginPath(MethodElement methodElement) {
        MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin != null) {
            return this.getPhysicalPath((MethodElement)methodPlugin);
        }
        return null;
    }

    public String resolve(MethodElement methodElement, String string) {
        int n = (string = string.replace('/', File.separatorChar)).indexOf(File.separatorChar);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = null;
            MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)methodElement);
            List list = LibraryUtil.getMethodPlugins((MethodLibrary)methodLibrary);
            for (MethodPlugin methodPlugin : list) {
                if (!methodPlugin.getName().equals(string2)) continue;
                string3 = this.getPhysicalPluginPath((MethodElement)methodPlugin);
                break;
            }
            if (string3 != null) {
                return String.valueOf(string3) + string.substring(n + 1);
            }
        }
        return null;
    }
}

