/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal.migration;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.library.xmi.XMILibraryResourceManager;
import org.eclipse.epf.uma.MethodElement;

public class MigrationUtil {
    public static Set<String> cdataFeatureNames = new HashSet<String>();
    private static boolean localDebug = false;

    static {
        cdataFeatureNames.add("alternatives");
        cdataFeatureNames.add("mainDescription");
        cdataFeatureNames.add("howToStaff");
        cdataFeatureNames.add("keyConsiderations");
        cdataFeatureNames.add("purpose");
        cdataFeatureNames.add("scope");
        cdataFeatureNames.add("usageNotes");
        cdataFeatureNames.add("skills");
        cdataFeatureNames.add("assignmentApproaches");
        cdataFeatureNames.add("synonyms");
        cdataFeatureNames.add("sectionDescription");
        cdataFeatureNames.add("impactOfNotHaving");
        cdataFeatureNames.add("reasonsForNotNeeding");
        cdataFeatureNames.add("briefOutline");
        cdataFeatureNames.add("representationOptions");
        cdataFeatureNames.add("usageGuidance");
        cdataFeatureNames.add("refinedDescription");
        cdataFeatureNames.add("activityEntryState");
        cdataFeatureNames.add("activityExitState");
        cdataFeatureNames.add("externalDescription");
        cdataFeatureNames.add("packagingGuidance");
        cdataFeatureNames.add("additionalInfo");
        cdataFeatureNames.add("problem");
        cdataFeatureNames.add("background");
        cdataFeatureNames.add("goals");
        cdataFeatureNames.add("application");
        cdataFeatureNames.add("levelsOfAdoption");
        cdataFeatureNames.add("scale");
        cdataFeatureNames.add("projectCharacteristics");
        cdataFeatureNames.add("riskLevel");
        cdataFeatureNames.add("estimatingTechnique");
        cdataFeatureNames.add("projectMemberExpertise");
        cdataFeatureNames.add("typeOfContract");
    }

    private static boolean isHtmlFeature(EStructuralFeature eStructuralFeature) {
        return cdataFeatureNames.contains(eStructuralFeature.getName());
    }

    public static void formatValue(MethodElement methodElement) throws Exception {
        List list = methodElement.getInstanceProperties();
        if (list != null) {
            HTMLFormatter hTMLFormatter = new HTMLFormatter();
            if (ResourceHelper.getDefaultResourceMgr() == null) {
                ResourceHelper.setDefaultResourceMgr((ILibraryResourceManager)new XMILibraryResourceManager());
            }
            boolean bl = false;
            int n = 0;
            while (n < list.size()) {
                block10: {
                    EProperty eProperty = (EProperty)list.get(n);
                    if (eProperty != null) {
                        Object object;
                        EStructuralFeature eStructuralFeature = eProperty.getEStructuralFeature();
                        Object object2 = object = methodElement.eGet(eStructuralFeature);
                        if (MigrationUtil.isHtmlFeature(eStructuralFeature) && object instanceof String) {
                            block9: {
                                if (!bl && localDebug) {
                                    System.out.println("LD> element: " + methodElement.eClass().getName());
                                    bl = true;
                                }
                                try {
                                    String string = MigrationUtil.validateGuidAttribute((String)object);
                                    String string2 = ResourceHelper.validateContent((MethodElement)methodElement, (String)string);
                                    object2 = hTMLFormatter.formatHTML(string2);
                                    if (!localDebug) break block9;
                                    System.out.println("LD> feature: " + eStructuralFeature.getName());
                                    System.out.println("LD> str0: " + object);
                                    if (!string2.equals(string)) {
                                        System.out.println("LD> str1: " + string2);
                                    }
                                    if (object2.equals(string2)) break block9;
                                    System.out.println("LD> newValue: " + object2);
                                }
                                catch (UnsupportedEncodingException unsupportedEncodingException) {
                                    break block10;
                                }
                            }
                            methodElement.eSet(eStructuralFeature, object2);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private static String validateGuidAttribute(String string) {
        String string2 = MigrationUtil.validateGuidAttribute(string, ResourceHelper.p_link_ref);
        string2 = MigrationUtil.validateGuidAttribute(string2, ResourceHelper.p_area_ref);
        return string2;
    }

    private static String validateGuidAttribute(String string, Pattern pattern) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2;
            String string3 = string2 = matcher.group();
            Map map = ResourceHelper.getAttributesFromLink((Pattern)pattern, (String)string2);
            if (localDebug) {
                System.out.println("LD> text:      " + string2);
                System.out.println("LD> attributeMap: " + map);
            }
            String string4 = map == null ? null : (String)map.get("guid");
            String string5 = map == null ? null : (String)map.get("href");
            int n = -1;
            int n2 = -1;
            if (string4 == null && string5 != null) {
                n = string5.lastIndexOf(",");
                n2 = string5.lastIndexOf(".html");
            }
            if (n >= 0 && n2 > n) {
                string4 = string5.substring(n + 1, n2);
                String string6 = String.valueOf(string5) + "\"";
                String string7 = String.valueOf(string5) + "\" guid=\"" + string4 + "\"";
                string3 = string2.replace(string6, string7);
                if (localDebug) {
                    System.out.println("LD>  replaced: " + string6);
                    System.out.println("LD> replacing: " + string7);
                    System.out.println("");
                }
            }
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

