/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.serviceability;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialogNoReason
extends IconAndMessageDialog {
    public static final boolean AUTOMATED_MODE = false;
    private static final int LIST_ITEM_COUNT = 7;
    private static final String NESTING_INDENT = "  ";
    protected Button detailsButton;
    private String title;
    private List list;
    private boolean listCreated = false;
    private int displayMask = 65535;
    private IStatus status;
    private Clipboard clipboard;
    private boolean shouldIncludeTopLevelErrorInDetails = false;

    public ErrorDialogNoReason(Shell shell, String string, String string2, IStatus iStatus, int n) {
        super(shell);
        this.title = string == null ? JFaceResources.getString((String)"Problem_Occurred") : string;
        this.message = string2 == null ? iStatus.getMessage() : string2;
        this.status = iStatus;
        this.displayMask = n;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void buttonPressed(int n) {
        if (n == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(n);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.shouldShowDetailsButton()) {
            this.detailsButton = this.createButton(composite, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        }
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        composite2.setFont(composite.getFont());
        return composite2;
    }

    protected void createDialogAndButtonArea(Composite composite) {
        Composite composite2;
        super.createDialogAndButtonArea(composite);
        if (this.dialogArea instanceof Composite && (composite2 = (Composite)this.dialogArea).getChildren().length == 0) {
            new Label(composite2, 0);
        }
    }

    protected Image getImage() {
        if (this.status != null) {
            if (this.status.getSeverity() == 2) {
                return this.getWarningImage();
            }
            if (this.status.getSeverity() == 1) {
                return this.getInfoImage();
            }
        }
        return this.getErrorImage();
    }

    protected List createDropDownList(Composite composite) {
        this.list = new List(composite, 2818);
        this.populateList(this.list);
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.list.getItemHeight() * 7;
        gridData.horizontalSpan = 2;
        this.list.setLayoutData((Object)gridData);
        this.list.setFont(composite.getFont());
        Menu menu = new Menu((Control)this.list);
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ErrorDialogNoReason.this.copyToClipboard();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ErrorDialogNoReason.this.copyToClipboard();
            }
        });
        menuItem.setText(JFaceResources.getString((String)"copy"));
        this.list.setMenu(menu);
        this.listCreated = true;
        return this.list;
    }

    public int open() {
        if (ErrorDialogNoReason.shouldDisplay(this.status, this.displayMask)) {
            return super.open();
        }
        this.setReturnCode(0);
        return 0;
    }

    public static int openError(Shell shell, String string, String string2, IStatus iStatus) {
        return ErrorDialogNoReason.openError(shell, string, string2, iStatus, 7);
    }

    public static int openError(Shell shell, String string, String string2, IStatus iStatus, int n) {
        ErrorDialogNoReason errorDialogNoReason = new ErrorDialogNoReason(shell, string, string2, iStatus, n);
        return errorDialogNoReason.open();
    }

    private void populateList(List list) {
        this.populateList(list, this.status, 0, this.shouldIncludeTopLevelErrorInDetails);
    }

    private void populateList(List list, IStatus iStatus, int n, boolean bl) {
        Object object;
        IStatus[] iStatusArray;
        if (!iStatus.matches(this.displayMask)) {
            return;
        }
        Throwable throwable = iStatus.getException();
        boolean bl2 = throwable instanceof CoreException;
        boolean bl3 = false;
        if (bl) {
            iStatusArray = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n2;
            }
            object = iStatus.getMessage();
            iStatusArray.append((String)object);
            list.add(iStatusArray.toString());
            bl3 = true;
        }
        if (!bl2 && throwable != null) {
            iStatusArray = new StringBuffer();
            int n3 = 0;
            while (n3 < n) {
                iStatusArray.append(NESTING_INDENT);
                ++n3;
            }
            object = throwable.getLocalizedMessage();
            if (object == null) {
                object = throwable.toString();
            }
            iStatusArray.append((String)object);
            list.add(iStatusArray.toString());
            bl3 = true;
        }
        if (bl3) {
            ++n;
        }
        if (bl2) {
            iStatusArray = (CoreException)throwable;
            object = iStatusArray.getStatus();
            if (this.message == null || this.message.indexOf(object.getMessage()) == -1) {
                this.populateList(list, (IStatus)object, n, true);
            }
        }
        iStatusArray = iStatus.getChildren();
        int n4 = 0;
        while (n4 < iStatusArray.length) {
            this.populateList(list, iStatusArray[n4], n, true);
            ++n4;
        }
    }

    protected static boolean shouldDisplay(IStatus iStatus, int n) {
        IStatus[] iStatusArray = iStatus.getChildren();
        if (iStatusArray == null || iStatusArray.length == 0) {
            return iStatus.matches(n);
        }
        int n2 = 0;
        while (n2 < iStatusArray.length) {
            if (iStatusArray[n2].matches(n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void toggleDetailsArea() {
        Point point = this.getShell().getSize();
        Point point2 = this.getShell().computeSize(-1, -1);
        if (this.listCreated) {
            this.list.dispose();
            this.listCreated = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.list = this.createDropDownList((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point point3 = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(point.x, point.y + (point3.y - point2.y)));
    }

    private void populateCopyBuffer(IStatus iStatus, StringBuffer stringBuffer, int n) {
        IStatus[] iStatusArray;
        if (!iStatus.matches(this.displayMask)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(NESTING_INDENT);
            ++n2;
        }
        stringBuffer.append(iStatus.getMessage());
        stringBuffer.append("\n");
        Throwable throwable = iStatus.getException();
        if (throwable instanceof CoreException) {
            iStatusArray = (IStatus[])throwable;
            this.populateCopyBuffer(iStatusArray.getStatus(), stringBuffer, n + 1);
        }
        iStatusArray = iStatus.getChildren();
        int n3 = 0;
        while (n3 < iStatusArray.length) {
            this.populateCopyBuffer(iStatusArray[n3], stringBuffer, n + 1);
            ++n3;
        }
    }

    private void copyToClipboard() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.populateCopyBuffer(this.status, stringBuffer, 0);
        this.clipboard = new Clipboard(this.list.getDisplay());
        this.clipboard.setContents(new Object[]{stringBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        return super.close();
    }

    protected final void showDetailsArea() {
        Control control;
        if (!this.listCreated && (control = this.getContents()) != null && !control.isDisposed()) {
            this.toggleDetailsArea();
        }
    }

    protected boolean shouldShowDetailsButton() {
        return this.status.isMultiStatus() || this.status.getException() != null;
    }

    protected final void setStatus(IStatus iStatus) {
        if (this.status != iStatus) {
            this.status = iStatus;
        }
        this.shouldIncludeTopLevelErrorInDetails = true;
        if (this.listCreated) {
            this.repopulateList();
        }
    }

    private void repopulateList() {
        if (this.list != null && !this.list.isDisposed()) {
            this.list.removeAll();
            this.populateList(this.list);
        }
    }
}

