/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class ClipboardUtil {
    private static Clipboard clipboard;
    private static final String SOURCE_URL = "SourceURL:";
    private static Transfer htmlTransfer;

    static {
        htmlTransfer = null;
        if (SWT.getPlatform().equals("win32")) {
            try {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.epf.common.win32.win32.x86");
                Class clazz = bundle.loadClass("org.eclipse.epf.common.win32.Win32HTMLTransfer");
                if (clazz != null) {
                    htmlTransfer = (Transfer)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                htmlTransfer = null;
            }
        }
    }

    public static String getHTMLSourceURL() {
        if (htmlTransfer == null) {
            return null;
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        String string = null;
        try {
            URL uRL;
            int n;
            String string2 = (String)clipboard.getContents(htmlTransfer);
            if (string2 != null && string2.length() > 0 && (n = string2.indexOf(SOURCE_URL)) > 0) {
                string = string2.substring(n + SOURCE_URL.length());
                string = string.substring(0, string.indexOf(FileUtil.LINE_SEP));
            }
            if (string != null && string.indexOf("\\") != -1 && (string = (uRL = new URL(string)).toExternalForm()).startsWith("file://") && !string.startsWith("file:///")) {
                string = "file:///" + string.substring(7);
            }
            String string3 = string;
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            String string4 = string;
            return string4;
        }
        finally {
            clipboard.dispose();
        }
    }

    public static void copyTextHTMLToClipboard(String string) {
        if (clipboard != null) {
            clipboard.dispose();
        }
        clipboard = new Clipboard(null);
        clipboard.setContents(new Object[]{string, string}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
        if (clipboard != null) {
            clipboard.dispose();
        }
    }
}

