/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class NetUtil {
    public static final String FILE_SCHEME = "file";
    public static final String FILE_URI_PREFIX = "file:/";
    public static final int FILE_URI_PREFIX_LENGTH = "file:/".length();
    public static final String HTTP_SCHEME = "http";
    public static final String HTTP_URI_PREFIX = "http://";
    public static final int HTTP_URI_PREFIX_LENGTH = "http://".length();
    public static final String FILE_PREFIX_2 = "file://";
    public static final String FILE_PREFIX_3 = "file:///";
    private static final String[] HEX_VALUES = new String[]{"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07", "%08", "%09", "%0A", "%0B", "%0C", "%0D", "%0E", "%0F", "%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", "%18", "%19", "%1A", "%1B", "%1C", "%1D", "%1E", "%1F", "%20", "%21", "%22", "%23", "%24", "%25", "%26", "%27", "%28", "%29", "%2A", "%2B", "%2C", "%2D", "%2E", "%2F", "%30", "%31", "%32", "%33", "%34", "%35", "%36", "%37", "%38", "%39", "%3A", "%3B", "%3C", "%3D", "%3E", "%3F", "%40", "%41", "%42", "%43", "%44", "%45", "%46", "%47", "%48", "%49", "%4A", "%4B", "%4C", "%4D", "%4E", "%4F", "%50", "%51", "%52", "%53", "%54", "%55", "%56", "%57", "%58", "%59", "%5A", "%5B", "%5C", "%5D", "%5E", "%5F", "%60", "%61", "%62", "%63", "%64", "%65", "%66", "%67", "%68", "%69", "%6A", "%6B", "%6C", "%6D", "%6E", "%6F", "%70", "%71", "%72", "%73", "%74", "%75", "%76", "%77", "%78", "%79", "%7A", "%7B", "%7C", "%7D", "%7E", "%7F", "%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", "%88", "%89", "%8A", "%8B", "%8C", "%8D", "%8E", "%8F", "%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", "%98", "%99", "%9A", "%9B", "%9C", "%9D", "%9E", "%9F", "%A0", "%A1", "%A2", "%A3", "%A4", "%A5", "%A6", "%A7", "%A8", "%A9", "%AA", "%AB", "%AC", "%AD", "%AE", "%AF", "%B0", "%B1", "%B2", "%B3", "%B4", "%B5", "%B6", "%B7", "%B8", "%B9", "%BA", "%BB", "%BC", "%BD", "%BE", "%BF", "%C0", "%C1", "%C2", "%C3", "%C4", "%C5", "%C6", "%C7", "%C8", "%C9", "%CA", "%CB", "%CC", "%CD", "%CE", "%CF", "%D0", "%D1", "%D2", "%D3", "%D4", "%D5", "%D6", "%D7", "%D8", "%D9", "%DA", "%DB", "%DC", "%DD", "%DE", "%DF", "%E0", "%E1", "%E2", "%E3", "%E4", "%E5", "%E6", "%E7", "%E8", "%E9", "%EA", "%EB", "%EC", "%ED", "%EE", "%EF", "%F0", "%F1", "%F2", "%F3", "%F4", "%F5", "%F6", "%F7", "%F8", "%F9", "%FA", "%FB", "%FC", "%FD", "%FE", "%FF"};

    private NetUtil() {
    }

    public static String getUri(File file) throws MalformedURLException {
        String string = file.toURL().toExternalForm();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ' ': {
                    stringBuffer.append("%20");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String resolveUri(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("../")) {
            if (string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            while (string.startsWith("../")) {
                string = string.substring(3);
                int n = string2.lastIndexOf(47);
                if (n <= 0) continue;
                string2 = string2.substring(0, n);
            }
            string = "/" + string;
        }
        if (string.startsWith("/")) {
            return string2.endsWith("/") ? String.valueOf(string2) + string.substring(1) : String.valueOf(string2) + string;
        }
        if (string.startsWith(FILE_URI_PREFIX) || string.startsWith(HTTP_URI_PREFIX)) {
            return string;
        }
        return string2.endsWith("/") ? String.valueOf(string2) + string : String.valueOf(string2) + '/' + string;
    }

    public static InputStream getInputStream(String string) throws MalformedURLException, IOException {
        if (string == null) {
            return null;
        }
        if (string.startsWith(HTTP_URI_PREFIX)) {
            URL uRL = new URL(string);
            return uRL.openStream();
        }
        if (string.startsWith(FILE_URI_PREFIX)) {
            string = string.substring(FILE_URI_PREFIX_LENGTH);
        }
        return new FileInputStream(NetUtil.decodeUrl(string, null));
    }

    public static String decodeUrl(String string, String string2) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n2 += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        String string3 = stringBuffer.toString();
        if (string2 != null) {
            try {
                byte[] byArray = string3.getBytes("8859_1");
                string3 = new String(byArray, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return string3;
    }

    public static String encodeUrl(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return string;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = string.getBytes(string2);
        int n2 = 0;
        while (n2 < byArray.length) {
            char c = (char)byArray[n2];
            if (c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                stringBuffer.append(c);
            } else if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            } else {
                switch (c) {
                    case '!': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '-': 
                    case '.': 
                    case '_': 
                    case '~': {
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        stringBuffer.append(HEX_VALUES[c & 0xFF]);
                    }
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String encodeFileURL(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case ' ': {
                    stringBuffer.append("%20");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String decodedFileUrl(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string2.substring(n2 + 1, n2 + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n2 += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String decodeURL(String string) throws UnsupportedEncodingException {
        string = URLDecoder.decode(string, "UTF-8");
        return string;
    }
}

