/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.actions.ActionDelegate;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.commands.DeleteDiagramCommand;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteElementActionDelegate
extends ActionDelegate {
    private Request secondaryTargetRequest;

    public DeleteElementActionDelegate() {
    }

    public DeleteElementActionDelegate(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        super(iAction, iWorkbenchPart);
    }

    protected org.eclipse.gef.commands.Command getCommand() {
        this.targetRequest = null;
        Request request = this.getTargetRequest();
        Iterator iterator = this.selectedParts.iterator();
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        Process process = this.getOwningProcess();
        CompositeTransactionalCommand compositeTransactionalCommand = new CompositeTransactionalCommand(this.getEditingDomain(), DiagramCoreResources.deleteCommand_label){

            public boolean canUndo() {
                for (EditPart editPart : DeleteElementActionDelegate.this.selectedParts) {
                    MethodElement methodElement;
                    if (!(editPart instanceof IGraphicalEditPart)) continue;
                    IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)editPart;
                    View view = (View)iGraphicalEditPart.getModel();
                    EObject eObject = ViewUtil.resolveSemanticElement((View)view);
                    if (view instanceof Diagram || eObject instanceof Diagram || (methodElement = BridgeHelper.getMethodElement(view)) == null || !(methodElement instanceof Activity)) continue;
                    return false;
                }
                return true;
            }
        };
        while (iterator.hasNext()) {
            EditPart editPart = (EditPart)iterator.next();
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)editPart;
            View view = (View)iGraphicalEditPart.getModel();
            EObject eObject = ViewUtil.resolveSemanticElement((View)view);
            if (view instanceof Diagram || eObject instanceof Diagram) {
                return null;
            }
            MethodElement methodElement = BridgeHelper.getMethodElement(view);
            if (methodElement != null && methodElement instanceof Activity) {
                arrayList.add((Activity)methodElement);
            }
            org.eclipse.gef.commands.Command command = null;
            command = editPart instanceof IGraphicalEditPart && this.isCanonical((IGraphicalEditPart)editPart) ? editPart.getCommand(request) : editPart.getCommand(this.getSecondaryTargetRequest());
            if (command == null && this.isDiagramUIObject(view)) {
                command = editPart.getCommand(this.getSecondaryTargetRequest());
            }
            if (command == null) continue;
            compositeTransactionalCommand.compose((IUndoableOperation)new CommandProxy(command));
        }
        if (compositeTransactionalCommand.isEmpty() || compositeTransactionalCommand.size() != this.selectedParts.size()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!arrayList.isEmpty()) {
            new DeleteDiagramCommand(arrayList, process).execute();
        }
        return new ICommandProxy((ICommand)compositeTransactionalCommand);
    }

    private boolean isDiagramUIObject(View view) {
        return view.getElement() == null;
    }

    protected Request createTargetRequest() {
        return new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(this.getEditingDomain(), false));
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.setEnabled(true);
        super.selectionChanged(iAction, iSelection);
        for (EditPart editPart : this.selectedParts) {
            View view = (View)editPart.getModel();
            if (view.getElement() == null) continue;
            if (view instanceof Diagram || BridgeHelper.isReadOnly(view) || TngUtil.isLocked((EObject)this.getOwningProcess()) || view.getElement() instanceof LinkedObject && view.getDiagram().getElement() instanceof ActivityDetailDiagram || BridgeHelper.getMethodElement(view) != null && BridgeHelper.isInherited((EModelElement)view)) {
                iAction.setEnabled(false);
                this.setEnabled(false);
                break;
            }
            if (!(view instanceof Edge) || DiagramCoreValidation.checkDelete((Edge)view) == null) continue;
            iAction.setEnabled(false);
            this.setEnabled(false);
            break;
        }
    }

    public void run(IAction iAction) {
        if (!this.isEnabled()) {
            return;
        }
        ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>();
        for (Object e : this.selectedParts) {
            MethodElement methodElement;
            Object object;
            if (!(e instanceof EditPart) || !((object = ((EditPart)e).getModel()) instanceof Node) || (methodElement = BridgeHelper.getMethodElement((View)((Node)object))) == null || !(methodElement instanceof BreakdownElement)) continue;
            arrayList.add((BreakdownElement)methodElement);
        }
        if (!arrayList.isEmpty()) {
            Iterator iterator = new ProcessDeleteAction(){

                public Command createCommand(Collection collection) {
                    this.domain = null;
                    for (Object e : collection) {
                        if (!(e instanceof WorkProductDescriptor)) continue;
                        this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                        break;
                    }
                    if (this.domain == null) {
                        this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
                    }
                    return super.createCommand(collection);
                }
            };
            iterator.updateSelection((IStructuredSelection)new StructuredSelection(arrayList));
            iterator.run();
            if (iterator.isDeletionConfirmed()) {
                super.run(iAction);
                BusyIndicator.showWhile((Display)this.targetPart.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ((AbstractDiagramEditor)DeleteElementActionDelegate.this.targetPart).doSave((IProgressMonitor)new NullProgressMonitor());
                        if (DeleteElementActionDelegate.this.getDiagramCommandStack() != null) {
                            DeleteElementActionDelegate.this.getDiagramCommandStack().flush();
                        }
                    }
                });
            }
        } else {
            super.run(iAction);
        }
    }

    private boolean isCanonical(IGraphicalEditPart iGraphicalEditPart) {
        CanonicalEditPolicy canonicalEditPolicy;
        EditPart editPart = iGraphicalEditPart.getParent();
        return editPart instanceof IGraphicalEditPart && (canonicalEditPolicy = (CanonicalEditPolicy)editPart.getEditPolicy((Object)"Canonical")) != null && canonicalEditPolicy.isEnabled();
    }

    public Request getSecondaryTargetRequest() {
        if (this.secondaryTargetRequest == null) {
            this.secondaryTargetRequest = new GroupRequest((Object)"delete");
        }
        return this.secondaryTargetRequest;
    }

    private Process getOwningProcess() {
        Diagram diagram;
        DiagramAdapter diagramAdapter;
        if (this.targetPart != null && (diagramAdapter = BridgeHelper.getDiagramAdapter((diagram = ((AbstractDiagramEditor)this.targetPart).getDiagram()).getElement())) != null) {
            return TngUtil.getOwningProcess((BreakdownElement)diagramAdapter.getActivity());
        }
        return null;
    }
}

