/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramAdapter
extends NodeAdapter {
    private org.eclipse.epf.uma.Activity baseAct;
    protected IFilter filter;
    private Suppression suppression;
    protected long umaLastModified;

    public DiagramAdapter(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        this((org.eclipse.epf.uma.Activity)TngUtil.unwrap((Object)breakdownElementWrapperItemProvider));
        this.wrapper = breakdownElementWrapperItemProvider;
        this.basicSetTargetReadOnly(breakdownElementWrapperItemProvider.isReadOnly());
    }

    public DiagramAdapter(org.eclipse.epf.uma.Activity activity) {
        super((MethodElement)activity);
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) {
            this.baseAct = (org.eclipse.epf.uma.Activity)activity.getVariabilityBasedOnElement();
            this.baseAct.eAdapters().add((Object)this.methodElementAdapter);
        }
    }

    @Override
    public void dispose() {
        for (ActivityNode activityNode : this.getNodes()) {
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
            if (nodeAdapter == null) continue;
            nodeAdapter.dispose();
        }
        super.dispose();
        if (this.baseAct != null) {
            this.baseAct.eAdapters().remove((Object)this.methodElementAdapter);
        }
    }

    @Override
    protected void handleNotification(Notification notification) {
        switch (notification.getFeatureID(Activity.class)) {
            case 62: {
                switch (notification.getEventType()) {
                    case 3: {
                        this.nodeAdded(notification.getPosition(), (ActivityNode)notification.getNewValue());
                        return;
                    }
                    case 4: {
                        this.nodeRemoved((ActivityNode)notification.getOldValue());
                        return;
                    }
                    case 5: {
                        Collection collection = (Collection)notification.getNewValue();
                        for (ActivityNode activityNode : collection) {
                            this.nodeAdded(notification.getPosition(), activityNode);
                        }
                        return;
                    }
                    case 6: {
                        Collection collection = (Collection)notification.getOldValue();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            this.nodeRemoved((ActivityNode)iterator.next());
                        }
                        return;
                    }
                }
            }
        }
        super.handleNotification(notification);
    }

    protected void replaceNode(Object object, Object object2) {
    }

    @Override
    protected NodeAdapter.MethodElementAdapter createMethodElementAdapter() {
        return new ActivityAdapter();
    }

    protected final void populateLinks() {
        this.populateLinks(this.getNodes());
    }

    /*
     * Unable to fully structure code
     */
    protected void populateLinks(List<ActivityNode> var1_1) {
        var2_2 = var1_1.size();
        var3_3 = new boolean[var2_2];
        try {
            var4_4 = 0;
            while (var4_4 < var2_2) {
                var5_6 = var1_1.get(var4_4);
                var3_3[var4_4] = var5_6.eDeliver();
                var5_6.eSetDeliver(false);
                ++var4_4;
            }
            for (ActivityNode var4_5 : var1_1) {
                this.populateLinks(var4_5, false);
            }
        }
        finally {
            var7_9 = 0;
            ** while (var7_9 < var2_2)
        }
lbl-1000:
        // 1 sources

        {
            var1_1.get(var7_9).eSetDeliver(var3_3[var7_9]);
            ++var7_9;
            continue;
        }
lbl21:
        // 1 sources

    }

    protected List getNodes() {
        Activity activity = this.getDiagram();
        return activity != null ? this.getDiagram().getNodes() : Collections.emptyList();
    }

    @Override
    protected Activity getDiagram() {
        return (Activity)this.getTarget();
    }

    protected boolean removeNode(Object object) {
        if (!TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)object)) {
            return false;
        }
        ActivityNode activityNode = BridgeHelper.findNode(this.getDiagram(), object);
        if (activityNode == null) {
            return false;
        }
        for (ActivityEdge activityEdge : activityNode.getOutgoings()) {
            activityEdge.setTarget(null);
        }
        for (ActivityEdge activityEdge : activityNode.getIncomings()) {
            activityEdge.setSource(null);
        }
        activityNode.getOutgoings().clear();
        activityNode.getIncomings().clear();
        this.getNodes().remove(activityNode);
        return true;
    }

    protected void removeNodes(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeNode(iterator.next());
        }
    }

    protected ActivityNode addNode(Object object) {
        ActivityNode activityNode = this.addNode(this.getNodes(), object);
        if (activityNode == null) {
            return activityNode;
        }
        this.populateLinks(activityNode, true);
        return activityNode;
    }

    protected Collection addNodes(Collection collection) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addNode(arrayList, iterator.next());
        }
        this.getNodes().addAll(arrayList);
        return arrayList;
    }

    public void moveNode(Object object) {
    }

    protected void populateLinks(ActivityNode activityNode, boolean bl) {
    }

    protected ActivityNode toNode(MethodElement methodElement) {
        ActivityNode activityNode = this.newNode(methodElement);
        if (activityNode == null) {
            return null;
        }
        this.initializeNode(activityNode, methodElement);
        return activityNode;
    }

    protected void initializeNodeAdapter(NodeAdapter nodeAdapter) {
        nodeAdapter.setEditingDomain(this.domain);
        nodeAdapter.actionManager = this.actionManager;
    }

    private void initializeNode(ActivityNode activityNode, MethodElement methodElement) {
        String string = BridgeHelper.getNodeName(methodElement);
        activityNode.setName(string);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        if (nodeAdapter != null && nodeAdapter.getElement() != methodElement) {
            nodeAdapter.dispose();
            nodeAdapter = null;
        }
        if (nodeAdapter == null) {
            nodeAdapter = this.createNodeAdapter(methodElement);
            this.initializeNodeAdapter(nodeAdapter);
            activityNode.eAdapters().add((Object)nodeAdapter);
        }
    }

    protected NodeAdapter createNodeAdapter(MethodElement methodElement) {
        return null;
    }

    protected ActivityNode newNode(MethodElement methodElement) {
        return null;
    }

    protected ActivityNode addNode(Collection collection, Object object) {
        ActivityNode activityNode;
        if (TngUtil.isInstanceOf((Collection)this.getBreakdownElementTypes(), (Object)object) && (activityNode = this.toNode((MethodElement)object)) != null) {
            collection.add(activityNode);
            return activityNode;
        }
        return null;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(BreakdownElement.class);
    }

    public org.eclipse.epf.uma.Activity getActivity() {
        return (org.eclipse.epf.uma.Activity)this.element;
    }

    @Override
    protected void removeFromUmaModel(ActivityNode activityNode) {
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode);
        if (methodElement instanceof BreakdownElement) {
            this.getActionManager().doAction(4, (EObject)this.getActivity(), (EStructuralFeature)UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, (Object)methodElement, -1);
        }
        super.removeFromUmaModel(activityNode);
    }

    protected void extractChildren(ITreeItemContentProvider iTreeItemContentProvider, Object object, Collection collection) {
        Object object2;
        boolean bl = false;
        if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
            object2 = (BSActivityItemProvider)iTreeItemContentProvider;
            bl = object2.isRolledUp();
            object2.basicSetRolledUp(false);
        } else if (iTreeItemContentProvider instanceof IBSItemProvider) {
            object2 = (IBSItemProvider)iTreeItemContentProvider;
            bl = object2.isRolledUp();
            object2.setRolledUp(false);
        }
        try {
            for (Object e : iTreeItemContentProvider.getChildren(object)) {
                if (this.getSuppression().isSuppressed(e)) continue;
                collection.add(e);
            }
        }
        finally {
            if (iTreeItemContentProvider instanceof IBSItemProvider) {
                ((IBSItemProvider)iTreeItemContentProvider).setRolledUp(bl);
            }
        }
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public void setSuppression(Suppression suppression) {
        this.suppression = suppression;
    }

    private void updateView(Collection<?> collection) throws InterruptedException, RollbackException {
        DiagramAdapter.updateView(this.getView(), collection);
    }

    private static void updateView(View view, Collection<?> collection) {
        for (View view2 : view.getChildren()) {
            if (collection.contains(view2.getElement())) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(view2.getElement());
                if (nodeAdapter != null) {
                    nodeAdapter.updateView();
                }
                view2.setVisible(true);
                continue;
            }
            if (view2.getElement() instanceof ActivityNode) {
                if (!view2.isVisible()) continue;
                view2.setVisible(false);
                continue;
            }
            if (view2.getElement() instanceof ActivityPartition) {
                DiagramAdapter.updateView(view2, collection);
                continue;
            }
            if (view2.isVisible()) continue;
            view2.setVisible(true);
        }
    }

    private void updateEdges(Collection collection) throws InterruptedException, RollbackException {
        for (View view : this.getView().getChildren()) {
            if (collection.contains(view.getElement())) {
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(view.getElement());
                nodeAdapter.updateView();
                view.setVisible(true);
                this.setEdgeVisibility(view, true);
                continue;
            }
            if (view.getElement() instanceof ActivityNode) {
                if (!view.isVisible()) continue;
                this.setEdgeVisibility(view, false);
                continue;
            }
            if (view.isVisible()) continue;
            view.setVisible(true);
            this.setEdgeVisibility(view, true);
        }
    }

    private void setEdgeVisibility(View view, boolean bl) {
        Diagram diagram = view.getDiagram();
        for (Edge edge : diagram.getEdges()) {
            if (edge.getSource() != view && edge.getTarget() != view) continue;
            if (bl) {
                view.setVisible(true);
            }
            edge.setVisible(bl);
        }
    }

    public void populateDiagram() {
        boolean bl = this.notificationEnabled;
        try {
            try {
                this.notificationEnabled = false;
                final ArrayList arrayList = new ArrayList();
                Activity activity = this.getDiagram();
                TxUtil.runInTransaction((EObject)activity, (Runnable)new Runnable(){

                    public void run() {
                        arrayList.addAll(DiagramAdapter.this.populateNodes());
                        DiagramAdapter.this.populateLinks(arrayList);
                    }
                });
                for (ActivityNode activityNode : arrayList) {
                    NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
                    if (nodeAdapter == null) continue;
                    nodeAdapter.addConsumer((Object)this);
                }
                TxUtil.runInTransaction((EObject)activity, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            DiagramAdapter.this.updateEdges(arrayList);
                            DiagramAdapter.this.updateView(arrayList);
                        }
                        catch (Exception exception) {
                            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                        }
                    }
                });
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                this.notificationEnabled = bl;
            }
        }
        finally {
            this.notificationEnabled = bl;
        }
    }

    protected Collection populateNodes() {
        return Collections.EMPTY_LIST;
    }

    public void setFilter(IFilter iFilter) {
        this.filter = iFilter;
    }

    @Override
    public IActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager(){

                public boolean doAction(int n, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n2) {
                    boolean bl = super.doAction(n, eObject, eStructuralFeature, object, n2);
                    if (bl) {
                        DiagramAdapter.this.umaLastModified = System.currentTimeMillis();
                    }
                    return bl;
                }
            };
        }
        return this.actionManager;
    }

    public long getUmaLastModified() {
        return this.umaLastModified;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    protected class ActivityAdapter
    extends NodeAdapter.MethodElementAdapter {
        protected ActivityAdapter() {
            super(DiagramAdapter.this);
        }

        protected Collection handleNotification(Notification notification) {
            ArrayList<ActivityNode> arrayList = new ArrayList<ActivityNode>();
            block0 : switch (notification.getFeatureID(org.eclipse.epf.uma.Activity.class)) {
                case 27: {
                    switch (notification.getEventType()) {
                        case 3: {
                            ActivityNode activityNode = DiagramAdapter.this.addNode(notification.getNewValue());
                            if (activityNode == null || notification.getNotifier() != DiagramAdapter.this.baseAct) break block0;
                            BridgeHelper.getNodeAdapter((EObject)activityNode).basicSetTargetReadOnly(true);
                            arrayList.add(activityNode);
                            break;
                        }
                        case 4: {
                            DiagramAdapter.this.removeNode(notification.getOldValue());
                            break;
                        }
                        case 5: {
                            Collection collection = DiagramAdapter.this.addNodes((Collection)notification.getNewValue());
                            if (notification.getNotifier() != DiagramAdapter.this.baseAct) break block0;
                            for (ActivityNode activityNode : collection) {
                                BridgeHelper.getNodeAdapter((EObject)activityNode).basicSetTargetReadOnly(true);
                                arrayList.add(activityNode);
                            }
                            break block0;
                        }
                        case 6: {
                            DiagramAdapter.this.removeNodes((Collection)notification.getOldValue());
                            break;
                        }
                        case 7: {
                            DiagramAdapter.this.moveNode(notification.getNewValue());
                            break;
                        }
                        case 1: {
                            DiagramAdapter.this.replaceNode(notification.getOldValue(), notification.getNewValue());
                        }
                    }
                    break;
                }
                default: {
                    return super.handleNotification(notification);
                }
            }
            return arrayList;
        }
    }
}

