/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class ReconnectLinkCommand
extends Command {
    private boolean isSource;
    private Edge link;
    private Node newNode;
    private Node oldNode;
    private int viewIndex;
    private Point endPoint;
    private InternalTransactionalEditingDomain domain;
    private static final String LABEL = "Reconnect Link";

    public ReconnectLinkCommand(InternalTransactionalEditingDomain internalTransactionalEditingDomain, Edge edge, Node node, boolean bl) {
        super(LABEL);
        this.domain = internalTransactionalEditingDomain;
        this.link = edge;
        this.newNode = node;
        this.isSource = bl;
    }

    public void setEndPoint(Point point) {
        this.endPoint = point.getCopy();
    }

    public boolean canExecute() {
        boolean bl;
        boolean bl2 = bl = this.link != null && this.newNode != null;
        if (!bl) {
            return false;
        }
        if (this.isSource) {
            return DiagramCoreValidation.checkReconnect(this.newNode, (Node)this.link.getTarget(), this.link) == null;
        }
        return DiagramCoreValidation.checkReconnect((Node)this.link.getSource(), this.newNode, this.link) == null;
    }

    public void execute() {
        try {
            TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                public void run() {
                    if (ReconnectLinkCommand.this.isSource) {
                        ReconnectLinkCommand.this.oldNode = (Node)ReconnectLinkCommand.this.link.getSource();
                        if (ReconnectLinkCommand.this.oldNode != null) {
                            ReconnectLinkCommand.this.viewIndex = ReconnectLinkCommand.this.oldNode.getTargetEdges().indexOf((Object)ReconnectLinkCommand.this.link);
                        }
                        ReconnectLinkCommand.this.link.setSource((View)ReconnectLinkCommand.this.newNode);
                    } else {
                        ReconnectLinkCommand.this.oldNode = (Node)ReconnectLinkCommand.this.link.getTarget();
                        if (ReconnectLinkCommand.this.oldNode != null) {
                            ReconnectLinkCommand.this.viewIndex = ReconnectLinkCommand.this.oldNode.getSourceEdges().indexOf((Object)ReconnectLinkCommand.this.link);
                        }
                        ReconnectLinkCommand.this.link.setTarget((View)ReconnectLinkCommand.this.newNode);
                    }
                }
            });
        }
        catch (Exception exception) {
            DiagramCorePlugin.getDefault().getLogger().logError("Error while re-connect the link :", (Throwable)exception);
        }
    }

    public void undo() {
        if (this.isSource) {
            this.newNode.getTargetEdges().remove((Object)this.link);
            this.oldNode.getTargetEdges().add(this.viewIndex, (Object)this.link);
        } else {
            this.newNode.getSourceEdges().remove((Object)this.link);
            this.oldNode.getSourceEdges().add(this.viewIndex, (Object)this.link);
        }
        this.oldNode = null;
    }
}

