/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IAdapterFactoryProvider;
import org.eclipse.epf.library.edit.process.DescribableElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.DependencyValidationMgr;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.validation.Activator;
import org.eclipse.epf.validation.ValidationResources;
import org.eclipse.epf.validation.constraints.LibraryTraversalStrategy;
import org.eclipse.epf.validation.util.ValidationStatus;

public class LibraryEValidator
extends EObjectValidator {
    private static final boolean DEBUG = Activator.getDefault().isDebugging();
    private static final Map featureToPropertyMap = LibraryEValidator.createFeatureToAttributeMap();
    public static final String CTX_ADAPTER_FACTORY_PROVIDER = "CTX_ADAPTER_FACTORY_PROVIDER";
    public static final String CTX_DEPENDENCY_VALIDATION_MGR = "CTX_DEPENDENCY_VALIDATION_MGR";
    public static final String CTX_CONSTRAINT_FILTER = "CTX_CONSTRAINT_FILTER";
    public static final String CONSTRAINT_CATEGORY = "org.eclipse.epf.validation.library.category";
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    private static Map createFeatureToAttributeMap() {
        HashMap<EAttribute, String> hashMap = new HashMap<EAttribute, String>();
        hashMap.put(UmaPackage.Literals.NAMED_ELEMENT__NAME, "name");
        hashMap.put(UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME, "presentation_name");
        return hashMap;
    }

    public LibraryEValidator() {
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
        this.batchValidator.addConstraintFilter(new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor iConstraintDescriptor, EObject eObject) {
                Set set = iConstraintDescriptor.getCategories();
                if (set != null && !set.isEmpty()) {
                    for (Category category : set) {
                        if (!LibraryEValidator.CONSTRAINT_CATEGORY.equals(category.getId())) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnosticChain, Map map) {
        return this.validate(eObject.eClass(), eObject, diagnosticChain, map);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnosticChain, Map map) {
        Object object;
        IStatus iStatus = Status.OK_STATUS;
        boolean bl = true;
        DependencyValidationMgr dependencyValidationMgr = (DependencyValidationMgr)map.get(CTX_DEPENDENCY_VALIDATION_MGR);
        if (DependencyChecker.newCheck && dependencyValidationMgr != null && (eObject instanceof VariabilityElement || eObject instanceof MethodPlugin) && !(iStatus = dependencyValidationMgr.checkCircularDependnecy((MethodElement)eObject)).isOK()) {
            bl = false;
            object = iStatus.getMessage();
            if (StrUtil.isBlank((String)object)) {
                object = ValidationResources.circularDependency_error;
            }
            this.appendDiagnostics(iStatus, diagnosticChain);
        }
        if (diagnosticChain != null && !this.hasProcessed(eObject, map)) {
            if (LibraryEValidator.getTraversalType(map) == 1) {
                this.batchValidator.setTraversalStrategy(LibraryTraversalStrategy.deepTraversalStrategy);
            }
            if ((object = (IConstraintFilter)map.get(CTX_CONSTRAINT_FILTER)) != null) {
                this.batchValidator.addConstraintFilter((IConstraintFilter)object);
            }
            try {
                iStatus = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                if (object != null) {
                    this.batchValidator.removeConstraintFilter((IConstraintFilter)object);
                }
            }
            this.processed(eObject, map, iStatus);
            this.appendDiagnostics(iStatus, diagnosticChain);
        }
        if (eObject instanceof ProcessComponent && (object = ((ProcessComponent)eObject).getProcess()) != null) {
            this.validateProcess((Process)object, diagnosticChain, map);
        }
        return bl && iStatus.isOK();
    }

    public void validateProcess(Process process, DiagnosticChain diagnosticChain, Map map) {
        Object v = map.get(CTX_ADAPTER_FACTORY_PROVIDER);
        if (!(v instanceof IAdapterFactoryProvider)) {
            return;
        }
        IAdapterFactoryProvider iAdapterFactoryProvider = (IAdapterFactoryProvider)v;
        class FilteredAdapterFactoryTreeIterator
        extends AdapterFactoryTreeIterator {
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DiagnosticChain val$diagnostics;

            public FilteredAdapterFactoryTreeIterator(AdapterFactory adapterFactory, Object object, DiagnosticChain diagnosticChain) {
                this.val$diagnostics = diagnosticChain;
                super(adapterFactory, object);
            }

            protected boolean accept(Object object) {
                return object instanceof NamedElement;
            }

            protected Iterator getChildren(Object object) {
                ArrayList arrayList = new ArrayList();
                Iterator iterator = super.getChildren(object);
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    if (object2 instanceof MethodElement || object2 instanceof DescribableElementWrapperItemProvider && !((DescribableElementWrapperItemProvider)object2).isReadOnly()) {
                        arrayList.add(object2);
                        object2 = TngUtil.unwrap(object2);
                    }
                    if (!this.accept(object2)) continue;
                    try {
                        ArrayList<EAttribute> arrayList2 = new ArrayList<EAttribute>();
                        arrayList2.add(UmaPackage.Literals.NAMED_ELEMENT__NAME);
                        if (object2 instanceof DescribableElement) {
                            arrayList2.add(UmaPackage.Literals.DESCRIBABLE_ELEMENT__PRESENTATION_NAME);
                        }
                        NamedElement namedElement = (NamedElement)object2;
                        boolean cfr_ignored_0 = namedElement instanceof BreakdownElement;
                        if (DEBUG) {
                            System.out.println("FilteredAdapterFactoryTreeIterator.getChildren(): validating '" + namedElement.getName() + "'");
                        }
                        for (EStructuralFeature eStructuralFeature : arrayList2) {
                            IValidator iValidator = IValidatorFactory.INSTANCE.createValidator(object, null, (EObject)object2, eStructuralFeature, this.adapterFactory);
                            Object object3 = this.adapterFactory.adapt(object2, ITreeItemContentProvider.class);
                            String string = (String)featureToPropertyMap.get(eStructuralFeature);
                            String string2 = object3 instanceof IBSItemProvider && string != null ? ((IBSItemProvider)object3).getAttribute(object2, string) : (String)namedElement.eGet(eStructuralFeature);
                            String string3 = iValidator.isValid(string2);
                            if (string3 == null) continue;
                            LibraryEValidator.this.appendDiagnostics((IStatus)new ValidationStatus(4, 0, string3, namedElement, eStructuralFeature), this.val$diagnostics);
                        }
                    }
                    catch (Exception exception) {}
                }
                return arrayList.iterator();
            }
        }
        FilteredAdapterFactoryTreeIterator filteredAdapterFactoryTreeIterator = new FilteredAdapterFactoryTreeIterator(iAdapterFactoryProvider.getWBSAdapterFactory(), process, diagnosticChain);
        while (filteredAdapterFactoryTreeIterator.hasNext()) {
            filteredAdapterFactoryTreeIterator.next();
        }
        filteredAdapterFactoryTreeIterator = new FilteredAdapterFactoryTreeIterator(iAdapterFactoryProvider.getTBSAdapterFactory(), process, diagnosticChain){
            private static final long serialVersionUID = 1L;
            {
                super(adapterFactory, object, diagnosticChain);
            }

            protected boolean accept(Object object) {
                return object instanceof RoleDescriptor || object instanceof TeamProfile;
            }
        };
        while (filteredAdapterFactoryTreeIterator.hasNext()) {
            filteredAdapterFactoryTreeIterator.next();
        }
        filteredAdapterFactoryTreeIterator = new FilteredAdapterFactoryTreeIterator(iAdapterFactoryProvider.getWPBSAdapterFactory(), process, diagnosticChain){
            private static final long serialVersionUID = 1L;
            {
                super(adapterFactory, object, diagnosticChain);
            }

            protected boolean accept(Object object) {
                return object instanceof WorkProductDescriptor;
            }
        };
        while (filteredAdapterFactoryTreeIterator.hasNext()) {
            filteredAdapterFactoryTreeIterator.next();
        }
    }

    private static int getTraversalType(Map map) {
        Object v = map.get("TRAVERSAL_TYPE");
        return v instanceof Number && ((Number)v).intValue() == 1 ? 1 : 0;
    }

    public boolean validate(EDataType eDataType, Object object, DiagnosticChain diagnosticChain, Map map) {
        return super.validate(eDataType, object, diagnosticChain, map);
    }

    private void processed(EObject eObject, Map map, IStatus iStatus) {
        if (map != null) {
            map.put(eObject, iStatus);
        }
    }

    private boolean hasProcessed(EObject eObject, Map map) {
        boolean bl = false;
        if (map != null) {
            while (eObject != null) {
                if (map.containsKey(eObject)) {
                    bl = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return bl;
    }

    private void appendDiagnostics(IStatus iStatus, DiagnosticChain diagnosticChain) {
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                this.appendDiagnostics(iStatusArray[n], diagnosticChain);
                ++n;
            }
        } else if (iStatus instanceof IConstraintStatus) {
            diagnosticChain.add((Diagnostic)new BasicDiagnostic(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), ((IConstraintStatus)iStatus).getResultLocus().toArray()));
        } else if (iStatus instanceof org.eclipse.epf.library.edit.validation.ValidationStatus) {
            diagnosticChain.add((Diagnostic)new BasicDiagnostic(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), new Object[]{((org.eclipse.epf.library.edit.validation.ValidationStatus)iStatus).getCheckedObject()}));
        } else {
            diagnosticChain.add((Diagnostic)new BasicDiagnostic(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), iStatus.getMessage(), null));
        }
    }
}

