/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.PluginModifyInfo;
import org.eclipse.epf.importing.wizards.SelectImportPluginSource;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.PluginDepInfo;
import org.eclipse.epf.library.edit.validation.PluginDependencyInfoMgr;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportPluginWizard
extends Wizard
implements IImportWizard {
    protected SelectImportPluginSource page1;
    protected SelectPluginsToImport page2;
    protected PluginImportData data = new PluginImportData();
    protected PluginImportingService service = new PluginImportingService(this.data);

    public ImportPluginWizard() {
        this.setWindowTitle(ImportResources.importPluginsWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        ILibraryManager iLibraryManager;
        IFileManager iFileManager = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            iFileManager.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null && iLibraryManager.isMethodLibraryReadOnly()) {
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.importPluginsWizard_title, ImportResources.ImportPluginWizard_readonly);
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.page1 = new SelectImportPluginSource(this.data, this.service);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new SelectPluginsToImport(this.data, this.service);
        this.addPage((IWizardPage)this.page2);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(LibraryUIImages.IMG_METHOD_PLUGIN);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.page2) {
            return false;
        }
        return this.page2.isPageComplete();
    }

    public boolean performFinish() {
        Object object;
        boolean bl;
        PluginModifyInfo pluginModifyInfo = this.checkModify();
        if (pluginModifyInfo.readonlyPlugins.size() > 0) {
            String string = pluginModifyInfo.getReadonlyMessage().toString();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportConfigurationWizard_error, string);
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            if (pluginInfo.existingPlugin == null || !pluginInfo.selected) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append("\t").append(pluginInfo.name);
        }
        if (stringBuffer.length() > 0 && !(bl = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(ImportResources.importPluginsWizard_title, NLS.bind((String)ImportResources.ImportPluginWizard_warn_existing_plugins, (Object)stringBuffer.toString())))) {
            return false;
        }
        if (pluginModifyInfo.lockedPlugins.size() > 0) {
            object = String.valueOf(pluginModifyInfo.getLockedMessage().toString()) + ImportResources.ImportPluginWizard_confirm_continue;
            boolean bl2 = ImportPlugin.getDefault().getMsgDialog().displayConfirmation(ImportResources.importPluginsWizard_title, (String)object);
            if (!bl2) {
                return false;
            }
        }
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        object = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        iProgressMonitor.beginTask(ImportResources.ImportPluginWizard_MSG1, -1);
                        ImportPluginWizard.this.service.performImport(iProgressMonitor);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)object);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ImportPlugin.getDefault().getMsgDialog().displayError(ImportResources.ImportPluginWizard_error, throwable.getMessage());
            return false;
        }
        try {
            this.checkPluginCircularDependency();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        ImportUIPreferences.addImportPluginDir(this.data.llData.getParentFolder());
        ImportUIPreferences.setCheckBasePlugins(this.service.isCheckBasePlugins());
        return true;
    }

    public PluginModifyInfo checkModify() {
        PluginModifyInfo pluginModifyInfo = new PluginModifyInfo();
        for (PluginImportData.PluginInfo pluginInfo : this.data.getPlugins()) {
            MethodPlugin methodPlugin = pluginInfo.existingPlugin;
            if (methodPlugin == null || !pluginInfo.selected) continue;
            if (!methodPlugin.getUserChangeable().booleanValue()) {
                pluginModifyInfo.lockedPlugins.add(methodPlugin);
                continue;
            }
            IStatus iStatus = TngUtil.checkEdit((EObject)methodPlugin, (Object)this.getShell());
            if (iStatus.isOK()) continue;
            pluginModifyInfo.readonlyPlugins.add(methodPlugin);
        }
        return pluginModifyInfo;
    }

    private void checkPluginCircularDependency() {
        PluginDependencyInfoMgr pluginDependencyInfoMgr = new PluginDependencyInfoMgr(LibraryService.getInstance().getCurrentMethodLibrary());
        PluginDependencyInfoMgr.CheckResult checkResult = pluginDependencyInfoMgr.checkCircularDependnecy(null, false);
        if (checkResult.circularList != null && !checkResult.circularList.isEmpty()) {
            List list = (List)checkResult.circularList.get(0);
            String string = "";
            int n = 0;
            while (n < list.size()) {
                PluginDepInfo pluginDepInfo = (PluginDepInfo)list.get(n);
                if (n != 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + pluginDepInfo.getPlugin().getName();
                ++n;
            }
            ImportPlugin.getDefault().getMsgDialog().displayWarning(ImportResources.ImportPluginWizard_warn_circular_plugins, string);
        }
    }
}

