/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.folding.FoldingMessages;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderDescriptor;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;

public class JavaFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new JavaFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String id) {
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (JavaFoldingStructureProviderDescriptor)this.fDescriptors.get(id);
        }
    }

    public IJavaFoldingStructureProvider getCurrentFoldingProvider() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        String currentProviderId = preferenceStore.getString("editor_folding_provider");
        JavaFoldingStructureProviderDescriptor desc = this.getFoldingProviderDescriptor(currentProviderId);
        if (desc == null) {
            String message = Messages.format(FoldingMessages.JavaFoldingStructureProviderRegistry_warning_providerNotFound_resetToDefault, currentProviderId);
            JavaPlugin.log((IStatus)new Status(2, JavaPlugin.getPluginId(), 0, message, null));
            String defaultProviderId = preferenceStore.getDefaultString("editor_folding_provider");
            desc = this.getFoldingProviderDescriptor(defaultProviderId);
            Assert.isNotNull((Object)desc);
            preferenceStore.setToDefault("editor_folding_provider");
        }
        try {
            return desc.createProvider();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        HashMap<String, JavaFoldingStructureProviderDescriptor> map = new HashMap<String, JavaFoldingStructureProviderDescriptor>();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(JavaPlugin.getPluginId(), EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            JavaFoldingStructureProviderDescriptor desc = new JavaFoldingStructureProviderDescriptor(elements[i]);
            map.put(desc.getId(), desc);
            ++i;
        }
        JavaFoldingStructureProviderRegistry javaFoldingStructureProviderRegistry = this;
        synchronized (javaFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(map);
        }
    }
}

