/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;

public class MoveInSectionListCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentElement contentElement;
    private SectionList sectionList;
    private List elementsList;
    private ContentElement usedContentElement = null;
    private Collection modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInSectionListCommand() {
    }

    public MoveInSectionListCommand(ContentElement contentElement, List list, SectionList sectionList, int n) {
        this.contentElement = contentElement;
        this.sectionList = sectionList;
        this.elementsList = list;
        this.direction = n;
        this.modifiedResources = new HashSet();
    }

    protected boolean prepare() {
        return true;
    }

    public MoveInSectionListCommand(String string) {
        super(string);
    }

    public MoveInSectionListCommand(String string, String string2) {
        super(string, string2);
    }

    public Collection getModifiedResources() {
        this.modifiedResources.add(this.contentElement.eResource());
        return this.modifiedResources;
    }

    public void execute() {
        MethodPlugin methodPlugin;
        MethodPlugin methodPlugin2 = UmaUtil.getMethodPlugin((EObject)this.contentElement);
        if (methodPlugin2 != (methodPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)this.elementsList.get(0)))) && Misc.isBaseOf(methodPlugin2, methodPlugin)) {
            Iterator iterator = TngUtil.getContributors((VariabilityElement)this.contentElement);
            while (iterator.hasNext()) {
                VariabilityElement variabilityElement = (VariabilityElement)iterator.next();
                if (!(variabilityElement instanceof ContentElement) || UmaUtil.getMethodPlugin((EObject)variabilityElement) != methodPlugin) continue;
                this.usedContentElement = (ContentElement)variabilityElement;
                break;
            }
        }
        if (this.usedContentElement == null) {
            this.usedContentElement = this.contentElement;
        }
        this.redo();
    }

    public void redo() {
        if (this.usedContentElement == null) {
            return;
        }
        for (Object e : this.elementsList) {
            int n = this.sectionList.indexOf(e);
            if (this.direction == UP) {
                if (n > 0) {
                    this.sectionList.move(n - 1, e);
                }
            } else if (this.direction == Down && n < this.sectionList.size()) {
                this.sectionList.move(n + this.elementsList.size(), e);
            }
            this.moved = true;
        }
        this.sectionList.apply();
    }

    public void undo() {
        if (this.moved) {
            for (Object e : this.elementsList) {
                int n = this.sectionList.indexOf(e);
                if (this.direction == UP) {
                    if (n < this.sectionList.size()) {
                        this.sectionList.move(n + this.elementsList.size(), e);
                    }
                } else if (this.direction == Down && n > 0) {
                    this.sectionList.move(n - 1, e);
                }
                this.moved = true;
            }
            this.sectionList.apply();
            this.moved = false;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.usedContentElement);
    }
}

