/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;

public class AssignRoleToTaskDescriptor
extends AddMethodElementCommand {
    private List roles;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private int action;
    List existingRoleDescList = new ArrayList();
    List newRoleDescList = new ArrayList();
    private HashMap map = new HashMap();
    private MethodConfiguration config;
    private boolean isNewRoleDescriptor = false;

    public AssignRoleToTaskDescriptor(TaskDescriptor taskDescriptor, List list, int n, MethodConfiguration methodConfiguration) {
        super(TngUtil.getOwningProcess((BreakdownElement)taskDescriptor));
        this.roles = list;
        this.taskDesc = taskDescriptor;
        this.action = n;
        this.config = methodConfiguration;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)taskDescriptor, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)taskDescriptor);
        if (object instanceof Activity) {
            this.activity = (Activity)object;
        }
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.roles)) {
            return;
        }
        for (Role role : this.roles) {
            RoleDescriptor roleDescriptor = null;
            this.isNewRoleDescriptor = false;
            roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)role, this.activity, this.config);
            if (roleDescriptor == null && (roleDescriptor = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(role, this.activity, this.config)) == null) {
                roleDescriptor = ProcessUtil.createRoleDescriptor(role);
                this.isNewRoleDescriptor = true;
            }
            if (this.isNewRoleDescriptor) {
                this.newRoleDescList.add(roleDescriptor);
            } else {
                this.existingRoleDescList.add(roleDescriptor);
            }
            TeamProfile teamProfile = UserInteractionHelper.getTeam(this.activity, role);
            if (teamProfile == null) continue;
            this.map.put(roleDescriptor, teamProfile);
        }
        this.redo();
    }

    public void redo() {
        if (this.action == 1) {
            this.taskDesc.getAdditionallyPerformedBy().addAll(this.existingRoleDescList);
            this.taskDesc.getAdditionallyPerformedBy().addAll(this.newRoleDescList);
        } else if (this.action == 2) {
            this.taskDesc.getAssistedBy().addAll(this.existingRoleDescList);
            this.taskDesc.getAssistedBy().addAll(this.newRoleDescList);
        }
        this.activity.getBreakdownElements().addAll(this.newRoleDescList);
        if (this.map != null) {
            Set set = this.map.keySet();
            for (Object k : set) {
                TeamProfile teamProfile = (TeamProfile)this.map.get(k);
                teamProfile.getTeamRoles().add((RoleDescriptor)k);
            }
        }
    }

    public void undo() {
        super.undo();
        if (this.action == 1) {
            this.taskDesc.getAdditionallyPerformedBy().removeAll(this.existingRoleDescList);
            this.taskDesc.getAdditionallyPerformedBy().removeAll(this.newRoleDescList);
        } else if (this.action == 2) {
            this.taskDesc.getAssistedBy().removeAll(this.existingRoleDescList);
            this.taskDesc.getAssistedBy().removeAll(this.newRoleDescList);
        }
        this.activity.getBreakdownElements().removeAll(this.newRoleDescList);
        if (this.map != null) {
            Set set = this.map.keySet();
            for (Object k : set) {
                TeamProfile teamProfile = (TeamProfile)this.map.get(k);
                teamProfile.getTeamRoles().remove((RoleDescriptor)k);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.roles != null && !this.roles.isEmpty()) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.taskDesc.eResource() != null) {
                this.modifiedResources.add(this.taskDesc.eResource());
            }
        }
        return this.modifiedResources;
    }
}

