/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class BasicSynchronizeDescriptorCommand
extends AbstractCommand
implements IResourceAwareCommand {
    public static final Set NONEMPTY_ATTRIBUTES = new HashSet(Arrays.asList(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getDescribableElement_PresentationName()));
    protected Descriptor descriptor;
    protected Set synchFeatures;
    protected MethodConfiguration config;
    private HashMap featureMap;

    public BasicSynchronizeDescriptorCommand(Descriptor descriptor, Set set, MethodConfiguration methodConfiguration) {
        this.descriptor = descriptor;
        this.synchFeatures = set == null ? BSDropCommand.DEFAULT_SYNCH_FEATURES : set;
        this.config = methodConfiguration;
    }

    public Collection getModifiedResources() {
        if (this.descriptor.eResource() != null) {
            return Collections.singletonList(this.descriptor.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    private void saveOldFeatureValue(EStructuralFeature eStructuralFeature) {
        if (this.featureMap == null) {
            this.featureMap = new HashMap();
        }
        this.featureMap.put(eStructuralFeature, this.descriptor.eGet(eStructuralFeature));
    }

    public void execute() {
        MethodElement methodElement = ProcessUtil.getAssociatedElement(this.descriptor);
        Object object = Providers.getConfigurationApplicator().resolve(methodElement, this.config);
        if (object != methodElement) {
            Object object2 = this.descriptor instanceof TaskDescriptor ? UmaPackage.eINSTANCE.getTaskDescriptor_Task() : (this.descriptor instanceof WorkProductDescriptor ? UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct() : (this.descriptor instanceof RoleDescriptor ? UmaPackage.eINSTANCE.getRoleDescriptor_Role() : null));
            this.saveOldFeatureValue((EStructuralFeature)object2);
            methodElement = (MethodElement)object;
            this.descriptor.eSet((EStructuralFeature)object2, (Object)methodElement);
        }
        for (Object e : this.synchFeatures) {
            EAttribute eAttribute;
            EAttribute eAttribute2;
            if (!(e instanceof EAttribute) || (eAttribute2 = (EAttribute)BSDropCommand.FEATURE_MAP.get(eAttribute = (EAttribute)e)) == null) continue;
            if (NONEMPTY_ATTRIBUTES.contains(eAttribute)) {
                Object object3;
                Object object4 = object3 = methodElement instanceof VariabilityElement ? (String)Providers.getConfigurationApplicator().getAttribute((VariabilityElement)methodElement, eAttribute, this.config) : methodElement.eGet((EStructuralFeature)eAttribute);
                if (eAttribute2.equals(UmaPackage.eINSTANCE.getDescribableElement_PresentationName()) && (object3 == null || object3.equals(""))) {
                    object3 = methodElement instanceof VariabilityElement ? (String)Providers.getConfigurationApplicator().getAttribute((VariabilityElement)methodElement, UmaPackage.eINSTANCE.getNamedElement_Name(), this.config) : methodElement.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
                }
                Object object5 = this.descriptor.eGet((EStructuralFeature)eAttribute2);
                if ((object3 != null || object5 == null) && (object3 == null || object3.equals(object5))) continue;
                this.saveOldFeatureValue((EStructuralFeature)eAttribute2);
                this.descriptor.eSet((EStructuralFeature)eAttribute2, object3);
                continue;
            }
            this.saveOldFeatureValue((EStructuralFeature)eAttribute2);
            this.descriptor.eSet((EStructuralFeature)eAttribute2, eAttribute2.getDefaultValue());
        }
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        if (this.featureMap != null) {
            for (Map.Entry entry : this.featureMap.entrySet()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)entry.getKey();
                this.descriptor.eSet(eStructuralFeature, entry.getValue());
            }
            this.featureMap.clear();
        }
    }

    public void dispose() {
        if (this.featureMap != null) {
            this.featureMap.clear();
            this.featureMap = null;
        }
        super.dispose();
    }
}

