/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;

public abstract class VaryActivityCommand
extends AbstractCommand
implements IResourceAwareCommand {
    protected BreakdownElementWrapperItemProvider wrapper;
    private Process proc;
    protected List createdActivities;
    public Activity superActivity;

    public VaryActivityCommand(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        this.wrapper = breakdownElementWrapperItemProvider;
        this.proc = (Process)breakdownElementWrapperItemProvider.getTopItem();
    }

    public BreakdownElementWrapperItemProvider getWrapper() {
        return this.wrapper;
    }

    public Collection getModifiedResources() {
        if (this.proc.eResource() != null) {
            return Collections.singletonList(this.proc.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        if (this.createdActivities == null) {
            this.createdActivities = new ArrayList();
        } else {
            this.createdActivities.clear();
        }
        this.doVary();
        List list = Providers.getCommandListeners(VaryActivityCommand.class);
        if (list != null) {
            for (ICommandListener iCommandListener : list) {
                iCommandListener.notifyExecuted(this);
            }
        }
    }

    protected abstract void doVary();

    public void redo() {
        Object object = this.wrapper.getOwner();
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.wrapper.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
        for (Object e : iTreeItemContentProvider.getChildren(object)) {
            if (!(e instanceof BreakdownElementWrapperItemProvider) || ((BreakdownElementWrapperItemProvider)e).getValue() != this.wrapper.getValue()) continue;
            this.wrapper = (BreakdownElementWrapperItemProvider)e;
            break;
        }
        this.execute();
    }

    public void undo() {
        List list = Providers.getCommandListeners(VaryActivityCommand.class);
        if (list != null) {
            for (ICommandListener iCommandListener : list) {
                iCommandListener.preUndo(this);
            }
        }
        if (!this.createdActivities.isEmpty()) {
            this.restoreOrder();
            Activity activity = (Activity)this.createdActivities.get(0);
            this.superActivity = activity.getSuperActivities();
            activity.setSuperActivities(null);
            this.createdActivities.clear();
        }
        if (list != null) {
            for (ICommandListener iCommandListener : list) {
                iCommandListener.postUndo(this);
            }
        }
    }

    protected void restoreOrder() {
        BreakdownElement breakdownElement;
        Activity activity = (Activity)this.createdActivities.get(this.createdActivities.size() - 1);
        BreakdownElement breakdownElement2 = (BreakdownElement)TngUtil.unwrap(this.wrapper);
        BreakdownElement breakdownElement3 = activity.getPresentedBefore();
        if (breakdownElement3 != null && this.proc == TngUtil.getOwningProcess(breakdownElement3)) {
            breakdownElement3.setPresentedAfter(breakdownElement2);
        }
        if ((breakdownElement = activity.getPresentedAfter()) != null && this.proc == TngUtil.getOwningProcess(breakdownElement)) {
            breakdownElement.setPresentedBefore(breakdownElement2);
        }
    }

    public Collection getResult() {
        return this.createdActivities;
    }
}

