/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.model.OrderInfo;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorySortHelper {
    public static final String KEY_CATEGORY_ELEMENTS__SORT_TYPE = "CategoryElementsSortType";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA = "Alphabetic";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA = "ReverseAlphabetic";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE = "MethodType";
    public static final String V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL = "Manual";

    public static MethodElementProperty createNewSortProperty(String string) {
        MethodElementProperty methodElementProperty = UmaFactory.eINSTANCE.createMethodElementProperty();
        methodElementProperty.setName(KEY_CATEGORY_ELEMENTS__SORT_TYPE);
        if (string != null) {
            methodElementProperty.setValue(string);
        }
        return methodElementProperty;
    }

    public static MethodElementProperty getCategorySortProperty(MethodElement methodElement) {
        List list = methodElement.getMethodElementProperty();
        for (MethodElementProperty methodElementProperty : list) {
            if (!KEY_CATEGORY_ELEMENTS__SORT_TYPE.equals(methodElementProperty.getName())) continue;
            return methodElementProperty;
        }
        return null;
    }

    public static boolean isManualCategorySort(MethodElement methodElement) {
        String string = CategorySortHelper.getCategorySortValue(methodElement);
        return V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(string);
    }

    public static String getCategorySortValue(MethodElement methodElement) {
        MethodElementProperty methodElementProperty = CategorySortHelper.getCategorySortProperty(methodElement);
        if (methodElementProperty == null) {
            return V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL;
        }
        return methodElementProperty.getValue();
    }

    public static List<String> getCategorySortTypes() {
        List<String> list = Arrays.asList(V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL, V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA, V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA, V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE);
        return list;
    }

    public static String getSortTypeDisplayName(String string) {
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA.equals(string)) {
            return LibraryEditResources.SortType_Alphabetic;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA.equals(string)) {
            return LibraryEditResources.SortType_ReverseAlphabetic;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE.equals(string)) {
            return LibraryEditResources.SortType_MethodType;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(string)) {
            return LibraryEditResources.SortType_Manual;
        }
        return "";
    }

    public static List<Object> sortCategoryElements(MethodElement methodElement, Object[] objectArray) {
        return CategorySortHelper.sortCategoryElements(methodElement, objectArray, false);
    }

    public static List<Object> sortCategoryElements(MethodElement methodElement, Object[] objectArray, boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>((Collection)Arrays.asList(objectArray));
        String string = CategorySortHelper.getCategorySortValue(methodElement);
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(string)) {
            if (methodElement instanceof ContentCategory) {
                return CategorySortHelper.findManualSortOrderInContributors((ContentCategory)methodElement, arrayList);
            }
            return arrayList;
        }
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_ALPHA.equals(string)) {
            Comparator comparator = PresentationContext.INSTANCE.getComparator();
            if (bl) {
                comparator = PresentationContext.INSTANCE.getPresNameComparator();
            }
            Collections.sort(arrayList, comparator);
        } else if (V_CATEGORY_ELEMENTS__SORT_TYPE_REVERSE_ALPHA.equals(string)) {
            Comparator comparator = PresentationContext.INSTANCE.getReverseComparator();
            if (bl) {
                comparator = PresentationContext.INSTANCE.getPresNameReverseComparator();
            }
            Collections.sort(arrayList, comparator);
        } else if (V_CATEGORY_ELEMENTS__SORT_TYPE_METHOD_TYPE.equals(string)) {
            Comparator comparator = PresentationContext.INSTANCE.getMethodElementTypeComparator();
            if (bl) {
                comparator = PresentationContext.INSTANCE.getPresNameMethodElementTypeComparator();
            }
            Collections.sort(arrayList, comparator);
        }
        return arrayList;
    }

    private static List<Object> findManualSortOrderInContributors(ContentCategory contentCategory, List<Object> list) {
        OrderInfo orderInfo = null;
        HashMap<String, MethodElement> hashMap = new HashMap<String, MethodElement>();
        String string = CategorySortHelper.getCategorySortValue((MethodElement)contentCategory);
        if (V_CATEGORY_ELEMENTS__SORT_TYPE_MANUAL.equals(string)) {
            Object object;
            for (Object object2 : list) {
                if (!(object2 instanceof MethodElement)) continue;
                hashMap.put(((MethodElement)object2).getGuid(), (MethodElement)object2);
            }
            Object object3 = TngUtil.getContributors((VariabilityElement)contentCategory);
            while (object3.hasNext()) {
                Object object2;
                object2 = object3.next();
                if (!(object2 instanceof ContentCategory)) continue;
                ContentCategory contentCategory2 = (ContentCategory)object2;
                object = TngUtil.getOrderInfo((MethodElement)contentCategory2, "content elements");
                if (orderInfo != null && object.getTimestamp() <= orderInfo.getTimestamp()) continue;
                orderInfo = object;
            }
            if (orderInfo != null) {
                object3 = new ArrayList();
                int n = orderInfo.getGUIDs().size();
                int n2 = 0;
                while (n2 < n) {
                    object = (String)orderInfo.getGUIDs().get(n2);
                    Object v = hashMap.get(object);
                    if (v != null) {
                        object3.add(v);
                        hashMap.remove(object);
                    } else {
                        MethodElement methodElement = CategorySortHelper.findElementInGeneralizerList(hashMap, (String)object);
                        if (methodElement != null) {
                            object3.add(methodElement);
                            hashMap.remove(object);
                        }
                    }
                    ++n2;
                }
                if (list.size() == object3.size()) {
                    return object3;
                }
            }
        }
        return list;
    }

    private static MethodElement findElementInGeneralizerList(Map<String, MethodElement> map, String string) {
        for (MethodElement methodElement : map.values()) {
            if (!(methodElement instanceof VariabilityElement)) continue;
            Iterator iterator = TngUtil.getGeneralizers((VariabilityElement)methodElement);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof MethodElement) || !((MethodElement)e).getGuid().equals(string)) continue;
                return (MethodElement)e;
            }
        }
        return null;
    }

    public static boolean needToSort(MethodElement methodElement, EStructuralFeature eStructuralFeature) {
        if (!(methodElement instanceof ContentCategory)) {
            return false;
        }
        if (methodElement instanceof CustomCategory && eStructuralFeature == UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements()) {
            return true;
        }
        if (methodElement instanceof Discipline && eStructuralFeature == UmaPackage.eINSTANCE.getDiscipline_Tasks()) {
            return true;
        }
        if (methodElement instanceof Domain && eStructuralFeature == UmaPackage.eINSTANCE.getDomain_WorkProducts()) {
            return true;
        }
        if (methodElement instanceof RoleSet && eStructuralFeature == UmaPackage.eINSTANCE.getRoleSet_Roles()) {
            return true;
        }
        if (methodElement instanceof Tool && eStructuralFeature == UmaPackage.eINSTANCE.getTool_ToolMentors()) {
            return true;
        }
        return methodElement instanceof WorkProductType && eStructuralFeature == UmaPackage.eINSTANCE.getWorkProductType_WorkProducts();
    }
}

