/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.DepthLevelAdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.util.MethodElementPropertyHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredecessorList
extends ArrayList<Object> {
    private static final long serialVersionUID = 3617853092570412082L;
    private static final String FINISH_TO_START = LibraryEditResources.WorkOrderTypeAbbreviation_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = LibraryEditResources.WorkOrderTypeAbbreviation_FINISH_TO_FINISH;
    private static final String START_TO_START = LibraryEditResources.WorkOrderTypeAbbreviation_START_TO_START;
    private static final String START_TO_FINISH = LibraryEditResources.WorkOrderTypeAbbreviation_START_TO_FINISH;
    private Map map4LinkType = new HashMap();
    public static final PredecessorList EMPTY_LIST = new PredecessorList(){
        private static final long serialVersionUID = 3904676098217097016L;

        public void refresh() {
        }

        public void add(int n, Object object) {
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException();
        }
    };
    private AdapterFactory adapterFactory;
    private Object object;
    private Adapter listener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(BreakdownElement.class)) {
                case 22: {
                    PredecessorList.this.refresh();
                    return;
                }
            }
        }
    };
    private Object top;

    private PredecessorList() {
    }

    public PredecessorList(AdapterFactory adapterFactory, Object object) {
        this.adapterFactory = adapterFactory;
        this.object = object;
        BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap(object);
        breakdownElement.eAdapters().add(0, (Object)this.listener);
        if (!this.map4LinkType.isEmpty()) {
            this.map4LinkType.clear();
        }
        this.initialize();
    }

    public void dispose() {
        Object object = TngUtil.unwrap(this.object);
        if (object instanceof EObject) {
            ((EObject)object).eAdapters().remove((Object)this.listener);
        }
        this.clear();
    }

    protected Object getTopItem() {
        if (this.object instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)this.object;
            if (breakdownElementWrapperItemProvider.isReadOnly()) {
                BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap(this.object);
                Process process = TngUtil.getOwningProcess(breakdownElement);
                Object object = breakdownElementWrapperItemProvider;
                Object object2 = breakdownElementWrapperItemProvider.getParent(this.object);
                while (object2 != null) {
                    object = object2;
                    BreakdownElement breakdownElement2 = (BreakdownElement)TngUtil.unwrap(object2);
                    Process process2 = TngUtil.getOwningProcess(breakdownElement2);
                    if (process2 != process) break;
                    if (object2 instanceof ITreeItemContentProvider) {
                        object2 = ((ITreeItemContentProvider)object2).getParent(object2);
                        continue;
                    }
                    ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object2, ITreeItemContentProvider.class);
                    object2 = iTreeItemContentProvider.getParent(object2);
                }
                return object;
            }
            return breakdownElementWrapperItemProvider.getTopItem();
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)this.adapterFactory.adapt(this.object, ITreeItemContentProvider.class);
        return iBSItemProvider.getTopItem();
    }

    static List<DepthLevelItemProvider> createItemProviderList(Object object, AdapterFactory adapterFactory) {
        ArrayList<DepthLevelItemProvider> arrayList = new ArrayList<DepthLevelItemProvider>();
        DepthLevelAdapterFactoryTreeIterator<Object> depthLevelAdapterFactoryTreeIterator = new DepthLevelAdapterFactoryTreeIterator<Object>(adapterFactory, object){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object object) {
                Object object2 = TngUtil.unwrap(object);
                if (object2 instanceof Descriptor || object2 instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(object);
            }
        };
        while (depthLevelAdapterFactoryTreeIterator.hasNext()) {
            Object e = depthLevelAdapterFactoryTreeIterator.next();
            Object object2 = TngUtil.unwrap(e);
            if (!(object2 instanceof WorkBreakdownElement)) continue;
            int n = depthLevelAdapterFactoryTreeIterator.getDepthLevel();
            Object object3 = adapterFactory.adapt(e, ITreeItemContentProvider.class);
            arrayList.add(new DepthLevelItemProvider(e, n, object3, object2));
        }
        return arrayList;
    }

    private static void updateElementToItemProvidersMap(Map<Object, Collection<Object>> map, Object object, Object object2) {
        VariabilityElement variabilityElement;
        Collection<Object> collection = map.get(object);
        if (collection == null) {
            collection = new ArrayList<Object>();
            map.put(object, collection);
        }
        collection.add(object2);
        if (object instanceof VariabilityElement && (variabilityElement = (VariabilityElement)object).getVariabilityBasedOnElement() != null) {
            collection = map.get(variabilityElement.getVariabilityBasedOnElement());
            if (collection == null) {
                collection = new ArrayList<Object>();
                map.put(variabilityElement.getVariabilityBasedOnElement(), collection);
            }
            collection.add(object2);
        }
    }

    Map<?, Collection<Object>> createBreakdownElementToItemProviderMap(List<DepthLevelItemProvider> list) {
        Object object = this.getTopItem();
        DepthLevelItemProvider depthLevelItemProvider = null;
        int n = 0;
        for (DepthLevelItemProvider depthLevelItemProvider2 : list) {
            if (depthLevelItemProvider2.object == object) {
                depthLevelItemProvider = depthLevelItemProvider2;
                break;
            }
            ++n;
        }
        assert (depthLevelItemProvider != null) : "Could not find item provider of top object in the given item provider list.";
        int n2 = list.size();
        int n3 = n + 1;
        while (n3 < n2 && list.get(n3).depthLevel > depthLevelItemProvider.depthLevel) {
            ++n3;
        }
        HashMap<Object, Collection<Object>> hashMap = new HashMap<Object, Collection<Object>>();
        for (DepthLevelItemProvider depthLevelItemProvider3 : list.subList(n, n3)) {
            PredecessorList.updateElementToItemProvidersMap(hashMap, depthLevelItemProvider3.element, depthLevelItemProvider3.itemProvider);
        }
        return hashMap;
    }

    static Map<Object, Collection<Object>> createBreakdownElementToItemProviderMap(Object object, AdapterFactory adapterFactory) {
        AdapterFactoryTreeIterator<Object> adapterFactoryTreeIterator = new AdapterFactoryTreeIterator<Object>(adapterFactory, object){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object object) {
                Object object2 = TngUtil.unwrap(object);
                if (object2 instanceof Descriptor || object2 instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(object);
            }
        };
        HashMap<Object, Collection<Object>> hashMap = new HashMap<Object, Collection<Object>>();
        while (adapterFactoryTreeIterator.hasNext()) {
            Object object2 = adapterFactoryTreeIterator.next();
            Object object3 = TngUtil.unwrap(object2);
            if (!(object3 instanceof WorkBreakdownElement)) continue;
            IBSItemProvider iBSItemProvider = (IBSItemProvider)(object2 instanceof IBSItemProvider ? object2 : adapterFactory.adapt(object2, ITreeItemContentProvider.class));
            PredecessorList.updateElementToItemProvidersMap(hashMap, object3, iBSItemProvider);
        }
        return hashMap;
    }

    private void initialize() {
        Object object = TngUtil.unwrap(this.object);
        if (object instanceof WorkBreakdownElement) {
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)object;
            List list = workBreakdownElement.getLinkToPredecessor();
            if (list.isEmpty()) {
                return;
            }
            this.top = this.getTopItem();
            this.initialize(PredecessorList.createBreakdownElementToItemProviderMap(this.top, this.adapterFactory));
        }
    }

    private void initialize(Map<?, Collection<Object>> map) {
        if (TngUtil.unwrap(this.object) instanceof WorkBreakdownElement) {
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)TngUtil.unwrap(this.object);
            List list = workBreakdownElement.getLinkToPredecessor();
            if (list.isEmpty()) {
                return;
            }
            WorkBreakdownElement workBreakdownElement2 = (WorkBreakdownElement)TngUtil.unwrap(this.top);
            String string = workBreakdownElement2.getGuid();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                WorkOrder workOrder = (WorkOrder)list.get(n2);
                WorkBreakdownElement workBreakdownElement3 = workOrder.getPred();
                Collection<Object> collection = map.get(workBreakdownElement3);
                if (collection != null && !collection.isEmpty()) {
                    IBSItemProvider iBSItemProvider = null;
                    MethodElementProperty methodElementProperty = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, "pred_process_path");
                    if (methodElementProperty == null) {
                        iBSItemProvider = (IBSItemProvider)collection.iterator().next();
                    } else {
                        String string2 = methodElementProperty.getValue();
                        String string3 = string;
                        VariabilityElement variabilityElement = workBreakdownElement2 instanceof VariabilityElement ? ((VariabilityElement)workBreakdownElement2).getVariabilityBasedOnElement() : null;
                        int n3 = string2.indexOf(string3);
                        while (n3 == -1 && variabilityElement != null) {
                            if (variabilityElement != null) {
                                string3 = variabilityElement.getGuid();
                                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
                            }
                            n3 = string2.indexOf(string3);
                        }
                        if (n3 != -1) {
                            StringBuffer stringBuffer = new StringBuffer(string2.substring(n3 + string3.length()));
                            Object object = this.top;
                            Object object2 = workBreakdownElement2;
                            while (object2 != null) {
                                stringBuffer.insert(0, object2.getGuid());
                                stringBuffer.insert(0, '/');
                                if (object instanceof WorkBreakdownElement) {
                                    object = object2 = ((WorkBreakdownElement)object).getSuperActivities();
                                    continue;
                                }
                                object = this.adapterFactory.adapt(object, ITreeItemContentProvider.class);
                                object2 = (WorkBreakdownElement)TngUtil.unwrap(object);
                            }
                            stringBuffer.insert(0, ":/").insert(0, "wbs");
                            object2 = stringBuffer.toString();
                            for (Object object3 : collection) {
                                String string4;
                                if (!(object3 instanceof BreakdownElementWrapperItemProvider) || !((String)object2).equals(string4 = Suppression.getPath((BreakdownElementWrapperItemProvider)object3))) continue;
                                iBSItemProvider = (IBSItemProvider)object3;
                                break;
                            }
                        }
                    }
                    if (iBSItemProvider != null) {
                        this.add(iBSItemProvider);
                        this.map4LinkType.put(iBSItemProvider.getId(), workOrder.getLinkType().getValue());
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (!this.map4LinkType.isEmpty()) {
            this.map4LinkType.clear();
        }
    }

    protected void refresh() {
        this.clear();
        this.initialize();
    }

    void refresh(List<DepthLevelItemProvider> list) {
        this.clear();
        this.initialize(this.createBreakdownElementToItemProviderMap(list));
    }

    @Override
    public String toString() {
        return this.toUnSuppressedString(null);
    }

    public String toUnSuppressedString(Suppression suppression) {
        Object object;
        Object object2 = this.iterator();
        while (object2.hasNext()) {
            BreakdownElement breakdownElement;
            Object object3 = TngUtil.unwrap(object2.next());
            if (object3 instanceof ItemProviderAdapter && (object3 = ((ItemProviderAdapter)object3).getTarget()) == null) {
                object2.remove();
            }
            if (!(object3 instanceof BreakdownElement) || (object = (breakdownElement = (BreakdownElement)object3).getSuperActivities()) != null || TngUtil.getOwningProcess(breakdownElement) == breakdownElement) continue;
            object2.remove();
        }
        if (this.isEmpty()) {
            return "";
        }
        object2 = new StringBuffer();
        int n = this.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            object = (IBSItemProvider)this.get(n2);
            if (suppression == null || !suppression.isSuppressed(object)) {
                ((StringBuffer)object2).append(object.getId()).append(',');
            }
            ++n2;
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)this.get(n);
        if (suppression == null || !suppression.isSuppressed(iBSItemProvider)) {
            ((StringBuffer)object2).append(iBSItemProvider.getId());
        }
        return ((StringBuffer)object2).toString();
    }

    public String toUnSuppressedString(Suppression suppression, boolean bl) {
        Object object;
        Object object2 = this.iterator();
        while (object2.hasNext()) {
            BreakdownElement breakdownElement;
            Object object3 = TngUtil.unwrap(object2.next());
            if (object3 instanceof ItemProviderAdapter && (object3 = ((ItemProviderAdapter)object3).getTarget()) == null) {
                object2.remove();
            }
            if (!(object3 instanceof BreakdownElement) || (object = (breakdownElement = (BreakdownElement)object3).getSuperActivities()) != null || TngUtil.getOwningProcess(breakdownElement) == breakdownElement) continue;
            object2.remove();
        }
        if (this.isEmpty()) {
            return "";
        }
        object2 = new StringBuffer();
        int n = this.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            object = (IBSItemProvider)this.get(n2);
            if (suppression == null || !suppression.isSuppressed(object)) {
                int n3;
                String string;
                ((StringBuffer)object2).append(object.getId());
                Object v = this.map4LinkType.get(object.getId());
                if (v != null && bl && (string = PredecessorList.toWorkOrderTypeAbbreviation(n3 = Integer.parseInt(v.toString()))) != null) {
                    ((StringBuffer)object2).append(string);
                }
                ((StringBuffer)object2).append(',');
            }
            ++n2;
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)this.get(n);
        if (suppression == null || !suppression.isSuppressed(iBSItemProvider)) {
            int n4;
            String string;
            ((StringBuffer)object2).append(iBSItemProvider.getId());
            object = this.map4LinkType.get(iBSItemProvider.getId());
            if (object != null && bl && (string = PredecessorList.toWorkOrderTypeAbbreviation(n4 = Integer.parseInt(object.toString()))) != null) {
                ((StringBuffer)object2).append(string);
            }
        }
        return ((StringBuffer)object2).toString();
    }

    public static boolean prepareUpdatePredecessors(AdapterFactory adapterFactory, WorkBreakdownElement workBreakdownElement, List<Object> list, List<WorkOrder> list2, List<WorkOrder> list3) {
        WorkOrder workOrder22 = null;
        int n = workBreakdownElement.getLinkToPredecessor().size();
        IFilter iFilter = ProcessUtil.getFilter(adapterFactory);
        boolean bl = iFilter == null;
        for (WorkOrder workOrder22 : workBreakdownElement.getLinkToPredecessor()) {
            if (!bl && !iFilter.accept(workOrder22.getPred())) continue;
            boolean bl2 = false;
            for (Object object : list) {
                if (object instanceof WorkBreakdownElement) {
                    if (workOrder22.getPred() != object) continue;
                    bl2 = true;
                    break;
                }
                if (!(object instanceof BreakdownElementWrapperItemProvider) || !PredecessorList.isPredecessor((BreakdownElementWrapperItemProvider)object, workOrder22)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            list3.add(workOrder22);
        }
        n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object2 = list.get(n2);
            WorkBreakdownElement workBreakdownElement2 = (WorkBreakdownElement)TngUtil.unwrap(object2);
            boolean bl2 = false;
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)(object2 instanceof BreakdownElementWrapperItemProvider ? object2 : null);
            String string = null;
            for (WorkOrder workOrder22 : workBreakdownElement.getLinkToPredecessor()) {
                if (workOrder22.getPred() != workBreakdownElement2) continue;
                if (breakdownElementWrapperItemProvider != null) {
                    if (!PredecessorList.isPredecessor(breakdownElementWrapperItemProvider, workOrder22)) continue;
                    bl2 = true;
                    break;
                }
                bl2 = true;
                break;
            }
            if (!bl2) {
                workOrder22 = UmaFactory.eINSTANCE.createWorkOrder();
                workOrder22.setPred(workBreakdownElement2);
                if (breakdownElementWrapperItemProvider != null) {
                    if (string == null) {
                        string = Suppression.getPath(breakdownElementWrapperItemProvider);
                    }
                    MethodElementPropertyHelper.setProperty((MethodElement)workOrder22, "pred_process_path", string);
                }
                list2.add(workOrder22);
            }
            ++n2;
        }
        return true;
    }

    public static boolean prepareUpdatePredecessors(AdapterFactory adapterFactory, WorkBreakdownElement workBreakdownElement, String string, List<WorkOrder> list, List<WorkOrder> list2) {
        ArrayList<Object> arrayList;
        Process process = TngUtil.getOwningProcess((BreakdownElement)workBreakdownElement);
        if (ProcessUtil.checkPredecessorList(workBreakdownElement, string, adapterFactory, (Object)process, arrayList = new ArrayList<Object>()) == null) {
            return PredecessorList.prepareUpdatePredecessors(adapterFactory, workBreakdownElement, arrayList, list, list2);
        }
        return false;
    }

    public static String toWorkOrderTypeAbbreviation(int n) {
        switch (n) {
            case 1: {
                return FINISH_TO_FINISH;
            }
            case 3: {
                return START_TO_FINISH;
            }
            case 2: {
                return START_TO_START;
            }
        }
        return null;
    }

    public static boolean isPredecessor(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, WorkOrder workOrder) {
        MethodElementProperty methodElementProperty = MethodElementPropertyHelper.getProperty((MethodElement)workOrder, "pred_process_path");
        if (methodElementProperty == null) {
            return false;
        }
        String string = methodElementProperty.getValue();
        String string2 = Suppression.getPath(breakdownElementWrapperItemProvider);
        return string.equals(string2);
    }

    /* synthetic */ PredecessorList(PredecessorList predecessorList) {
        this();
    }

    public static class DepthLevelItemProvider {
        private int depthLevel;
        private Object itemProvider;
        private Object object;
        private Object element;

        private DepthLevelItemProvider(Object object, int n, Object object2, Object object3) {
            this.object = object;
            this.depthLevel = n;
            this.itemProvider = object2;
            this.element = object3;
        }

        public Object getItemProvider() {
            return this.itemProvider;
        }
    }
}

