/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.DescribableElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.process.command.ProcessDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.provider.UmaEditPlugin;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessUtil {
    private static Collection<EClass> OBSEclasses = null;
    private static Collection<EClass> WBSEclasses = null;
    private static Collection<EClass> PBSEclasses = null;
    private static Collection<VariabilityType> extendAndLocalContributionVariabilityTypes = null;

    private static Collection<VariabilityType> getExtendAndLocalContributionVariabilityTypes() {
        if (extendAndLocalContributionVariabilityTypes == null) {
            extendAndLocalContributionVariabilityTypes = new ArrayList<VariabilityType>();
            extendAndLocalContributionVariabilityTypes.add(VariabilityType.EXTENDS_LITERAL);
            extendAndLocalContributionVariabilityTypes.add(VariabilityType.LOCAL_CONTRIBUTION_LITERAL);
        }
        return extendAndLocalContributionVariabilityTypes;
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, String string, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), string, suppression);
    }

    public static String checkBreakdownElementName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, String string, Suppression suppression, boolean bl) {
        return NameChecker.checkName(adapterFactory, breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), string, suppression, bl);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, String string, Suppression suppression) {
        if ((string == null || string.length() == 0) && ProcessUtil.isExtendingOrLocallyContributing(breakdownElement)) {
            BreakdownElement breakdownElement2 = (BreakdownElement)((VariabilityElement)breakdownElement).getVariabilityBasedOnElement();
            string = ProcessUtil.getPresentationName(breakdownElement2);
        }
        return NameChecker.checkName(adapterFactory, breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression);
    }

    public static String checkBreakdownElementPresentationName(AdapterFactory adapterFactory, BreakdownElement breakdownElement, String string, Suppression suppression, boolean bl) {
        return NameChecker.checkName(adapterFactory, breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string, suppression, bl);
    }

    public static Object getRootProcess(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter, Object object) {
        Object object2 = itemProviderAdapter.getParent(object);
        itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
        if (object2 == null) {
            return object;
        }
        return ProcessUtil.getRootProcess(adapterFactory, itemProviderAdapter, object2);
    }

    public static Collection<EClass> getWBSEclasses() {
        if (WBSEclasses == null) {
            WBSEclasses = new HashSet<EClass>();
            WBSEclasses.add(UmaPackage.eINSTANCE.getTaskDescriptor());
            WBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            WBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return WBSEclasses;
    }

    public static Collection<EClass> getOBSEclasses() {
        if (OBSEclasses == null) {
            OBSEclasses = new HashSet<EClass>();
            OBSEclasses.add(UmaPackage.eINSTANCE.getRoleDescriptor());
            OBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            OBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
            OBSEclasses.add(UmaPackage.eINSTANCE.getTeamProfile());
            OBSEclasses.add(UmaPackage.eINSTANCE.getCompositeRole());
        }
        return OBSEclasses;
    }

    public static Collection<EClass> getPBSEclasses() {
        if (PBSEclasses == null) {
            PBSEclasses = new HashSet<EClass>();
            PBSEclasses.add(UmaPackage.eINSTANCE.getWorkProductDescriptor());
            PBSEclasses.add(UmaPackage.eINSTANCE.getActivity());
            PBSEclasses.add(UmaPackage.eINSTANCE.getMilestone());
        }
        return PBSEclasses;
    }

    public static boolean isFirstElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter, Object object) {
        Object object2 = itemProviderAdapter.getParent(object);
        if (object2 instanceof TeamProfile) {
            return true;
        }
        LinkedList linkedList = ProcessUtil.getSiblings(adapterFactory, itemProviderAdapter, object);
        if (linkedList != null && !linkedList.isEmpty()) {
            return linkedList.getFirst() == object;
        }
        return true;
    }

    public static LinkedList getSiblings(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter, Object object) {
        Object object2 = itemProviderAdapter.getParent(object);
        if (object2 == null) {
            return null;
        }
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            return new LinkedList(iTreeItemContentProvider.getChildren(object2));
        }
        return null;
    }

    public static boolean isLastElement(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter, Object object) {
        Object object2 = itemProviderAdapter.getParent(object);
        if (object2 instanceof TeamProfile) {
            return true;
        }
        LinkedList linkedList = ProcessUtil.getSiblings(adapterFactory, itemProviderAdapter, object);
        if (linkedList != null && !linkedList.isEmpty()) {
            return linkedList.getLast() == object;
        }
        return true;
    }

    public static List getAffectedElements(Notification notification, IFilter iFilter) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        switch (notification.getEventType()) {
            case 3: {
                Object object = notification.getNewValue();
                if (iFilter != null && !iFilter.accept(object)) break;
                arrayList.add(object);
                break;
            }
            case 5: {
                for (Object e : (Collection)notification.getNewValue()) {
                    if (iFilter != null && !iFilter.accept(e)) continue;
                    arrayList.add(e);
                }
                break;
            }
            case 4: {
                Object object = notification.getOldValue();
                if (iFilter != null && !iFilter.accept(object)) break;
                arrayList.add(object);
                break;
            }
            case 6: {
                for (Object e : (Collection)notification.getOldValue()) {
                    if (iFilter != null && !iFilter.accept(e)) continue;
                    arrayList.add(e);
                }
                break;
            }
            case 7: {
                Object object = notification.getNewValue();
                if (object instanceof Collection) {
                    for (Object e : (Collection)object) {
                        if (iFilter != null && !iFilter.accept(e)) continue;
                        arrayList.add(e);
                    }
                    break;
                }
                if (iFilter != null && !iFilter.accept(object)) break;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public static boolean isRefreshRequired(Notification notification, IFilter iFilter) {
        switch (notification.getEventType()) {
            case 1: 
            case 3: {
                Object object = notification.getNewValue();
                if (iFilter != null && !iFilter.accept(object)) break;
                return true;
            }
            case 5: {
                for (Object e : (Collection)notification.getNewValue()) {
                    if (iFilter != null && !iFilter.accept(e)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                Object object = notification.getOldValue();
                if (iFilter != null && !iFilter.accept(object)) break;
                return true;
            }
            case 6: {
                for (Object e : (Collection)notification.getOldValue()) {
                    if (iFilter != null && !iFilter.accept(e)) continue;
                    return true;
                }
                break;
            }
            case 7: {
                Object object = notification.getNewValue();
                if (object instanceof Collection) {
                    for (Object e : (Collection)object) {
                        if (iFilter != null && !iFilter.accept(e)) continue;
                        return true;
                    }
                    break;
                }
                if (iFilter != null && !iFilter.accept(object)) break;
                return true;
            }
        }
        return false;
    }

    public static void addToContainer(BreakdownElement breakdownElement, ItemProviderAdapter itemProviderAdapter) {
        ProcessUtil.addToContainer(breakdownElement, itemProviderAdapter, true);
    }

    public static void addToContainer(BreakdownElement breakdownElement, ItemProviderAdapter itemProviderAdapter, boolean bl) {
        EObject eObject;
        ProcessPackage processPackage = null;
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        if (object instanceof EObject && (eObject = ((EObject)object).eContainer()) instanceof ProcessPackage) {
            processPackage = (ProcessPackage)eObject;
        }
        if (processPackage == null) {
            return;
        }
        if (breakdownElement instanceof Activity) {
            ProcessPackage processPackage2;
            eObject = (Activity)breakdownElement;
            if (eObject.eContainer() == null) {
                ProcessPackage processPackage3 = UmaFactory.eINSTANCE.createProcessPackage();
                processPackage3.setName(eObject.getName());
                processPackage.getChildPackages().add(processPackage3);
                processPackage3.getProcessElements().add(breakdownElement);
            } else if (bl && (processPackage2 = (ProcessPackage)eObject.eContainer()).eContainer() != processPackage) {
                processPackage.getChildPackages().add(processPackage2);
            }
        } else if (breakdownElement.eContainer() == null) {
            processPackage.getProcessElements().add(breakdownElement);
        } else if (bl && breakdownElement.eContainer() != processPackage) {
            processPackage.getProcessElements().add(breakdownElement);
        }
    }

    public static void setParent(Object object, Object object2, AdapterFactory adapterFactory) {
        Object object3 = adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (object3 instanceof IBSItemProvider) {
            ((IBSItemProvider)object3).setParent(object2);
        }
    }

    public static RoleDescriptor createRoleDescriptor(Role role) {
        RoleDescriptor roleDescriptor = UmaFactory.eINSTANCE.createRoleDescriptor();
        roleDescriptor.setRole(role);
        String string = role.getPresentationName();
        roleDescriptor.setName(role.getName());
        roleDescriptor.setPresentationName(StrUtil.isBlank((String)string) ? role.getName() : string);
        return roleDescriptor;
    }

    public static WorkProductDescriptor createWorkProductDescriptor(WorkProduct workProduct) {
        WorkProductDescriptor workProductDescriptor = UmaFactory.eINSTANCE.createWorkProductDescriptor();
        workProductDescriptor.setWorkProduct(workProduct);
        workProductDescriptor.setName(workProduct.getName());
        workProductDescriptor.setPresentationName(StrUtil.isBlank((String)workProduct.getPresentationName()) ? workProduct.getName() : workProduct.getPresentationName());
        return workProductDescriptor;
    }

    public static Viewer getViewer(AdapterFactory adapterFactory, Process process) {
        if (adapterFactory instanceof ExposedAdapterFactory) {
            for (Object t : Collections.unmodifiableList(((ExposedAdapterFactory)adapterFactory).getChangeListeners())) {
                Viewer viewer;
                if (!(t instanceof IContentProvider) || !(t instanceof IViewerProvider) || !((viewer = ((IViewerProvider)t).getViewer()).getInput() instanceof ProcessComponent) || ((ProcessComponent)viewer.getInput()).getProcess() != process) continue;
                return viewer;
            }
        }
        return null;
    }

    public static boolean refreshNeeded(AdapterFactory adapterFactory, BSActivityItemProvider bSActivityItemProvider) {
        BSActivityItemProvider bSActivityItemProvider2;
        Object e;
        Process process = (Process)bSActivityItemProvider.getTopItem();
        if (process == null) {
            return false;
        }
        Viewer viewer = ProcessUtil.getViewer(adapterFactory, process);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            return true;
        }
        Iterator iterator = TngUtil.getContributors((VariabilityElement)process);
        while (iterator.hasNext()) {
            e = iterator.next();
            bSActivityItemProvider2 = (BSActivityItemProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
            if (!ProcessUtil.refreshNeeded(adapterFactory, bSActivityItemProvider2)) continue;
            return true;
        }
        iterator = TngUtil.getGeneralizers((VariabilityElement)process, VariabilityType.EXTENDS_LITERAL);
        while (iterator.hasNext()) {
            e = iterator.next();
            bSActivityItemProvider2 = (BSActivityItemProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
            if (!ProcessUtil.refreshNeeded(adapterFactory, bSActivityItemProvider2)) continue;
            return true;
        }
        return false;
    }

    public static void refreshPredeccessorLists(AdapterFactory adapterFactory, Process process) {
        List<PredecessorList.DepthLevelItemProvider> list = PredecessorList.createItemProviderList(process, adapterFactory);
        for (PredecessorList.DepthLevelItemProvider depthLevelItemProvider : list) {
            PredecessorList predecessorList;
            Object object = depthLevelItemProvider.getItemProvider();
            if (!(object instanceof IBSItemProvider) || (predecessorList = ((IBSItemProvider)object).getPredecessors()) == null) continue;
            predecessorList.refresh(list);
        }
    }

    public static void updateIDs(AdapterFactory adapterFactory, Process process) {
        AdapterFactoryTreeIterator<Object> adapterFactoryTreeIterator = new AdapterFactoryTreeIterator<Object>(adapterFactory, (Object)process){
            private static final long serialVersionUID = 1L;

            protected Iterator<Object> getChildren(Object object) {
                Object object2 = TngUtil.unwrap(object);
                if (object2 instanceof Descriptor || object2 instanceof Milestone) {
                    return Collections.emptyList().iterator();
                }
                return super.getChildren(object);
            }
        };
        int n = 0;
        while (adapterFactoryTreeIterator.hasNext()) {
            IBSItemProvider iBSItemProvider;
            Object object = adapterFactoryTreeIterator.next();
            Object object2 = adapterFactory.adapt(object, ITreeItemContentProvider.class);
            if (!(object2 instanceof IBSItemProvider) || (iBSItemProvider = (IBSItemProvider)object2) == null || !(TngUtil.unwrap(object) instanceof WorkBreakdownElement)) continue;
            iBSItemProvider.setId(n++);
        }
    }

    public static void refreshViewer(AdapterFactory adapterFactory, Process process) {
        final Viewer viewer = ProcessUtil.getViewer(adapterFactory, process);
        if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            UserInteractionHelper.runInUIThread(new Runnable(){

                public void run() {
                    viewer.refresh();
                }
            });
        }
    }

    public static void refreshIDsInViewers(final ExposedAdapterFactory exposedAdapterFactory) {
        UserInteractionHelper.runInUIThread(new Runnable(){

            public void run() {
                for (Object t : Collections.unmodifiableList(exposedAdapterFactory.getChangeListeners())) {
                    Process process;
                    BSActivityItemProvider bSActivityItemProvider;
                    Viewer viewer;
                    if (!(t instanceof IContentProvider) || !(t instanceof IViewerProvider) || (viewer = ((IViewerProvider)t).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent) || !(bSActivityItemProvider = (BSActivityItemProvider)exposedAdapterFactory.adapt((Notifier)(process = ((ProcessComponent)viewer.getInput()).getProcess()), (Object)ITreeItemContentProvider.class)).isRefreshAllIDsRequired()) continue;
                    ProcessUtil.updateIDs((AdapterFactory)exposedAdapterFactory, process);
                    viewer.refresh();
                    bSActivityItemProvider.setRefreshAllIDsRequired(false);
                }
            }
        });
    }

    public static void refreshAllViewers(final ExposedAdapterFactory exposedAdapterFactory) {
        UserInteractionHelper.runInUIThread(new Runnable(){

            public void run() {
                for (Object t : Collections.unmodifiableList(exposedAdapterFactory.getChangeListeners())) {
                    Viewer viewer;
                    if (!(t instanceof IContentProvider) || !(t instanceof IViewerProvider) || (viewer = ((IViewerProvider)t).getViewer()) == null || viewer.getControl() == null || viewer.getControl().isDisposed() || !(viewer.getInput() instanceof ProcessComponent)) continue;
                    viewer.refresh();
                }
            }
        });
    }

    public static String checkPredecessorList(WorkBreakdownElement workBreakdownElement, List<Integer> list, AdapterFactory adapterFactory, Object object, List<Object> list2) {
        Integer n;
        Object object2;
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(adapterFactory, object);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object e = adapterFactoryTreeIterator.next();
            object2 = (IBSItemProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
            n = new Integer(object2.getId());
            Object object3 = TngUtil.unwrap(e);
            arrayList2.add(object3);
            if (!list.contains(n)) continue;
            arrayList.add(e);
        }
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            object2 = TngUtil.unwrap(arrayList.get(n3));
            if (object2 instanceof WorkBreakdownElement) {
                n = (WorkBreakdownElement)object2;
                if (ProcessUtil.checkCircular(workBreakdownElement, (WorkBreakdownElement)n, arrayList2)) {
                    return LibraryEditResources.util_ProcessUtil_err_same_breakdown_element;
                }
                if (TngUtil.isSubelementOf(n, workBreakdownElement, adapterFactory)) {
                    return LibraryEditResources.util_ProcessUtil_err_same_sub_element;
                }
                if (TngUtil.isSuperElementOf(n, workBreakdownElement, adapterFactory)) {
                    return LibraryEditResources.util_ProcessUtil_err_child_element;
                }
            } else {
                return LibraryEditResources.util_ProcessUtil_err_wrong_element;
            }
            ++n3;
        }
        if (list2 != null) {
            list2.addAll(arrayList);
        }
        return null;
    }

    public static boolean checkCircular(WorkBreakdownElement workBreakdownElement, WorkBreakdownElement workBreakdownElement2, List list) {
        if (workBreakdownElement == workBreakdownElement2) {
            return workBreakdownElement2.getIsRepeatable() == false;
        }
        for (WorkOrder workOrder : workBreakdownElement2.getLinkToPredecessor()) {
            WorkBreakdownElement workBreakdownElement3 = workOrder.getPred();
            if (workBreakdownElement3 == workBreakdownElement2 || !list.contains(workBreakdownElement3) || !ProcessUtil.checkCircular(workBreakdownElement, workBreakdownElement3, list)) continue;
            return true;
        }
        return false;
    }

    public static void getAllPredecessorList(WorkBreakdownElement workBreakdownElement, List list, List list2) {
        if (!list2.contains(workBreakdownElement)) {
            list2.add(workBreakdownElement);
        }
        for (WorkOrder workOrder : workBreakdownElement.getLinkToPredecessor()) {
            WorkBreakdownElement workBreakdownElement2 = workOrder.getPred();
            if (workBreakdownElement2 == workBreakdownElement || !list.contains(workBreakdownElement2) || list2.contains(workBreakdownElement2)) continue;
            list2.add(workBreakdownElement2);
            ProcessUtil.getAllPredecessorList(workBreakdownElement2, list, list2);
        }
    }

    public static String checkPredecessorList(WorkBreakdownElement workBreakdownElement, String string, AdapterFactory adapterFactory, Object object, List<Object> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Integer n;
            String string2 = stringTokenizer.nextToken().trim();
            try {
                n = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return LibraryEditResources.invalidPredecessorError_msg;
            }
            arrayList.add(n);
        }
        return ProcessUtil.checkPredecessorList(workBreakdownElement, arrayList, adapterFactory, object, list);
    }

    public static void addToDefaultConfiguration(Process process, EObject eObject, Set set) {
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        if (eObject instanceof Task) {
            ProcessUtil.addTaskToDefaultConfiguration(process, (Task)eObject, set, true);
        } else if (eObject instanceof WorkProduct) {
            WorkProduct workProduct = (WorkProduct)eObject;
            ProcessUtil.addWPToDefaultConfiguration(process, workProduct, set);
            List list = ProcessUtil.getTasksForWorkProduct(workProduct, methodConfiguration);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ProcessUtil.addTaskToDefaultConfiguration(process, (Task)iterator.next(), set, false);
                }
            }
        } else if (eObject instanceof Role) {
            Role role = (Role)eObject;
            ProcessUtil.addRoleToDefaultConfiguration(process, role, set);
        } else if (eObject instanceof Activity) {
            ProcessUtil.addActivityToDefaultConfiguration(process, (Activity)eObject, set);
        } else if (eObject instanceof Guidance) {
            TngUtil.addToConfiguration(methodConfiguration, (EObject)((Guidance)eObject), set);
        }
    }

    private static void addActivityToDefaultConfiguration(Process process, Activity activity, Set set) {
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        TngUtil.addTo(methodConfiguration, (EObject)UmaUtil.getProcessComponent((MethodElement)activity), set);
        for (Object e : activity.getBreakdownElements()) {
            if (e instanceof Descriptor) {
                MethodElement methodElement = ProcessUtil.getAssociatedElement((Descriptor)e);
                if (methodElement == null) continue;
                ProcessUtil.addToDefaultConfiguration(process, (EObject)methodElement, set);
                continue;
            }
            if (!(e instanceof Activity)) continue;
            ProcessUtil.addActivityToDefaultConfiguration(process, (Activity)e, set);
        }
        Activity activity2 = (Activity)activity.getVariabilityBasedOnElement();
        while (activity2 != null) {
            ProcessUtil.addActivityToDefaultConfiguration(process, activity2, set);
            activity2 = (Activity)activity2.getVariabilityBasedOnElement();
        }
    }

    private static void addTaskToDefaultConfiguration(Process process, Task task, Set set, boolean bl) {
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        TngUtil.addToConfiguration(methodConfiguration, (EObject)task, set);
        ArrayList<Role> arrayList = new ArrayList<Role>();
        arrayList.addAll(task.getAdditionallyPerformedBy());
        arrayList.add(task.getPerformedBy());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TngUtil.addToConfiguration(methodConfiguration, (EObject)iterator.next(), set);
        }
        if (bl) {
            arrayList.clear();
            arrayList.addAll(task.getOptionalInput());
            arrayList.addAll(task.getOutput());
            arrayList.addAll(task.getMandatoryInput());
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ProcessUtil.addWPToDefaultConfiguration(process, (WorkProduct)iterator.next(), set);
            }
        }
        for (VariabilityElement variabilityElement : task.getSteps()) {
            VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
            if (variabilityElement2 == null) continue;
            TngUtil.addToConfiguration(methodConfiguration, (EObject)variabilityElement2, set);
        }
    }

    private static void addRoleToDefaultConfiguration(Process process, Role role, Set set) {
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        TngUtil.addToConfiguration(methodConfiguration, (EObject)role, set);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(role.getModifies());
        arrayList.addAll(role.getResponsibleFor());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ProcessUtil.addWPToDefaultConfiguration(process, (WorkProduct)iterator.next(), set);
        }
    }

    private static void addWPToDefaultConfiguration(Process process, WorkProduct workProduct, Set set) {
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        TngUtil.addToConfiguration(methodConfiguration, (EObject)workProduct, set);
        if (workProduct instanceof Deliverable) {
            Iterator iterator = ((Deliverable)workProduct).getDeliveredWorkProducts().iterator();
            while (iterator.hasNext()) {
                TngUtil.addToConfiguration(methodConfiguration, (EObject)iterator.next(), set);
            }
        }
    }

    public static void updateTaskDescriptorSteps(Activity activity, TaskDescriptor taskDescriptor) {
        if (taskDescriptor == null) {
            return;
        }
        Task task = taskDescriptor.getTask();
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        MethodConfiguration methodConfiguration = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
        List list = (List)iConfigurationApplicator.getReference((VariabilityElement)task, UmaPackage.eINSTANCE.getTask_Steps(), methodConfiguration);
        for (Object e : list) {
            if (taskDescriptor.getSelectedSteps().contains(e)) continue;
            taskDescriptor.getSelectedSteps().add(e);
        }
    }

    public static MethodElement getAssociatedElement(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return ((RoleDescriptor)descriptor).getRole();
        }
        if (descriptor instanceof TaskDescriptor) {
            return ((TaskDescriptor)descriptor).getTask();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return ((WorkProductDescriptor)descriptor).getWorkProduct();
        }
        return null;
    }

    public static EReference getLinkReference(Descriptor descriptor) {
        if (descriptor instanceof RoleDescriptor) {
            return UmaPackage.eINSTANCE.getRoleDescriptor_Role();
        }
        if (descriptor instanceof TaskDescriptor) {
            return UmaPackage.eINSTANCE.getTaskDescriptor_Task();
        }
        if (descriptor instanceof WorkProductDescriptor) {
            return UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct();
        }
        return null;
    }

    public static void disposeWrappers(Collection collection) {
        if (collection == null) {
            return;
        }
        for (Object e : collection) {
            if (!(e instanceof IWrapperItemProvider)) continue;
            ((IWrapperItemProvider)e).dispose();
        }
    }

    public static List getTasksForWorkProduct(WorkProduct workProduct, MethodConfiguration methodConfiguration) {
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        List list = (List)iConfigurationApplicator.getReference((MethodElement)workProduct, AssociationHelper.WorkProduct_OutputFrom_Tasks, methodConfiguration);
        return list;
    }

    public static List getWorkProductsForRole(Role role, MethodConfiguration methodConfiguration) {
        IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
        List list = (List)iConfigurationApplicator.getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), methodConfiguration);
        return list;
    }

    public static List getAllWorkProducts(MethodPlugin methodPlugin) {
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(contentPackage, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage contentPackage = (ContentPackage)object;
                ArrayList arrayList = new ArrayList();
                for (Object e : contentPackage.getChildPackages()) {
                    if (!(e instanceof ContentPackage)) continue;
                    arrayList.add(e);
                }
                for (Object e : contentPackage.getContentElements()) {
                    if (!(e instanceof WorkProduct) || TngUtil.isContributor((VariabilityElement)e)) continue;
                    arrayList.add(e);
                }
                return arrayList.iterator();
            }
        };
        ArrayList arrayList = new ArrayList();
        while (abstractTreeIterator.hasNext()) {
            Object e = abstractTreeIterator.next();
            if (!(e instanceof WorkProduct)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static List getAllTasks(MethodPlugin methodPlugin) {
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(contentPackage, false){
            private static final long serialVersionUID = 3833752066324837937L;

            protected Iterator getChildren(Object object) {
                if (!(object instanceof ContentPackage)) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ContentPackage contentPackage = (ContentPackage)object;
                ArrayList arrayList = new ArrayList();
                for (Object e : contentPackage.getChildPackages()) {
                    if (!(e instanceof ContentPackage)) continue;
                    arrayList.add(e);
                }
                for (Object e : contentPackage.getContentElements()) {
                    if (!(e instanceof Task) || TngUtil.isContributor((VariabilityElement)e)) continue;
                    arrayList.add(e);
                }
                return arrayList.iterator();
            }
        };
        ArrayList arrayList = new ArrayList();
        while (abstractTreeIterator.hasNext()) {
            Object e = abstractTreeIterator.next();
            if (!(e instanceof Task)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    public static boolean isExtendingOrLocallyContributing(BreakdownElement breakdownElement) {
        return TngUtil.isGeneralizer(breakdownElement, ProcessUtil.getExtendAndLocalContributionVariabilityTypes());
    }

    public static String getPresentationName(BreakdownElement breakdownElement) {
        if ((breakdownElement.getPresentationName() == null || breakdownElement.getPresentationName().length() == 0) && ProcessUtil.isExtendingOrLocallyContributing(breakdownElement)) {
            BreakdownElement breakdownElement2 = (BreakdownElement)((VariabilityElement)breakdownElement).getVariabilityBasedOnElement();
            return ProcessUtil.getPresentationName(breakdownElement2);
        }
        return breakdownElement.getPresentationName();
    }

    public static String getLabelWithPath(BreakdownElement breakdownElement) {
        StringBuffer stringBuffer = new StringBuffer(breakdownElement.getName());
        Process process = TngUtil.getOwningProcess(breakdownElement);
        if (process != null) {
            stringBuffer.append(", ");
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)process);
            if (methodPlugin != null) {
                stringBuffer.append(methodPlugin.getName());
            }
            if (breakdownElement != process) {
                stringBuffer.append('/').append(process.getName());
            }
        }
        return stringBuffer.toString();
    }

    public static void getModelInfo(BreakdownElement breakdownElement, Object object, StringBuffer stringBuffer) {
        if (breakdownElement instanceof VariabilityElement) {
            VariabilityElement variabilityElement = (VariabilityElement)breakdownElement;
            VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
            if (variabilityElement2 != null) {
                VariabilityType variabilityType = variabilityElement.getVariabilityType();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("; ");
                }
                String string = null;
                if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                    string = LibraryEditResources.util_ProcessUtil_contributesto;
                } else if (variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                    string = LibraryEditResources.util_ProcessUtil_localContributesto;
                } else if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                    string = LibraryEditResources.process_extends;
                } else if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                    string = LibraryEditResources.process_replaces;
                } else if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
                    string = LibraryEditResources.process_localReplaces;
                }
                if (string != null) {
                    String string2 = ProcessUtil.getLabelWithPath((BreakdownElement)variabilityElement2);
                    stringBuffer.append(MessageFormat.format((String)string, (Object[])new Object[]{string2}));
                    ProcessUtil.getModelInfo((BreakdownElement)variabilityElement2, object, stringBuffer);
                }
            }
        } else if (object instanceof BreakdownElementWrapperItemProvider) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object;
            breakdownElementWrapperItemProvider.getOwner();
            if (breakdownElementWrapperItemProvider.getFeature() != null) {
                stringBuffer.append(TngUtil.getFeatureText(breakdownElementWrapperItemProvider.getFeature()));
            } else if (breakdownElementWrapperItemProvider instanceof WorkProductDescriptorWrapperItemProvider) {
                ProcessUtil.getWPDModelInfo(stringBuffer, breakdownElementWrapperItemProvider, breakdownElementWrapperItemProvider);
            }
        }
    }

    public static String getColumnName(String string) {
        if ("id".equals(string)) {
            return "id";
        }
        if ("name".equals(string)) {
            return "name";
        }
        if ("presentation_name".equals(string)) {
            return "presentation_name";
        }
        if ("predecessors".equals(string)) {
            return "predecessors";
        }
        if ("is_event_driven".equals(string)) {
            return "is_event_driven";
        }
        if ("is_ongoing".equals(string)) {
            return "is_ongoing";
        }
        if ("is_repeatable".equals(string)) {
            return "is_repeatable";
        }
        if ("prefix".equals(string)) {
            return "prefix";
        }
        if ("model_info".equals(string)) {
            return "model_info";
        }
        if ("type".equals(string)) {
            return "type";
        }
        if ("teams".equals(string)) {
            return "teams";
        }
        if ("entry_state".equals(string)) {
            return "entry_state";
        }
        if ("exit_state".equals(string)) {
            return "exit_state";
        }
        if ("deliverable".equals(string)) {
            return "deliverable";
        }
        if ("is_optional".equals(string)) {
            return "is_optional";
        }
        if ("is_planned".equals(string)) {
            return "is_planned";
        }
        if ("has_multiple_occurrences".equals(string)) {
            return "has_multiple_occurrences";
        }
        return null;
    }

    public static String getAttribute(Object object, String string, Object object2) {
        StringBuffer stringBuffer;
        Object object3;
        BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap(object);
        if (string == "id") {
            if (breakdownElement instanceof WorkBreakdownElement && object2 instanceof IBSItemProvider) {
                return String.valueOf(((IBSItemProvider)object2).getId());
            }
        } else if (string == "name") {
            if (object2 instanceof IItemLabelProvider) {
                return ((IItemLabelProvider)object2).getText((Object)breakdownElement);
            }
        } else {
            if (string == "presentation_name") {
                return ProcessUtil.getPresentationName(breakdownElement);
            }
            if (string == "predecessors") {
                if (object2 instanceof IBSItemProvider) {
                    return ((IBSItemProvider)object2).getPredecessors().toString();
                }
            } else if (string == "is_event_driven") {
                if (breakdownElement instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)breakdownElement).getIsEventDriven());
                }
            } else if (string == "is_ongoing") {
                if (breakdownElement instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)breakdownElement).getIsOngoing());
                }
            } else if (string == "is_repeatable") {
                if (breakdownElement instanceof WorkBreakdownElement) {
                    return String.valueOf(((WorkBreakdownElement)breakdownElement).getIsRepeatable());
                }
            } else {
                if (string == "prefix") {
                    return breakdownElement.getPrefix();
                }
                if (string == "model_info") {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    ProcessUtil.getModelInfo(breakdownElement, object2, stringBuffer2);
                    return stringBuffer2.toString();
                }
                if (string == "type") {
                    object3 = null;
                    if (breakdownElement instanceof WorkProductDescriptor && (stringBuffer = ((WorkProductDescriptor)breakdownElement).getWorkProduct()) != null) {
                        object3 = String.valueOf(stringBuffer.eClass().getName()) + "Descriptor";
                    }
                    if (object3 == null && breakdownElement instanceof EObject) {
                        object3 = breakdownElement.eClass().getName();
                    }
                    if (object3 != null) {
                        return UmaEditPlugin.INSTANCE.getString("_UI_" + (String)object3 + "_type");
                    }
                } else if (string == "teams") {
                    if (breakdownElement instanceof TeamProfile) {
                        return TngUtil.getPresentationName(((TeamProfile)breakdownElement).getSuperTeam());
                    }
                    if (breakdownElement instanceof RoleDescriptor && object2 instanceof ITreeItemContentProvider) {
                        AdapterFactory adapterFactory = null;
                        if (object2 instanceof BreakdownElementWrapperItemProvider) {
                            adapterFactory = ((BreakdownElementWrapperItemProvider)object2).getAdapterFactory();
                        } else if (object2 instanceof ItemProviderAdapter) {
                            adapterFactory = ((ItemProviderAdapter)object2).getAdapterFactory();
                        }
                        return ProcessUtil.getTeamListString(ProcessUtil.getTeamProfiles(object, (ITreeItemContentProvider)object2, adapterFactory));
                    }
                }
            }
        }
        if (string == "entry_state") {
            if (breakdownElement instanceof WorkProductDescriptor) {
                object3 = (WorkProductDescriptor)breakdownElement;
                return TngUtil.checkNull(object3.getActivityEntryState());
            }
        } else if (string == "exit_state") {
            if (breakdownElement instanceof WorkProductDescriptor) {
                object3 = (WorkProductDescriptor)breakdownElement;
                return TngUtil.checkNull(object3.getActivityExitState());
            }
        } else if (string == "deliverable") {
            if (breakdownElement instanceof WorkProductDescriptor) {
                object3 = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)((WorkProductDescriptor)breakdownElement));
                if (object3.isEmpty()) {
                    return "";
                }
                stringBuffer = new StringBuffer();
                int n = object3.size() - 1;
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append(TngUtil.getPresentationName(object3.get(n2))).append(',');
                    ++n2;
                }
                stringBuffer.append(TngUtil.getPresentationName(object3.get(n)));
                return stringBuffer.toString();
            }
        } else {
            if (string == "is_optional") {
                return String.valueOf(breakdownElement.getIsOptional());
            }
            if (string == "is_planned") {
                return String.valueOf(breakdownElement.getIsPlanned());
            }
            if (string == "has_multiple_occurrences") {
                return String.valueOf(breakdownElement.getHasMultipleOccurrences());
            }
        }
        return "";
    }

    public static Object getParentActivityOfTeam(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        while (!(object instanceof Activity)) {
            breakdownElement = (BreakdownElement)object;
            itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
            object = itemProviderAdapter.getParent((Object)breakdownElement);
        }
        return object;
    }

    public static void getRoleDescriptor(AdapterFactory adapterFactory, Activity activity, List list, List list2) {
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        Collection collection = itemProviderAdapter.getChildren((Object)activity);
        if (collection instanceof List) {
            List list3 = (List)collection;
            for (Object e : list3) {
                RoleDescriptor roleDescriptor;
                if (e instanceof Activity) {
                    ProcessUtil.getRoleDescriptor(adapterFactory, (Activity)e, list, list2);
                }
                if (!(e instanceof RoleDescriptor) || (roleDescriptor = (RoleDescriptor)e).getRole() == null || !list2.contains(roleDescriptor.getRole())) continue;
                list.add(e);
            }
        }
    }

    private static String getTeamListString(List list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size() - 1;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(TngUtil.getPresentationName(list.get(n2))).append(',');
            ++n2;
        }
        stringBuffer.append(TngUtil.getPresentationName(list.get(n)));
        return stringBuffer.toString();
    }

    public static void setAttribute(WorkBreakdownElement workBreakdownElement, String string, String string2) {
        if (string == "name") {
            workBreakdownElement.setName(string2);
        } else if (string == "prefix") {
            workBreakdownElement.setPrefix(string2);
        } else if (string == "is_event_driven") {
            workBreakdownElement.setIsEventDriven(Boolean.valueOf(string2));
        } else if (string == "is_ongoing") {
            workBreakdownElement.setIsOngoing(Boolean.valueOf(string2));
        } else if (string == "is_repeatable") {
            workBreakdownElement.setIsRepeatable(Boolean.valueOf(string2));
        }
    }

    public static void setAttribute(IActionManager iActionManager, BreakdownElement breakdownElement, String string, String string2) {
        if (string == "name") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), string2, -1);
        } else if (string == "prefix") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_Prefix(), string2, -1);
        } else if (string == "is_event_driven") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), Boolean.valueOf(string2), -1);
        } else if (string == "is_ongoing") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), Boolean.valueOf(string2), -1);
        } else if (string == "is_repeatable") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), Boolean.valueOf(string2), -1);
        } else if (string == "presentation_name") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), string2, -1);
        } else if (string == "is_optional") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsOptional(), Boolean.valueOf(string2), -1);
        } else if (string == "is_planned") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_IsPlanned(), Boolean.valueOf(string2), -1);
        } else if (string == "has_multiple_occurrences") {
            iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getBreakdownElement_HasMultipleOccurrences(), Boolean.valueOf(string2), -1);
        } else if (breakdownElement instanceof WorkProductDescriptor) {
            if (string == "entry_state") {
                iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), string2, -1);
            } else if (string == "exit_state") {
                iActionManager.doAction(1, (EObject)breakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), string2, -1);
            }
        }
    }

    public static Activity generalize(Activity activity, VariabilityType variabilityType) {
        EAttribute eAttribute2;
        Object object;
        Activity activity2 = (Activity)UmaFactory.eINSTANCE.create(activity.eClass());
        activity2.setName(activity.getName());
        if (variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
            object = ProcessUtil.getPresentationName((BreakdownElement)activity);
            activity2.setPresentationName((String)(StrUtil.isBlank((String)object) ? activity.getName() : object));
        }
        activity2.setVariabilityBasedOnElement((VariabilityElement)activity);
        activity2.setVariabilityType(variabilityType);
        if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
            for (EAttribute eAttribute2 : activity.eClass().getEAllAttributes()) {
                if (eAttribute2.getEAttributeType().getInstanceClass() != Boolean.class) continue;
                activity2.eSet((EStructuralFeature)eAttribute2, activity.eGet((EStructuralFeature)eAttribute2));
            }
        }
        object = new ArrayList();
        eAttribute2 = new ArrayList(activity.getLinkToPredecessor()).iterator();
        while (eAttribute2.hasNext()) {
            ((ArrayList)object).add(TngUtil.copy((MethodElement)((WorkOrder)eAttribute2.next())));
        }
        activity2.getLinkToPredecessor().addAll(object);
        return activity2;
    }

    public static List getElementsInScope(AdapterFactory adapterFactory, BreakdownElement breakdownElement, Class clazz, List list) {
        Object object;
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        if (breakdownElement instanceof Activity) {
            object = ((Activity)breakdownElement).getBreakdownElements();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!clazz.isInstance(e) || list.contains(e)) continue;
                list.add(e);
            }
        }
        if ((object = iTreeItemContentProvider.getParent((Object)breakdownElement)) != null) {
            ProcessUtil.getElementsInScope(adapterFactory, (BreakdownElement)object, clazz, list);
        }
        return list;
    }

    public static List getRoles(List list) {
        ArrayList<Role> arrayList = new ArrayList<Role>();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)e).getRole();
                arrayList.add(role);
            }
        }
        return arrayList;
    }

    public static List getAssociatedElementList(List list) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof Descriptor)) continue;
                MethodElement methodElement = ProcessUtil.getAssociatedElement((Descriptor)e);
                arrayList.add(methodElement);
            }
        }
        return arrayList;
    }

    public static BreakdownElement getTopBreakdownElement(ProcessComponent processComponent) {
        Process process = processComponent.getProcess();
        if (process == null) {
            return null;
        }
        Adapter adapter = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory().adapt((Notifier)process, ITreeItemContentProvider.class);
        if (!(adapter instanceof IBSItemProvider)) {
            return process;
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)adapter;
        if (iBSItemProvider.getTopItem() == null) {
            iBSItemProvider.setTopItem(process);
            iBSItemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory().adapt((Notifier)process, ITreeItemContentProvider.class);
            iBSItemProvider.setTopItem(process);
            iBSItemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory().adapt((Notifier)process, ITreeItemContentProvider.class);
            iBSItemProvider.setTopItem(process);
            iBSItemProvider = (IBSItemProvider)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory().adapt((Notifier)process, ITreeItemContentProvider.class);
            iBSItemProvider.setTopItem(process);
        }
        ProcessUtil.updateIDs((EObject)process, (Object)process);
        return process;
    }

    private static void updateIDs(EObject eObject, Object object) {
        Process process;
        boolean bl;
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory().adapt((Notifier)eObject, ITreeItemContentProvider.class);
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(itemProviderAdapter.getAdapterFactory());
        boolean bl2 = bl = eObject == object && eObject instanceof Process;
        if (bl) {
            process = (Process)eObject;
            ProcessUtil.updateIDs(adapterFactory, process);
            ProcessUtil.refreshViewer(adapterFactory, process);
        } else {
            process = new AdapterFactoryTreeIterator(adapterFactory, (Object)eObject);
            ProcessUtil.updateIDs(adapterFactory, (AdapterFactoryTreeIterator)process, object);
        }
        itemProviderAdapter = (ItemProviderAdapter)TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory().adapt((Notifier)eObject, ITreeItemContentProvider.class);
        adapterFactory = TngUtil.getBestAdapterFactory(itemProviderAdapter.getAdapterFactory());
        if (bl) {
            process = (Process)eObject;
            ProcessUtil.updateIDs(adapterFactory, process);
            ProcessUtil.refreshViewer(adapterFactory, process);
        } else {
            process = new AdapterFactoryTreeIterator(adapterFactory, (Object)eObject);
            ProcessUtil.updateIDs(adapterFactory, (AdapterFactoryTreeIterator)process, object);
        }
    }

    public static void updateIDs(AdapterFactory adapterFactory, AdapterFactoryTreeIterator adapterFactoryTreeIterator, Object object) {
        Object object2;
        int n = 0;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        while (adapterFactoryTreeIterator.hasNext()) {
            object2 = adapterFactoryTreeIterator.next();
            IBSItemProvider iBSItemProvider = (IBSItemProvider)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
            iBSItemProvider.setId(n++);
            hashMap.put(object2, iBSItemProvider);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            IChangeNotifier iChangeNotifier = (IChangeNotifier)entry.getValue();
            object2 = entry.getKey();
            iChangeNotifier.fireNotifyChanged((Notification)new ViewerNotification((Notification)new NotificationImpl(1, object2, object2), object2, false, true));
        }
    }

    public static boolean checkDescriptorReferences(Descriptor descriptor, Descriptor descriptor2) {
        Set<Descriptor> set = descriptor != null ? Collections.singleton(descriptor) : Collections.EMPTY_SET;
        return ProcessUtil.checkDescriptorReferences(set, descriptor2);
    }

    public static boolean checkDescriptorReferences(Collection collection, Descriptor descriptor) {
        boolean bl;
        block3: {
            block4: {
                bl = false;
                if (!(descriptor instanceof RoleDescriptor)) break block4;
                RoleDescriptor roleDescriptor = (RoleDescriptor)descriptor;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(AssociationHelper.getAssistedTaskDescriptors((RoleDescriptor)roleDescriptor));
                arrayList.addAll(roleDescriptor.getResponsibleFor());
                arrayList.addAll(AssociationHelper.getAdditionalTaskDescriptors((RoleDescriptor)roleDescriptor));
                arrayList.addAll(AssociationHelper.getPrimaryTaskDescriptors((RoleDescriptor)roleDescriptor));
                arrayList.addAll(AssociationHelper.getTeamProfiles((RoleDescriptor)roleDescriptor));
                for (Object e : arrayList) {
                    if ((!(e instanceof Descriptor) || collection.contains(e)) && !(e instanceof TeamProfile)) continue;
                    bl = true;
                    break block3;
                }
                break block3;
            }
            if (descriptor instanceof WorkProductDescriptor) {
                return ProcessUtil.checkWorkProductDescriptorReferences(collection, (WorkProductDescriptor)descriptor, false, -1);
            }
            if (!(descriptor instanceof TaskDescriptor)) break block3;
            TaskDescriptor taskDescriptor = (TaskDescriptor)descriptor;
            ArrayList<RoleDescriptor> arrayList = new ArrayList<RoleDescriptor>();
            arrayList.addAll(taskDescriptor.getAdditionallyPerformedBy());
            arrayList.addAll(taskDescriptor.getAssistedBy());
            arrayList.addAll(taskDescriptor.getExternalInput());
            arrayList.addAll(taskDescriptor.getMandatoryInput());
            arrayList.addAll(taskDescriptor.getOptionalInput());
            arrayList.addAll(taskDescriptor.getOutput());
            arrayList.add(taskDescriptor.getPerformedPrimarilyBy());
            for (Object e : arrayList) {
                if (!(e instanceof Descriptor) || collection.contains(e)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean checkWorkProductDescriptorReferences(Collection collection, WorkProductDescriptor workProductDescriptor, boolean bl, int n) {
        List list;
        Object object;
        ArrayList<Artifact> arrayList;
        List list2;
        ArrayList<WorkProductDescriptor> arrayList2 = new ArrayList<WorkProductDescriptor>();
        arrayList2.add(workProductDescriptor);
        Activity activity = UmaUtil.getParentActivity((BreakdownElement)workProductDescriptor);
        if (workProductDescriptor.getWorkProduct() instanceof Artifact) {
            List list3 = ((Artifact)workProductDescriptor.getWorkProduct()).getContainedArtifacts();
            list2 = ProcessUtil.getWpDescForArtifacts(list3, activity);
            arrayList = new ArrayList<Artifact>();
            object = ((Artifact)workProductDescriptor.getWorkProduct()).getContainerArtifact();
            while (object != null) {
                arrayList.add((Artifact)object);
                object = object.getContainerArtifact();
            }
            list = ProcessUtil.getWpDescForArtifacts(arrayList, activity);
            arrayList2.addAll(list2);
            arrayList2.addAll(list);
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            list2 = (WorkProductDescriptor)arrayList2.get(n2);
            arrayList = new ArrayList();
            arrayList.addAll(list2.getImpactedBy());
            arrayList.addAll(list2.getImpacts());
            arrayList.addAll(AssociationHelper.getResponsibleRoleDescriptors((WorkProductDescriptor)list2));
            arrayList.addAll(list2.getDeliverableParts());
            object = new ArrayList();
            object.addAll(AssociationHelper.getExternalInputTo((WorkProductDescriptor)list2));
            object.addAll(AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)list2));
            object.addAll(AssociationHelper.getOptionalInputTo((WorkProductDescriptor)list2));
            list = AssociationHelper.getOutputFrom((WorkProductDescriptor)list2);
            if (bl) {
                switch (n) {
                    case 27: 
                    case 28: 
                    case 29: {
                        if (!list.containsAll(collection)) break;
                        return true;
                    }
                    case 30: {
                        if (!object.containsAll(collection)) break;
                        return true;
                    }
                }
            }
            arrayList.addAll((Collection<Artifact>)object);
            arrayList.addAll(list);
            for (Object e : arrayList) {
                if (!(e instanceof Descriptor) || collection.contains(e)) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static List getWpDescForArtifacts(List list, Activity activity) {
        ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
        int n = 0;
        while (n < list.size()) {
            Artifact artifact = (Artifact)list.get(n);
            if (activity != null) {
                List list2 = activity.getBreakdownElements();
                for (Object e : list2) {
                    WorkProductDescriptor workProductDescriptor;
                    if (!(e instanceof WorkProductDescriptor) || !((workProductDescriptor = (WorkProductDescriptor)e).getWorkProduct() instanceof Artifact) || !workProductDescriptor.getWorkProduct().equals(artifact)) continue;
                    arrayList.add(workProductDescriptor);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static CompositeRole createCompositeRole(CompositeRole compositeRole) {
        CompositeRole compositeRole2 = UmaFactory.eINSTANCE.createCompositeRole();
        compositeRole2.getAggregatedRoles().addAll(compositeRole.getAggregatedRoles());
        String string = compositeRole.getPresentationName();
        compositeRole2.setName(compositeRole.getName());
        compositeRole2.setPresentationName(StrUtil.isBlank((String)string) ? compositeRole.getName() : string);
        return compositeRole2;
    }

    public static void addTaskToActivity(Task task, Activity activity) {
        WBSDropCommand wBSDropCommand = new WBSDropCommand(activity, Collections.singletonList(task));
        BSDropCommand.IExecutor iExecutor = wBSDropCommand.getExecutor();
        if (iExecutor.preExecute()) {
            iExecutor.doExcecute();
        }
    }

    public static boolean hasProcessNotOfType(ProcessPackage processPackage, EClass eClass) {
        Object object;
        if (processPackage instanceof ProcessComponent && (object = ((ProcessComponent)processPackage).getProcess()) != null && !eClass.isInstance(object)) {
            return true;
        }
        for (Object e : processPackage.getChildPackages()) {
            Process process;
            if (!(e instanceof ProcessComponent ? (process = ((ProcessComponent)e).getProcess()) != null && !eClass.isInstance((Object)process) : e instanceof ProcessPackage && ProcessUtil.hasProcessNotOfType((ProcessPackage)e, eClass))) continue;
            return true;
        }
        return false;
    }

    public static Object findRoleDescriptor(TeamProfile teamProfile, RoleDescriptor roleDescriptor) {
        List list = teamProfile.getTeamRoles();
        for (Object e : list) {
            List list2;
            List list3;
            if (!(roleDescriptor instanceof CompositeRole ? e instanceof CompositeRole && (list3 = ((CompositeRole)roleDescriptor).getAggregatedRoles()).equals(list2 = ((CompositeRole)e).getAggregatedRoles()) : roleDescriptor instanceof RoleDescriptor && e instanceof RoleDescriptor && !(e instanceof CompositeRole) && ((Object)(list3 = roleDescriptor.getRole())).equals(list2 = ((RoleDescriptor)e).getRole()))) continue;
            return e;
        }
        return null;
    }

    public static Map toColumnIndexToNameMap(String string) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            hashMap.put(new Integer(n), ProcessUtil.getColumnID(string2));
            ++n;
        }
        return hashMap;
    }

    private static String getColumnID(String string) {
        int n = 0;
        while (n < IBSItemProvider.COLUMNS.length) {
            String string2 = IBSItemProvider.COLUMNS[n];
            if (string2.equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public static void removePredecessors(AdapterFactory adapterFactory, Process process, List list) {
        HashSet hashSet = new HashSet(list);
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator(adapterFactory, (Object)process);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object e = adapterFactoryTreeIterator.next();
            IBSItemProvider iBSItemProvider = (IBSItemProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
            if (iBSItemProvider == null || !(TngUtil.unwrap(e) instanceof WorkBreakdownElement)) continue;
            Iterator iterator = iBSItemProvider.getPredecessors().iterator();
            while (iterator.hasNext()) {
                Object object = TngUtil.unwrap(iterator.next());
                if (object instanceof ItemProviderAdapter) {
                    object = ((ItemProviderAdapter)object).getTarget();
                }
                if (!hashSet.contains(object)) continue;
                iterator.remove();
            }
        }
    }

    private static void addToActivity(Activity activity, BreakdownElement breakdownElement, Object[] objectArray) {
        int n;
        Object object = objectArray[1];
        boolean bl = false;
        if (object != null && (n = activity.getBreakdownElements().indexOf(object)) != -1) {
            activity.getBreakdownElements().add(n, breakdownElement);
            bl = true;
        }
        if (!bl) {
            Object object2 = objectArray[0];
            if (object2 != null) {
                int n2 = activity.getBreakdownElements().indexOf(object2);
                if (n2 != -1) {
                    activity.getBreakdownElements().add(n2 + 1, breakdownElement);
                } else {
                    activity.getBreakdownElements().add(breakdownElement);
                }
            } else {
                activity.getBreakdownElements().add(breakdownElement);
            }
        }
    }

    public static Activity contributeToActivity(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, List list) {
        Object object = breakdownElementWrapperItemProvider.getParent(null);
        Object[] objectArray = ProcessUtil.getPreviousAndNext(breakdownElementWrapperItemProvider);
        if (object instanceof BreakdownElementWrapperItemProvider) {
            object = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)object, list);
        }
        Activity activity = ProcessUtil.generialize(breakdownElementWrapperItemProvider, VariabilityType.LOCAL_CONTRIBUTION_LITERAL, objectArray);
        Activity activity2 = (Activity)object;
        ProcessUtil.addToActivity(activity2, (BreakdownElement)activity, objectArray);
        list.add(activity);
        return activity;
    }

    public static void replaceActivityLocally(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, List list) {
        Object object = breakdownElementWrapperItemProvider.getParent(null);
        Object[] objectArray = ProcessUtil.getPreviousAndNext(breakdownElementWrapperItemProvider);
        if (object instanceof BreakdownElementWrapperItemProvider) {
            object = ProcessUtil.contributeToActivity((BreakdownElementWrapperItemProvider)object, list);
        }
        Activity activity = ProcessUtil.generialize(breakdownElementWrapperItemProvider, VariabilityType.LOCAL_REPLACEMENT_LITERAL, objectArray);
        Activity activity2 = (Activity)object;
        ProcessUtil.addToActivity(activity2, (BreakdownElement)activity, objectArray);
        list.add(activity);
    }

    static Object[] getPreviousAndNext(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        Object object = breakdownElementWrapperItemProvider.getParent(null);
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(breakdownElementWrapperItemProvider.getAdapterFactory());
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        List list = (List)iTreeItemContentProvider.getChildren(object);
        int n = list.indexOf(breakdownElementWrapperItemProvider) + 1;
        Object var6_6 = null;
        if (n < list.size()) {
            var6_6 = list.get(n);
        }
        Object var7_7 = null;
        if ((n -= 2) > -1) {
            var7_7 = list.get(n);
        }
        Object[] objectArray = new Object[]{var7_7, var6_6};
        return objectArray;
    }

    static Activity generialize(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider, VariabilityType variabilityType, Object[] objectArray) {
        Object object;
        AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(breakdownElementWrapperItemProvider.getAdapterFactory());
        Activity activity = ProcessUtil.generalize((Activity)TngUtil.unwrap(breakdownElementWrapperItemProvider), variabilityType);
        Object object2 = objectArray[1];
        if (object2 != null) {
            activity.setPresentedAfter((BreakdownElement)TngUtil.unwrap(object2));
            if (object2 instanceof BreakdownElement) {
                ((BreakdownElement)object2).setPresentedBefore((BreakdownElement)activity);
            }
        }
        if ((object = objectArray[0]) != null) {
            activity.setPresentedBefore((BreakdownElement)TngUtil.unwrap(object));
            if (object instanceof BreakdownElement) {
                ((BreakdownElement)object).setPresentedAfter((BreakdownElement)activity);
            }
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        iBSItemProvider.setExpanded(breakdownElementWrapperItemProvider.isExpanded());
        return activity;
    }

    public static Process getImmediateBaseProcess(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        Activity activity = ProcessUtil.getInheritor(breakdownElementWrapperItemProvider);
        if (activity != null) {
            return TngUtil.getOwningProcess((BreakdownElement)activity.getVariabilityBasedOnElement());
        }
        return null;
    }

    public static Activity getInheritor(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        if (breakdownElementWrapperItemProvider.isReadOnly()) {
            Object object = breakdownElementWrapperItemProvider.getParent(breakdownElementWrapperItemProvider);
            while (object != null) {
                if (object instanceof BreakdownElementWrapperItemProvider) {
                    object = ((BreakdownElementWrapperItemProvider)object).getParent(object);
                    continue;
                }
                return (Activity)object;
            }
        }
        return null;
    }

    public static List getParentList(Object object, BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        return ProcessUtil.getParentList(breakdownElementWrapperItemProvider, object, breakdownElementWrapperItemProvider.getAdapterFactory());
    }

    public static LinkedList<String> getGuidList(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        LinkedList<String> linkedList = new LinkedList<String>();
        List list = ProcessUtil.getParentList(null, breakdownElementWrapperItemProvider);
        if (!list.isEmpty()) {
            for (MethodElement methodElement : list) {
                if (methodElement instanceof TaskDescriptor || methodElement instanceof RoleDescriptor) continue;
                linkedList.add(methodElement.getGuid());
            }
        }
        MethodElement methodElement = (MethodElement)TngUtil.unwrap(breakdownElementWrapperItemProvider);
        linkedList.add(methodElement.getGuid());
        return linkedList;
    }

    public static LinkedList<String> getGuidList(Activity activity, Activity activity2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Activity activity3 = activity2;
        while (activity3 != null && (activity == null || activity3 != activity)) {
            linkedList.addFirst(activity3.getGuid());
            activity3 = activity3.getSuperActivities();
        }
        return linkedList;
    }

    public static List<String> getGuidList(Object object) {
        if (object instanceof BreakdownElementWrapperItemProvider) {
            return ProcessUtil.getGuidList((BreakdownElementWrapperItemProvider)object);
        }
        if (object instanceof Activity) {
            return ProcessUtil.getGuidList(null, (Activity)object);
        }
        return null;
    }

    public static String toGuidPath(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            stringBuffer.append('/').append(string);
        }
        return stringBuffer.toString();
    }

    public static List getParentList(Object object, Object object2, AdapterFactory adapterFactory) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class);
        Object object3 = iTreeItemContentProvider.getParent(object);
        while (object3 != object2 && object3 != null) {
            ItemProviderAdapter itemProviderAdapter;
            MethodElement methodElement;
            Object object4 = TngUtil.unwrap(object3);
            if (object4 instanceof MethodElement) {
                methodElement = (MethodElement)object4;
                itemProviderAdapter = object3 instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object3 : (ITreeItemContentProvider)adapterFactory.adapt(object3, ITreeItemContentProvider.class);
                object3 = ProcessUtil.isTopProcess(methodElement) ? null : itemProviderAdapter.getParent(object3);
            } else {
                itemProviderAdapter = (ItemProviderAdapter)object4;
                methodElement = (MethodElement)itemProviderAdapter.getTarget();
                object3 = itemProviderAdapter.getParent(object3);
            }
            arrayList.add(0, methodElement);
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getWrappers(BreakdownElementWrapperItemProvider var0, AdapterFactory[] var1_1) {
        var2_2 = new ArrayList<Object>();
        try {
            var3_3 = TngUtil.getBestAdapterFactory(var0.getAdapterFactory());
            var4_4 = var0.getTopItem();
            var5_5 = new ArrayList<Object>(ProcessUtil.getParentList(var4_4, var0));
            var6_6 = new ArrayList<Object>();
            var7_7 = 0;
            while (var7_7 < var1_1.length) {
                var8_8 = var1_1[var7_7];
                if (var8_8 == var3_3) {
                    var6_6.add(var0);
                } else {
                    var9_9 = TngUtil.unwrap(var0);
                    var5_5.add(var9_9);
                    var10_10 = var4_4;
                    block4: for (E var12_12 : var5_5) {
                        var13_13 = (ITreeItemContentProvider)var8_8.adapt(var10_10, ITreeItemContentProvider.class);
                        var14_14 = TngUtil.unwrap(var10_10);
                        if (var14_14 instanceof Activity) {
                            if (var13_13 instanceof BSActivityItemProvider) {
                                var15_15 = (BSActivityItemProvider)var13_13;
                                if (var15_15.isRolledUp()) {
                                    var15_15.basicSetRolledUp(false);
                                    var2_2.add(var15_15);
                                }
                            } else if (var13_13 instanceof IBSItemProvider && (var15_15 = (IBSItemProvider)var13_13).isRolledUp()) {
                                var15_15.setRolledUp(false);
                                var2_2.add(var15_15);
                            }
                        }
                        var15_15 = var13_13.getChildren(var10_10).iterator();
                        while (var15_15.hasNext()) {
                            var16_16 = var15_15.next();
                            if (var12_12 != TngUtil.unwrap(var16_16)) continue;
                            var10_10 = var16_16;
                            continue block4;
                        }
                    }
                    if (var10_10 instanceof BreakdownElementWrapperItemProvider == false) throw new RuntimeException("Could not find wrapper for " + var9_9 + " using adapter factory " + var8_8);
                    var6_6.add(var10_10);
                }
                ++var7_7;
            }
            var18_17 = var6_6;
            return var18_17;
        }
        finally {
            if (var2_2.isEmpty() != false) return var18_17;
            var19_18 = var2_2.iterator();
            ** while (var19_18.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            ((BSActivityItemProvider)var19_18.next()).basicSetRolledUp(true);
            continue;
        }
lbl53:
        // 1 sources

        return var18_17;
    }

    public static void getWPDModelInfo(StringBuffer stringBuffer, Object object, Object object2) {
        Object object3 = TngUtil.unwrap(object);
        if (object3 instanceof WorkProductDescriptor) {
            WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)object3;
            if (object2 instanceof ITreeItemContentProvider) {
                AdapterFactory adapterFactory = null;
                if (object2 instanceof ItemProviderAdapter) {
                    adapterFactory = ((ItemProviderAdapter)object2).getAdapterFactory();
                } else if (object2 instanceof BreakdownElementWrapperItemProvider) {
                    adapterFactory = ((BreakdownElementWrapperItemProvider)object2).getAdapterFactory();
                }
                if (adapterFactory != null) {
                    Object object4 = null;
                    ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)object2;
                    Object object5 = iTreeItemContentProvider.getParent(object);
                    while (object5 != null) {
                        Object object6 = TngUtil.unwrap(object5);
                        if (object6 instanceof TaskDescriptor) {
                            object4 = object6;
                            break;
                        }
                        if (object6 instanceof Activity) break;
                        iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object5, ITreeItemContentProvider.class);
                        object5 = iTreeItemContentProvider.getParent(object5);
                    }
                    if (object4 != null) {
                        object5 = new ArrayList<EReference>();
                        if (AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)workProductDescriptor).contains(object4)) {
                            ((ArrayList)object5).add(UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
                        }
                        if (AssociationHelper.getOptionalInputTo((WorkProductDescriptor)workProductDescriptor).contains(object4)) {
                            ((ArrayList)object5).add(UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
                        }
                        if (AssociationHelper.getOutputFrom((WorkProductDescriptor)workProductDescriptor).contains(object4)) {
                            ((ArrayList)object5).add(UmaPackage.eINSTANCE.getTaskDescriptor_Output());
                        }
                        if (!((ArrayList)object5).isEmpty()) {
                            if (stringBuffer.toString().length() > 0) {
                                stringBuffer.append(",");
                            }
                            int n = 0;
                            while (n < ((ArrayList)object5).size()) {
                                EStructuralFeature eStructuralFeature = (EStructuralFeature)((ArrayList)object5).get(n);
                                stringBuffer.append(TngUtil.getFeatureText(eStructuralFeature));
                                if (n < ((ArrayList)object5).size() - 1) {
                                    stringBuffer.append(",");
                                }
                                ++n;
                            }
                        }
                        return;
                    }
                }
            }
            ProcessUtil.getModelInfoForWorkProductDescriptor(stringBuffer, workProductDescriptor);
        }
    }

    private static void getModelInfoForWorkProductDescriptor(StringBuffer stringBuffer, WorkProductDescriptor workProductDescriptor) {
        String string = ",";
        if (!AssociationHelper.getMandatoryInputTo((WorkProductDescriptor)workProductDescriptor).isEmpty()) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_mandatoryInput_feature"));
        }
        if (!AssociationHelper.getOptionalInputTo((WorkProductDescriptor)workProductDescriptor).isEmpty()) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_optionalInput_feature"));
        }
        if (!AssociationHelper.getOutputFrom((WorkProductDescriptor)workProductDescriptor).isEmpty()) {
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(UmaEditPlugin.INSTANCE.getString("_UI_TaskDescriptor_output_feature"));
        }
    }

    public static Collection getDuplicateDescriptorsAfterReveal(Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e : collection) {
            Descriptor descriptor;
            MethodElement methodElement;
            if (!(e instanceof Descriptor) || (methodElement = ProcessUtil.getAssociatedElement(descriptor = (Descriptor)e)) == null) continue;
            Activity activity = UmaUtil.getParentActivity((BreakdownElement)descriptor);
            MethodConfiguration methodConfiguration = TngUtil.getOwningProcess((BreakdownElement)activity).getDefaultContext();
            methodElement = (MethodElement)Providers.getConfigurationApplicator().resolve(methodElement, methodConfiguration);
            Object object = ProcessCommandUtil.getDescriptor((Object)methodElement, activity, methodConfiguration);
            if (object == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public static Collection<Descriptor> getDuplicateDescriptorsAfterSuppress(Collection collection) {
        ArrayList<Descriptor> arrayList = new ArrayList<Descriptor>();
        for (Object e : collection) {
            Descriptor descriptor;
            MethodElement methodElement;
            if (!(e instanceof Descriptor) || (methodElement = ProcessUtil.getAssociatedElement(descriptor = (Descriptor)e)) == null) continue;
            Activity activity = UmaUtil.getParentActivity((BreakdownElement)descriptor);
            for (BreakdownElement breakdownElement : activity.getBreakdownElements()) {
                MethodElement methodElement2;
                if (breakdownElement == descriptor || !(breakdownElement instanceof Descriptor) || !breakdownElement.getSuppressed().booleanValue() || (methodElement2 = ProcessUtil.getAssociatedElement((Descriptor)breakdownElement)) != methodElement) continue;
                arrayList.add((Descriptor)breakdownElement);
            }
        }
        return arrayList;
    }

    public static boolean isInherited(Object object) {
        return object instanceof DescribableElementWrapperItemProvider && ((DescribableElementWrapperItemProvider)object).isInherited();
    }

    public static boolean hasInherited(Activity activity) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    return ((Activity)object).getBreakdownElements().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            VariabilityType variabilityType;
            Activity activity2;
            VariabilityElement variabilityElement;
            Object e = abstractTreeIterator.next();
            if (!(e instanceof Activity) || (variabilityElement = (activity2 = (Activity)e).getVariabilityBasedOnElement()) == null || (variabilityType = activity2.getVariabilityType()) != VariabilityType.EXTENDS_LITERAL && variabilityType != VariabilityType.LOCAL_CONTRIBUTION_LITERAL) continue;
            return true;
        }
        return false;
    }

    public static boolean isContributed(Object object) {
        return object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isContributed();
    }

    public static void getAllSubTeams(TeamProfile teamProfile, List list) {
        list.add(teamProfile);
        List list2 = teamProfile.getSubTeam();
        for (TeamProfile teamProfile2 : list2) {
            ProcessUtil.getAllSubTeams(teamProfile2, list);
        }
    }

    private static List getTeamProfiles(Object object, ITreeItemContentProvider iTreeItemContentProvider, AdapterFactory adapterFactory) {
        Object object2;
        RoleDescriptor roleDescriptor = (RoleDescriptor)TngUtil.unwrap(object);
        ArrayList arrayList = new ArrayList(AssociationHelper.getTeamProfiles((RoleDescriptor)roleDescriptor));
        HashSet hashSet = new HashSet();
        Object object3 = iTreeItemContentProvider.getParent(object);
        while (object3 != null) {
            iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object3, ITreeItemContentProvider.class);
            object2 = iTreeItemContentProvider.getChildren(object3).iterator();
            while (object2.hasNext()) {
                Object object4 = TngUtil.unwrap(object2.next());
                if (!(object4 instanceof TeamProfile)) continue;
                ArrayList arrayList2 = new ArrayList();
                ProcessUtil.getAllSubTeams((TeamProfile)object4, arrayList2);
                for (Object e : arrayList2) {
                    if (!(e instanceof TeamProfile) || !((TeamProfile)e).getTeamRoles().contains(roleDescriptor)) continue;
                    hashSet.add(e);
                }
            }
            object2 = iTreeItemContentProvider.getParent(object3);
            if (object2 == null && object3 instanceof Activity) {
                object2 = UmaUtil.getParentActivity((BreakdownElement)((Activity)object3));
            }
            object3 = object2;
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            if (hashSet.contains(object2)) continue;
            object3.remove();
        }
        return arrayList;
    }

    public static List getTeamProfiles(RoleDescriptorWrapperItemProvider roleDescriptorWrapperItemProvider) {
        return ProcessUtil.getTeamProfiles(roleDescriptorWrapperItemProvider, (ITreeItemContentProvider)roleDescriptorWrapperItemProvider, roleDescriptorWrapperItemProvider.getAdapterFactory());
    }

    public static List getTeamProfiles(RoleDescriptor roleDescriptor, AdapterFactory adapterFactory) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)roleDescriptor, ITreeItemContentProvider.class);
        return ProcessUtil.getTeamProfiles(roleDescriptor, iTreeItemContentProvider, adapterFactory);
    }

    public static void getChildElements(Activity activity, Class clazz, Collection collection) {
        int n = activity.getBreakdownElements().size() - 1;
        while (n > -1) {
            Object e = activity.getBreakdownElements().get(n);
            if (clazz.isInstance(e)) {
                collection.add(e);
            }
            if (e instanceof Activity) {
                ProcessUtil.getChildElements((Activity)e, clazz, collection);
            }
            --n;
        }
    }

    public static IFilter getFilter(AdapterFactory adapterFactory) {
        AdapterFactory adapterFactory2 = TngUtil.getBestAdapterFactory(adapterFactory);
        if (adapterFactory2 instanceof ConfigurableComposedAdapterFactory) {
            return ((ConfigurableComposedAdapterFactory)adapterFactory2).getFilter();
        }
        return null;
    }

    public static List getContainedArtifacts(Artifact artifact, AdapterFactory adapterFactory) {
        MethodConfiguration methodConfiguration = null;
        IFilter iFilter = ProcessUtil.getFilter(adapterFactory);
        if (iFilter instanceof IConfigurator) {
            methodConfiguration = ((IConfigurator)iFilter).getMethodConfiguration();
        }
        if (methodConfiguration == null) {
            return artifact.getContainedArtifacts();
        }
        return (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)artifact, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), methodConfiguration);
    }

    public static List getContainedArtifactsDescriptors(WorkProductDescriptor workProductDescriptor, List list) {
        if (list.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Artifact artifact = (Artifact)workProductDescriptor.getWorkProduct();
        ArrayList<WorkProductDescriptor> arrayList = new ArrayList<WorkProductDescriptor>();
        int n = list.size() - 1;
        while (n > -1) {
            EObject eObject;
            WorkProductDescriptor workProductDescriptor2 = (WorkProductDescriptor)list.get(n);
            WorkProduct workProduct = workProductDescriptor2.getWorkProduct();
            if (workProduct != null && ((eObject = workProduct.eContainer()) == artifact || eObject instanceof Artifact && TngUtil.isContributorOf(artifact, (VariabilityElement)((Artifact)eObject)))) {
                arrayList.add(workProductDescriptor2);
            }
            --n;
        }
        return arrayList;
    }

    public static boolean isContainedBy(WorkProductDescriptor workProductDescriptor, WorkProductDescriptor workProductDescriptor2, List list) {
        return UmaUtil.isContainedBy((EObject)workProductDescriptor2.getWorkProduct(), (Object)workProductDescriptor.getWorkProduct());
    }

    public static List removeSubartifactsFromChildren(Collection collection, boolean bl) {
        Object object;
        Object object22;
        ArrayList<WorkProduct> arrayList = new ArrayList<WorkProduct>();
        for (Object object22 : collection) {
            WorkProduct workProduct;
            if (bl) {
                object22 = TngUtil.unwrap(object22);
            }
            if (!(object22 instanceof WorkProductDescriptor) || !((workProduct = ((WorkProductDescriptor)object22).getWorkProduct()) instanceof Artifact)) continue;
            arrayList.add(workProduct);
        }
        HashSet hashSet = new HashSet();
        object22 = null;
        boolean bl2 = false;
        while (!arrayList.isEmpty()) {
            if (!bl2) {
                object22 = (Artifact)arrayList.get(0);
                arrayList.remove(0);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                Artifact artifact = (Artifact)object.next();
                bl2 = false;
                if (UmaUtil.isContainedBy((EObject)artifact, object22)) {
                    object.remove();
                    continue;
                }
                if (!UmaUtil.isContainedBy(object22, (Object)artifact)) continue;
                object.remove();
                object22 = artifact;
                bl2 = true;
                break;
            }
            if (!bl2 || arrayList.isEmpty()) {
                hashSet.add(object22);
                continue;
            }
            if (!arrayList.isEmpty()) continue;
            hashSet.add(object22);
        }
        object = new ArrayList();
        for (Object e : collection) {
            Object object3 = bl ? TngUtil.unwrap(e) : e;
            boolean bl3 = false;
            if (object3 instanceof WorkProductDescriptor) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)object3;
                WorkProduct workProduct = workProductDescriptor.getWorkProduct();
                if (!(workProduct instanceof Artifact)) {
                    bl3 = true;
                } else if (hashSet.contains(workProduct)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (!bl3) continue;
            object.add(e);
        }
        return object;
    }

    public static List removeSubartifactsFromChildren(Collection collection, boolean bl, AdapterFactory adapterFactory) {
        Object object;
        WorkProduct workProduct;
        Object object22;
        ArrayList arrayList = new ArrayList();
        for (Object object22 : collection) {
            if (bl) {
                object22 = TngUtil.unwrap(object22);
            }
            if (!(object22 instanceof WorkProductDescriptor) || !((workProduct = ((WorkProductDescriptor)object22).getWorkProduct()) instanceof Artifact)) continue;
            arrayList.add(object22);
        }
        if (arrayList.isEmpty()) {
            if (collection instanceof List) {
                return (List)collection;
            }
            return new ArrayList(collection);
        }
        HashSet hashSet = new HashSet();
        object22 = new ArrayList(arrayList);
        workProduct = null;
        boolean bl2 = false;
        while (!arrayList.isEmpty()) {
            if (!bl2) {
                workProduct = (WorkProductDescriptor)arrayList.get(0);
                arrayList.remove(0);
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)object.next();
                bl2 = false;
                if (ProcessUtil.isContainedBy((WorkProductDescriptor)workProduct, workProductDescriptor, object22)) {
                    object.remove();
                    continue;
                }
                if (!ProcessUtil.isContainedBy(workProductDescriptor, (WorkProductDescriptor)workProduct, object22)) continue;
                object.remove();
                workProduct = workProductDescriptor;
                bl2 = true;
                break;
            }
            if (!bl2 || arrayList.isEmpty()) {
                hashSet.add(workProduct);
                continue;
            }
            if (!arrayList.isEmpty()) continue;
            hashSet.add(workProduct);
        }
        object = new ArrayList();
        for (Object e : collection) {
            Object object3 = bl ? TngUtil.unwrap(e) : e;
            boolean bl3 = false;
            if (object3 instanceof WorkProductDescriptor) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)object3;
                WorkProduct workProduct2 = workProductDescriptor.getWorkProduct();
                if (!(workProduct2 instanceof Artifact)) {
                    bl3 = true;
                } else if (hashSet.contains(workProductDescriptor)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (!bl3) continue;
            object.add(e);
        }
        return object;
    }

    public static Activity findActivity(ProcessPackage processPackage) {
        if (processPackage instanceof ProcessComponent) {
            return ((ProcessComponent)processPackage).getProcess();
        }
        for (Object e : processPackage.getProcessElements()) {
            if (!(e instanceof Activity)) continue;
            return (Activity)e;
        }
        return null;
    }

    public static void fixBreakdonwElementOrderRecursively(Activity activity) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 3368261685663354478L;

            protected Iterator getChildren(Object object) {
                ArrayList arrayList = new ArrayList();
                for (Object e : ((Activity)object).getBreakdownElements()) {
                    if (!(e instanceof Activity)) continue;
                    arrayList.add(e);
                }
                return arrayList.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            ProcessUtil.fixBreakdownElementOrder((Activity)abstractTreeIterator.next());
        }
    }

    public static void fixBreakdownElementOrder(Activity activity) {
        EList eList = (EList)activity.getBreakdownElements();
        for (BreakdownElement breakdownElement : new ArrayList(eList)) {
            int n;
            BreakdownElement breakdownElement2 = breakdownElement.getPresentedAfter();
            if (breakdownElement2 == null || breakdownElement2 == breakdownElement || (n = eList.indexOf((Object)breakdownElement2)) == -1) continue;
            int n2 = eList.indexOf((Object)breakdownElement);
            if (n2 != n - 1) {
                if (n2 < n) {
                    eList.move(n - 1, n2);
                } else {
                    eList.move(n2, n);
                }
            }
            breakdownElement.setPresentedAfter(null);
        }
    }

    public static void initializeItemProviderPath(Activity activity, AdapterFactory adapterFactory) {
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)activity, ITreeItemContentProvider.class);
        IBSItemProvider iBSItemProvider = (IBSItemProvider)iTreeItemContentProvider;
        Object object = iBSItemProvider.getTopItem();
        if (!(object instanceof Process) || !(((EObject)object).eContainer() instanceof ProcessComponent)) {
            ArrayList<Activity> arrayList = new ArrayList<Activity>();
            activity = activity.getSuperActivities();
            while (activity != null) {
                arrayList.add(0, activity);
                activity = activity.getSuperActivities();
            }
            for (Object e : arrayList) {
                iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(e, ITreeItemContentProvider.class);
                iTreeItemContentProvider.getChildren(e);
            }
        }
    }

    public static boolean hasContributorOrReplacer(Activity activity) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    ArrayList arrayList = new ArrayList();
                    for (Object e : ((Activity)object).getBreakdownElements()) {
                        if (!(e instanceof VariabilityElement)) continue;
                        arrayList.add(e);
                    }
                    return arrayList.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            VariabilityElement variabilityElement = (VariabilityElement)abstractTreeIterator.next();
            VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
            VariabilityType variabilityType = variabilityElement.getVariabilityType();
            if (variabilityElement2 == null || variabilityType != VariabilityType.CONTRIBUTES_LITERAL && variabilityType != VariabilityType.REPLACES_LITERAL) continue;
            return true;
        }
        return false;
    }

    public static boolean isTopProcess(Object object) {
        return object instanceof Process && ((Process)object).eContainer() instanceof ProcessComponent;
    }

    public static WorkProductDescriptor getWorkProductDescriptor(Collection collection, WorkProduct workProduct) {
        for (Object e : collection) {
            WorkProductDescriptor workProductDescriptor;
            if (!(e instanceof WorkProductDescriptor) || (workProductDescriptor = (WorkProductDescriptor)e).getWorkProduct() != workProduct) continue;
            return workProductDescriptor;
        }
        return null;
    }

    public static TaskDescriptor getTaskDescriptor(Collection collection, Task task) {
        for (Object e : collection) {
            TaskDescriptor taskDescriptor;
            if (!(e instanceof TaskDescriptor) || (taskDescriptor = (TaskDescriptor)e).getTask() != task) continue;
            return taskDescriptor;
        }
        return null;
    }

    public static WorkBreakdownElement getOwner(WorkOrder workOrder) {
        return AssociationHelper.getSuccessor((WorkOrder)workOrder);
    }

    public static ComposedBreakdownElementWrapperItemProvider getComposedWrapper(Object object) {
        while (!(object instanceof ComposedBreakdownElementWrapperItemProvider) && object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getValue();
        }
        if (object instanceof ComposedBreakdownElementWrapperItemProvider) {
            return (ComposedBreakdownElementWrapperItemProvider)object;
        }
        return null;
    }

    public static final String getColumnDisplayName(String string) {
        try {
            return LibraryEditPlugin.INSTANCE.getString("BS_Column_" + string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static List getTaskDescriptors(List list) {
        ArrayList arrayList = new ArrayList();
        ExposedAdapterFactory exposedAdapterFactory = (ExposedAdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        for (Object e : list) {
            if (e instanceof Activity || e instanceof ActivityWrapperItemProvider) {
                ProcessUtil.getTaskDescriptors((AdapterFactory)exposedAdapterFactory, e, arrayList);
            }
            if (!(e instanceof TaskDescriptor) && !(e instanceof TaskDescriptorWrapperItemProvider) || arrayList.contains(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private static void getTaskDescriptors(AdapterFactory adapterFactory, Object object, List list) {
        Object object2;
        Collection collection = null;
        if (object instanceof Activity) {
            object2 = (ItemProviderAdapter)adapterFactory.adapt(object, ITreeItemContentProvider.class);
            collection = object2.getChildren(object);
        } else if (object instanceof ActivityWrapperItemProvider) {
            collection = ((WrapperItemProvider)object).getChildren(object);
        }
        if (collection != null && collection instanceof List) {
            object2 = (List)collection;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Activity || e instanceof ActivityWrapperItemProvider) {
                    ProcessUtil.getTaskDescriptors(adapterFactory, e, list);
                }
                if (!(e instanceof TaskDescriptor) && !(e instanceof TaskDescriptorWrapperItemProvider) || list.contains(e)) continue;
                list.add(e);
            }
        }
    }

    public static boolean isRolledUpDescriptor(Object object, AdapterFactory adapterFactory) {
        ITreeItemContentProvider iTreeItemContentProvider;
        Object object2;
        if (TngUtil.unwrap(object) instanceof Descriptor && TngUtil.unwrap(object2 = (iTreeItemContentProvider = (ITreeItemContentProvider)adapterFactory.adapt(object, ITreeItemContentProvider.class)).getParent(object)) instanceof Activity) {
            Object object3 = adapterFactory.adapt(object2, ITreeItemContentProvider.class);
            return object3 instanceof IBSItemProvider && ((IBSItemProvider)object3).isRolledUp();
        }
        return false;
    }

    public static Process deepCopy(IProgressMonitor iProgressMonitor, Process process, String string, MethodConfiguration methodConfiguration, ProcessPackage processPackage) {
        CopyHelper copyHelper = new CopyHelper();
        try {
            Process process2 = ProcessUtil.deepCopy(iProgressMonitor, process, string, methodConfiguration, processPackage, copyHelper);
            return process2;
        }
        finally {
            copyHelper.clear();
        }
    }

    public static Process deepCopy(IProgressMonitor iProgressMonitor, Process process, String string, MethodConfiguration methodConfiguration, ProcessPackage processPackage, CopyHelper copyHelper) {
        if (processPackage == null) {
            processPackage = (ProcessPackage)process.eContainer().eContainer();
        }
        Process process2 = null;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        ProcessDeepCopyCommand processDeepCopyCommand = new ProcessDeepCopyCommand(process, string, copyHelper, methodConfiguration, processPackage, iProgressMonitor);
        try {
            processDeepCopyCommand.execute();
            Collection<?> collection = processDeepCopyCommand.getResult();
            if (!collection.isEmpty()) {
                process2 = (Process)collection.toArray()[0];
                ProcessUtil.fixBreakdonwElementOrderRecursively((Activity)process2);
                processDeepCopyCommand.copySuppressionStates();
            }
        }
        finally {
            processDeepCopyCommand.dispose();
        }
        return process2;
    }

    public static boolean accept(Activity activity, IFilter iFilter, boolean bl) {
        if (iFilter == null) {
            return true;
        }
        Activity activity2 = (Activity)activity.getVariabilityBasedOnElement();
        VariabilityType variabilityType = activity.getVariabilityType();
        if (activity2 == null) {
            if (bl) {
                return iFilter.accept(TngUtil.getOwningProcess((BreakdownElement)activity));
            }
            return true;
        }
        if (variabilityType == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL || variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL) {
            boolean bl2;
            do {
                bl2 = iFilter.accept(TngUtil.getOwningProcess((BreakdownElement)activity2));
                variabilityType = activity2.getVariabilityType();
                activity2 = (Activity)activity2.getVariabilityBasedOnElement();
            } while (bl2 && activity2 != null && (variabilityType == VariabilityType.EXTENDS_LITERAL || variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL || variabilityType == VariabilityType.LOCAL_REPLACEMENT_LITERAL));
            return bl2;
        }
        return true;
    }
}

