/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.epf.common.utils.ProfilingUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IDependencyInfo;
import org.eclipse.epf.library.edit.validation.Tracer;
import org.eclipse.epf.library.edit.validation.UpwardReachableInfo;
import org.eclipse.epf.library.edit.validation.ValidationStatus;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;

public class DependencyInfoMgr {
    private static boolean profiling = false;
    private static boolean debug = false;
    private MethodLibrary lib;
    private Map reachableInfoMap;
    private Map replacerMap;
    private Map processed;
    private MethodElement filterElement;
    private MethodElement moveElement;
    private List circularList;
    private boolean dndBit = false;

    public DependencyInfoMgr(MethodLibrary methodLibrary) {
        this.lib = methodLibrary;
    }

    public void logCircularDependency(Stack stack) {
        if (this.circularList == null) {
            this.circularList = new ArrayList();
        }
        this.circularList.addAll(stack);
    }

    private List getAndClearCircularList() {
        List list = this.circularList;
        this.circularList = null;
        return list;
    }

    public boolean isFilterElement(MethodElement methodElement) {
        return this.filterElement == methodElement;
    }

    public boolean isMoveElement(MethodElement methodElement) {
        return this.moveElement == methodElement;
    }

    private void log(String string) {
        LibraryEditPlugin.INSTANCE.log(string);
    }

    public IStatus checkCircularDependnecy(VariabilityElement variabilityElement) {
        if (debug) {
            System.out.println("LD> ve: " + TngUtil.getLabelWithPath(variabilityElement));
        }
        IDependencyInfo iDependencyInfo = this.registerVariabilityElement(variabilityElement, false, false, true);
        List list = this.getAndClearCircularList();
        boolean bl = list != null && !list.isEmpty();
        boolean bl2 = iDependencyInfo.inheritAncestor(VariabilityType.REPLACES_LITERAL);
        boolean bl3 = this.getActInerentingAncestor(variabilityElement);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.epf.library.edit", 0, "", null);
        if (bl) {
            this.log("Error> Circular dependency detected: ");
            int n = 0;
            while (n < list.size()) {
                IDependencyInfo iDependencyInfo2 = (IDependencyInfo)list.get(n);
                MethodElement methodElement = iDependencyInfo2.getElement();
                this.log("Error> " + n + ": " + TngUtil.getLabelWithPath(methodElement));
                ++n;
            }
            multiStatus.add((IStatus)new ValidationStatus(4, 0, this.genErrorMsg(list), variabilityElement, null));
        }
        if (bl2) {
            MethodElement methodElement = iDependencyInfo.getElement();
            this.log("Error> " + TngUtil.getLabelWithPath(methodElement) + " is replacing an ancestor.");
            multiStatus.add((IStatus)new ValidationStatus(4, 0, LibraryEditResources.replacing_ancestor_error_msg, variabilityElement, null));
        }
        if (bl3) {
            iDependencyInfo.getElement();
            multiStatus.add((IStatus)new ValidationStatus(4, 0, LibraryEditResources.circular_dependency_error_msg, variabilityElement, null));
        }
        return multiStatus;
    }

    private boolean getActInerentingAncestor(VariabilityElement variabilityElement) {
        Activity activity;
        if (variabilityElement instanceof Activity && (activity = (Activity)variabilityElement.getVariabilityBasedOnElement()) != null) {
            Activity activity2 = ((Activity)variabilityElement).getSuperActivities();
            while (activity2 != null) {
                if (activity2 == activity) {
                    return true;
                }
                activity2 = activity2.getSuperActivities();
            }
        }
        return false;
    }

    private String genErrorMsg(List list) {
        String string = LibraryEditResources.variability_element_circular_loop_error_msg;
        int n = 0;
        while (n < list.size()) {
            IDependencyInfo iDependencyInfo = (IDependencyInfo)list.get(n);
            MethodElement methodElement = iDependencyInfo.getElement();
            if (n > 0) {
                string = String.valueOf(string) + ": ";
            }
            string = String.valueOf(string) + TngUtil.getLabelWithPath(methodElement);
            ++n;
        }
        return string;
    }

    public IDependencyInfo registerVariabilityElement(VariabilityElement variabilityElement, boolean bl, boolean bl2) {
        return this.registerVariabilityElement(variabilityElement, bl, bl2, false);
    }

    private IDependencyInfo registerVariabilityElement(VariabilityElement variabilityElement, boolean bl, boolean bl2, boolean bl3) {
        IDependencyInfo iDependencyInfo;
        if (bl) {
            this.filterElement = variabilityElement;
        }
        if (bl2) {
            this.moveElement = variabilityElement;
        }
        if ((iDependencyInfo = this.getProcessedInfo((MethodElement)variabilityElement)) == null) {
            iDependencyInfo = this.newDependencyInfo(this, (MethodElement)variabilityElement);
        }
        if (!iDependencyInfo.isComplete()) {
            iDependencyInfo.build(bl3);
        }
        return iDependencyInfo;
    }

    protected boolean processed(MethodElement methodElement) {
        return this.processed != null && this.processed.containsKey(methodElement.getGuid());
    }

    protected IDependencyInfo getProcessedInfo(MethodElement methodElement) {
        return this.processed == null ? null : (IDependencyInfo)this.processed.get(methodElement.getGuid());
    }

    protected void addToProcessed(IDependencyInfo iDependencyInfo) {
        if (this.processed == null) {
            this.processed = new HashMap();
        }
        this.processed.put(iDependencyInfo.getElement().getGuid(), iDependencyInfo);
    }

    protected void addToReplacerMap(IDependencyInfo iDependencyInfo) {
        if (this.replacerMap == null) {
            this.replacerMap = new HashMap();
        }
        this.replacerMap.put(iDependencyInfo.getElement().getGuid(), iDependencyInfo);
    }

    private IDependencyInfo addToReachableInfoMap(MethodElement methodElement) {
        IDependencyInfo iDependencyInfo;
        if (this.reachableInfoMap == null) {
            this.reachableInfoMap = new HashMap();
        }
        if ((iDependencyInfo = (IDependencyInfo)this.reachableInfoMap.get(methodElement.getGuid())) == null) {
            iDependencyInfo = this.newDependencyInfo(this, methodElement);
            this.reachableInfoMap.put(methodElement.getGuid(), iDependencyInfo);
        }
        return iDependencyInfo;
    }

    public boolean hasCircularDependency() {
        this.buildReachableInfoMap();
        boolean bl = false;
        if (this.replacerMap != null) {
            for (Object object : this.replacerMap.values()) {
                if (!((UpwardReachableInfo)object).inheritAncestor(VariabilityType.REPLACES_LITERAL)) continue;
                bl = true;
            }
        }
        if (debug && this.circularList != null) {
            System.out.println("LD> Circular loops detected: ");
            for (Object object : this.circularList) {
                int n = 0;
                while (n < ((Vector)object).size()) {
                    System.out.println("LD> " + n + ": " + ((Vector)object).get(n));
                    ++n;
                }
            }
        }
        return bl || this.numCircularDependency() > 0;
    }

    private int numCircularDependency() {
        return this.circularList == null ? 0 : this.circularList.size();
    }

    protected IDependencyInfo newDependencyInfo(DependencyInfoMgr dependencyInfoMgr, MethodElement methodElement) {
        return new UpwardReachableInfo(this, methodElement);
    }

    private void buildReachableInfoMap() {
        long l = 0L;
        Runtime runtime = Runtime.getRuntime();
        if (profiling) {
            TreeIterator treeIterator = this.lib.eAllContents();
            while (treeIterator.hasNext()) {
                treeIterator.next();
            }
            ProfilingUtil.fullGC();
            l = runtime.totalMemory() - runtime.freeMemory();
        }
        this.buildReachableInfoMap_();
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + l / 1000L + " k bytes");
            long l2 = runtime.totalMemory() - runtime.freeMemory();
            System.out.println("LD> usedMem1: " + l2 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (l2 - l) / 1000L + " k bytes");
        }
    }

    private void buildReachableInfoMap_() {
        this.reachableInfoMap = new HashMap();
        List list = this.lib.getMethodPlugins();
        int n = 0;
        while (n < list.size()) {
            Object object = (MethodPlugin)list.get(n);
            TreeIterator treeIterator = object.eAllContents();
            while (treeIterator.hasNext()) {
                Object e = treeIterator.next();
                if (!DependencyInfoMgr.VeToCheck(e)) continue;
                this.addToReachableInfoMap((MethodElement)e);
            }
            ++n;
        }
        for (Object object : this.reachableInfoMap.values()) {
            if (this.processed(object.getElement())) continue;
            object.build(true);
        }
    }

    public static boolean VeToCheck(Object object) {
        return object instanceof Domain || object instanceof CustomCategory || object instanceof Artifact || object instanceof Practice || object instanceof Deliverable || object instanceof Activity;
    }

    public CheckResult checkCircularDependnecy(Tracer tracer) {
        Object object;
        long l = 0L;
        Runtime runtime = Runtime.getRuntime();
        if (profiling) {
            object = this.lib.eAllContents();
            while (object.hasNext()) {
                object.next();
            }
            ProfilingUtil.fullGC();
            l = runtime.totalMemory() - runtime.freeMemory();
        }
        object = this.checkCircularDependnecy_(tracer);
        if (profiling) {
            ProfilingUtil.fullGC();
            System.out.println("LD> usedMem0: " + l / 1000L + " k bytes");
            long l2 = runtime.totalMemory() - runtime.freeMemory();
            System.out.println("LD> usedMem1: " + l2 / 1000L + " k bytes");
            System.out.println("LD> diffMem: " + (l2 - l) / 1000L + " k bytes");
        }
        return object;
    }

    private CheckResult checkCircularDependnecy_(Tracer tracer) {
        CheckResult checkResult = new CheckResult();
        HashSet hashSet = new HashSet();
        List list = this.lib.getMethodPlugins();
        for (MethodPlugin methodPlugin : list) {
            TreeIterator treeIterator = methodPlugin.eAllContents();
            while (treeIterator.hasNext()) {
                Object e = treeIterator.next();
                if (hashSet.contains(e)) continue;
                hashSet.add(e);
                if (!DependencyInfoMgr.VeToCheck(e)) continue;
                IDependencyInfo iDependencyInfo = this.registerVariabilityElement((VariabilityElement)e, false, false, true);
                List list2 = this.getAndClearCircularList();
                boolean bl = list2 != null && !list2.isEmpty();
                boolean bl2 = iDependencyInfo.inheritAncestor(VariabilityType.REPLACES_LITERAL);
                if (bl) {
                    tracer.trace("Error> Circular dependency detected: ");
                    int n = 0;
                    while (n < list2.size()) {
                        IDependencyInfo iDependencyInfo2 = (IDependencyInfo)list2.get(n);
                        MethodElement methodElement = iDependencyInfo2.getElement();
                        tracer.trace("Error> " + n + ": " + TngUtil.getLabelWithPath(methodElement));
                        ++n;
                    }
                    checkResult.circularList.add(list2);
                }
                if (!bl2) continue;
                MethodElement methodElement = iDependencyInfo.getElement();
                tracer.trace("Error> " + TngUtil.getLabelWithPath(methodElement) + " is replacing an ancestor.");
                checkResult.replacingAncestorList.add(iDependencyInfo);
            }
        }
        return checkResult;
    }

    protected boolean isDndElement(MethodElement methodElement) {
        return this.dndBit && this.moveElement == methodElement;
    }

    protected void setDndBit(boolean bl) {
        this.dndBit = bl;
    }

    public static class CheckResult {
        public List circularList = new ArrayList();
        public List replacingAncestorList = new ArrayList();

        public int getErrorCount() {
            return this.circularList.size() + this.replacingAncestorList.size();
        }

        public int getCircularElementCount() {
            int n = this.replacingAncestorList.size();
            int n2 = 0;
            while (n2 < this.circularList.size()) {
                List list = (List)this.circularList.get(n2);
                int n3 = list == null ? 0 : list.size();
                n += n3;
                ++n2;
            }
            return n;
        }
    }
}

