/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.edit.policies;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.GroupRequestViaKeyboard;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DiagramReferenceConnectionEditPolicy
extends ConnectionEditPolicy {
    private static final String DELETE_FROM_DIAGRAM_DLG_TITLE = DiagramUIMessages.PromptingDeleteAction_DeleteFromDiagramDialog_Title;
    private static final String DELETE_FROM_DIAGRAM_DLG_MESSAGE = DiagramUIMessages.PromptingDeleteAction_DeleteFromDiagramDialog_Message;
    private static final String DELETE_FROM_MODEL_DLG_TOGGLE_LABEL = DiagramUIMessages.MessageDialogWithToggle_DoNotPromptAgainToggle_label;

    protected final Command getDeleteCommand(GroupRequest groupRequest) {
        GroupRequestViaKeyboard groupRequestViaKeyboard;
        boolean bl = groupRequest instanceof GroupRequestViaKeyboard;
        if (this.shouldDeleteSemantic()) {
            return this.createDeleteSemanticCommand(groupRequest);
        }
        boolean bl2 = true;
        if (bl && (groupRequestViaKeyboard = (GroupRequestViaKeyboard)groupRequest).isShowInformationDialog()) {
            bl2 = this.showPrompt();
            groupRequestViaKeyboard.setShowInformationDialog(false);
            if (!bl2) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return this.createDeleteViewCommand(groupRequest);
    }

    protected boolean shouldDeleteSemantic() {
        Assert.isTrue((boolean)(this.getHost() instanceof AbstractConnectionEditPart));
        AbstractConnectionEditPart abstractConnectionEditPart = (AbstractConnectionEditPart)this.getHost();
        boolean bl = false;
        if (abstractConnectionEditPart.getSource() != null) {
            bl = this.IsCanonical(abstractConnectionEditPart.getSource());
        }
        if (abstractConnectionEditPart.getTarget() != null) {
            return bl ? bl : this.IsCanonical(abstractConnectionEditPart.getTarget());
        }
        return bl;
    }

    private boolean IsCanonical(EditPart editPart) {
        EditPart editPart2 = editPart.getParent();
        return editPart2 instanceof GraphicalEditPart ? ((GraphicalEditPart)editPart2).isCanonical() : false;
    }

    protected Command createDeleteViewCommand(GroupRequest groupRequest) {
        TransactionalEditingDomain transactionalEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        return new ICommandProxy((ICommand)new DeleteCommand(transactionalEditingDomain, (View)this.getHost().getModel()));
    }

    protected Command createDeleteSemanticCommand(GroupRequest groupRequest) {
        TransactionalEditingDomain transactionalEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        EditCommandRequestWrapper editCommandRequestWrapper = new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(transactionalEditingDomain, false), groupRequest.getExtendedData());
        Command command = this.getHost().getCommand((Request)editCommandRequestWrapper);
        if (command != null && command.canExecute()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            compoundCommand.add(command);
            return compoundCommand;
        }
        return null;
    }

    private boolean showPrompt() {
        boolean bl = ((IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore()).getBoolean("Global.promptOnDelFromDiagram");
        if (bl) {
            return this.showMessageDialog();
        }
        return true;
    }

    private boolean showMessageDialog() {
        MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.openYesNoQuestion((Shell)Display.getCurrent().getActiveShell(), (String)DELETE_FROM_DIAGRAM_DLG_TITLE, (String)DELETE_FROM_DIAGRAM_DLG_MESSAGE, (String)DELETE_FROM_MODEL_DLG_TOGGLE_LABEL, (boolean)false, (IPreferenceStore)((IPreferenceStore)((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint().getPreferenceStore()), (String)"Global.promptOnDelFromDiagram");
        return messageDialogWithToggle.getReturnCode() == 2;
    }

    public Command getCommand(Request request) {
        if (request instanceof GroupRequestViaKeyboard) {
            return this.getDeleteCommand((GroupRequest)request);
        }
        return super.getCommand(request);
    }
}

