/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.ad.edit.parts.InitialNodeNameEditPart;
import org.eclipse.epf.diagram.ad.edit.policies.InitialNodeItemSemanticEditPolicy;
import org.eclipse.epf.diagram.ad.part.UMLVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class InitialNodeEditPart
extends AbstractBorderedShapeEditPart {
    public static final int VISUAL_ID = 1004;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    public static final Color INITIALNODEFIGURE_BACK = new Color(null, 45, 85, 130);

    public InitialNodeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new InitialNodeItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy layoutEditPolicy = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart editPart) {
                if (editPart instanceof IBorderItemEditPart) {
                    return new BorderItemSelectionEditPolicy();
                }
                EditPolicy editPolicy = editPart.getEditPolicy((Object)"PrimaryDrag Policy");
                if (editPolicy == null) {
                    editPolicy = new NonResizableEditPolicy();
                }
                return editPolicy;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest createRequest) {
                return null;
            }
        };
        return layoutEditPolicy;
    }

    protected IFigure createNodeShape() {
        InitialNodeFigure initialNodeFigure = new InitialNodeFigure();
        this.primaryShape = initialNodeFigure;
        return this.primaryShape;
    }

    public InitialNodeFigure getPrimaryShape() {
        return (InitialNodeFigure)this.primaryShape;
    }

    protected void addBorderItem(IFigure iFigure, IBorderItemEditPart iBorderItemEditPart) {
        if (iBorderItemEditPart instanceof InitialNodeNameEditPart) {
            BorderItemLocator borderItemLocator = new BorderItemLocator(this.getMainFigure(), 4);
            borderItemLocator.setBorderItemOffset(new Dimension(-20, -20));
            iFigure.add(iBorderItemEditPart.getFigure(), (Object)borderItemLocator);
        } else {
            super.addBorderItem(iFigure, iBorderItemEditPart);
        }
    }

    protected NodeFigure createNodePlate() {
        return new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(20), this.getMapMode().DPtoLP(20));
    }

    protected NodeFigure createMainFigure() {
        NodeFigure nodeFigure = this.createNodePlate();
        nodeFigure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure iFigure = this.createNodeShape();
        nodeFigure.add(iFigure);
        this.contentPane = this.setupContentPane(iFigure);
        return nodeFigure;
    }

    protected IFigure setupContentPane(IFigure iFigure) {
        if (iFigure.getLayoutManager() == null) {
            ConstrainedToolbarLayout constrainedToolbarLayout = new ConstrainedToolbarLayout();
            constrainedToolbarLayout.setSpacing(this.getMapMode().DPtoLP(5));
            iFigure.setLayoutManager((LayoutManager)constrainedToolbarLayout);
        }
        return iFigure;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(4003));
    }

    protected void handleNotificationEvent(Notification notification) {
        Object object = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(object) || NotationPackage.eINSTANCE.getSize_Height().equals(object) || NotationPackage.eINSTANCE.getLocation_X().equals(object) || NotationPackage.eINSTANCE.getLocation_Y().equals(object)) {
            this.refreshBounds();
        } else if (NotationPackage.eINSTANCE.getFillStyle_FillColor().equals(object)) {
            Integer n = (Integer)notification.getNewValue();
            this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(n));
            this.getPrimaryShape().setBackgroundColor(DiagramColorRegistry.getInstance().getColor(n));
        } else if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(object)) {
            Integer n = (Integer)notification.getNewValue();
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(n));
            this.getPrimaryShape().setForegroundColor(DiagramColorRegistry.getInstance().getColor(n));
        } else if (NotationPackage.eINSTANCE.getFontStyle().isInstance(notification.getNotifier())) {
            this.refreshFont();
        } else if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Element() && (EObject)notification.getNotifier() == this.getNotationView()) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    public class InitialNodeFigure
    extends Ellipse {
        private boolean myUseLocalCoordinates = false;

        public InitialNodeFigure() {
            LineStyle lineStyle = (LineStyle)InitialNodeEditPart.this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
            if (lineStyle != null && lineStyle.getLineColor() != 0xB0B0B0) {
                this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(lineStyle.getLineColor())));
            } else {
                this.setForegroundColor(ColorConstants.darkBlue);
            }
            FillStyle fillStyle = (FillStyle)InitialNodeEditPart.this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
            if (fillStyle != null && fillStyle.getFillColor() != 0xFFFFFF) {
                this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(fillStyle.getFillColor())));
            } else {
                this.setBackgroundColor(INITIALNODEFIGURE_BACK);
            }
            this.setPreferredSize(InitialNodeEditPart.this.getMapMode().DPtoLP(20), InitialNodeEditPart.this.getMapMode().DPtoLP(20));
            this.setSize(InitialNodeEditPart.this.getMapMode().DPtoLP(20), InitialNodeEditPart.this.getMapMode().DPtoLP(20));
            this.createContents();
        }

        private void createContents() {
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean bl) {
            this.myUseLocalCoordinates = bl;
        }
    }
}

