/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.policies;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;

public class UMLTextSelectionEditPolicy
extends SelectionEditPolicy {
    private IFigure selectionFeedbackFigure;
    private IFigure focusFeedbackFigure;

    protected void showPrimarySelection() {
        if (this.getHostFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getHostFigure()).setSelected(true);
            ((WrapLabel)this.getHostFigure()).setFocus(true);
        } else {
            this.showSelection();
            this.showFocus();
        }
    }

    protected void showSelection() {
        if (this.getHostFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getHostFigure()).setSelected(true);
            ((WrapLabel)this.getHostFigure()).setFocus(false);
        } else {
            this.hideSelection();
            this.selectionFeedbackFigure = this.createSelectionFeedbackFigure();
            this.addFeedback(this.selectionFeedbackFigure);
            this.refreshSelectionFeedback();
            this.hideFocus();
        }
    }

    protected void hideSelection() {
        if (this.getHostFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getHostFigure()).setSelected(false);
            ((WrapLabel)this.getHostFigure()).setFocus(false);
        } else {
            if (this.selectionFeedbackFigure != null) {
                this.removeFeedback(this.selectionFeedbackFigure);
                this.selectionFeedbackFigure = null;
            }
            this.hideFocus();
        }
    }

    protected void showFocus() {
        if (this.getHostFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getHostFigure()).setFocus(true);
        } else {
            this.hideFocus();
            this.focusFeedbackFigure = this.createFocusFeedbackFigure();
            this.addFeedback(this.focusFeedbackFigure);
            this.refreshFocusFeedback();
        }
    }

    protected void hideFocus() {
        if (this.getHostFigure() instanceof WrapLabel) {
            ((WrapLabel)this.getHostFigure()).setFocus(false);
        } else if (this.focusFeedbackFigure != null) {
            this.removeFeedback(this.focusFeedbackFigure);
            this.focusFeedbackFigure = null;
        }
    }

    protected Rectangle getFeedbackBounds() {
        Rectangle rectangle;
        if (this.getHostFigure() instanceof Label) {
            rectangle = ((Label)this.getHostFigure()).getTextBounds();
            rectangle.intersect(this.getHostFigure().getBounds());
        } else {
            rectangle = this.getHostFigure().getBounds().getCopy();
        }
        this.getHostFigure().getParent().translateToAbsolute((Translatable)rectangle);
        this.getFeedbackLayer().translateToRelative((Translatable)rectangle);
        return rectangle;
    }

    protected IFigure createSelectionFeedbackFigure() {
        if (this.getHostFigure() instanceof Label) {
            Label label = new Label();
            label.setOpaque(true);
            label.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            label.setForegroundColor(ColorConstants.menuForegroundSelected);
            return label;
        }
        RectangleFigure rectangleFigure = new RectangleFigure();
        rectangleFigure.setFill(false);
        return rectangleFigure;
    }

    protected IFigure createFocusFeedbackFigure() {
        return new Figure(){

            protected void paintFigure(Graphics graphics) {
                graphics.drawFocus(this.getBounds().getResized(-1, -1));
            }
        };
    }

    protected void updateLabel(Label label) {
        Label label2 = (Label)this.getHostFigure();
        label.setText(label2.getText());
        label.setTextAlignment(label2.getTextAlignment());
        label.setFont(label2.getFont());
    }

    protected void refreshSelectionFeedback() {
        if (this.selectionFeedbackFigure != null) {
            if (this.selectionFeedbackFigure instanceof Label) {
                this.updateLabel((Label)this.selectionFeedbackFigure);
                this.selectionFeedbackFigure.setBounds(this.getFeedbackBounds());
            } else {
                this.selectionFeedbackFigure.setBounds(this.getFeedbackBounds().expand(5, 5));
            }
        }
    }

    protected void refreshFocusFeedback() {
        if (this.focusFeedbackFigure != null) {
            this.focusFeedbackFigure.setBounds(this.getFeedbackBounds());
        }
    }

    public void refreshFeedback() {
        this.refreshSelectionFeedback();
        this.refreshFocusFeedback();
    }
}

