/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.conversion;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;

public class StringToNumberConverter
extends NumberFormatConverter {
    private Class toType;
    private NumberFormat numberFormat;
    private final Number min;
    private final Number max;
    private final Class boxedType;
    private static final Integer MIN_INTEGER = new Integer(Integer.MIN_VALUE);
    private static final Integer MAX_INTEGER = new Integer(Integer.MAX_VALUE);
    private static final Double MIN_DOUBLE = new Double(-1.7976931348623157E308);
    private static final Double MAX_DOUBLE = new Double(Double.MAX_VALUE);
    private static final Long MIN_LONG = new Long(Long.MIN_VALUE);
    private static final Long MAX_LONG = new Long(Long.MIN_VALUE);
    private static final Float MIN_FLOAT = new Float(-3.4028235E38f);
    private static final Float MAX_FLOAT = new Float(Float.MAX_VALUE);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private StringToNumberConverter(NumberFormat numberFormat, Class toType, Number min, Number max, Class boxedType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz, toType, numberFormat);
        this.toType = toType;
        this.numberFormat = numberFormat;
        this.min = min;
        this.max = max;
        this.boxedType = boxedType;
    }

    public Object convert(Object fromObject) {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse(fromObject, this.numberFormat, this.toType.isPrimitive());
        if (result.getPosition() != null) {
            throw new IllegalArgumentException(StringToNumberParser.createParseErrorMessage((String)fromObject, result.getPosition()));
        }
        if (result.getNumber() == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(this.boxedType)) {
            if (StringToNumberParser.inIntegerRange(result.getNumber())) {
                return new Integer(result.getNumber().intValue());
            }
        } else {
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz2.equals(this.boxedType)) {
                if (StringToNumberParser.inDoubleRange(result.getNumber())) {
                    return new Double(result.getNumber().doubleValue());
                }
            } else {
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3.equals(this.boxedType)) {
                    if (StringToNumberParser.inLongRange(result.getNumber())) {
                        return new Long(result.getNumber().longValue());
                    }
                } else {
                    Class<?> clazz4 = class$4;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$4 = Class.forName("java.lang.Float");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4.equals(this.boxedType)) {
                        if (StringToNumberParser.inFloatRange(result.getNumber())) {
                            return new Float(result.getNumber().floatValue());
                        }
                    } else {
                        Class<?> clazz5 = class$5;
                        if (clazz5 == null) {
                            try {
                                clazz5 = class$5 = Class.forName("java.math.BigInteger");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz5.equals(this.boxedType)) {
                            return new BigDecimal(result.getNumber().doubleValue()).toBigInteger();
                        }
                    }
                }
            }
        }
        if (this.min != null && this.max != null) {
            throw new IllegalArgumentException(StringToNumberParser.createOutOfRangeMessage(this.min, this.max, this.numberFormat));
        }
        throw new IllegalArgumentException("Could not convert [" + fromObject + "] to type [" + this.toType + "]");
    }

    public static StringToNumberConverter toInteger(boolean primitive) {
        return StringToNumberConverter.toInteger(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toInteger(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        Class<?> clazz2;
        if (primitive) {
            clazz2 = Integer.TYPE;
        } else {
            clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new StringToNumberConverter(numberFormat, clazz2, MIN_INTEGER, MAX_INTEGER, clazz);
    }

    public static StringToNumberConverter toDouble(boolean primitive) {
        return StringToNumberConverter.toDouble(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toDouble(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        Class<?> clazz2;
        if (primitive) {
            clazz2 = Double.TYPE;
        } else {
            clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new StringToNumberConverter(numberFormat, clazz2, MIN_DOUBLE, MAX_DOUBLE, clazz);
    }

    public static StringToNumberConverter toLong(boolean primitive) {
        return StringToNumberConverter.toLong(NumberFormat.getIntegerInstance(), primitive);
    }

    public static StringToNumberConverter toLong(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        Class<?> clazz2;
        if (primitive) {
            clazz2 = Long.TYPE;
        } else {
            clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        if ((clazz = class$3) == null) {
            try {
                clazz = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new StringToNumberConverter(numberFormat, clazz2, MIN_LONG, MAX_LONG, clazz);
    }

    public static StringToNumberConverter toFloat(boolean primitive) {
        return StringToNumberConverter.toFloat(NumberFormat.getNumberInstance(), primitive);
    }

    public static StringToNumberConverter toFloat(NumberFormat numberFormat, boolean primitive) {
        Class<?> clazz;
        Class<?> clazz2;
        if (primitive) {
            clazz2 = Float.TYPE;
        } else {
            clazz2 = class$4;
            if (clazz2 == null) {
                try {
                    clazz2 = class$4 = Class.forName("java.lang.Float");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new StringToNumberConverter(numberFormat, clazz2, MIN_FLOAT, MAX_FLOAT, clazz);
    }

    public static StringToNumberConverter toBigInteger() {
        return StringToNumberConverter.toBigInteger(NumberFormat.getIntegerInstance());
    }

    public static StringToNumberConverter toBigInteger(NumberFormat numberFormat) {
        Class<?> clazz;
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$5) == null) {
            try {
                clazz = class$5 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new StringToNumberConverter(numberFormat, clazz2, null, null, clazz);
    }
}

