/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshJob
extends WorkspaceJob
implements IResourceChangeListener {
    private static final long UPDATE_DELAY = 200L;
    private static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    private static final String DEBUG_PREFIX = "EPF Auto-refresh:";
    private ResourceSet resourceSet;
    private Collection<Resource> addedResources = new UniqueEList();
    private Collection<Resource> changedResources = new UniqueEList();
    private Collection<Resource> removedResources = new UniqueEList();
    private Collection<Resource> movedResources = new UniqueEList();
    private UniqueEList<Resource> savedResources = new UniqueEList();
    private Collection<Resource> loadedBeforeRefreshResources = new ArrayList<Resource>();
    private IRefreshHandler refreshHandler;
    private boolean enabled = true;
    private Collection<IResource> addedWorkspaceResources = new UniqueEList();
    private static RefreshJob instance = new RefreshJob();

    private RefreshJob() {
        super(PersistenceResources.resourceAutoRefreshJob_name);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setRefreshHandler(IRefreshHandler iRefreshHandler) {
        this.refreshHandler = iRefreshHandler;
    }

    public Collection<Resource> getAddedResources() {
        RefreshJob.removeResources(this.addedResources, this.savedResources);
        return this.addedResources;
    }

    public Collection<IResource> getAddedWorkspaceResources() {
        return this.addedWorkspaceResources;
    }

    public Collection<Resource> getChangedResources() {
        RefreshJob.removeResources(this.changedResources, this.savedResources);
        RefreshJob.removeResources(this.changedResources, this.loadedBeforeRefreshResources);
        return this.changedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeResources(Collection<Resource> collection, Collection<Resource> collection2) {
        Collection<Resource> collection3 = collection2;
        synchronized (collection3) {
            if (!collection2.isEmpty()) {
                Iterator<Resource> iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    Resource resource = iterator.next();
                    boolean bl = true;
                    if (resource instanceof MultiFileXMIResourceImpl) {
                        MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)resource;
                        bl = multiFileXMIResourceImpl.isSynchronized();
                    }
                    if (!bl || !collection.remove(resource)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }

    public Collection<Resource> getMovedResources() {
        return this.movedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceSaved(Resource resource) {
        if (resource.getResourceSet() == this.resourceSet) {
            UniqueEList<Resource> uniqueEList = this.savedResources;
            synchronized (uniqueEList) {
                this.savedResources.add((Object)resource);
            }
        }
    }

    public Collection<Resource> getReloadedBeforeRefreshResources() {
        return this.loadedBeforeRefreshResources;
    }

    public void reset() {
        this.changedResources.clear();
        this.removedResources.clear();
        this.movedResources.clear();
        this.savedResources.clear();
        this.loadedBeforeRefreshResources.clear();
        this.addedResources.clear();
        this.addedWorkspaceResources.clear();
    }

    private MethodLibrary getMethodLibrary() {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).getMethodLibrary();
        }
        return null;
    }

    private void scheduleRefresh() {
        MethodLibrary methodLibrary;
        if (this.getState() == 0 && (methodLibrary = this.getMethodLibrary()) != null) {
            this.setRule(new LibrarySchedulingRule(methodLibrary));
            this.schedule(200L);
        }
    }

    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) {
        if (this.refreshHandler == null) {
            return Status.OK_STATUS;
        }
        long l = System.currentTimeMillis();
        Throwable throwable = null;
        try {
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: starting refresh job");
            }
            iProgressMonitor.beginTask("", -1);
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            try {
                this.refreshHandler.refresh(iProgressMonitor);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        finally {
            iProgressMonitor.done();
            if (DEBUG) {
                System.out.println("EPF Auto-refresh: finished refresh job in: " + (System.currentTimeMillis() - l) + "ms");
            }
        }
        if (throwable != null) {
            return new Status(4, FileManager.PLUGIN_ID, 0, "Refresh error", throwable);
        }
        return Status.OK_STATUS;
    }

    public synchronized boolean shouldRun() {
        return this.shouldRefresh();
    }

    private boolean shouldRefresh() {
        return !this.removedResources.isEmpty() || !this.changedResources.isEmpty() || !this.addedResources.isEmpty() || !this.movedResources.isEmpty() || !this.loadedBeforeRefreshResources.isEmpty() || !this.addedWorkspaceResources.isEmpty();
    }

    public void start() {
        if (DEBUG) {
            System.out.println("RefreshJob.start()");
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void stop() {
        if (DEBUG) {
            System.out.println("RefreshJob.stop()");
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.cancel();
    }

    public Resource getResource(IResource iResource) {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).getResource(iResource);
        }
        IPath iPath = iResource.getLocation();
        return iPath != null ? PersistenceUtil.getResource(iPath, this.resourceSet) : null;
    }

    private boolean accept(IResource iResource) {
        if (this.resourceSet instanceof MultiFileResourceSetImpl) {
            return ((MultiFileResourceSetImpl)this.resourceSet).isNewResourceToLoad(iResource);
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (!this.isEnabled() || this.resourceSet == null) {
            return;
        }
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        if (iResourceDelta == null) {
            return;
        }
        try {
            class ResourceDeltaVisitor
            implements IResourceDeltaVisitor {
                private Collection<Resource> changedResources = new ArrayList<Resource>();
                private Collection<Resource> removedResources = new ArrayList<Resource>();
                private Collection<Resource> movedResources = new ArrayList<Resource>();
                private Collection<Resource> addedResources = new ArrayList<Resource>();
                private ArrayList<IResource> addedWorkspaceResources = new ArrayList();

                ResourceDeltaVisitor() {
                }

                public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                    if ((iResourceDelta.getFlags() & 0x20000) != 131072 && iResourceDelta.getResource().getType() == 1) {
                        switch (iResourceDelta.getKind()) {
                            case 1: {
                                MethodElement methodElement;
                                Resource resource = RefreshJob.this.getResource(iResourceDelta.getResource());
                                if (resource != null) {
                                    if (!resource.isLoaded() && !((methodElement = PersistenceUtil.getMethodElement(resource)) instanceof ContentDescription)) {
                                        this.addedResources.add(resource);
                                    }
                                } else if (RefreshJob.this.accept(iResourceDelta.getResource())) {
                                    this.addedWorkspaceResources.add(iResourceDelta.getResource());
                                }
                                if ((0x2000 & iResourceDelta.getFlags()) == 0 || !DEBUG) break;
                                methodElement = iResourceDelta.getResource().getLocation();
                                IPath iPath = iResourceDelta.getMovedToPath();
                                System.out.println("Resource moved from '" + methodElement + "' to '" + iPath + "'");
                                break;
                            }
                            case 2: {
                                Resource resource = RefreshJob.this.getResource(iResourceDelta.getResource());
                                if (resource == null) break;
                                this.removedResources.add(resource);
                                break;
                            }
                            case 4: {
                                Resource resource;
                                boolean bl;
                                boolean bl2 = (0x100000 & iResourceDelta.getFlags()) != 0;
                                boolean bl3 = bl = (0x100 & iResourceDelta.getFlags()) != 0;
                                if (!bl2 && !bl || (resource = RefreshJob.this.getResource(iResourceDelta.getResource())) == null || MultiFileSaveUtil.checkSynchronized(resource) == 1) break;
                                this.changedResources.add(resource);
                            }
                        }
                    }
                    return true;
                }
            }
            ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
            iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
            this.removedResources.addAll(resourceDeltaVisitor.removedResources);
            this.movedResources.addAll(resourceDeltaVisitor.movedResources);
            this.changedResources.addAll(resourceDeltaVisitor.changedResources);
            this.addedResources.addAll(resourceDeltaVisitor.addedResources);
            this.addedWorkspaceResources.addAll(resourceDeltaVisitor.addedWorkspaceResources);
            if (this.shouldRefresh()) {
                this.scheduleRefresh();
            }
        }
        catch (CoreException coreException) {
            CommonPlugin.INSTANCE.log((Object)coreException);
        }
    }

    public EObject resolve(EObject eObject) {
        return PersistenceUtil.resolve(eObject, this.resourceSet);
    }

    public static RefreshJob getInstance() {
        return instance;
    }
}

