/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.MethodElement;

public class PublishingRunnable
implements Runnable {
    int timeout_limit = 600000;
    HtmlBuilder htmlBuilder;
    String html_file;
    IElementLayout layout;

    public PublishingRunnable(HtmlBuilder htmlBuilder, int n) {
        this.timeout_limit = n;
        this.htmlBuilder = htmlBuilder;
    }

    private PublishingContentValidator getValidator() {
        return (PublishingContentValidator)this.htmlBuilder.getValidator();
    }

    public void run() {
        if (this.htmlBuilder != null && this.layout != null) {
            this.html_file = null;
            this.html_file = this.htmlBuilder.generateHtml(this.layout);
        }
    }

    public String generateHtml(IElementLayout iElementLayout) {
        this.layout = iElementLayout;
        MethodElement methodElement = this.layout.getElement();
        Timer timer = new Timer();
        try {
            try {
                this.getValidator().setTargetElement(methodElement);
                Thread thread = new Thread(this);
                thread.start();
                thread.join(this.timeout_limit);
                if (thread.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo(methodElement, "publishing element takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.getValidator().setTargetElement(null);
                this.getValidator().getReferencedElements().remove(methodElement);
                timer.stop();
                this.getValidator().logInfo(methodElement, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
            }
        }
        finally {
            this.getValidator().setTargetElement(null);
            this.getValidator().getReferencedElements().remove(methodElement);
            timer.stop();
            this.getValidator().logInfo(methodElement, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
        }
        return this.html_file;
    }

    public void dispose() {
        this.layout = null;
        this.html_file = null;
        this.htmlBuilder = null;
    }
}

