/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.OutputStreamWriter;
import java.util.Vector;
import org.eclipse.epf.publishing.services.index.Def;
import org.eclipse.epf.publishing.services.index.Document;
import org.eclipse.epf.publishing.services.index.HelpMessages;
import org.eclipse.epf.publishing.services.index.IO;
import org.eclipse.epf.publishing.services.index.KeyWordDef;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.services.index.MiscStatic;
import org.eclipse.epf.publishing.services.index.SpecKeyWord;

class KeyWord {
    private String keyWord = null;
    private Vector myKeyWords = null;
    private Vector myDocuments = null;
    private SpecKeyWord mySpecKeyWord = null;
    private KeyWord parentM = null;
    KeyWordDef def = null;

    KeyWord(KeyWordDef keyWordDef) {
        this.def = keyWordDef;
        this.keyWord = keyWordDef.getKey();
    }

    private KeyWord(KeyWordDef keyWordDef, String string, KeyWord keyWord) {
        this.def = keyWordDef;
        this.keyWord = string;
        this.parentM = keyWord;
    }

    String getKeyWord() {
        return this.keyWord;
    }

    void addKeyWord(KeyWordDef keyWordDef, String string, Document document) {
        int n = MiscStatic.getIndex(string, KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
        if (n == -1) {
            this.addDocument(document);
        } else {
            int n2 = MiscStatic.getIndex(string, KeyWordIndexHelper.defObj.levelSeparatorReplace, n + 1);
            String string2 = null;
            string2 = n2 != -1 ? string.substring(n + 1, n2) : string.substring(n + 1);
            KeyWord keyWord = this.createKeyWord(keyWordDef, string2);
            if (keyWord != null) {
                keyWord.addKeyWord(keyWordDef, string.substring(n + 1), document);
            }
        }
    }

    void setSpecKeyWord(String string, boolean bl) {
        IO.printDebug("setSpecKeyWord " + string);
        this.mySpecKeyWord = new SpecKeyWord(string, bl);
    }

    void insertSpecKeyWord(String string, String string2) {
        boolean bl = false;
        int n = 0;
        String string3 = string;
        int n2 = string.indexOf(KeyWordIndexHelper.defObj.levelSeparatorReplace, 0);
        if (n2 != -1) {
            string3 = string.substring(0, n2);
        }
        while (!bl && this.myKeyWords != null && n < this.myKeyWords.size()) {
            KeyWord keyWord = (KeyWord)this.myKeyWords.elementAt(n);
            if (string3.equals(keyWord.getKeyWord())) {
                bl = true;
                if (n2 != -1) {
                    keyWord.insertSpecKeyWord(string.substring(n2 + 1), string2);
                } else {
                    keyWord.setSpecKeyWord(string2, false);
                }
            }
            ++n;
        }
        if (!bl) {
            int n3 = -1;
            n = 0;
            KeyWord keyWord = new KeyWord(null, string3, this);
            IO.printDebug("new keyword " + string3);
            if (n2 == -1) {
                keyWord.setSpecKeyWord(string2, true);
            } else {
                keyWord.insertSpecKeyWord(string.substring(n2 + 1), string2);
            }
            if (this.myKeyWords == null) {
                IO.printDebug("myKeyWords");
                this.myKeyWords = new Vector();
            }
            while (n3 == -1 && n < this.myKeyWords.size()) {
                KeyWord keyWord2 = (KeyWord)this.myKeyWords.elementAt(n);
                if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) < 0) {
                    n3 = n;
                } else if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) == 0 && keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) != 0) {
                    n3 = keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) > 0 ? n : n - 1;
                }
                ++n;
            }
            if (n3 != -1) {
                this.myKeyWords.insertElementAt(keyWord, n3);
            } else {
                this.myKeyWords.insertElementAt(keyWord, this.myKeyWords.size());
            }
        }
    }

    private KeyWord createKeyWord(KeyWordDef keyWordDef, String string) {
        if (this.myKeyWords == null) {
            this.myKeyWords = new Vector();
            KeyWord keyWord = new KeyWord(keyWordDef, string, this);
            this.myKeyWords.addElement(keyWord);
            return keyWord;
        }
        int n = -1;
        int n2 = 0;
        KeyWord keyWord = new KeyWord(keyWordDef, string, this);
        while (n == -1 && n2 < this.myKeyWords.size()) {
            KeyWord keyWord2 = (KeyWord)this.myKeyWords.elementAt(n2);
            if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) < 0) {
                n = n2;
            } else if (keyWord.getKeyWord().toUpperCase().compareTo(keyWord2.getKeyWord().toUpperCase()) == 0) {
                if (keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) != 0) {
                    n = keyWord.getKeyWord().compareTo(keyWord2.getKeyWord()) < 0 ? n2 : n2 + 1;
                } else {
                    return keyWord2;
                }
            }
            ++n2;
        }
        if (n != -1) {
            this.myKeyWords.insertElementAt(keyWord, n);
            return keyWord;
        }
        this.myKeyWords.insertElementAt(keyWord, this.myKeyWords.size());
        return keyWord;
    }

    private void addDocument(Document document) {
        document.setKeyWord(this);
        if (this.myDocuments == null) {
            this.myDocuments = new Vector();
            this.myDocuments.addElement(document);
        } else {
            int n = -1;
            int n2 = 0;
            while (n == -1 && n2 < this.myDocuments.size()) {
                Document document2 = (Document)this.myDocuments.elementAt(n2);
                if (document.getTitle().compareTo(document2.getTitle()) < 0) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1) {
                this.myDocuments.insertElementAt(document, n);
            } else {
                this.myDocuments.insertElementAt(document, this.myDocuments.size());
            }
        }
    }

    void print(OutputStreamWriter outputStreamWriter, int n) {
        if (outputStreamWriter == null) {
            System.err.println("KeyWord:print\n" + HelpMessages.BAD_OUTPUT_STREAM);
            return;
        }
        KeyWordIndexHelper.defObj.printStart(outputStreamWriter, n + 1);
        if (n == 0) {
            MiscStatic.print(outputStreamWriter, "<A NAME=\"" + this.keyWord + "\"> </A>");
        }
        MiscStatic.printSpace(outputStreamWriter, n * 4);
        if (n != 0) {
            MiscStatic.printSpace(outputStreamWriter, 2);
        }
        if (this.myDocuments != null) {
            if (!KeyWordIndexHelper.defObj.getShowDocumentTitle() && !KeyWordIndexHelper.defObj.getMulitDocumentKeyword()) {
                Document document = (Document)this.myDocuments.elementAt(0);
                document.setKeyWord(this);
                MiscStatic.print(outputStreamWriter, "<A HREF=\"" + document.getUrl() + "\" TARGET=\"" + KeyWordIndexHelper.defObj.getTarget() + "\">" + this.keyWord + "</A>");
            } else if (!KeyWordIndexHelper.defObj.getMulitDocumentKeyword()) {
                MiscStatic.print(outputStreamWriter, this.keyWord);
                Document document = (Document)this.myDocuments.elementAt(0);
                document.setKeyWord(this);
                document.print(outputStreamWriter);
            } else {
                MiscStatic.print(outputStreamWriter, this.keyWord);
                MiscStatic.printSpace(outputStreamWriter, 1);
                int n2 = 0;
                while (n2 < this.myDocuments.size()) {
                    Document document = (Document)this.myDocuments.elementAt(n2);
                    document.setKeyWord(this);
                    document.print(outputStreamWriter);
                    if (n2 != this.myDocuments.size() - 1) {
                        MiscStatic.print(outputStreamWriter, ", ");
                    }
                    MiscStatic.print(outputStreamWriter, "\n");
                    ++n2;
                }
            }
        } else {
            MiscStatic.print(outputStreamWriter, this.keyWord);
        }
        if (this.mySpecKeyWord != null) {
            this.mySpecKeyWord.print(outputStreamWriter);
        }
        if (KeyWordIndexHelper.defObj.getStyleSheet(Def.DefaultStyle) == null) {
            MiscStatic.print(outputStreamWriter, "<BR>");
        }
        KeyWordIndexHelper.defObj.printEnd(outputStreamWriter, n + 1);
        if (this.myKeyWords != null) {
            int n3 = n + 1;
            int n4 = 0;
            while (n4 < this.myKeyWords.size()) {
                KeyWord keyWord = (KeyWord)this.myKeyWords.elementAt(n4);
                keyWord.print(outputStreamWriter, n3);
                ++n4;
            }
        }
    }

    String getAnchor() {
        if (this.def != null) {
            return this.def.getAnchor();
        }
        if (this.parentM != null) {
            return this.parentM.getAnchor();
        }
        return "";
    }
}

