/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp.ui;

import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.utils.CommandLineRunUtil;
import org.eclipse.epf.rcp.ui.MainWorkbenchWindowAdvisor;
import org.eclipse.epf.rcp.ui.RCPUIPlugin;
import org.eclipse.epf.rcp.ui.RCPUIResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.osgi.framework.Bundle;

public class MainWorkbenchAdvisor
extends WorkbenchAdvisor {
    protected Logger logger;

    private void declareWorkbenchImage(Bundle bundle, String string, String string2, boolean bl) {
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path(string2), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        this.getWorkbenchConfigurer().declareImage(string, imageDescriptor, bl);
    }

    private void declareWorkbenchImages() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(bundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        this.logger = RCPUIPlugin.getDefault().getLogger();
        super.initialize(iWorkbenchConfigurer);
        iWorkbenchConfigurer.setSaveAndRestore(true);
        String string = System.getProperty("user.dir");
        this.logger.logInfo(String.valueOf(RCPUIResources.startup_dir_log_info_text) + string);
        this.declareWorkbenchImages();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new MainWorkbenchWindowAdvisor(iWorkbenchWindowConfigurer);
    }

    public String getInitialWindowPerspectiveId() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        return AuthoringPerspective.PERSPECTIVE_ID;
    }

    public void preStartup() {
        super.preStartup();
        WorkbenchAdapterBuilder.registerAdapters();
    }

    public boolean preShutdown() {
        IWorkbenchPage iWorkbenchPage;
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null && iWorkbenchPage instanceof WorkbenchPage) {
            IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
            boolean bl = false;
            int n = 0;
            while (n < iViewReferenceArray.length) {
                if (iViewReferenceArray[n].getId().equals("org.eclipse.ui.internal.introview")) {
                    bl = true;
                    break;
                }
                ++n;
            }
            IPreferenceStore iPreferenceStore = RCPUIPlugin.getDefault().getPreferenceStore();
            iPreferenceStore.setValue("welcome_intro_view_exists", bl);
            RCPUIPlugin.getDefault().savePluginPreferences();
        }
        return true;
    }

    public void postShutdown() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
    }

    public void postStartup() {
        CommandLineRunUtil commandLineRunUtil = CommandLineRunUtil.getInstance();
        if (commandLineRunUtil.isNeedToRun()) {
            commandLineRunUtil.execute(Platform.getApplicationArgs());
            final IWorkbench iWorkbench = this.getWorkbenchConfigurer().getWorkbench();
            iWorkbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    iWorkbench.close();
                }
            });
        }
        super.postStartup();
    }
}

