/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.ui.preferences.BasePreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RoleDiagramPreferencePage
extends BasePreferencePage
implements ModifyListener {
    private static int MIN_HORIZONTAL_SPACING = 50;
    private static int MAX_HORIZONTAL_SPACING = 200;
    private static int MIN_VERTICAL_SPACING = 25;
    private static int MAX_VERTICAL_SPACING = 100;
    private static int MIN_TEXT_LINES = 1;
    private static int MAX_TEXT_LINES = 5;
    private Composite composite;
    private Text horizonalSpacingText;
    private Text verticalSpacingText;
    private Text textLinesText;

    protected Control createContents(Composite composite) {
        this.composite = new Composite(composite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group group = RoleDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.elementSpacingGroup_text, (int)2);
        RoleDiagramPreferencePage.createLabel((Composite)group, (String)PublishingUIResources.tasksHorizonalSpacingLabel_text);
        this.horizonalSpacingText = RoleDiagramPreferencePage.createEditableText((Composite)group, (String)"", (int)25);
        RoleDiagramPreferencePage.createLabel((Composite)group, (String)PublishingUIResources.tasksVerticalSpacingLabel_text);
        this.verticalSpacingText = RoleDiagramPreferencePage.createEditableText((Composite)group, (String)"", (int)25);
        Group group2 = RoleDiagramPreferencePage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.elementTextLabelGroup_text, (int)2);
        RoleDiagramPreferencePage.createLabel((Composite)group2, (String)PublishingUIResources.maxLineOfTextLabel_text);
        this.textLinesText = RoleDiagramPreferencePage.createEditableText((Composite)group2, (String)"", (int)15);
        this.initControls();
        this.addListeners();
        return this.composite;
    }

    protected void initControls() {
        this.horizonalSpacingText.setText(String.valueOf(LibraryPreferences.getRoleDiagramHorizontalSpacing()));
        this.verticalSpacingText.setText(String.valueOf(LibraryPreferences.getRoleDiagramVerticalSpacing()));
        this.textLinesText.setText(String.valueOf(LibraryPreferences.getRoleDiagramMaximumTextLines()));
    }

    protected void addListeners() {
        this.horizonalSpacingText.addModifyListener((ModifyListener)this);
        this.verticalSpacingText.addModifyListener((ModifyListener)this);
        this.textLinesText.addModifyListener((ModifyListener)this);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setErrorMessage(null);
        this.setValid(true);
        int n = 0;
        if (modifyEvent.widget == this.horizonalSpacingText) {
            n = this.getHorizontalSpacing();
            if (n < MIN_HORIZONTAL_SPACING || n > MAX_HORIZONTAL_SPACING) {
                this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidHorizonalSpacingError_msg, (Object[])new Object[]{new Integer(MIN_HORIZONTAL_SPACING), new Integer(MAX_HORIZONTAL_SPACING)}));
                this.setValid(false);
            }
        } else if (modifyEvent.widget == this.verticalSpacingText) {
            n = this.getVerticalSpacing();
            if (n < MIN_VERTICAL_SPACING || n > MAX_VERTICAL_SPACING) {
                this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidVerticalSpacingError_msg, (Object[])new Object[]{new Integer(MIN_VERTICAL_SPACING), new Integer(MAX_VERTICAL_SPACING)}));
                this.setValid(false);
            }
        } else if (modifyEvent.widget == this.textLinesText && ((n = this.getMaximumTextLines()) < MIN_TEXT_LINES || n > MAX_TEXT_LINES)) {
            this.setErrorMessage(PublishingUIResources.bind((String)PublishingUIResources.invalidTextLinesError_msg, (Object[])new Object[]{new Integer(MIN_TEXT_LINES), new Integer(MAX_TEXT_LINES)}));
            this.setValid(false);
        }
        this.updateApplyButton();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.horizonalSpacingText.setText("" + LibraryPreferences.getDefaultRoleDiagramHorizontalSpacing());
        this.verticalSpacingText.setText("" + LibraryPreferences.getDefaultRoleDiagramVerticalSpacing());
        this.textLinesText.setText("" + LibraryPreferences.getDefaultRoleDiagramMaximumTextLines());
    }

    public boolean performOk() {
        LibraryPreferences.setRoleDiagramHorizontalSpacing((int)this.getHorizontalSpacing());
        LibraryPreferences.setRoleDiagramVerticalSpacing((int)this.getVerticalSpacing());
        LibraryPreferences.setRoleDiagramMaximumTextLines((int)this.getMaximumTextLines());
        return true;
    }

    protected int getHorizontalSpacing() {
        return StrUtil.getIntValue((String)this.horizonalSpacingText.getText().trim(), (int)0);
    }

    protected int getVerticalSpacing() {
        return StrUtil.getIntValue((String)this.verticalSpacingText.getText().trim(), (int)0);
    }

    protected int getMaximumTextLines() {
        return StrUtil.getIntValue((String)this.textLinesText.getText().trim(), (int)0);
    }
}

